/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import org.bdgp.io.VisualDataAdapter;
import org.bdgp.util.ProgressEvent;
import org.bdgp.util.ProgressListener;

public class ProgressFrame
extends JFrame {
    protected ProgressListener progressListener;
    protected JProgressBar progressBar;
    protected VisualDataAdapter adapter;

    public ProgressFrame(JFrame parent, String title) {
        super(title);
        this.buildGUI();
        this.installListeners();
    }

    public ProgressFrame(JFrame parent, VisualDataAdapter adapter, String title) {
        this(parent, title);
        this.setAdapter(adapter);
    }

    public void installListeners() {
        try {
            this.progressListener = new ProgressBarProgressListener(this.progressBar);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ProgressListener getListener() {
        return this.progressListener;
    }

    public void setAdapter(VisualDataAdapter adapter) {
        if (this.adapter != null) {
            this.adapter.removeProgressListener(this.progressListener);
        }
        this.adapter = adapter;
        adapter.addProgressListener(this.progressListener);
    }

    public void buildGUI() {
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressBar.setFont(this.getFont());
        this.progressBar.setPreferredSize(new Dimension(300, 30));
        this.getContentPane().add((Component)this.progressBar, "Center");
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("Loading data...");
        this.progressBar.setValue(this.progressBar.getMinimum());
        this.pack();
    }

    class ProgressBarProgressListener
    implements ProgressListener {
        JProgressBar bar;

        public ProgressBarProgressListener(JProgressBar bar) {
            this.bar = bar;
        }

        public void progressMade(ProgressEvent e) {
            String displayMe = null;
            if (e.getDescription() == null) {
                this.bar.setStringPainted(false);
            } else {
                displayMe = e.getDescription();
            }
            if (e.getValue() == null) {
                this.bar.setValue(this.bar.getMaximum());
                ProgressFrame.this.adapter.removeProgressListener(ProgressFrame.this.progressListener);
                ProgressFrame.this.hide();
                ProgressFrame.this.dispose();
            } else {
                int val = (int)e.getValue().doubleValue();
                this.bar.setValue(val);
                displayMe = displayMe == null ? val + "%" : displayMe + " " + val + "%";
            }
            if (displayMe != null) {
                this.bar.setString(displayMe);
            }
        }
    }
}

