/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import apollo.gui.PreferencesDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Panel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class PrefsPanel
extends JPanel {
    JTextArea defaultTextArea;
    JTextArea personalTextArea;
    Color bgColor;
    JLabel defaultHeader;
    JLabel personalHeader;

    public PrefsPanel(PreferencesDialog parent, Color bgColor) {
        this.bgColor = bgColor;
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout(10, 10));
        this.setBackground(this.bgColor);
        this.setupTextArea("default");
        this.setupTextArea("personal");
    }

    private void setupTextArea(String which) {
        JLabel header;
        JTextArea textArea;
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout(10, 5));
        boolean editable = true;
        if (which.equals("default")) {
            textArea = this.defaultTextArea = new JTextArea();
            textArea.setRows(19);
            editable = false;
            textArea.setForeground(Color.gray);
            header = this.defaultHeader = new JLabel("");
        } else {
            textArea = this.personalTextArea = new JTextArea();
            textArea.setRows(11);
            header = this.personalHeader = new JLabel("");
        }
        header.setForeground(Color.black);
        JScrollPane textScroll = new JScrollPane();
        textScroll.setHorizontalScrollBarPolicy(30);
        textScroll.setVerticalScrollBarPolicy(20);
        textArea.setLineWrap(false);
        textArea.setWrapStyleWord(true);
        textArea.setEditable(editable);
        textScroll.getViewport().add((Component)textArea, null);
        panel.add((Component)header, "North");
        panel.add((Component)textScroll, "Center");
        if (which.equals("default")) {
            this.add((Component)panel, "North");
        } else {
            this.add((Component)panel, "South");
        }
    }

    public void setText(String text, String which) {
        JTextArea textArea = which.equals("personal") ? this.personalTextArea : this.defaultTextArea;
        textArea.setText(text);
        textArea.setCaretPosition(0);
    }

    public String getText() {
        return this.personalTextArea.getText();
    }

    public void addMessage(String text, String which) {
        JLabel header = which.equals("default") ? this.defaultHeader : this.personalHeader;
        header.setText("<HTML><FONT FACE=Geneva,Dialog,Helvetica color=black><B>" + text + "</B></FONT></HTML>");
    }
}

