/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import apollo.config.Config;
import apollo.config.Style;
import apollo.dataadapter.DataLoadEvent;
import apollo.dataadapter.DataLoadListener;
import apollo.gui.ApolloFrame;
import apollo.gui.ControlledObjectI;
import apollo.gui.Controller;
import apollo.gui.PrefsPanel;
import apollo.gui.menus.HelpMenu;
import apollo.util.IOUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PreferencesDialog
extends JFrame
implements DataLoadListener,
ControlledObjectI {
    private JButton helpButton;
    private JButton restoreButton;
    private JButton saveButton;
    private JButton cancelButton;
    private PrefsPanel prefsPanel;
    private Color bgColor = new Color(255, 255, 150);
    private String origText = "";
    private String defaultStyleFile;
    private String styleFileName;
    private Controller controller;

    public PreferencesDialog() {
        this.setController(Controller.getMasterController());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                e.getWindow().setVisible(false);
                PreferencesDialog.this.getController().removeListener(this);
            }
        });
        try {
            this.defaultStyleFile = Config.getStyle().getFileName();
            this.styleFileName = this.personalStyle(this.defaultStyleFile);
            if (this.styleFileName == null) {
                this.setVisible(false);
                this.getController().removeListener(this);
                this.dispose();
                return;
            }
            this.jbInit();
            this.readPrefs(this.styleFileName);
            this.copyStyleFile(this.styleFileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setTitle("Preferences");
    }

    private void jbInit() {
        this.setSize(new Dimension(600, 635));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.prefsPanel = new PrefsPanel(this, this.bgColor);
        this.getContentPane().add(this.prefsPanel);
        this.helpButton = new JButton("Help");
        this.helpButton.setBackground(Color.white);
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String rootdir = System.getProperty("APOLLO_ROOT");
                String help = rootdir + "/doc/html/userguide.html#StyleFiles";
                HelpMenu.showHelpInBrowser(help);
            }
        });
        this.restoreButton = new JButton("Restore original");
        this.restoreButton.setBackground(Color.white);
        this.restoreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.restoreOriginal(PreferencesDialog.this.styleFileName, PreferencesDialog.this.styleFileName + ".orig");
            }
        });
        this.saveButton = new JButton("Save");
        this.saveButton.setBackground(Color.white);
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.save();
            }
        });
        this.saveButton.setEnabled(this.styleFileName != null);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setBackground(Color.white);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.close();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBackground(this.bgColor);
        buttonPanel.add(this.helpButton);
        buttonPanel.add(this.restoreButton);
        buttonPanel.add(this.saveButton);
        buttonPanel.add(this.cancelButton);
        this.getContentPane().add(buttonPanel);
    }

    private void readPrefs(String styleFile) {
        try {
            this.origText = IOUtil.readFile(styleFile);
        }
        catch (Exception ex) {
            System.out.println("PreferencesDialog.readPrefs: couldn't read personal style file " + styleFile);
            return;
        }
        String confStyleFile = "";
        String exampleText = "";
        try {
            confStyleFile = styleFile;
            if (confStyleFile.indexOf("/") >= 0) {
                confStyleFile = confStyleFile.substring(confStyleFile.lastIndexOf("/") + 1);
            }
            confStyleFile = IOUtil.findFile(IOUtil.getRootDir() + "/conf/" + confStyleFile);
            exampleText = IOUtil.readFile(confStyleFile);
        }
        catch (Exception ex) {
            System.out.println("PreferencesDialog.readPrefs: couldn't read default style file " + confStyleFile);
            return;
        }
        if (this.origText != null) {
            this.prefsPanel.setText(exampleText, "example");
            this.prefsPanel.setText(this.origText, "personal");
            this.prefsPanel.addMessage("Default preferences file: " + confStyleFile, "default");
            this.prefsPanel.addMessage("Your personal preferences file: " + styleFile, "personal");
        }
    }

    private void save() {
        String newText = this.prefsPanel.getText();
        if (newText.equals(this.origText)) {
            JOptionPane.showMessageDialog(null, "No changes to save");
            return;
        }
        String orig = this.styleFileName + ".orig";
        if (!this.copyStyleFile(this.styleFileName)) {
            return;
        }
        try {
            IOUtil.writeFile(this.styleFileName, newText);
        }
        catch (Exception ex) {
            String message = "Couldn't write to " + this.styleFileName + "\n.  Sorry--you will not be able to edit preferences.\nGive your sysadmin this message and see if they can fix the permissions for you.";
            System.err.println(message);
            JOptionPane.showMessageDialog(null, message, "Warning", 2);
            this.saveButton.setEnabled(false);
            return;
        }
        this.setNewStyle(this.styleFileName, orig);
        JOptionPane.showMessageDialog(null, "Saved " + this.styleFileName + "\nYou may need to restart Apollo in order to see all your changes take effect.");
        this.close();
    }

    private boolean copyStyleFile(String styleFileName) {
        String orig = styleFileName + ".orig";
        if (!IOUtil.copyFile(styleFileName, orig)) {
            String message = "The directory where " + styleFileName + " lives is unwriteable.\nSorry--you will not be able to edit preferences.\nGive your sysadmin this message and see if they can fix the permissions for you.";
            System.err.println(message);
            JOptionPane.showMessageDialog(null, message, "Warning", 2);
            return false;
        }
        System.out.println("Original style file saved in " + orig);
        this.restoreButton.setEnabled(true);
        return true;
    }

    private void close() {
        this.setVisible(false);
    }

    private void restoreOriginal(String current, String orig) {
        if (!current.equals(orig)) {
            if (!IOUtil.copyFile(orig, current)) {
                String msg = "Couldn't write to " + current;
                if (orig.endsWith("orig")) {
                    msg = msg + "\nUnable to restore " + current + " from " + orig;
                }
                System.err.println(msg);
                JOptionPane.showMessageDialog(null, msg);
                this.saveButton.setEnabled(false);
                this.restoreButton.setEnabled(false);
                return;
            }
            this.setNewStyle(current, orig);
            System.out.println("Restored style file " + current + " from original " + orig);
        }
    }

    private void setNewStyle(String newStyleFile, String origStyleFile) {
        this.checkStyle(newStyleFile, origStyleFile);
        Config.getStyle().readStyle(newStyleFile);
        Config.setStyle(Config.getStyle(), true);
        this.readPrefs(newStyleFile);
        ApolloFrame.getFrame().repaint();
    }

    private void checkStyle(String newStyleFile, String origStyleFile) {
        Style newStyle = new Style(newStyleFile);
        if (!newStyle.getErrors().equals("")) {
            String msg = "\nNOT SAVING your changes to " + newStyleFile + "--restoring original style file " + origStyleFile;
            System.err.println(msg);
            JOptionPane.showMessageDialog(null, newStyle.getErrors() + "\n" + msg);
            this.restoreOriginal(newStyleFile, origStyleFile);
        }
    }

    private String personalStyle(String defaultStyle) {
        String homeDotApolloDir = System.getProperty("user.home") + "/.apollo/";
        File dotApollo = new File(homeDotApolloDir);
        if (!dotApollo.exists()) {
            if (!dotApollo.mkdir()) {
                String message = "The directory where " + this.styleFileName + " lives is unwriteable.\nYou don't have a " + homeDotApolloDir + ".\nTried and failed to create one.  Sorry--you will not be able to edit preferences.\nGive your sysadmin this message and see if they can fix the permissions for you.";
                System.err.println(message);
                JOptionPane.showMessageDialog(null, message, "Warning", 2);
                return null;
            }
            System.out.println("Created " + homeDotApolloDir);
        }
        String pathSeparator = "/";
        String name = defaultStyle;
        if (defaultStyle.lastIndexOf(pathSeparator) > 0) {
            name = defaultStyle.substring(defaultStyle.lastIndexOf(pathSeparator) + 1);
        }
        this.styleFileName = homeDotApolloDir + name;
        File personalStyle = new File(this.styleFileName);
        if (!personalStyle.exists()) {
            String comments = "// This is your personal " + name + ".\n// All that needs to go in it is the parameters that you want to change from the default.\n// The default preferences file above shows you most of the parameters you can set.\n// Press \"Help\" for more information about the parameters.\n\n";
            try {
                IOUtil.writeFile(this.styleFileName, comments);
            }
            catch (Exception ex) {
                String message = "Tried and failed to create personal style file " + this.styleFileName + "\nSorry--you will not be able to edit preferences.\nGive your sysadmin this message and see if they can fix the permissions for you.";
                System.err.println(message);
                JOptionPane.showMessageDialog(null, message, "Warning", 2);
                return null;
            }
            System.out.println("Created new personal style file " + this.styleFileName);
        }
        return this.styleFileName;
    }

    public boolean handleDataLoadEvent(DataLoadEvent evt) {
        String newStyleFileName = Config.getStyle().getFileName();
        if (!(newStyleFileName = this.personalStyle(newStyleFileName)).equals(this.styleFileName)) {
            this.styleFileName = newStyleFileName;
            try {
                this.readPrefs(this.styleFileName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public void setController(Controller controller) {
        this.controller = controller;
        controller.addListener(this);
    }

    public Controller getController() {
        return this.controller;
    }

    public Object getControllerWindow() {
        return this;
    }

    public boolean needsAutoRemoval() {
        return true;
    }
}

