/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import apollo.datamodel.CurationSet;
import apollo.datamodel.SequenceI;
import apollo.gui.WindowScoreCalculator;

public class GCScoreCalculator
extends WindowScoreCalculator {
    CurationSet curation;

    public GCScoreCalculator(CurationSet curation, int winSize) {
        super(winSize);
        if (curation != null) {
            this.curation = curation;
        }
    }

    public int[] getXRange() {
        if (this.curation != null) {
            return new int[]{this.curation.getLow(), this.curation.getHigh()};
        }
        return new int[]{1, 1};
    }

    public double[] getScoresForPositions(int[] positions) {
        int posLen = positions.length;
        int[] regionExtents = new int[2];
        SequenceI sequence = this.curation.getRefSequence();
        if (positions == null || posLen == 0 || sequence == null) {
            return new double[0];
        }
        this.getWindowExtents(positions[0], regionExtents, this.curation.getLow(), this.curation.getHigh());
        int tmp = regionExtents[0];
        this.getWindowExtents(positions[posLen - 1], regionExtents, this.curation.getLow(), this.curation.getHigh());
        regionExtents[0] = tmp;
        int bottomOverhang = positions[0] - regionExtents[0];
        char[] regSeq = this.xOrientation == 1 ? sequence.getResidues(regionExtents[0], regionExtents[1]).toCharArray() : sequence.getResidues(regionExtents[1], regionExtents[0]).toCharArray();
        double[] scores = new double[posLen];
        for (int i = 0; i < posLen; ++i) {
            this.getRelativeWindowExtents(regSeq, positions[i] - positions[0] + bottomOverhang, this.winExtents);
            scores[i] = this.getScore(regSeq, this.winExtents[0], this.winExtents[1]);
        }
        return scores;
    }

    private double getScore(char[] seqChars, int low, int high) {
        double nGC = 0.0;
        for (int i = low; i <= high; ++i) {
            if (seqChars[i] != 'G' && seqChars[i] != 'C') continue;
            nGC += 1.0;
        }
        return nGC / (double)(high - low + 1) * 100.0;
    }

    private void getRelativeWindowExtents(char[] seqStr, int pos, int[] extents) {
        int low = pos - this.halfWinSize;
        int high = pos + this.halfWinSize;
        extents[0] = low < 0 ? 0 : low;
        int seqLen = seqStr.length - 1;
        extents[1] = high > seqLen ? seqLen : high;
    }
}

