/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import apollo.dataadapter.KaryotypeAdapter;
import apollo.dataadapter.SyntenyGFFAdapter;
import apollo.dataadapter.synteny.ChromosomePanel;
import apollo.datamodel.Chromosome;
import apollo.datamodel.Karyotype;
import apollo.datamodel.SyntenyRegion;
import apollo.gui.StatusBar;
import apollo.gui.event.BasicWindowListener;
import gov.sandia.postscript.PSGr2;
import gov.sandia.postscript.PSGrBase;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class FullSyntenyPanel
extends JPanel
implements ActionListener {
    String org1;
    String org2;
    String fileStub = ".gff";
    JPanel chrPanel = new JPanel();
    StatusBar sb = new StatusBar();
    public Vector panels;

    public FullSyntenyPanel() {
        this("homo_sapiens", "mus_musculus");
    }

    public FullSyntenyPanel(String org1, String org2) {
        this.org1 = org1;
        this.org2 = org2;
    }

    public void init() {
        Chromosome tmpchr;
        int cc;
        int count = 1;
        this.panels = new Vector();
        this.setLayout(new BorderLayout());
        this.chrPanel.setLayout(new GridLayout(4, 6));
        this.chrPanel.setBackground(Color.white);
        KaryotypeAdapter ca = new KaryotypeAdapter();
        Karyotype org1Kary = ca.getKaryotypeBySpeciesName(this.org1);
        Karyotype org2Kary = ca.getKaryotypeBySpeciesName(this.org2);
        Hashtable<Chromosome, Color> colours = new Hashtable<Chromosome, Color>();
        Vector chr1 = org1Kary.getChromosomes();
        for (cc = 0; cc < chr1.size(); ++cc) {
            Chromosome chrtmp = (Chromosome)chr1.elementAt(cc);
            String chr = chrtmp.getDisplayId();
            String filename = chr + this.fileStub;
            SyntenyGFFAdapter sga = new SyntenyGFFAdapter(filename, this.org1, this.org2);
            Vector regions = sga.getSyntenyRegions();
            if (regions == null) continue;
            for (int i = 0; i < regions.size(); ++i) {
                SyntenyRegion reg = (SyntenyRegion)regions.elementAt(i);
                tmpchr = reg.getChromosome2();
                if (colours.containsKey(tmpchr)) continue;
                Color c = new Color((int)(255.0 * Math.random()), (int)(255.0 * Math.random()), (int)(255.0 * Math.random()));
                colours.put(tmpchr, c.brighter());
            }
        }
        for (cc = 0; cc < chr1.size(); ++cc) {
            String name = String.valueOf(cc + 1);
            if (name.equals("23")) {
                name = "X";
            }
            System.out.println("name is " + name);
            Chromosome chrtmp = org1Kary.getChromosomeByName(name);
            if (chrtmp != null) {
                String chr = chrtmp.getDisplayId();
                String filename = chr + this.fileStub;
                SyntenyGFFAdapter sga = new SyntenyGFFAdapter(filename, this.org1, this.org2);
                Vector regions = sga.getSyntenyRegions();
                ChromosomePanel cp = null;
                if (sga.getChromosome1() != null) {
                    System.out.println("Chromosome " + chr + " length " + sga.getChromosome1().getLength());
                    cp = new ChromosomePanel(sga.getChromosome1(), regions, this.sb);
                    this.panels.addElement(cp);
                    this.chrPanel.add(cp);
                } else {
                    System.out.println("No hits " + chr + " Generating dummy chromosome");
                    tmpchr = org1Kary.getChromosomeByName(chr);
                    Vector tmpreg = new Vector();
                    cp = new ChromosomePanel(tmpchr, tmpreg, this.sb);
                    this.panels.addElement(cp);
                    this.chrPanel.add(cp);
                }
            }
            ++count;
        }
        this.add((Component)this.chrPanel, "Center");
        this.add((Component)this.sb, "South");
    }

    public void actionPerformed(ActionEvent e) {
        System.out.println("Got action event");
        this.psPrint();
    }

    public static void main(String[] args) {
        FullSyntenyPanel fsp;
        JFrame frame = new JFrame();
        JMenuBar menuBar = new JMenuBar();
        frame.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        menuBar.add(fileMenu);
        fileMenu.setMnemonic('F');
        JMenuItem print = new JMenuItem("Save as postscript...");
        fileMenu.add(print);
        if (args.length == 3) {
            frame.setTitle(args[1] + "_" + args[2]);
            fsp = new FullSyntenyPanel(args[1], args[2]);
            fsp.fileStub = args[0];
        } else {
            fsp = new FullSyntenyPanel();
        }
        fsp.init();
        print.addActionListener(fsp);
        frame.setJMenuBar(menuBar);
        frame.setDefaultCloseOperation(2);
        frame.addWindowListener(new BasicWindowListener());
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add("Center", fsp);
        frame.setSize(700, 700);
        frame.show();
    }

    public void psPrint() {
        PSGr2 psg = null;
        PrintWriter fw = null;
        double scaleVal = 1.0;
        double scale = 0.0;
        try {
            String startPath = System.getProperty("user.home");
            JFileChooser chooser = new JFileChooser(startPath);
            int returnVal = chooser.showSaveDialog(this);
            File file = chooser.getSelectedFile();
            if (returnVal != 0) {
                return;
            }
            fw = new PrintWriter(new FileWriter(file));
            psg = new PSGr2((Writer)fw);
            scale = PSGrBase.getPSScale((Dimension)this.getSize(), (String)"portrait");
        }
        catch (Exception e) {
            System.out.println("Got exception " + e);
        }
        try {
            scale = new Double(scale);
        }
        catch (Exception e) {
            System.out.println("Invalid scale factor");
            return;
        }
        fw.println("-30 30 translate");
        int yOffset = (int)(762.0 - 792.0 * scaleVal);
        fw.println("30 " + yOffset + " translate");
        fw.println("" + scale + " " + scale + " scale");
        int width = 30;
        int height = 762;
        psg.translate(30, 100);
        for (int i = 0; i < this.panels.size(); ++i) {
            ChromosomePanel p = (ChromosomePanel)this.panels.elementAt(i);
            p.paint((Graphics)psg);
            psg.translate(p.getSize().width, 0);
            if ((i + 1) % 6 != 0) continue;
            psg.translate(-6 * p.getSize().width, -1 * p.getSize().height);
        }
    }
}

