/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import apollo.config.Config;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class ChromosomeField {
    private JComponent jComponent;
    private boolean isJCombo;
    private JComboBox jComboBox;
    private JTextField jTextField;
    private boolean haveChromList = false;

    public ChromosomeField() {
        this.initGui(null);
    }

    public ChromosomeField(Vector chroms) {
        this.initGui(chroms);
    }

    private void initGui(Vector chroms) {
        if (chroms != null || Config.hasChromosomes()) {
            this.isJCombo = true;
            if (chroms == null) {
                chroms = Config.getChromosomes();
            }
            this.jComboBox = new JComboBox(chroms);
            this.jComponent = this.jComboBox;
        } else {
            this.isJCombo = false;
            this.jTextField = new JTextField();
            this.jComponent = this.jTextField;
        }
        this.jComponent.setPreferredSize(new Dimension(70, 25));
        this.haveChromList = Config.hasChromosomes();
    }

    public void addActionListener(ActionListener al) {
        if (!this.isJCombo) {
            this.jTextField.addActionListener(al);
        }
    }

    public JComponent getComponent() {
        return this.jComponent;
    }

    public void setChromosome(String chrom) {
        if (this.styleChanged()) {
            this.initGui(null);
        }
        if (this.isJCombo) {
            this.jComboBox.setSelectedItem(chrom);
        } else {
            this.jTextField.setText(chrom);
        }
    }

    public String getChromosome() {
        if (this.isJCombo) {
            return (String)this.jComboBox.getSelectedItem();
        }
        return this.jTextField.getText();
    }

    public boolean styleChanged() {
        return this.haveChromList != Config.hasChromosomes();
    }
}

