/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import javax.swing.JOptionPane;

public class CheckMemoryThread
extends Thread {
    long minMemory;
    long maxMemory;
    long interval = 30000L;
    private boolean halt = false;

    public CheckMemoryThread(long memoryAllocation) {
        this.maxMemory = memoryAllocation;
        this.minMemory = memoryAllocation / 20L;
        this.setDaemon(true);
    }

    public void checkFreeMemory() {
        long memoryUsed = Runtime.getRuntime().totalMemory();
        long freeMemory = this.maxMemory - memoryUsed;
        if (freeMemory < this.minMemory) {
            try {
                System.gc();
                CheckMemoryThread.sleep(2000L);
                System.gc();
                CheckMemoryThread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            memoryUsed = Runtime.getRuntime().totalMemory();
            freeMemory = this.maxMemory - memoryUsed;
            if (freeMemory < this.minMemory) {
                String m = "WARNING: you are almost out of memory (" + freeMemory + " bytes left).\nIf you run out of memory, Apollo could crash and you could lose your work.\nWe recommend saving now, then exiting Apollo and restarting.";
                System.out.println(m);
                JOptionPane.showMessageDialog(null, m);
                System.err.println("checkFreeMemory: free memory = " + freeMemory + ", total memory used = " + memoryUsed);
                this.halt();
            }
        }
    }

    public void halt() {
        this.halt = true;
        this.interrupt();
    }

    public void run() {
        while (!this.halt) {
            try {
                CheckMemoryThread.sleep(this.interval);
                this.checkFreeMemory();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

