/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import apollo.dataadapter.DataLoadEvent;
import apollo.dataadapter.DataLoadListener;
import apollo.editor.AnnotationChangeEvent;
import apollo.editor.AnnotationChangeListener;
import apollo.editor.ResultChangeEvent;
import apollo.editor.ResultChangeListener;
import apollo.gui.Controller;
import apollo.gui.event.BaseFocusEvent;
import apollo.gui.event.BaseFocusListener;
import apollo.gui.event.FeatureSelectionEvent;
import apollo.gui.event.FeatureSelectionListener;
import apollo.gui.event.NamedFeatureSelectionEvent;
import apollo.gui.event.NamedFeatureSelectionListener;
import jalview.gui.AlignFrame;
import jalview.gui.ColumnSelection;
import jalview.gui.Selection;
import jalview.gui.event.AlignViewportEvent;
import jalview.gui.event.AlignViewportListener;
import jalview.gui.event.ColumnSelectionEvent;
import jalview.gui.event.ColumnSelectionListener;
import jalview.gui.event.SequenceSelectionEvent;
import jalview.gui.event.SequenceSelectionListener;
import java.util.EventListener;
import javax.swing.JFrame;

public class ApolloJalviewEventBridge
implements BaseFocusListener,
AnnotationChangeListener,
FeatureSelectionListener,
NamedFeatureSelectionListener,
DataLoadListener,
ResultChangeListener,
ColumnSelectionListener,
AlignViewportListener,
SequenceSelectionListener {
    Controller apolloController;
    jalview.gui.Controller jalviewController;
    AlignFrame alignFrame;
    private static final boolean DEBUG = false;

    public ApolloJalviewEventBridge(Controller apolloController, jalview.gui.Controller jalviewController, AlignFrame alignFrame) {
        this.jalviewController = jalviewController;
        this.apolloController = apolloController;
        this.alignFrame = alignFrame;
        apolloController.addListener(this);
        jalviewController.addListener((EventListener)this);
    }

    public jalview.gui.Controller getJalviewController() {
        return this.jalviewController;
    }

    public JFrame getAlignFrame() {
        return this.alignFrame;
    }

    public boolean handleAnnotationChangeEvent(AnnotationChangeEvent evt) {
        return true;
    }

    public boolean handleNamedFeatureSelectionEvent(NamedFeatureSelectionEvent evt) {
        return true;
    }

    public boolean handleFeatureSelectionEvent(FeatureSelectionEvent evt) {
        return true;
    }

    public boolean handleDataLoadEvent(DataLoadEvent evt) {
        this.alignFrame.dispose();
        this.apolloController.removeListener(this);
        this.jalviewController.removeListener((EventListener)this);
        return true;
    }

    public boolean handleResultChangeEvent(ResultChangeEvent evt) {
        return true;
    }

    public boolean handleBaseFocusEvent(BaseFocusEvent evt) {
        this.alignFrame.getAlignViewport().setStartRes(evt.getFocus());
        return true;
    }

    public boolean handleSequenceSelectionEvent(SequenceSelectionEvent evt) {
        Selection sel = evt.getSelection();
        String[] names = new String[sel.size()];
        for (int i = 0; i < sel.size(); ++i) {
            names[i] = sel.sequenceAt(i).getName();
        }
        if (names.length != 0) {
            this.apolloController.handleNamedFeatureSelectionEvent(new NamedFeatureSelectionEvent(this, names));
        }
        return true;
    }

    public boolean handleColumnSelectionEvent(ColumnSelectionEvent evt) {
        ColumnSelection colSel = evt.getColumnSelection();
        int jalviewCol = -1;
        for (int i = 0; i < colSel.size(); ++i) {
            jalviewCol = colSel.columnAt(i);
        }
        int genomic = this.alignFrame.getMapper().condensed2genomic(jalviewCol);
        if (genomic != -1) {
            BaseFocusEvent b = new BaseFocusEvent(this, genomic, null);
            this.apolloController.handleBaseFocusEvent(b);
        }
        return true;
    }

    public boolean handleAlignViewportEvent(AlignViewportEvent evt) {
        if (evt.getType() == 10) {
            // empty if block
        }
        return true;
    }
}

