/*
 * Decompiled with CFR 0.152.
 */
package apollo.gui;

import apollo.config.Config;
import apollo.dataadapter.DataLoadEvent;
import apollo.dataadapter.DataLoadListener;
import apollo.datamodel.CompositeDataHolder;
import apollo.datamodel.SeqFeatureI;
import apollo.gui.ControlledObjectI;
import apollo.gui.Controller;
import apollo.gui.StatusBar;
import apollo.gui.TypePanel;
import apollo.gui.UnBorderedSplitPane;
import apollo.gui.event.BasicWindowListener;
import apollo.gui.event.LazyLoadEvent;
import apollo.gui.event.LazyLoadListener;
import apollo.gui.evidencepanel.EvidencePanelOrientationManager;
import apollo.gui.genomemap.StrandedZoomableApolloPanel;
import apollo.gui.menus.MenuManager;
import apollo.gui.synteny.CompositeApolloFrame;
import apollo.gui.synteny.CurationManager;
import apollo.gui.synteny.GuiCurationState;
import apollo.gui.synteny.SyntenyPanel;
import apollo.main.Version;
import apollo.util.GuiUtil;
import apollo.util.SwingMissingUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;

public abstract class ApolloFrame
extends JFrame
implements ControlledObjectI,
LazyLoadListener,
DataLoadListener {
    static String version = Version.getVersion();
    private UnBorderedSplitPane evidenceSzapSplitPane;
    private SyntenyPanel syntenyPanel;
    private JDialog ld;
    private Runnable beforeLazyLoad = new Runnable(){

        public void run() {
            ApolloFrame af = ApolloFrame.this;
            ApolloFrame.this.ld = new JDialog((Frame)af, "Loading sequence");
            ApolloFrame.this.ld.setLocationRelativeTo(af);
            JPanel p = new JPanel();
            p.setPreferredSize(new Dimension(250, 20));
            ApolloFrame.this.ld.getContentPane().add(p);
            ApolloFrame.this.ld.pack();
            ApolloFrame.this.ld.show();
        }
    };
    Runnable afterLazyLoad = new Runnable(){

        public void run() {
            ApolloFrame.this.ld.hide();
            ApolloFrame.this.ld.dispose();
        }
    };

    public static CompositeApolloFrame getApolloFrame() {
        return CompositeApolloFrame.getApolloFrame();
    }

    public static JFrame getFrame() {
        return ApolloFrame.getApolloFrame();
    }

    protected ApolloFrame() {
    }

    public void setController(Controller c) {
    }

    public Controller getController() {
        return Controller.getMasterController();
    }

    public Object getControllerWindow() {
        return SwingMissingUtil.getWindowAncestor(this);
    }

    public boolean needsAutoRemoval() {
        return true;
    }

    public boolean handleDataLoadEvent(DataLoadEvent evt) {
        if (evt.dataRetrievalBeginning()) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else if (evt.dataRetrievalDone()) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        this.invalidate();
        this.validate();
        return true;
    }

    public boolean handleLazyLoadEvent(LazyLoadEvent evt) {
        if (evt.getType() == 10) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(this.beforeLazyLoad);
            } else {
                this.beforeLazyLoad.run();
            }
        } else if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this.afterLazyLoad);
        } else {
            this.afterLazyLoad.run();
        }
        return true;
    }

    public void setVisible(boolean state) {
        super.setVisible(state);
        for (int i = 0; i < ApolloFrame.getCurationManager().numberOfCurations(); ++i) {
            this.getSZAP(i).setVisible(state);
        }
    }

    private int getPreferredFrameWidth() {
        return Config.getMainWindowWidth();
    }

    public int getPreferredFrameHeight() {
        if (ApolloFrame.getCurationManager().isMultiCuration()) {
            return 900;
        }
        return 700;
    }

    public JSplitPane getSplitPane() {
        if (this.evidenceSzapSplitPane == null) {
            this.evidenceSzapSplitPane = new UnBorderedSplitPane();
        }
        return this.evidenceSzapSplitPane;
    }

    public void completeGUIInitialization() {
        MenuManager.createMenuManager(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getSplitPane(), "Center");
        StatusBar sb = ApolloFrame.getCurationManager().getStatusBar();
        this.getContentPane().add((Component)sb, "South");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new BasicWindowListener());
        this.setSize(GuiUtil.fitToScreen(this.getPreferredFrameWidth(), this.getPreferredFrameHeight()));
        ApolloFrame.centerOnScreen(this);
        EvidencePanelOrientationManager.getSingleton().orientEvidencePanels();
        this.setVisible(true);
        this.putVerticalScrollbarsAtStart();
        TypePanel.getTypePanelInstance().setLocationRelativeToFrame(this.getSize());
    }

    private void putVerticalScrollbarsAtStart() {
        for (int i = 0; i < ApolloFrame.getCurationManager().numberOfCurations(); ++i) {
            this.getSZAP(i).putVerticalScrollbarsAtStart();
        }
    }

    public static void centerOnScreen(Component c) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        c.setLocation((screenSize.width - c.getSize().width) / 2, (screenSize.height - c.getSize().height) / 2);
    }

    public void loadSyntenyLink(SeqFeatureI link) {
    }

    public SyntenyPanel getSyntenyPanel() {
        return this.syntenyPanel;
    }

    protected void setSyntenyPanel(SyntenyPanel panel) {
        this.syntenyPanel = panel;
    }

    protected CompositeDataHolder getCompositeDataHolder() {
        return ApolloFrame.getCurationManager().getCompositeDataHolder();
    }

    protected static CurationManager getCurationManager() {
        return CurationManager.getCurationManager();
    }

    protected GuiCurationState getCurationState(int i) {
        return ApolloFrame.getCurationManager().getCurationState(i);
    }

    private StrandedZoomableApolloPanel getSZAP(int i) {
        return this.getCurationState(i).getSZAP();
    }
}

