/*
 * Decompiled with CFR 0.152.
 */
package apollo.editor;

import apollo.config.ApolloNameAdapterI;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.SeqFeatureI;
import apollo.editor.AnnotationChangeEvent;
import apollo.editor.AnnotationEditor;
import apollo.editor.AnnotationUpdateEvent;
import apollo.editor.Transaction;
import apollo.editor.TransactionSubpart;
import apollo.editor.TransactionUtil;

public class UpdateTransaction
extends Transaction {
    private Object previousValue;
    private transient ApolloNameAdapterI nameAdapter;

    public UpdateTransaction() {
    }

    public UpdateTransaction(SeqFeatureI feature, TransactionSubpart part) {
        this.setSeqFeature(feature);
        this.setSubpart(part);
    }

    public UpdateTransaction(SeqFeatureI feat, TransactionSubpart ts, Object oldValue, Object newValue) {
        this(feat, ts);
        this.setOldSubpartValue(oldValue);
        this.setNewSubpartValue(newValue);
    }

    public UpdateTransaction(Object source, SeqFeatureI feat, TransactionSubpart ts, Object oldValue, Object newValue) {
        this(feat, ts);
        this.setSource(source);
        this.setOldSubpartValue(oldValue);
        this.setNewSubpartValue(newValue);
    }

    public SeqFeatureI getUpdatedSeqFeature() {
        return this.getSeqFeature();
    }

    public boolean isUpdate() {
        return true;
    }

    void undo() {
        this.setValue(this.getOldSubpartValue(), this.getOldId());
    }

    public void editModel() {
        this.setValue(this.getNewSubpartValue(), this.getNewId());
    }

    private void setValue(Object value, String updatedId) {
        this.getSubpart().setValue(this.getSeqFeature(), value);
        if (!this.getSubpart().isId() && this.idHasChanged()) {
            if (this.idEqualsName()) {
                this.setNameFromId(updatedId);
            }
            this.executeIdChange(updatedId);
        }
    }

    private boolean idHasChanged() {
        if (this.getOldId() == null || this.getNewId() == null) {
            return false;
        }
        return !this.getOldId().equals(this.getNewId());
    }

    private boolean idEqualsName() {
        return this.getSeqFeature().getId().equals(this.getSeqFeature().getName());
    }

    private void executeIdChange(String id) {
        TransactionUtil.setId(this.getAnnotatedFeature(), id, this.nameAdapter);
    }

    public void setNameAdapter(ApolloNameAdapterI nameAdapter) {
        this.nameAdapter = nameAdapter;
    }

    private void setNameFromId(String id) {
        AnnotatedFeatureI topAnnot = this.getAnnotatedFeature();
        topAnnot.setName(id);
        if (topAnnot.isAnnotTop()) {
            for (int i = 0; i < topAnnot.size(); ++i) {
                AnnotatedFeatureI trans = topAnnot.getAnnotChild(i);
                this.nameAdapter.setTranscriptNameFromAnnot(trans, topAnnot);
            }
        }
    }

    AnnotationChangeEvent generateAnnotationChangeEvent() {
        if (this.getSource() == null) {
            this.setSource(this);
            System.out.println("UpdateTransaction does not have a source. setting to self");
            if (AnnotationEditor.DEBUG) {
                System.out.println("DEBUG stack trace:");
                new Throwable().printStackTrace();
            }
        }
        return new AnnotationUpdateEvent(this);
    }

    protected String getOperationString() {
        return "UPDATE";
    }
}

