/*
 * Decompiled with CFR 0.152.
 */
package apollo.editor;

import apollo.config.ApolloNameAdapterI;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.Comment;
import apollo.editor.Transaction;
import apollo.editor.TransactionSubpart;

public class TransactionUtil {
    public static boolean getBoolean(AnnotatedFeatureI annot, TransactionSubpart subpart) {
        if (!subpart.isBoolean()) {
            throw new RuntimeException();
        }
        if (subpart == TransactionSubpart.IS_PROBLEMATIC) {
            return annot.isProblematic();
        }
        if (subpart == TransactionSubpart.REPLACE_STOP) {
            return annot.hasReadThroughStop();
        }
        if (subpart == TransactionSubpart.IS_DICISTRONIC) {
            return Boolean.valueOf(annot.getProperty("dicistronic"));
        }
        if (subpart == TransactionSubpart.FINISHED) {
            return annot.getProperty("status").equals("all done");
        }
        if (subpart == TransactionSubpart.NON_CONSENSUS_SPLICE_OKAY) {
            return annot.nonConsensusSplicingOkay();
        }
        return false;
    }

    public static void flipBoolean(AnnotatedFeatureI annot, TransactionSubpart subpart) {
        boolean oldVal = TransactionUtil.getBoolean(annot, subpart);
        if (subpart == TransactionSubpart.IS_DICISTRONIC) {
            annot.replaceProperty("dicistronic", !oldVal + "");
        } else if (subpart == TransactionSubpart.IS_PROBLEMATIC) {
            annot.setIsProblematic(!oldVal);
        } else if (subpart == TransactionSubpart.FINISHED) {
            String newVal = oldVal ? "not done" : "all done";
            annot.replaceProperty("status", newVal);
        } else if (subpart == TransactionSubpart.REPLACE_STOP) {
            annot.setReadThroughStop(!oldVal);
        } else if (subpart == TransactionSubpart.NON_CONSENSUS_SPLICE_OKAY && TransactionUtil.haveNonConsensusSpliceSite(annot)) {
            annot.nonConsensusSplicingOkay(!TransactionUtil.getBoolean(annot, subpart));
        }
    }

    private static boolean haveNonConsensusSpliceSite(AnnotatedFeatureI annot) {
        if (!annot.getFeatureType().equals("transcript")) {
            return false;
        }
        if (!annot.isProteinCodingGene()) {
            return false;
        }
        if (annot.size() <= 1) {
            return false;
        }
        return annot.getNonConsensusAcceptorNum() >= 0 || annot.getNonConsensusDonorNum() >= 0;
    }

    public static void undoUpdateComment(Transaction trans, AnnotatedFeatureI ann) {
        TransactionUtil.undoAddComment(trans);
        TransactionUtil.undoDeleteComment(trans);
    }

    static void undoAddComment(Transaction trans) {
        int rank = trans.getSubpartRank();
        trans.getAnnotatedFeature().deleteComment(rank);
    }

    static void undoDeleteComment(Transaction trans) {
        Comment oldComment = trans.getOldComment();
        int index = trans.getSubpartRank();
        trans.getAnnotatedFeature().addComment(index, oldComment);
    }

    public static void setId(AnnotatedFeatureI ann, String newId, ApolloNameAdapterI nameAdapter) {
        nameAdapter.setAnnotId(ann, newId);
    }
}

