/*
 * Decompiled with CFR 0.152.
 */
package apollo.editor;

import apollo.config.Config;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.SeqFeatureI;
import apollo.editor.Transaction;
import apollo.editor.TransactionSubpart;
import apollo.editor.UpdateDetailsI;
import java.util.EventObject;

public abstract class FeatureChangeEvent
extends EventObject {
    public static final int ADD = 1;
    public static final int DELETE = 2;
    public static final int REDRAW = 5;
    public static final int SYNC = 6;
    public static final int SPLIT = 20;
    public static final int MERGE = 21;
    public static final int REPLACE = 22;
    private int operation;
    private SeqFeatureI changeTop;
    private SeqFeatureI changedFeature;
    protected SeqFeatureI parentFeature;
    private AnnotatedFeatureI replacedFeature;
    private Transaction transaction;
    private TransactionSubpart transactionSubpart;
    private boolean isSingularEvent;

    public FeatureChangeEvent(Object source, SeqFeatureI changeTop, int operation, SeqFeatureI feature1, SeqFeatureI feature2) {
        super(source);
        this.changeTop = changeTop;
        this.operation = operation;
        this.parentFeature = feature1;
        this.changedFeature = feature2;
    }

    protected FeatureChangeEvent(Object source, SeqFeatureI changedFeature) {
        super(source);
        this.changedFeature = changedFeature;
    }

    protected FeatureChangeEvent(Object source, SeqFeatureI changedFeature, TransactionSubpart subpart) {
        this(source, changedFeature);
        this.transactionSubpart = subpart;
    }

    protected FeatureChangeEvent(Object source) {
        super(source);
    }

    boolean isTransactionOperation() {
        return !this.isEndOfEditSession() && this.operation != 5 && this.operation != 6;
    }

    public boolean isEndOfEditSession() {
        if (this.getOperation() == 5 || this.getOperation() == 6) {
            return true;
        }
        return this.isSingularEvent;
    }

    void setSingularEventState(boolean isSingularEvent) {
        this.isSingularEvent = isSingularEvent;
    }

    public Object getSource() {
        return this.source;
    }

    public SeqFeatureI getChangeTop() {
        return this.changeTop;
    }

    protected void setChangeTop(SeqFeatureI changeTop) {
        this.changeTop = changeTop;
    }

    public int getOperation() {
        return this.operation;
    }

    public boolean isRootAnnotChange() {
        if (this.getChangedFeature() == null) {
            return false;
        }
        if (this.getChangedFeature().getAnnotatedFeature() == null) {
            return false;
        }
        return this.getChangedFeature().getAnnotatedFeature() == this.getChangeTop();
    }

    public boolean isTranscriptChange() {
        return this.getChangedFeature().getFeatureType().equals("transcript");
    }

    public boolean isExonChange() {
        return this.getChangedFeature().getFeatureType().equals("exon");
    }

    protected String getOperationAsString() {
        return FeatureChangeEvent.asString(this.operation);
    }

    public boolean isAdd() {
        return this.getOperation() == 1;
    }

    public SeqFeatureI getAddedFeature() {
        if (!this.isAdd()) {
            return null;
        }
        return this.getChangedFeature();
    }

    public SeqFeatureI getChangedFeature() {
        return this.changedFeature;
    }

    public void setParentFeature(SeqFeatureI parent) {
        this.parentFeature = parent;
    }

    public SeqFeatureI getParentFeature() {
        if (this.parentFeature != null) {
            return this.parentFeature;
        }
        return this.getChangedFeature().getRefFeature();
    }

    public boolean isDelete() {
        return this.getOperation() == 2;
    }

    public boolean isMerge() {
        return this.getOperation() == 21;
    }

    public boolean isSplit() {
        return this.getOperation() == 20;
    }

    public boolean isMove() {
        return false;
    }

    public AnnotatedFeatureI getReplacedFeature() {
        return this.replacedFeature;
    }

    protected void setReplacedFeature(AnnotatedFeatureI replacedFeature) {
        this.replacedFeature = replacedFeature;
    }

    public boolean isSync() {
        return this.getOperation() == 6;
    }

    public boolean isUpdate() {
        return false;
    }

    public UpdateDetailsI getUpdateDetails() {
        return null;
    }

    public boolean hasSubpart() {
        return this.getSubpart() != null;
    }

    public TransactionSubpart getSubpart() {
        return this.transactionSubpart;
    }

    void setSubpart(TransactionSubpart subpart) {
        this.transactionSubpart = subpart;
    }

    public boolean isCompound() {
        return false;
    }

    String getObjectClassAsString() {
        if (this.isCompound()) {
            return "COMPOUND";
        }
        if (this.isRootAnnotChange()) {
            return "ANNOTATION";
        }
        if (this.isTranscriptChange()) {
            return "TRANSCRIPT";
        }
        if (this.isExonChange()) {
            return "EXON";
        }
        if (Config.DEBUG) {
            System.err.println("DEBUG: Unknown object class");
            new Throwable().printStackTrace();
        }
        return "UNKNOWN OBJECT CLASS";
    }

    public String toString() {
        return this.getOperationAsString() + "ing " + this.getObjectClassAsString() + " on strand " + this.getChangeTop().getStrand() + ", top feature " + (this.getChangeTop() == null ? "top?" : this.getChangeTop().getName()) + ", parent " + (this.getParentFeature() == null ? "parent?" : this.getParentFeature().getName()) + ", changed feature " + (this.getChangedFeature() == null ? "changedFeature?" : this.getChangedFeature().getName());
    }

    static String asString(int operation) {
        switch (operation) {
            case 1: {
                return "ADD";
            }
            case 2: {
                return new String("DELETE");
            }
            case 5: {
                return new String("REDRAW");
            }
            case 6: {
                return new String("SYNC");
            }
            case 20: {
                return new String("SPLIT");
            }
            case 21: {
                return new String("MERGE");
            }
            case 22: {
                return new String("REPLACE");
            }
        }
        return new String("UNKNOWN OPERATION (" + operation + ")");
    }
}

