/*
 * Decompiled with CFR 0.152.
 */
package apollo.editor;

import apollo.config.ApolloNameAdapterI;
import apollo.config.Config;
import apollo.config.FeatureProperty;
import apollo.config.OverlapI;
import apollo.config.PropertyScheme;
import apollo.datamodel.AnnotatedFeature;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.Comment;
import apollo.datamodel.CurationSet;
import apollo.datamodel.DbXref;
import apollo.datamodel.Exon;
import apollo.datamodel.ExonI;
import apollo.datamodel.FeaturePairI;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.Range;
import apollo.datamodel.RangeI;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceEdit;
import apollo.datamodel.SequenceI;
import apollo.datamodel.StrandedFeatureSetI;
import apollo.datamodel.Synonym;
import apollo.datamodel.Transcript;
import apollo.datamodel.TranslationI;
import apollo.editor.AddTransaction;
import apollo.editor.AnnotSessionDoneEvent;
import apollo.editor.AnnotationAddEvent;
import apollo.editor.AnnotationChangeEvent;
import apollo.editor.AnnotationChangeListener;
import apollo.editor.AnnotationUpdateEvent;
import apollo.editor.ChangeList;
import apollo.editor.CompoundTransaction;
import apollo.editor.DeleteTransaction;
import apollo.editor.ResultChangeEvent;
import apollo.editor.SelectionSet;
import apollo.editor.Transaction;
import apollo.editor.TransactionSubpart;
import apollo.editor.UpdateParentTransaction;
import apollo.editor.UpdateTransaction;
import apollo.editor.UserName;
import apollo.gui.ControlledObjectI;
import apollo.gui.Controller;
import apollo.gui.DetailInfo;
import apollo.gui.Selection;
import apollo.gui.SelectionManager;
import apollo.gui.drawable.DrawableAnnotationConstants;
import apollo.gui.event.FeatureSelectionEvent;
import apollo.gui.genomemap.AnnotationView;
import apollo.gui.genomemap.ResultView;
import apollo.gui.genomemap.StrandedZoomableApolloPanel;
import apollo.gui.genomemap.TierViewI;
import apollo.gui.synteny.GuiCurationState;
import apollo.util.FeatureList;
import java.awt.Component;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class AnnotationEditor
implements ControlledObjectI,
DrawableAnnotationConstants {
    Controller controller = null;
    private AnnotationChangeListener annotCngListener;
    FeatureSetI annotationCollection = null;
    CurationSet curation = null;
    private SelectionSet cursorSet;
    private SelectionSet annotSet;
    SelectionSet evidenceSet;
    SelectionSet siteSet;
    int basePosition = -1;
    int endBasePosition = -1;
    int defaultStrand;
    boolean strandSet = false;
    Component parentComponent;
    AnnotationView annotationView;
    private GuiCurationState curationState;
    private FeatureList oldTranscripts;
    private FeatureList newTranscripts;
    private FeatureList oldAnnots;
    static String ALL_DONE = "all done";
    static String NOT_DONE = "not done";
    static boolean DEBUG = false;
    static boolean DO_ONE_LEVEL_ANNOTS = false;

    public AnnotationEditor(GuiCurationState curationState, FeatureSetI annotationCollection) {
        this.curationState = curationState;
        this.annotationCollection = annotationCollection;
        this.setController(curationState.getController());
        this.annotCngListener = curationState.getController();
        curationState.addAnnotationEditor(this, annotationCollection.isForwardStrand());
    }

    public void setController(Controller c) {
        this.controller = c;
    }

    public void setCurationSet(CurationSet curation) {
        this.curation = curation;
    }

    public Controller getController() {
        return this.controller;
    }

    public Object getControllerWindow() {
        return null;
    }

    public boolean needsAutoRemoval() {
        return true;
    }

    public void setParentComponent(Component comp) {
        this.parentComponent = comp;
    }

    protected void resetData() {
        this.siteSet = null;
        this.evidenceSet = null;
        this.cursorSet = null;
        this.annotSet = null;
        this.endBasePosition = -1;
        this.basePosition = -1;
        this.strandSet = false;
    }

    public void setSelections(AnnotationView v, Selection selection, Vector underCursor) {
        this.annotationView = v;
        this.setSelections(underCursor, v.getViewSelection(selection).getSelectedVector(), v.getResultView().getViewSelection(selection).getSelectedVector(), v.getSiteView().getViewSelection(selection).getSelectedVector());
    }

    public void setSelections(AnnotationView annotView, Selection selection, Vector underCursor, int basePosition, int strand) {
        this.annotationView = annotView;
        boolean checkForRedundantDescendants = true;
        Selection annotSel = selection.getSelectionDescendedFromModel(this.annotationCollection, checkForRedundantDescendants);
        Vector annotVector = annotSel.getSelectedVector();
        FeatureSetI topModel = annotView.getResultView().getTopModel();
        Selection resultSel = selection.getSelectionDescendedFromModel(topModel);
        Vector resultVector = resultSel.getSelectedVector();
        this.setSelections(underCursor, annotVector, resultVector, annotView.getSiteView().getViewSelection(selection).getSelectedVector());
        this.strandSet = true;
        this.basePosition = basePosition;
        this.defaultStrand = strand;
    }

    public void setView(AnnotationView annotView) {
        this.annotationView = annotView;
    }

    public void setSelections(int basePosition, int endBasePosition, Vector underCursor, Vector annotVect, Vector resultVect, Vector siteVect) {
        this.setSelections(underCursor, annotVect, resultVect, siteVect);
        this.basePosition = basePosition;
        this.endBasePosition = endBasePosition;
    }

    public void setSelections(Vector underCursor, Vector annotVect, Vector resultVect, Vector siteVect) {
        this.resetData();
        this.cursorSet = new SelectionSet(underCursor);
        this.annotSet = new SelectionSet(annotVect);
        this.evidenceSet = new SelectionSet(resultVect);
        this.siteSet = new SelectionSet(siteVect);
        this.synchOldAnnots();
    }

    void synchOldAnnots() {
        this.synchTranscripts(this.getSelectionSetTranscripts());
        FeatureList newAnnots = this.getNewTopAnnots();
        if (newAnnots == null) {
            return;
        }
        this.oldAnnots = newAnnots.cloneList();
    }

    private void synchTranscript(SeqFeatureI transcript) {
        FeatureList transList = new FeatureList(transcript, false);
        this.synchTranscripts(transList);
    }

    private void synchTranscripts(FeatureList transcripts) {
        if (transcripts == null) {
            return;
        }
        this.newTranscripts = transcripts;
        this.oldTranscripts = transcripts.cloneList();
    }

    FeatureList getSelectionSetTranscripts() {
        if (this.annotSet == null) {
            return null;
        }
        FeatureList transcripts = this.annotSet.getTranscriptList();
        transcripts.addAll(this.cursorSet.getTranscriptList());
        return transcripts;
    }

    FeatureList getNewTopAnnots() {
        if (this.annotSet == null) {
            return null;
        }
        FeatureList genes = this.annotSet.getGeneList();
        genes.addAll(this.cursorSet.getGeneList());
        return genes;
    }

    FeatureList getOldTranscripts() {
        return this.oldTranscripts;
    }

    FeatureList getNewTranscripts() {
        return this.newTranscripts;
    }

    FeatureList getOldTopAnnots() {
        return this.oldAnnots;
    }

    public boolean mergeTranscriptsAllowed() {
        if (this.annotSet.getTranscripts().size() != 2) {
            return false;
        }
        Transcript tran1 = (Transcript)this.annotSet.getTranscripts().elementAt(0);
        Transcript tran2 = (Transcript)this.annotSet.getTranscripts().elementAt(1);
        return tran1.getGene().getTopLevelType().equals(tran2.getGene().getTopLevelType());
    }

    public void mergeTranscripts() {
        if (this.mergeTranscriptsAllowed()) {
            Vector combinedTranscripts = new Vector();
            combinedTranscripts.addElement(this.annotSet.getTranscripts().elementAt(0));
            combinedTranscripts.addElement(this.annotSet.getTranscripts().elementAt(1));
            this.mergeTranscripts(combinedTranscripts);
        } else {
            this.showMessage(0, "To merge transcripts, you must select two transcripts on the same strand.");
        }
    }

    private void mergeTranscripts(Vector transcripts) {
        Transcript tran1 = (Transcript)transcripts.elementAt(0);
        Transcript tran2 = (Transcript)transcripts.elementAt(1);
        System.out.println("\n\t****** MERGING TRANSCRIPTS ******");
        if (this.isTemp(tran1) && !this.isTemp(tran2)) {
            tran2 = (Transcript)transcripts.elementAt(0);
            tran1 = (Transcript)transcripts.elementAt(1);
        }
        this.moveExonsToTranscript(tran1, (Vector)tran2.getFeatures().clone(), "merge transcripts");
    }

    public void printSets() {
        this.cursorSet.dump("cursorSet:");
        this.annotSet.dump("annotSet:");
        this.evidenceSet.dump("evidenceSet:");
        this.siteSet.dump("siteSet:");
    }

    private ChangeList beginEdit(String description) {
        return this.createCoalescer();
    }

    private ChangeList createCoalescer() {
        return this.createChangeList();
    }

    private ChangeList createChangeList() {
        return new ChangeList(this, this.getController());
    }

    protected void showMessage(int type, String message) {
        switch (type) {
            case 0: {
                System.err.println("ERROR: " + message);
                this.showMessageWindow(type, message, "Editor error");
                break;
            }
            case 2: {
                System.err.println("WARNING: " + message);
                this.showMessageWindow(type, message, "Editor warning");
                break;
            }
            default: {
                System.err.println(message);
            }
        }
    }

    protected void showMessageWindow(int type, String message, String title) {
        if (this.parentComponent != null) {
            JOptionPane.showMessageDialog(this.parentComponent, message, title, type);
        }
    }

    protected boolean areOverlapping(SeqFeatureI sa, SeqFeatureI sb) {
        if (!this.getAnnotTypeForFeature(sa).equals(this.getAnnotTypeForFeature(sb))) {
            return false;
        }
        OverlapI checker = Config.getOverlapper(sa);
        return checker.areOverlapping(sa, sb);
    }

    private CompoundTransaction consolidateGenes(AnnotatedFeatureI dest) {
        return this.consolidateGenes(dest, true);
    }

    private CompoundTransaction consolidateGenes(AnnotatedFeatureI destGene, boolean askBeforeMerging) {
        if (!destGene.isAnnotTop()) {
            this.showMessage(0, "consolidateGenes called with non-annotation " + destGene.getName());
            return null;
        }
        if (!this.isFirstTierAnnot(destGene)) {
            return null;
        }
        Transaction mergeTrans = null;
        Vector<AnnotatedFeatureI> overlapped_genes = new Vector<AnnotatedFeatureI>();
        overlapped_genes.addElement(destGene);
        if (this.findMerges(destGene, overlapped_genes)) {
            mergeTrans = new CompoundTransaction(2, this);
            for (int i = 0; i < overlapped_genes.size(); ++i) {
                boolean answer;
                AnnotatedFeatureI g = (AnnotatedFeatureI)overlapped_genes.elementAt(i);
                if (g == destGene) continue;
                System.out.println(g.getName() + " at " + g.getStart() + "-" + g.getEnd() + " is a " + g.getTopLevelType() + " and overlaps " + destGene.getTopLevelType() + " " + destGene.getName() + " at " + destGene.getStart() + "-" + destGene.getEnd());
                if (askBeforeMerging && !destGene.getName().equals(g.getName()) && !(answer = this.askMergeDialog(destGene.getName() + " and " + g.getName()))) continue;
                int size = g.size();
                for (int j = 0; j < size; ++j) {
                    Transcript t = (Transcript)g.getFeatureAt(0);
                    CompoundTransaction ct = this.purgeTranscript(g, t);
                    ((CompoundTransaction)mergeTrans).addTransaction(ct);
                    AddTransaction at = this.addTranscript(destGene, t);
                    ((CompoundTransaction)mergeTrans).addTransaction(at);
                }
                CompoundTransaction ct = this.mergeGeneIdentifiers(destGene, g);
                ((CompoundTransaction)mergeTrans).addTransaction(ct);
            }
        }
        if (mergeTrans == null || !mergeTrans.hasKids()) {
            return null;
        }
        return mergeTrans;
    }

    private boolean askMergeDialog(String geneNames) {
        Object[] options = new Object[]{"Merge", "Don't merge"};
        String message = "There are overlapping genes in this region: " + geneNames + ".\nDo you want to merge these overlapping genes into a single gene?";
        System.out.println(message);
        JOptionPane pane = new JOptionPane(message, -1, 2, null, options, options[0]);
        JDialog dialog = pane.createDialog(null, "Please Confirm");
        dialog.show();
        Object result = pane.getValue();
        if (result != null && ((String)result).equals("Merge")) {
            System.out.println("Merging genes...");
            return true;
        }
        return false;
    }

    public void setTranslationStart(ExonI exon, int pos) {
        Transcript trans = (Transcript)exon.getRefFeature();
        RangeI oldRange = trans.getTranslationRange();
        if (trans.setTranslationStart(pos, true)) {
            trans.setMissing5prime(false);
            trans.setPeptideValidity(false);
            trans.setOwner(this.getUserName());
            trans.replaceProperty("date", new Date().toString());
            Transaction t = this.updatePeptideRange(trans, oldRange);
            this.getController().handleAnnotationChangeEvent(t.generateAnnotationChangeEvent());
        }
    }

    Transaction updatePeptideRange(SeqFeatureI trans, RangeI oldRange) {
        Transaction transaction = null;
        if (trans.hasPeptideSequence() && trans.getPeptideSequence().hasName() && trans.getPeptideSequence().getAccessionNo() != null) {
            TransactionSubpart ts = TransactionSubpart.PEPTIDE_LIMITS;
            transaction = new UpdateTransaction(this, trans, ts, oldRange, trans);
        } else {
            trans.getPeptideSequence().setName("temp");
            trans.getPeptideSequence().setAccessionNo("temp");
            boolean isAddPeptide = true;
            transaction = new AddTransaction(this, trans, isAddPeptide);
        }
        return transaction;
    }

    public void setFrameShiftPosition(ExonI exon, int pos, boolean plus1) {
        TransactionSubpart subpart;
        int oldPos;
        Transcript trans = (Transcript)exon.getRefFeature();
        boolean okay = false;
        this.synchTranscript(trans);
        if (plus1) {
            oldPos = trans.plus1FrameShiftPosition();
            okay = trans.setPlus1FrameShiftPosition(pos);
            subpart = TransactionSubpart.PLUS_1_FRAMESHIFT;
        } else {
            oldPos = trans.minus1FrameShiftPosition();
            okay = trans.setMinus1FrameShiftPosition(pos);
            subpart = TransactionSubpart.MINUS_1_FRAMESHIFT;
        }
        if (okay) {
            trans.setPeptideValidity(false);
            trans.setOwner(this.getUserName());
            trans.replaceProperty("date", new Date().toString());
            AnnotationUpdateEvent aue = new AnnotationUpdateEvent((Object)this, trans, subpart);
            aue.setOldInt(oldPos);
            this.fireSingleChange(aue);
        }
    }

    private void fireSingleChange(AnnotationChangeEvent ace) {
        ace.setSingularEventState(true);
        ChangeList acc = this.createCoalescer();
        acc.addChange(ace);
        acc.executeChanges();
    }

    private void fireCompoundTransaction(CompoundTransaction ct) {
        if (ct == null) {
            return;
        }
        ct.setSource(this);
        this.fireSingleChange(ct.generateAnnotationChangeEvent());
    }

    private void fireTransaction(Transaction t) {
        if (t == null) {
            return;
        }
        t.setSource(this);
        this.fireSingleChange(t.generateAnnotationChangeEvent());
    }

    public void setSequencingErrorPositions(SequenceI seq, String operation, int pos, String residue, FeatureList annots) {
        Transaction transaction;
        SequenceEdit seqEdit;
        boolean editSuccessful = false;
        if (operation == "NOP") {
            if (!seq.isSequencingErrorPosition(pos)) {
                System.out.println("Error, no seq err to remove at pos " + pos);
                return;
            }
            seqEdit = seq.getSequencingErrorAtPosition(pos);
            SeqFeature dummyParent = new SeqFeature();
            transaction = new DeleteTransaction((SeqFeatureI)seqEdit, dummyParent, (Object)this);
            editSuccessful = seq.removeSequenceEdit(seqEdit);
        } else {
            seqEdit = new SequenceEdit(operation, pos, residue);
            ApolloNameAdapterI na = this.getNameAdapter(seqEdit);
            seqEdit.setId(na.generateId(this.curation.getAnnots(), null, seqEdit));
            AddTransaction at = new AddTransaction(this, seqEdit);
            at.setResidues(seqEdit.getResidue());
            transaction = at;
            editSuccessful = seq.addSequenceEdit(seqEdit);
        }
        if (!editSuccessful) {
            System.out.println("Seq error edit failed at " + pos);
            return;
        }
        int annot_count = annots.size();
        for (int i = 0; i < annot_count; ++i) {
            SeqFeatureI annot = annots.getFeature(i);
            if (!annot.isAnnot()) {
                System.out.println("ERROR: non-annot in getSeqErrPosition");
                continue;
            }
            this.setSelections(null, null, null, null);
            this.redoTranscriptTranslation(annot.getAnnotatedFeature());
        }
        this.fireTransaction(transaction);
    }

    private void redoTranscriptTranslation(AnnotatedFeatureI annot) {
        if (annot.isExon() && annot.getRefFeature().isTranscript()) {
            SeqFeatureI trans = annot.getRefFeature();
            this.synchTranscript(trans);
            TranslationI translation = trans.getTranslation();
            System.out.println("old stop " + translation.getTranslationEnd());
            translation.setTranslationEndFromStart();
            System.out.println("new stop " + translation.getTranslationEnd());
            translation.setPeptideValidity(false);
            trans.getAnnotatedFeature().setOwner(this.getUserName());
            trans.replaceProperty("date", new Date().toString());
        }
    }

    public void setLongestORF() {
        Vector trans_vect = this.annotSet.getTranscripts();
        int trans_count = trans_vect.size();
        for (int i = 0; i < trans_count; ++i) {
            Transcript trans;
            ChangeList changer = this.beginEdit("Set longest ORF");
            try {
                trans = (Transcript)trans_vect.elementAt(i);
                trans.setPeptideValidity(false);
                trans.setOwner(this.getUserName());
            }
            catch (Exception e) {
                FeatureSetI fs = (FeatureSetI)trans_vect.elementAt(i);
                System.out.println(fs.getName() + " is not a Transcript " + " it is a " + fs.getClass().getName());
                continue;
            }
            trans.calcTranslationStartForLongestPeptide();
            trans.replaceProperty("date", new Date().toString());
            this.endEdit(changer, true, trans, 5);
        }
        this.createCoalescer().executeChanges();
    }

    public boolean setTranslationTerminusAllowed() {
        return this.cursorSet.getLeafFeatures().size() == 1 && this.siteSet.getLeafFeatures().size() == 1;
    }

    public void setTranslationTerminus() {
        if (this.cursorSet.getLeafFeatures().size() != 1 || this.siteSet.getLeafFeatures().size() != 1) {
            this.showMessage(0, "Must select exactly one terminus and one exon");
            return;
        }
        if (!(this.cursorSet.getLeafFeat(0) instanceof ExonI) || this.siteSet.getLeafFeat(0).getFeatureType().indexOf("codon") < 0) {
            this.showMessage(0, "Wrong types in setTranslationTerminus");
            return;
        }
        this.setTranslationTerminus((ExonI)this.cursorSet.getLeafFeat(0), this.siteSet.getLeafFeat(0));
    }

    private void setTranslationTerminus(ExonI exon, SeqFeatureI codon) {
        if (!exon.contains(codon)) {
            this.showMessage(0, "Exon doesn't contain terminal codon range.");
            return;
        }
        if (!(exon.getRefFeature() instanceof Transcript)) {
            this.showMessage(0, "Exon parent not Transcript");
            return;
        }
        Transcript trans = (Transcript)exon.getRefFeature();
        if (codon.getFeatureType().startsWith("startcodon")) {
            trans.setTranslationStart(codon.getStart(), true);
            trans.setMissing5prime(false);
        } else if (codon.getFeatureType().startsWith("stopcodon")) {
            int stopPos = codon.getStart();
            if (this.isRangeOK(trans, trans.getTranslationStart(), stopPos)) {
                trans.setTranslationEnd(stopPos);
                trans.setMissing3prime(false);
            } else {
                this.showMessage(0, "Can't set stop before the start");
                return;
            }
        }
        trans.setPeptideValidity(false);
        trans.setOwner(this.getUserName());
        trans.replaceProperty("date", new Date().toString());
        this.createCoalescer().executeChanges();
    }

    public void setSpliceSite() {
        if (this.cursorSet.getLeafFeatures().size() != 1 || this.evidenceSet.getLeafFeatures().size() != 1) {
            this.showMessage(0, "Must select exactly one splice site and one exon");
            return;
        }
        if (!(this.cursorSet.getLeafFeat(0) instanceof ExonI) || this.evidenceSet.getLeafFeat(0).getFeatureType().indexOf("splice") < 0) {
            this.showMessage(0, "Wrong types in setSpliceSite");
            return;
        }
        this.setSpliceSite((ExonI)this.cursorSet.getLeafFeat(0), this.evidenceSet.getLeafFeat(0));
    }

    private void setSpliceSite(ExonI exon, SeqFeatureI site) {
        if (!(exon.getRefFeature() instanceof Transcript)) {
            this.showMessage(0, "Exon with non Transcript parent");
            return;
        }
        Transcript trans = (Transcript)exon.getRefFeature();
        int exIndex = trans.getFeatureIndex(exon);
        String site_type = site.getFeatureType();
        if (!site_type.equals("donor") && !site_type.equals("acceptor")) {
            site_type = site.getRefFeature().getProperty("splice");
        }
        if (site_type.equals("donor")) {
            if (exIndex == trans.size() - 1) {
                this.showMessage(0, "Can't set donor site on last exon");
                return;
            }
            if (this.isExonOverlap(trans.getGene(), exon, exon.getStart(), site.getEnd())) {
                this.showMessage(0, "Can't set donor site because it would cause overlap");
                return;
            }
            if (!this.isRangeOK(exon, exon.getStart(), site.getEnd())) {
                return;
            }
            exon.setEnd(site.getEnd());
        } else if (site_type.equals("acceptor")) {
            if (exIndex == 0) {
                this.showMessage(0, "Can't set acceptor site on first exon");
                return;
            }
            if (this.isExonOverlap(trans.getGene(), exon, site.getStart(), exon.getEnd())) {
                this.showMessage(0, "Can't set acceptor site because it would cause overlap");
                return;
            }
            if (!this.isRangeOK(exon, site.getStart(), exon.getEnd())) {
                return;
            }
            exon.setStart(site.getEnd());
        } else {
            this.showMessage(0, "Can't set splice site of type " + site.getFeatureType());
            return;
        }
        this.setGeneEnds(trans);
        ChangeList changer = this.beginEdit("set splice site");
        this.endEdit(changer, true, trans.getGene(), 5);
    }

    protected boolean isRangeOK(SeqFeatureI sf, int start, int end) {
        if (sf.getStrand() == 1 && start > end || sf.getStrand() == -1 && end > start) {
            this.showMessage(0, "Range is not okay - ignoring");
            return false;
        }
        if (sf.getStrand() == 0) {
            this.showMessage(2, "0 stranded feature");
        }
        return true;
    }

    private boolean isExonOverlap(AnnotatedFeatureI gene, AnnotatedFeatureI exon, int start, int end) {
        int trans_count = gene.size();
        for (int i = 0; i < trans_count; ++i) {
            if (!this.isExonOverlapInTrans(gene.getFeatureAt(i), exon, start, end)) continue;
            return true;
        }
        return false;
    }

    private boolean isExonOverlapInTrans(SeqFeatureI trans, AnnotatedFeatureI exon, int start, int end) {
        int exIndex = trans.getFeatureIndex(exon);
        if (exIndex != -1) {
            if (trans.getStrand() == 1) {
                if (exIndex != trans.size() - 1 && trans.getFeatureAt(exIndex + 1).getStart() <= end) {
                    return true;
                }
                if (exIndex != 0 && trans.getFeatureAt(exIndex - 1).getEnd() >= start) {
                    return true;
                }
            } else if (trans.getStrand() == -1) {
                if (exIndex != trans.size() - 1 && trans.getFeatureAt(exIndex + 1).getStart() >= end) {
                    return true;
                }
                if (exIndex != 0 && trans.getFeatureAt(exIndex - 1).getEnd() <= start) {
                    return true;
                }
            } else {
                this.showMessage(0, "Unstranded transcript");
                return false;
            }
            return false;
        }
        return false;
    }

    public boolean resultIsSelected() {
        return this.evidenceSet.getLeafFeatures().size() > 0;
    }

    private void errorMsgWithStackTrace(String errMsg, boolean popup) {
        errMsg = "Programmer error: " + errMsg;
        if (popup) {
            JOptionPane.showMessageDialog(null, errMsg);
        }
        errMsg = errMsg + " Here is a stack trace for an apollo programmer to use for debugging:";
        System.err.println(errMsg);
        new Throwable().printStackTrace();
    }

    public void flipResult() {
        if (!this.resultIsSelected()) {
            return;
        }
        Vector features = this.evidenceSet.getSets();
        StrandedZoomableApolloPanel szap = this.getCurationState().getSZAP();
        ResultView resultView = null;
        for (int i = 0; i < features.size(); ++i) {
            FeatureSetI feature = (FeatureSetI)features.elementAt(i);
            FeatureSetI parent = (FeatureSetI)feature.getRefFeature();
            parent.deleteFeature(feature);
            ResultChangeEvent rm_evt = new ResultChangeEvent(this, parent, 2, 17, parent, feature);
            this.getController().handleResultChangeEvent(rm_evt);
            resultView = szap.getViewForFeature(feature);
            feature.flipFlop();
            SeqFeatureI newParent = parent.getAnalogousOppositeStrandFeature();
            if (!parent.hasAnalogousOppositeStrandFeature()) {
                newParent = this.createOppositeStrandAnalysisFeature(parent);
            }
            newParent.addFeature(feature, true);
            ResultChangeEvent add_evt = new ResultChangeEvent(this, newParent, 1, 17, newParent, feature);
            this.getController().handleResultChangeEvent(add_evt);
        }
        FeatureSetI top_forward = szap.getForwardResults();
        FeatureSetI top_reverse = szap.getReverseResults();
        ResultChangeEvent redraw_evt = new ResultChangeEvent(this, top_forward, 5, 17, null, null);
        this.getController().handleResultChangeEvent(redraw_evt);
        redraw_evt = new ResultChangeEvent(this, top_reverse, 5, 17, null, null);
        this.getController().handleResultChangeEvent(redraw_evt);
        if (resultView != null) {
            this.selectFeatures(features, resultView);
        }
    }

    private SeqFeatureI createOppositeStrandAnalysisFeature(SeqFeatureI analysis) {
        SeqFeatureI oppositeAnalysis = analysis.cloneFeature();
        oppositeAnalysis.clearKids();
        int strand = analysis.getStrand() * -1;
        oppositeAnalysis.setStrand(strand);
        boolean isForward = oppositeAnalysis.isForwardStrand();
        String n = analysis.getProgramName() + ":" + analysis.getDatabase();
        n = n + (isForward ? "-plus" : "-minus");
        oppositeAnalysis.setName(n);
        StrandedFeatureSetI resultsBothStrands = analysis.getStrandedFeatSetAncestor();
        FeatureSetI strandParent = resultsBothStrands.getFeatSetForStrand(strand);
        strandParent.addFeature(oppositeAnalysis);
        analysis.setAnalogousOppositeStrandFeature(oppositeAnalysis);
        oppositeAnalysis.setAnalogousOppositeStrandFeature(analysis);
        ResultChangeEvent add_evt = new ResultChangeEvent(this, strandParent, 1, 17, strandParent, oppositeAnalysis);
        this.getController().handleResultChangeEvent(add_evt);
        return oppositeAnalysis;
    }

    public boolean addEvidenceExonsAllowed() {
        return this.goodEvidence(this.cursorSet.getTranscripts(), this.evidenceSet.getLeafFeatures());
    }

    protected boolean goodEvidence(Vector transcripts, Vector features) {
        boolean allowed = false;
        if (transcripts.size() == 1 && features.size() > 0) {
            Transcript trans = (Transcript)transcripts.elementAt(0);
            for (int i = 0; i < features.size() && !allowed; ++i) {
                SeqFeatureI possible_evidence = (SeqFeatureI)features.elementAt(i);
                if (possible_evidence.getId() == null) continue;
                for (int j = 0; j < trans.size() && !allowed; ++j) {
                    ExonI exon = trans.getExonAt(j);
                    allowed = possible_evidence.overlaps(exon);
                }
            }
        }
        return allowed;
    }

    protected boolean validNewExons(Vector transcripts, Vector features) {
        boolean allowed = false;
        if (transcripts.size() == 1 && features.size() > 0) {
            Transcript trans = (Transcript)transcripts.elementAt(0);
            for (int i = 0; i < features.size() && !allowed; ++i) {
                ExonI exon;
                SeqFeatureI possible_evidence = (SeqFeatureI)features.elementAt(i);
                if (possible_evidence.getId() == null) continue;
                allowed = true;
                for (int j = 0; j < trans.getExons().size() && allowed; allowed &= !possible_evidence.overlaps(exon = trans.getExonAt(j)), ++j) {
                }
            }
        }
        return allowed;
    }

    public void addEvidenceExons() {
        switch (this.cursorSet.getTranscripts().size()) {
            case 0: {
                this.showMessage(0, "Selected NO transcript to add exon evidence to");
                break;
            }
            case 1: {
                this.addEvidenceExons(this.cursorSet.getTranscript(0), this.evidenceSet.getLeafFeatures(), 1);
                break;
            }
            default: {
                this.showMessage(0, "Selected more than 1 transcript to add exon evidence to");
            }
        }
    }

    private void addEvidenceExons(Transcript trans, Vector features, int evidenceType) {
        ChangeList changer = this.beginEdit("add evidence exons");
        this.addEvidenceExons(trans, features, changer, evidenceType);
        this.endEdit(changer, true, trans.getGene(), 5);
    }

    private void addEvidenceExons(Transcript trans, Vector features, ChangeList changer, int evidenceType) {
        SeqFeatureI newEvidence = null;
        int nadded = 0;
        for (int i = 0; i < features.size(); ++i) {
            newEvidence = (SeqFeatureI)features.elementAt(i);
            if (newEvidence.getId() == null) continue;
            boolean added = false;
            for (int j = 0; j < trans.size(); ++j) {
                ExonI exon = trans.getExonAt(j);
                if (!newEvidence.overlaps(exon)) continue;
                exon.addEvidence(newEvidence.getId(), evidenceType);
                added = true;
                ++nadded;
            }
            if (added) continue;
            this.showMessage(0, "Tried to add non overlapping evidence");
        }
    }

    public boolean removeEvidenceExonsAllowed() {
        return this.goodEvidence(this.annotSet.getTranscripts(), this.evidenceSet.getLeafFeatures());
    }

    public void removeEvidenceExons() {
        switch (this.annotSet.getTranscripts().size()) {
            case 0: {
                this.showMessage(0, "Selected NO transcript to remove exon evidence from");
                break;
            }
            case 1: {
                this.removeEvidenceExons(this.annotSet.getTranscript(0), this.evidenceSet.getLeafFeatures());
                break;
            }
            default: {
                this.showMessage(0, "Selected more than 1 transcript to remove exon evidence from");
            }
        }
    }

    public void removeEvidenceExons(Transcript trans, Vector features) {
        ChangeList changer = this.beginEdit("remove evidence exons");
        this.removeEvidenceExons(trans, features, changer);
        this.endEdit(changer, true, trans.getGene(), 5);
    }

    protected void removeEvidenceExons(Transcript trans, Vector features, ChangeList changer) {
        SeqFeatureI feature = null;
        int nremoved = 0;
        for (int i = 0; i < features.size(); ++i) {
            feature = (SeqFeatureI)features.elementAt(i);
            boolean removed = false;
            if (feature.getId() != null) {
                for (int j = 0; j < trans.size(); ++j) {
                    ExonI exon = trans.getExonAt(j);
                    int nDel = exon.deleteEvidence(feature.getId());
                    if (nDel <= 0) continue;
                    if (removed) {
                        this.showMessage(2, "Evidence " + feature.getId() + " removed from multiple exons");
                    }
                    removed = true;
                    nremoved += nDel;
                }
                if (removed) continue;
                this.showMessage(0, "Tried to delete feature which is not evidence");
                continue;
            }
            System.err.println("WARNING: Tried to remove evidence with null ID (this may be OK)");
        }
    }

    public boolean addExonsAllowed() {
        if (!this.validNewExons(this.cursorSet.getTranscripts(), this.evidenceSet.getLeafFeatures())) {
            return false;
        }
        if (this.warnOnEdit(this.cursorSet.getTranscripts())) {
            JOptionPane.showMessageDialog(null, "Please note: the selected annotation is protected,\nso you shouldn't add exons to it.");
        }
        return true;
    }

    public boolean warnOnEdit(Vector transcripts) {
        FeatureSetI feat = (FeatureSetI)transcripts.elementAt(transcripts.size() - 1);
        SeqFeatureI parent = feat.getRefFeature();
        if (Config.getPropertyScheme().getFeatureProperty(feat.getTopLevelType()).warnOnEdit()) {
            return true;
        }
        if (this.checkFeatureAndParentForProperty("warn_about_edit", feat, parent)) {
            return true;
        }
        if (this.checkFeatureAndParentForProperty("unstranded", feat, parent)) {
            return true;
        }
        if (feat.hasReadThroughStop()) {
            return true;
        }
        if (this.checkFeatureAndParentForProperty("mutant_in_strain", feat, parent)) {
            return true;
        }
        return this.checkFeatureAndParentForProperty("transpliced_transcript", feat, parent);
    }

    private boolean checkFeatureAndParentForProperty(String property, FeatureSetI feat, SeqFeatureI parent) {
        return !feat.getProperty(property).equals("") && !feat.getProperty(property).equals("0") && !feat.getProperty(property).equals("false") || parent != null && !parent.getProperty(property).equals("") && !parent.getProperty(property).equals("0") && !parent.getProperty(property).equals("false");
    }

    public void addExons() {
        switch (this.cursorSet.getTranscripts().size()) {
            case 0: {
                this.showMessage(0, "Selected NO transcript to add exons to");
                this.printSets();
                break;
            }
            case 1: {
                this.addExons(this.cursorSet.getTranscript(0), this.evidenceSet.getLeafFeatures());
                break;
            }
            default: {
                this.showMessage(0, "Selected more than 1 transcript to add exons to");
            }
        }
    }

    public void addExons(Transcript trans, Vector features) {
        SeqFeatureI resFeature = null;
        ExonI ex = null;
        Vector<SeqFeatureI> added = new Vector<SeqFeatureI>();
        this.checkIfBeyondRange();
        System.out.println("\n\t****** ADDING EXONS ******");
        Vector<Exon> exons_to_add = new Vector<Exon>();
        boolean warnedAboutCollapsedTier = false;
        for (int i = 0; i < features.size(); ++i) {
            ExonI exon;
            resFeature = (SeqFeatureI)features.elementAt(i);
            if (!(warnedAboutCollapsedTier || resFeature.getFeatureType().equals("tmptype") || Config.getPropertyScheme().getTierProperty(resFeature.getFeatureType()).isExpanded())) {
                String warning = "Warning: adding possibly multiple features from collapsed tier (" + resFeature.getFeatureType() + ")";
                this.showMessage(2, warning);
                warnedAboutCollapsedTier = true;
            }
            boolean allowed = true;
            for (int j = 0; j < trans.size() && allowed; allowed &= !(exon = trans.getExonAt(j)).overlaps(resFeature), ++j) {
            }
            if (!allowed) continue;
            added.addElement(resFeature);
            boolean merged = false;
            for (int j = 0; j < exons_to_add.size() && !merged; ++j) {
                ExonI sf = (ExonI)exons_to_add.elementAt(j);
                merged = sf.overlaps(resFeature);
                if (!merged) continue;
                sf.merge(resFeature);
            }
            if (merged) continue;
            if (trans.getStrand() != resFeature.getStrand()) {
                System.err.println("Warning: Catering for incorrect strand in result");
                resFeature = new SeqFeature(resFeature.getLow(), resFeature.getHigh(), resFeature.getFeatureType(), trans.getStrand());
            }
            Exon newExon = new Exon(resFeature);
            exons_to_add.addElement(newExon);
        }
        ChangeList changer = this.beginEdit("add exons");
        if (exons_to_add.size() == 0) {
            this.showMessage(0, "Tried to add overlapping exon(s)");
        } else {
            for (int i = 0; i < exons_to_add.size(); ++i) {
                ex = (ExonI)exons_to_add.elementAt(i);
                trans.addExon(ex);
                this.setExonID(ex, trans.getGene().getId());
                ex.setEvidenceFinder(trans.getEvidenceFinder());
                AnnotationAddEvent aae = new AnnotationAddEvent((Object)this, ex);
                changer.addChange(aae);
            }
            changer.executeChanges();
            trans.setOwner(this.getUserName());
            trans.replaceProperty("date", new Date().toString());
            CompoundTransaction ct = this.consolidateGenes(trans.getGene());
            if (ct != null) {
                changer.addChange(ct.generateAnnotationChangeEvent());
            }
        }
        trans.setPeptideValidity(false);
        trans.setTranslationEndFromStart();
        this.endEdit(changer, true, trans.getGene(), 5);
    }

    protected Vector findOverlappingAnnots(Vector features) {
        Vector annots = this.annotationCollection.getFeatures();
        Vector<AnnotatedFeatureI> overlapGenes = new Vector<AnnotatedFeatureI>();
        for (int i = 0; i < annots.size(); ++i) {
            AnnotatedFeatureI gi = (AnnotatedFeatureI)annots.elementAt(i);
            if (!this.isFirstTierAnnot(gi)) continue;
            for (int j = 0; j < features.size(); ++j) {
                SeqFeatureI sf = (SeqFeatureI)features.elementAt(j);
                if (!this.areOverlapping(gi, sf) || !gi.isAnnotTop() || overlapGenes.contains(gi)) continue;
                overlapGenes.addElement(gi);
            }
        }
        return overlapGenes;
    }

    public boolean isFirstTierAnnot(FeatureSetI annot) {
        return Config.getPropertyScheme().getTierProperty(annot.getFeatureType()).isFirstTier();
    }

    public boolean addGeneOrTranscriptAllowed() {
        return this.evidenceSet.getLeafFeatures().size() > 0 && this.cursorSet.getLeafFeatures().size() == 0;
    }

    public void addGeneOrTranscript() {
        this.addGeneOrTranscript(false);
    }

    public void addGeneOrTranscript(boolean overlapping) {
        if (!this.addGeneOrTranscriptAllowed()) {
            this.showMessage(0, "Add gene or transcript not allowed when no features selected");
            return;
        }
        this.checkIfBeyondRange();
        if (overlapping) {
            this.addOverlappingGene(this.evidenceSet.getLeafFeatures());
        } else {
            this.addAnnotOrTranscript(this.evidenceSet.getLeafFeatures());
        }
    }

    public void addNewAnnot(String type) {
        if (this.evidenceSet.getLeafFeatures().size() == 0) {
            this.createAnnotation(type);
            return;
        }
        if (this.cursorSet.getLeafFeatures().size() > 0) {
            this.showMessage(0, "To create a new annotation, select only results, not existing annotations.\nIf you want to add a transcript to an existing annotation, use the menu option 'Add as new transcript to selected gene'.");
            return;
        }
        this.checkIfBeyondRange();
        this.addAnnotation(this.evidenceSet.getLeafFeatures(), false, type);
    }

    private void addAnnotOrTranscript(Vector features) {
        Vector overlapAnnots = this.findOverlappingAnnots(features);
        if (overlapAnnots.size() == 0) {
            this.addAnnot(features, false);
        } else if (overlapAnnots.size() == 1) {
            this.addTranscript((AnnotatedFeatureI)overlapAnnots.elementAt(0), features);
        } else {
            this.twoOrMoreOverlappingAnnots(features, overlapAnnots);
        }
    }

    private void twoOrMoreOverlappingAnnots(Vector features, Vector overlapAnnots) {
        String geneNames = "";
        for (int i = 0; i < overlapAnnots.size(); ++i) {
            AnnotatedFeatureI g = (AnnotatedFeatureI)overlapAnnots.elementAt(i);
            geneNames = geneNames + g.getName();
            if (i == overlapAnnots.size() - 2) {
                geneNames = geneNames + " and ";
                continue;
            }
            if (i >= overlapAnnots.size() - 2) continue;
            geneNames = geneNames + ", ";
        }
        Vector<String> options = new Vector<String>();
        options.add("New annotation");
        options.add("Merge annotations");
        for (int i = 0; i < overlapAnnots.size(); ++i) {
            options.add("Add to " + DetailInfo.getName((SeqFeatureI)overlapAnnots.elementAt(i)));
        }
        options.add("Cancel");
        Object[] optionsArray = options.toArray();
        JOptionPane pane = new JOptionPane("The selected features overlap more than one annotation: " + geneNames + ".\n Please choose an option:\n" + "- Add selected features as new separate but overlapping annotation\n" + "- Merge " + geneNames + " using selected features\n" + (overlapAnnots.size() > 0 ? "- Add as new transcript of " + overlapAnnots.elementAt(0) + "\n" : "") + (overlapAnnots.size() > 1 ? "- Add as new transcript of " + overlapAnnots.elementAt(1) + "\n" : "") + "- Cancel", -1, 2, null, optionsArray, optionsArray[1]);
        JDialog dialog = pane.createDialog(null, "Please Confirm");
        dialog.show();
        Object result = pane.getValue();
        if (result == null || ((String)result).equals("Cancel")) {
            return;
        }
        if (((String)result).equals(optionsArray[0])) {
            this.addNewAnnot(null);
        } else if (((String)result).equals(optionsArray[1])) {
            this.addTranscript((AnnotatedFeatureI)overlapAnnots.elementAt(0), features, true, false);
        } else if (options.size() > 2 && ((String)result).equals(optionsArray[2])) {
            this.addTranscript((AnnotatedFeatureI)overlapAnnots.elementAt(0), features, false, false);
        } else if (options.size() > 3 && ((String)result).equals(optionsArray[3])) {
            this.addTranscript((AnnotatedFeatureI)overlapAnnots.elementAt(1), features, false, false);
        } else if (options.size() > 4 && ((String)result).equals(optionsArray[4])) {
            this.addTranscript((AnnotatedFeatureI)overlapAnnots.elementAt(2), features, false, false);
        } else if (options.size() > 5 && ((String)result).equals(optionsArray[5])) {
            this.addTranscript((AnnotatedFeatureI)overlapAnnots.elementAt(3), features, false, false);
        }
    }

    public boolean addOverlappingAllowed() {
        Vector features = this.evidenceSet.getLeafFeatures();
        if (features.size() == 0) {
            return false;
        }
        Vector overlapGenes = this.findOverlappingAnnots(features);
        return overlapGenes.size() >= 1;
    }

    public void addOverlappingGene(Vector features) {
        this.addAnnot(features, false);
    }

    private CompoundTransaction setTransNameAndId(Transcript trans) {
        CompoundTransaction compoundTransaction = new CompoundTransaction(this);
        CompoundTransaction ct = this.setTransID(trans);
        compoundTransaction.addTransaction(ct);
        CompoundTransaction nameTransaction = this.setTransName(trans);
        compoundTransaction.addTransaction(nameTransaction);
        compoundTransaction.setSource(this);
        return compoundTransaction;
    }

    private CompoundTransaction setTransName(Transcript trans) {
        ApolloNameAdapterI nameAdapter = this.curationState.getNameAdapter(trans.getGene());
        String newName = nameAdapter.generateName(this.curation.getAnnots(), this.curation.getName(), trans);
        CompoundTransaction ct = nameAdapter.setTranscriptName(trans, newName);
        return ct;
    }

    private CompoundTransaction setTransID(Transcript trans) {
        ApolloNameAdapterI nameAdapter = this.curationState.getNameAdapter(trans.getGene());
        String tID = nameAdapter.generateId(this.curation.getAnnots(), this.curation.getName(), trans);
        CompoundTransaction compoundTransaction = nameAdapter.setTranscriptId(trans, tID);
        this.setExonIdsFromTranscript(trans);
        return compoundTransaction;
    }

    private UpdateTransaction setID(AnnotatedFeatureI annot, String newId) {
        TransactionSubpart ts = TransactionSubpart.ID;
        UpdateTransaction ut = new UpdateTransaction(annot, ts, annot.getId(), newId);
        ut.editModel();
        ut.setSource(this);
        return ut;
    }

    private void setExonIdsFromTranscript(Transcript trans) {
        for (int i = 0; i < trans.size(); ++i) {
            this.setExonID(trans.getExonAt(i), trans.getRefFeature().getId());
        }
    }

    private void setExonID(ExonI exon, String geneID) {
        exon.setId(this.getNameAdapter(exon).generateExonId(exon, geneID));
    }

    public boolean addTranscriptAllowed() {
        return this.addEvidenceExonsAllowed();
    }

    public void addTranscript() {
        if (this.annotSet.getTranscripts().size() != 1) {
            this.showMessage(2, "Can't add transcript to " + this.annotSet.getTranscripts().size() + "genes.  Please select exactly one gene transcript.");
            return;
        }
        Transcript trans = (Transcript)this.annotSet.getTranscripts().elementAt(0);
        AnnotatedFeatureI gene = trans.getGene();
        this.addTranscript(gene, this.evidenceSet.getLeafFeatures(), false, false);
    }

    private void addTranscript(AnnotatedFeatureI gene, Vector features) {
        this.addTranscript(gene, features, true, true);
    }

    private void addTranscript(AnnotatedFeatureI gene, Vector features, boolean mergeOverlapping, boolean askAboutMerge) {
        this.addTranscript(gene, features, null, mergeOverlapping, askAboutMerge);
    }

    private void addTranscript(AnnotatedFeatureI gene, Vector features, String type, boolean mergeOverlapping, boolean askAboutMerge) {
        CompoundTransaction merge;
        System.out.println("\n\t****** ADDING TRANSCRIPT ******");
        boolean warnedAboutCollapsedTier = false;
        for (int i = 0; i < features.size(); ++i) {
            SeqFeatureI resFeature = (SeqFeatureI)features.elementAt(i);
            if (warnedAboutCollapsedTier || resFeature.getFeatureType().equals("tmptype") || Config.getPropertyScheme().getTierProperty(resFeature.getFeatureType()).isExpanded()) continue;
            String warning = "Warning: adding possibly multiple features from collapsed tier (" + resFeature.getFeatureType() + ")";
            this.showMessage(2, warning);
            warnedAboutCollapsedTier = true;
        }
        Transcript trans = this.buildTranscript(gene, features, type);
        if (gene.isProteinCodingGene()) {
            trans.calcTranslationStartForLongestPeptide();
        }
        this.setTransNameAndId(trans);
        trans.setOwner(this.getUserName());
        trans.replaceProperty("date", new Date().toString());
        if (this.annotationView != null && this.annotationView.getEvidenceFinder() != null) {
            gene.setEvidenceFinder(this.annotationView.getEvidenceFinder());
        } else {
            System.err.println("Error: Didn't set EF for new annotations");
        }
        ChangeList changer = this.beginEdit("add transcript");
        AnnotationAddEvent aae = new AnnotationAddEvent((Object)this, trans);
        changer.addChange(aae);
        changer.executeChanges();
        this.addEvidenceExons(trans, features, changer, 1);
        if (mergeOverlapping && (merge = this.consolidateGenes(gene, true)) != null) {
            changer.addChange(merge.generateAnnotationChangeEvent());
        }
        this.endEdit(changer, true, gene, 5);
    }

    protected boolean userReallyWantsToSplit(AnnotatedFeatureI orig_gene) {
        String prevName = orig_gene.getName();
        String prevId = orig_gene.getId();
        Object[] options = new Object[]{"Split", "Cancel"};
        if (!prevName.equals(prevId)) {
            prevName = prevName + " (" + prevId + ")?";
        }
        String msg = "Are you sure you want gene " + prevName + " to be split?";
        JOptionPane pane = new JOptionPane(msg, -1, 2, null, options, options[0]);
        JDialog dialog = pane.createDialog(null, "Please Confirm");
        dialog.show();
        Object result = pane.getValue();
        return result != null && ((String)result).equals("Split");
    }

    private Transcript buildTranscript(AnnotatedFeatureI gene, Vector features, String type) {
        Transcript t = new Transcript();
        SequenceI seq = null;
        String site = "";
        String annot_type = null;
        boolean inherit_type = true;
        for (int i = 0; i < features.size(); ++i) {
            Object elem = features.elementAt(i);
            if (elem instanceof SeqFeatureI) {
                SeqFeatureI sf = (SeqFeatureI)elem;
                Exon exon = new Exon(sf);
                if (seq == null) {
                    seq = sf.getRefSequence();
                }
                if (seq == null && this.annotationCollection != null) {
                    seq = this.annotationCollection.getRefSequence();
                }
                if (seq == null) {
                    System.err.println(sf.getName() + " (" + sf.getId() + ") " + "has no reference seq");
                }
                exon.setRefSequence(seq);
                t.setStrand(exon.getStrand());
                t.addFeature(exon, true);
                FeatureList overlappingExons = this.getOverlappingExons(t, exon);
                if (!overlappingExons.isEmpty()) {
                    this.mergeExons(t, overlappingExons);
                }
                this.setExonID(exon, gene.getId());
                if (site.equals("")) {
                    site = sf.getProperty("insertion_site");
                }
                if (site.equals("") && sf.getRefFeature() != null) {
                    site = sf.getRefFeature().getProperty("insertion_site");
                }
                String new_type = type == null ? this.getAnnotTypeForResult(sf) : type;
                inherit_type &= new_type != null && (new_type == null || annot_type == null || new_type.equals(annot_type));
                annot_type = new_type;
                continue;
            }
            System.err.println("ERROR: Feature vector contained non SeqFeatureI element");
        }
        t.setRefSequence(seq);
        t.addProperty("insertion_site", site);
        if (inherit_type) {
            gene.setFeatureType(annot_type);
        }
        gene.setStrand(t.getStrand());
        gene.addFeature(t);
        return t;
    }

    private String getAnnotTypeForFeature(SeqFeatureI sf) {
        if (sf.isAnnot()) {
            return sf.getTopLevelType();
        }
        return this.getAnnotTypeForResult(sf);
    }

    private String getAnnotTypeForResult(RangeI sf) {
        PropertyScheme scheme = Config.getPropertyScheme();
        FeatureProperty fp = scheme.getFeatureProperty(sf.getFeatureType());
        String type = fp != null ? fp.getAnnotType() : FeatureProperty.getDefaultAnnotType();
        return type;
    }

    private FeatureList getOverlappingExons(SeqFeatureI transcript, SeqFeatureI exon) {
        FeatureList overlappingExons = new FeatureList();
        for (int i = 0; i < transcript.getNumberOfChildren(); ++i) {
            SeqFeatureI transExon = transcript.getFeatureAt(i);
            if (!transExon.overlaps(exon) || transExon == exon) continue;
            overlappingExons.addFeature(transcript.getFeatureAt(i));
        }
        if (overlappingExons.size() > 0 && !overlappingExons.contains(exon)) {
            overlappingExons.add(0, exon);
        }
        return overlappingExons;
    }

    private AnnotatedFeatureI newGeneSetup(Vector features, String type) {
        AnnotatedFeature annot = new AnnotatedFeature();
        if (type != null) {
            annot.setFeatureType(type);
        } else {
            this.setTypeFromFeatures(annot, features);
        }
        annot.setRefSequence(this.annotationCollection.getRefSequence());
        this.setAnnotNameEtc(annot, features);
        if (!this.isOneLevelAnnot(annot)) {
            this.buildTranscript(annot, features, type);
        } else {
            if (features.size() == 0) {
                return annot;
            }
            RangeI result = (RangeI)features.get(0);
            this.buildOneLevelAnnotFromResult(annot, result);
        }
        return annot;
    }

    private boolean isOneLevelAnnot(RangeI annot) {
        if (!DO_ONE_LEVEL_ANNOTS) {
            return false;
        }
        PropertyScheme ps = Config.getPropertyScheme();
        FeatureProperty fp = ps.getFeatureProperty(annot.getFeatureType());
        return fp.getNumberOfLevels() == 1;
    }

    private void buildOneLevelAnnotFromResult(RangeI annot, RangeI result) {
        annot.setStrand(result.getStrand());
        annot.setStart(result.getStart());
        annot.setEnd(result.getEnd());
    }

    private void setTypeFromFeatures(AnnotatedFeatureI annot, Vector resultFeats) {
        if (resultFeats.size() == 0) {
            return;
        }
        RangeI firstResult = (RangeI)resultFeats.get(0);
        String annotType = this.getAnnotTypeForResult(firstResult);
        if (annotType == null || annotType == "no_type") {
            annot.setFeatureType("gene");
        } else {
            annot.setFeatureType(annotType);
        }
    }

    private void setAnnotNameEtc(AnnotatedFeatureI annot, Vector resultExons) {
        this.annotationCollection.addFeature(annot, true);
        ApolloNameAdapterI nameAdapter = this.curationState.getNameAdapter(annot);
        String geneName = nameAdapter.generateName(this.curation.getAnnots(), this.curation.getName(), annot, resultExons);
        annot.setName(geneName);
        annot.setId(geneName);
        annot.setEvidenceFinder(this.annotationView.getEvidenceFinder());
    }

    private CompoundTransaction splitGeneSetup(FeatureSetI parent, AnnotatedFeatureI orig_gene, AnnotatedFeatureI new_gene) {
        CompoundTransaction compoundTransaction = new CompoundTransaction(this);
        parent.addFeature(new_gene, true);
        String prevName = orig_gene.getName();
        String orig_name = "";
        String new_name = "";
        ApolloNameAdapterI nameAdapter = this.curationState.getNameAdapter(new_gene);
        StrandedFeatureSetI annots = this.curation.getAnnots();
        String curation_name = this.curation.getName();
        new_name = nameAdapter.generateAnnotSplitName(orig_gene, annots, curation_name);
        new_gene.setName(new_name);
        if (nameAdapter.nameIsId(new_gene)) {
            new_gene.setId(new_gene.getName());
        } else {
            new_gene.setId(nameAdapter.generateId(annots, curation_name, new_gene));
        }
        boolean swapped = false;
        if (!Config.getStyle().queryForNamesOnSplit()) {
            System.out.println("not swapping name");
            orig_name = nameAdapter.generateAnnotSplitName(orig_gene, annots, curation_name);
        } else {
            System.out.println("swapping name");
            swapped = this.splitGeneNameDialog(orig_gene, new_gene);
            orig_name = orig_gene.getName();
            new_name = new_gene.getName();
            if (nameAdapter.nameIsId(new_gene)) {
                new_gene.setId(new_gene.getName());
            }
        }
        TransactionSubpart ts = TransactionSubpart.NAME;
        UpdateTransaction nameTrans = null;
        if (swapped || !Config.getStyle().queryForNamesOnSplit()) {
            nameTrans = new UpdateTransaction(orig_gene, ts, orig_gene.getName(), orig_name);
        }
        orig_gene.setName(orig_name);
        TransactionSubpart ts2 = TransactionSubpart.ID;
        String oldId = orig_gene.getId();
        if (nameAdapter.nameIsId(orig_gene)) {
            orig_gene.setId(orig_gene.getName());
        } else {
            orig_gene.setId(nameAdapter.generateId(annots, curation_name, orig_gene));
        }
        UpdateTransaction idTrans = new UpdateTransaction(orig_gene, ts2, oldId, orig_gene.getId());
        System.out.println("When " + prevName + " is split into two genes, one gene will have name=" + orig_gene.getName() + ", id=" + orig_gene.getId());
        compoundTransaction.addTransaction(idTrans);
        if (nameTrans != null) {
            compoundTransaction.addTransaction(nameTrans);
        }
        System.out.println(" and the other gene will have name=" + new_gene.getName() + ", id=" + new_gene.getId());
        new_gene.setEvidenceFinder(this.annotationView.getEvidenceFinder());
        compoundTransaction.addTransaction(this.copyAnnotData(orig_gene, new_gene));
        String username = this.getUserName();
        compoundTransaction.addTransaction(this.addSynonym(new_gene, prevName, username));
        compoundTransaction.addTransaction(this.addSynonym(orig_gene, prevName, username));
        return compoundTransaction;
    }

    private boolean splitGeneNameDialog(AnnotatedFeatureI left_gene, AnnotatedFeatureI right_gene) {
        String name1 = left_gene.getName();
        String name2 = right_gene.getName();
        Object[] options = new Object[]{"5' GENE", "3' GENE"};
        String message = "Please choose the gene to get the original name: left or right";
        System.out.println(message);
        JOptionPane pane = new JOptionPane(message, -1, 2, null, options, options[0]);
        JDialog dialog = pane.createDialog(null, "Please choose one");
        dialog.show();
        Object result = pane.getValue();
        boolean returnValue = false;
        if (result == "3' GENE") {
            left_gene.setName(name2);
            right_gene.setName(name1);
            returnValue = true;
        }
        return returnValue;
    }

    private CompoundTransaction setTransNameFromGene(AnnotatedFeatureI gene, boolean forceSet) {
        CompoundTransaction compTrans = new CompoundTransaction(this);
        int trans_count = gene.size();
        String gene_name = gene.getName();
        for (int i = 0; i < trans_count; ++i) {
            Transcript trans = (Transcript)gene.getFeatureAt(i);
            if (trans.getName().startsWith(gene_name) && !forceSet) continue;
            compTrans.addTransaction(this.setTransNameAndId(trans));
        }
        return compTrans;
    }

    public void duplicateTranscript(Transcript transcript) {
        this.checkIfBeyondRange();
        System.out.println("\n\t****** DUPLICATING TRANSCRIPT ******");
        AnnotatedFeatureI gene = (AnnotatedFeatureI)transcript.getRefFeature();
        Transcript newTrans = new Transcript(transcript);
        gene.addFeature(newTrans);
        String geneId = gene.getId();
        Iterator it = newTrans.getFeatures().iterator();
        while (it.hasNext()) {
            SeqFeatureI tmp = (SeqFeatureI)it.next();
            if (!(tmp instanceof ExonI)) continue;
            this.setExonID((ExonI)tmp, geneId);
        }
        if (gene.isProteinCodingGene()) {
            newTrans.setTranslationStart(transcript.getTranslationStart(), true);
        }
        this.setTransNameAndId(newTrans);
        newTrans.setOwner(this.getUserName());
        newTrans.replaceProperty("date", new Date().toString());
        ChangeList changer = this.beginEdit("Duplicate transcript");
        AnnotationAddEvent aae = new AnnotationAddEvent((Object)this, newTrans);
        changer.addChange(aae);
        changer.executeChanges();
        this.endEdit(changer, true, gene, 5);
    }

    public void addAnnot(Vector features, boolean mergeOverlapping) {
        this.addAnnotation(features, mergeOverlapping, null);
    }

    public void addAnnotation(Vector features, boolean mergeOverlapping, String type) {
        CompoundTransaction merge;
        if (this.annotationCollection == null) {
            return;
        }
        boolean warnedAboutCollapsedTier = false;
        for (int i = 0; i < features.size(); ++i) {
            SeqFeatureI resFeature = (SeqFeatureI)features.elementAt(i);
            if (warnedAboutCollapsedTier || resFeature.getFeatureType().equals("tmptype") || Config.getPropertyScheme().getTierProperty(resFeature.getFeatureType()).isExpanded()) continue;
            String warning = "Warning: adding possibly multiple features from collapsed tier (" + resFeature.getFeatureType() + ")";
            this.showMessage(2, warning);
            warnedAboutCollapsedTier = true;
        }
        AnnotatedFeatureI annot = this.newGeneSetup(features, type);
        if (!annot.isContainedByRefSeq()) {
            String m = "ERROR: your new annotation is not entirely contained within the current sequence region--cannot create.";
            System.err.println(m);
            JOptionPane.showMessageDialog(null, m);
            return;
        }
        System.out.println("\n\t****** Adding new" + (type == null ? "" : " " + type) + " annotation ******");
        if (!this.isOneLevelAnnot(annot)) {
            Transcript trans = (Transcript)annot.getFeatureAt(0);
            if (annot.isProteinCodingGene()) {
                trans.calcTranslationStartForLongestPeptide();
            }
            this.setTransNameAndId(trans);
            this.setOwnerAndDate(trans);
        } else {
            this.setOwnerAndDate(annot);
        }
        ChangeList changer = this.beginEdit("add annot");
        AnnotationAddEvent aae = new AnnotationAddEvent((Object)this, annot);
        changer.addChange(aae);
        changer.executeChanges();
        if (mergeOverlapping && (merge = this.consolidateGenes(annot)) != null) {
            changer.addChange(merge.generateAnnotationChangeEvent());
        }
        this.endEdit(changer, true, annot, 5);
    }

    public boolean moveExonsToTranscriptAllowed() {
        return this.annotSet.getTranscripts().size() == 2 && this.annotSet.getFirstFullySelectedTranscript() != null;
    }

    public void moveExonsToTranscript() {
        Transcript trans = this.annotSet.getFirstFullySelectedTranscript();
        if (trans == null) {
            this.showMessage(0, "The transcript accepting exons must be fully selected.");
            return;
        }
        if (this.annotSet.getTranscripts().size() < 2) {
            this.showMessage(0, "Can only add exons from other transcripts.\nYou must select a transcript plus some exons on the SAME strand.");
            return;
        }
        this.moveExonsToTranscript(trans, this.annotSet.getLeafFeatures());
    }

    private void moveExonsToTranscript(Transcript trans, Vector features) {
        this.moveExonsToTranscript(trans, features, "move exons to transcript");
    }

    private void moveExonsToTranscript(Transcript tgtTrans, Vector features, String log) {
        this.checkIfBeyondRange();
        int exon_count = 0;
        SeqFeature sourceTrans = null;
        for (int i = 0; i < features.size(); ++i) {
            ExonI exon;
            if (!(features.elementAt(i) instanceof ExonI) || (exon = (ExonI)features.elementAt(i)).getRefFeature() == tgtTrans) continue;
            ++exon_count;
            if (sourceTrans != null) continue;
            sourceTrans = (Transcript)exon.getRefFeature();
        }
        AnnotatedFeatureI sourceGene = (AnnotatedFeatureI)sourceTrans.getRefFeature();
        if (!(exon_count != ((FeatureSet)sourceTrans).getFeatures().size() || sourceGene.getFeatures().size() != 1 && tgtTrans.getGene().getFeatures().size() != 1 || this.askMergeDialog(tgtTrans.getGene().getName() + " and " + sourceGene.getName() + "\nIf you move the selected exons, " + "these genes will merge"))) {
            return;
        }
        System.out.println("\n\t****** MOVING EXONS TO TRANSCRIPT ******");
        CompoundTransaction compTrans = new CompoundTransaction(this);
        for (int i = 0; i < features.size(); ++i) {
            if (!(features.elementAt(i) instanceof ExonI)) continue;
            ExonI exon = (ExonI)features.elementAt(i);
            AnnotatedFeatureI tgtGene = tgtTrans.getGene();
            if (exon.getRefFeature() == tgtTrans) continue;
            Transcript srcTrans = (Transcript)exon.getRefFeature();
            AnnotatedFeatureI srcGene = srcTrans.getGene();
            CompoundTransaction ct = this.moveSingleExonToTranscript(exon, tgtTrans);
            compTrans.addTransaction(ct);
            if (srcTrans.size() == 0) {
                this.copyTransProtData(srcTrans, tgtTrans);
            }
            if (srcGene.size() != 0) continue;
            CompoundTransaction mergeIdTrans = this.mergeGeneIdentifiers(tgtGene, srcGene);
            mergeIdTrans.setCompoundType(-1);
            compTrans.setCompoundType(2);
            compTrans.addTransaction(mergeIdTrans);
        }
        tgtTrans.setTranslationEndFromStart();
        tgtTrans.setPeptideValidity(false);
        this.setOwnerAndDate(tgtTrans);
        CompoundTransaction merge = this.consolidateGenes(tgtTrans.getGene(), true);
        if (merge != null) {
            compTrans.setCompoundType(2);
            merge.setCompoundType(-1);
            compTrans.addTransaction(merge);
        }
        this.fireCompoundTransaction(compTrans);
    }

    private CompoundTransaction moveSingleExonToTranscript(ExonI exon, Transcript tgtTrans) {
        CompoundTransaction ct;
        CompoundTransaction compoundTransaction = new CompoundTransaction(this);
        Transcript srcTrans = exon.getTranscript();
        srcTrans.deleteExon(exon);
        FeatureList overlappingExons = this.getOverlappingExons(tgtTrans, exon);
        tgtTrans.addFeature(exon, !tgtTrans.isTransSpliced());
        UpdateParentTransaction upt = new UpdateParentTransaction(this, exon, srcTrans);
        compoundTransaction.addTransaction(upt);
        if (overlappingExons.size() > 0) {
            ct = this.mergeExons(tgtTrans, overlappingExons);
            compoundTransaction.addTransaction(ct);
        }
        if (srcTrans.size() == 0) {
            ct = this.purgeTranscript(srcTrans.getGene(), srcTrans);
            compoundTransaction.addTransaction(ct);
        } else {
            this.setOwnerAndDate(srcTrans);
        }
        compoundTransaction.setSource(this);
        return compoundTransaction;
    }

    private void setOwnerAndDate(AnnotatedFeatureI annFeat) {
        annFeat.setOwner(this.getUserName());
        annFeat.replaceProperty("date", new Date().toString());
    }

    private CompoundTransaction copyTransProtData(Transcript from_trans, Transcript to_trans) {
        CompoundTransaction compTrans = new CompoundTransaction(this);
        AddTransaction at = this.addSynonym(to_trans, from_trans.getName(), from_trans.getOwner());
        compTrans.addTransaction(at);
        CompoundTransaction ct = this.copyAnnotData(from_trans, to_trans);
        compTrans.addTransaction(ct);
        if (from_trans.hasProteinFeat() && to_trans.hasProteinFeat()) {
            ct = this.copyAnnotData(from_trans.getProteinFeat(), to_trans.getProteinFeat());
            compTrans.addTransaction(ct);
        }
        return compTrans;
    }

    private CompoundTransaction mergeGeneIdentifiers(AnnotatedFeatureI to_gene, AnnotatedFeatureI from_gene) {
        CompoundTransaction compTrans = new CompoundTransaction(this);
        ApolloNameAdapterI nameAdapter = this.curationState.getNameAdapter(to_gene);
        String userChosenGeneName = null;
        String toName = to_gene.getName();
        String fromName = from_gene.getName();
        String newGeneratedName = nameAdapter.generateId(this.curation.getAnnots(), this.curation.getName(), to_gene);
        if (this.isTemp(to_gene) && this.isTemp(from_gene)) {
            userChosenGeneName = toName;
        } else if (!this.isTemp(to_gene) && this.isTemp(from_gene)) {
            userChosenGeneName = toName;
        } else {
            if (this.isTemp(to_gene) && !this.isTemp(from_gene)) {
                System.out.println("Error in AnnotationEditor.mergeGeneIdentifier, trying to add an existing gene's exons to a temp gene");
                return null;
            }
            userChosenGeneName = this.askMergeName(toName, fromName, newGeneratedName);
        }
        System.out.println("User chose name " + userChosenGeneName + " when merging " + toName + " with " + fromName);
        if (userChosenGeneName.equals(toName)) {
            String fromId = from_gene.getId();
            this.addIdAndNameSynonyms(to_gene, fromId, fromName);
        } else if (!userChosenGeneName.equals(toName)) {
            String prev_name = to_gene.getName();
            String prev_id = to_gene.getId();
            UpdateTransaction nameTrans = this.makeNameTrans(to_gene, userChosenGeneName);
            to_gene.setName(userChosenGeneName);
            UpdateTransaction idUpdateTrans = null;
            CompoundTransaction synTrans = null;
            if (userChosenGeneName.equals(fromName)) {
                synTrans = this.addIdAndNameSynonyms(to_gene, prev_id, prev_name);
                String newId = from_gene.getId();
                idUpdateTrans = this.setID(to_gene, newId);
            } else if (userChosenGeneName.equals(newGeneratedName)) {
                synTrans = this.addIdAndNameSynonyms(to_gene, prev_id, prev_name);
                String fromId = from_gene.getId();
                synTrans.addTransaction(this.addIdAndNameSynonyms(to_gene, fromId, fromName));
                idUpdateTrans = this.setID(to_gene, userChosenGeneName);
            } else {
                String id = nameAdapter.generateId(this.curation.getAnnots(), this.curation.getName(), to_gene);
                idUpdateTrans = this.setID(to_gene, id);
                if (DEBUG) {
                    System.out.println("DEBUG error: name is neither generated nor from gene in mergeGeneIdentifiers");
                }
            }
            compTrans.addTransaction(idUpdateTrans);
            compTrans.addTransaction(nameTrans);
            compTrans.addTransaction(synTrans);
        }
        this.setTransNameFromGene(to_gene, true);
        compTrans.addTransaction(this.copyAnnotData(from_gene, to_gene));
        return compTrans;
    }

    private CompoundTransaction addIdAndNameSynonyms(AnnotatedFeatureI annot, String oldId, String oldName) {
        CompoundTransaction compTrans = new CompoundTransaction(this);
        if (!this.isTemp(oldId, annot) && !oldId.equals(oldName)) {
            compTrans.addTransaction(this.addSynonym(annot, oldName, this.getUserName()));
        }
        return compTrans;
    }

    private boolean isTemp(String idOrName, AnnotatedFeatureI feat) {
        return this.getNameAdapter(feat).isTemp(idOrName);
    }

    private boolean isTemp(AnnotatedFeatureI feat) {
        return this.isTemp(feat.getName(), feat);
    }

    private ApolloNameAdapterI getNameAdapter(AnnotatedFeatureI feat) {
        return this.curationState.getNameAdapter(feat);
    }

    private UpdateTransaction makeNameTrans(AnnotatedFeatureI annot, String newName) {
        if (annot.getName() == null || annot.getName() == "no_name") {
            return null;
        }
        TransactionSubpart ts = TransactionSubpart.NAME;
        UpdateTransaction ut = new UpdateTransaction(annot, ts, annot.getName(), newName);
        return ut;
    }

    private AddTransaction addSynonym(AnnotatedFeatureI annot, String syn, String owner) {
        return this.addSynonym(annot, new Synonym(syn, owner));
    }

    private AddTransaction addSynonym(AnnotatedFeatureI annot, Synonym syn) {
        if (annot.hasSynonym(syn.getName())) {
            return null;
        }
        if (this.isTemp(syn.getName(), annot)) {
            return null;
        }
        TransactionSubpart ts = TransactionSubpart.SYNONYM;
        AddTransaction at = new AddTransaction(annot, ts, syn);
        at.editModel();
        return at;
    }

    private String askMergeName(String geneName1, String geneName2, String generatedName) {
        if (geneName1.equals(geneName2)) {
            return geneName1;
        }
        Object[] options = new Object[]{geneName1, geneName2, generatedName};
        String message = "Please choose a name for the gene resulting from the merge\nof " + geneName1 + " and " + geneName2 + ":";
        JOptionPane pane = new JOptionPane(message, -1, 2, null, options, options[0]);
        JDialog dialog = pane.createDialog(null, "Please choose one");
        dialog.show();
        Object result = pane.getValue();
        if (result == null) {
            return geneName1;
        }
        return (String)result;
    }

    private CompoundTransaction copyAnnotData(AnnotatedFeatureI from_fs, AnnotatedFeatureI to_fs) {
        CompoundTransaction compoundTrans = new CompoundTransaction(this);
        Vector syns = from_fs.getSynonyms();
        for (int i = 0; i < syns.size(); ++i) {
            Synonym syn = (Synonym)syns.elementAt(i);
            compoundTrans.addTransaction(this.addSynonym(to_fs, syn));
        }
        compoundTrans.addTransaction(this.copyDbXrefs(from_fs, to_fs));
        Vector comments = from_fs.getComments();
        for (int i = 0; i < comments.size(); ++i) {
            Comment comm = (Comment)comments.elementAt(i);
            compoundTrans.addTransaction(this.addComment(to_fs, comm));
        }
        compoundTrans.addTransaction(this.setDescription(to_fs, from_fs.getDescription()));
        return compoundTrans;
    }

    private AddTransaction addComment(AnnotatedFeatureI ann, Comment cm) {
        ann.addComment(cm);
        TransactionSubpart ts = TransactionSubpart.COMMENT;
        int subpartRank = ann.getComments().size() - 1;
        AddTransaction at = new AddTransaction(ann, ts, cm, subpartRank);
        return at;
    }

    private CompoundTransaction copyDbXrefs(SeqFeatureI from, SeqFeatureI to) {
        CompoundTransaction compoundTrans = new CompoundTransaction(this);
        for (int i = 0; i < from.getDbXrefs().size(); ++i) {
            compoundTrans.addTransaction(this.addDbXref(to, from.getDbXref(i)));
        }
        return compoundTrans;
    }

    private AddTransaction addDbXref(SeqFeatureI ann, DbXref dbxref) {
        dbxref.setCurrent(0);
        ann.addDbXref(dbxref);
        TransactionSubpart ts = TransactionSubpart.DBXREF;
        int subpartRank = ann.getDbXrefs().size() - 1;
        AddTransaction at = new AddTransaction(ann, ts, dbxref, subpartRank);
        return at;
    }

    private UpdateTransaction setDescription(AnnotatedFeatureI ann, String desc) {
        if (ann.getDescription() != null || desc == null) {
            return null;
        }
        String oldDesc = ann.getDescription();
        ann.setDescription(desc);
        return new UpdateTransaction(ann, TransactionSubpart.DESCRIPTION, oldDesc, desc);
    }

    private void endEdit(ChangeList changer, boolean done, SeqFeatureI annot, int change_type, boolean updateSelection) {
        this.endEdit(changer, done, annot, change_type);
        if (updateSelection) {
            FeatureSelectionEvent fse = new FeatureSelectionEvent((Object)this.annotationView, this.getSelectionManager().getSelection(), true);
            this.getController().handleFeatureSelectionEvent(fse);
        }
    }

    private void endEdit(ChangeList changer) {
        AnnotSessionDoneEvent e = new AnnotSessionDoneEvent(this);
        changer.addChange(e);
        changer.executeChanges();
    }

    private void endEdit(ChangeList changer, boolean done, SeqFeatureI annot, int change_type) {
        this.endEdit(changer);
        if (done && this.annotSet != null && this.evidenceSet != null) {
            this._setUsed(done);
        }
    }

    public boolean mergeExonsAllowed() {
        if (this.annotSet.getTranscripts().size() != 1) {
            return false;
        }
        return this.annotSet.getLeafFeatures().size() > 1;
    }

    public void mergeExons() {
        switch (this.annotSet.getTranscripts().size()) {
            case 0: {
                this.showMessage(0, "Selected NO transcript to merge features in");
                break;
            }
            case 1: {
                CompoundTransaction ct = this.mergeExons(this.annotSet.getTranscript(0), this.annotSet.getLeafFeatList());
                this.fireCompoundTransaction(ct);
                break;
            }
            default: {
                this.showMessage(0, "Selected more than 1 transcript to merge features in");
            }
        }
    }

    private CompoundTransaction mergeExons(Transcript tran, FeatureList exons) {
        int i;
        this.checkIfBeyondRange();
        CompoundTransaction compoundTransaction = new CompoundTransaction(this);
        System.out.println("\n\t****** MERGING EXONS IN TRANSCRIPT ******");
        int min = 1000000000;
        int max = -1000000000;
        RangeI sourceExon = null;
        Vector<Transcript> deleted_trans = new Vector<Transcript>();
        Vector<AnnotatedFeatureI> deleted_genes = new Vector<AnnotatedFeatureI>();
        for (i = 0; i < exons.size(); ++i) {
            SeqFeatureI sf = exons.getFeature(i);
            if (!(sf instanceof ExonI)) continue;
            ExonI exon = (ExonI)sf;
            if (i == 0) {
                sourceExon = exon;
            } else {
                CompoundTransaction ct = this.purgeExon(exon);
                compoundTransaction.addTransaction(ct);
                Transcript from_tran = (Transcript)exon.getRefFeature();
                AnnotatedFeatureI from_gene = (AnnotatedFeatureI)from_tran.getRefFeature();
                if (from_tran.getExons().size() == 0) {
                    deleted_trans.addElement(from_tran);
                }
                if (from_gene != null && from_gene.size() == 0) {
                    deleted_genes.addElement(from_gene);
                }
            }
            if (exon.getLow() < min) {
                min = exon.getLow();
            }
            if (exon.getHigh() <= max) continue;
            max = exon.getHigh();
        }
        if (sourceExon != null) {
            if (sourceExon.getLow() != min || sourceExon.getHigh() != max) {
                TransactionSubpart ts = TransactionSubpart.LIMITS;
                RangeI oldRange = sourceExon.getRangeClone();
                sourceExon.setLow(min);
                sourceExon.setHigh(max);
                UpdateTransaction ut = new UpdateTransaction((SeqFeatureI)sourceExon, ts, oldRange, sourceExon);
                compoundTransaction.addTransaction(ut);
            }
            for (i = 0; i < tran.size(); ++i) {
                ExonI exon = tran.getExonAt(i);
                if (!exon.overlaps(sourceExon) || sourceExon == exon) continue;
                CompoundTransaction ct = this.purgeExon(exon);
                compoundTransaction.addTransaction(ct);
                Transcript from_tran = (Transcript)exon.getRefFeature();
                AnnotatedFeatureI from_gene = (AnnotatedFeatureI)from_tran.getRefFeature();
                if (from_tran.getExons().size() == 0) {
                    deleted_trans.addElement(from_tran);
                }
                if (from_gene.size() == 0) {
                    deleted_genes.addElement(from_gene);
                }
                --i;
            }
            for (i = 0; i < deleted_trans.size(); ++i) {
                this.copyTransProtData((Transcript)deleted_trans.elementAt(i), tran);
            }
            for (i = 0; i < deleted_genes.size(); ++i) {
                this.mergeGeneIdentifiers(tran.getGene(), (AnnotatedFeatureI)deleted_genes.elementAt(i));
            }
            this.setGeneEnds(tran);
        }
        if (!compoundTransaction.hasKids()) {
            return null;
        }
        return compoundTransaction;
    }

    protected boolean checkAdjacent(Transcript trans, Vector exonFeatures) {
        int ind1;
        if (exonFeatures.size() != 2) {
            System.err.println("ERROR: checkAdjacent called with wrong number of features");
            return false;
        }
        int ind0 = trans.getFeatureIndex((SeqFeatureI)exonFeatures.elementAt(0));
        return ind0 == (ind1 = trans.getFeatureIndex((SeqFeatureI)exonFeatures.elementAt(1))) + 1 || ind1 == ind0 + 1;
    }

    public boolean splitTranscriptAllowed() {
        if (this.annotSet.getTranscripts().size() == 1 && this.annotSet.getLeafFeatures().size() == 2) {
            return this.checkAdjacent(this.annotSet.getTranscript(0), this.annotSet.getLeafFeatures());
        }
        return false;
    }

    public void splitTranscript() {
        if (this.annotSet.getTranscripts().size() != 1) {
            this.showMessage(0, "Can only split a single transcript");
            return;
        }
        if (this.annotSet.getLeafFeatures().size() != 2 || !this.checkAdjacent(this.annotSet.getTranscript(0), this.annotSet.getLeafFeatures())) {
            this.showMessage(0, "Must select exactly two adjacent exons");
            return;
        }
        this.splitTranscript(this.annotSet.getTranscript(0), (ExonI)this.annotSet.getLeafFeat(0), (ExonI)this.annotSet.getLeafFeat(1));
    }

    private void splitTranscript(Transcript trans, ExonI exon1, ExonI exon2) {
        AnnotatedFeatureI gene = trans.getGene();
        if (!this.userReallyWantsToSplit(gene)) {
            return;
        }
        this.checkIfBeyondRange();
        System.out.println("\n\t****** SPLITING TRANSCRIPT ******");
        int ind1 = trans.getFeatureIndex(exon1);
        int ind2 = trans.getFeatureIndex(exon2);
        if (ind1 == -1 || ind2 == -1) {
            this.showMessage(0, "split transcript with non transcript exons impossible");
            return;
        }
        int splitind = ind1;
        if (ind1 > ind2) {
            splitind = ind2;
        }
        this.setOwnerAndDate(trans);
        Transcript newTrans = new Transcript();
        newTrans.setStrand(trans.getStrand());
        int origSize = trans.size();
        ChangeList exonChanges = this.createCoalescer();
        for (int i = splitind + 1; i < origSize; ++i) {
            ExonI exon = trans.getExonAt(splitind + 1);
            CompoundTransaction ct = this.moveSingleExonToTranscript(exon, newTrans);
            exonChanges.addChange(ct.generateAnnotationChangeEvent());
        }
        gene.adjustEdges();
        gene.addFeature(newTrans);
        this.copyTransProtData(trans, newTrans);
        this.setOwnerAndDate(newTrans);
        trans.setTranslationEndFromStart();
        if (gene.isProteinCodingGene()) {
            newTrans.calcTranslationStartForLongestPeptide();
        }
        ChangeList changeList = this.createCoalescer();
        CompoundTransaction merge = this.consolidateGenes(gene, true);
        if (merge != null) {
            changeList.addChange(merge.generateAnnotationChangeEvent());
        }
        SeqFeatureI clonedTranscript = newTrans.cloneFeature();
        ChangeList splitChangeList = this.splitAllGenes(false);
        if (splitChangeList.hasChanges()) {
            changeList.addChangeList(splitChangeList);
        } else {
            AnnotationAddEvent aae = new AnnotationAddEvent((Object)this, newTrans);
            changeList.addChange(aae);
        }
        CompoundTransaction ct = this.setTransNameFromGene(newTrans.getGene(), false);
        ct.setSource(this);
        changeList.addChange(ct.generateAnnotationChangeEvent());
        changeList.addChangeList(exonChanges);
        this.endEdit(changeList);
    }

    public boolean createAnnotationAllowed() {
        return this.annotSet.getLeafFeatures().size() == 0 && this.strandSet && this.basePosition != 1;
    }

    public void createAnnotation() {
        this.createAnnotation(null);
    }

    public void createAnnotation(String type) {
        if (this.annotSet.getLeafFeatures().size() > 0) {
            this.showMessage(0, "There are features selected.");
            return;
        }
        if (this.basePosition == -1) {
            this.showMessage(0, "Base position isn't set.");
            return;
        }
        if (!this.strandSet) {
            this.showMessage(0, "Strand isn't set.");
            return;
        }
        this.createAnnotation(this.basePosition, this.defaultStrand, type);
    }

    public void createAnnotation(int basePosition, int strand, String type) {
        int size = 100;
        if (this.parentComponent != null) {
            String sizeStr = JOptionPane.showInputDialog(this.parentComponent, "Enter desired length of annotation (in bases)", "Specify annotation length", 1);
            try {
                size = Integer.parseInt(sizeStr);
            }
            catch (NumberFormatException e) {
                if (sizeStr != null) {
                    this.showMessage(0, "Non-numeric length " + sizeStr + "-- try again");
                }
                return;
            }
        }
        ++basePosition;
        if (strand == -1) {
            this.createAnnotation(basePosition - size + 1, basePosition, strand, type);
        } else {
            this.createAnnotation(basePosition, basePosition + size - 1, strand, type);
        }
    }

    public void createAnnotation(int low, int high, int strand, String type) {
        Vector<SeqFeature> features = new Vector<SeqFeature>();
        if (type == null) {
            type = "tmptype";
        }
        SeqFeature sf = new SeqFeature(low, high, type, strand);
        features.addElement(sf);
        this.addAnnotation(features, false, type);
    }

    public boolean splitExonAllowed() {
        if (this.annotSet.getLeafFeatures().size() > 1) {
            return false;
        }
        if (this.annotSet.getLeafFeatures().size() == 0) {
            return false;
        }
        if (!(this.annotSet.getLeafFeat(0) instanceof ExonI)) {
            return false;
        }
        return this.basePosition != -1;
    }

    public void splitExon() {
        if (this.annotSet.getLeafFeatures().size() > 1) {
            this.showMessage(0, "Can only split one feature at a time.");
            return;
        }
        if (this.annotSet.getLeafFeatures().size() == 0) {
            this.showMessage(0, "No feature under cursor.");
            return;
        }
        if (!(this.annotSet.getLeafFeat(0) instanceof ExonI)) {
            this.showMessage(0, "Can only split an exon.");
            return;
        }
        if (this.basePosition == -1) {
            this.showMessage(0, "Base position isn't set.");
            return;
        }
        if (this.endBasePosition == -1) {
            this.splitExon((ExonI)this.annotSet.getLeafFeat(0), this.basePosition);
        } else {
            this.splitExon((ExonI)this.annotSet.getLeafFeat(0), this.basePosition, this.endBasePosition);
        }
    }

    public void splitExon(ExonI exon, int newHigh, int newLow) {
        this.checkIfBeyondRange();
        System.out.println("\n\t****** SPLITING FEATURE ******");
        Transcript tran = (Transcript)exon.getRefFeature();
        int high = exon.getHigh();
        if (newHigh >= exon.getLow() && newLow <= exon.getHigh()) {
            int start = exon.isForwardStrand() ? exon.getStart() : newHigh;
            int end = exon.isForwardStrand() ? newHigh : exon.getEnd();
            this.setExonTerminus(exon, start, end);
            Exon newExon = new Exon();
            newExon.setStrand(exon.getStrand());
            newExon.setLow(newLow);
            newExon.setHigh(high);
            tran.addExon(newExon);
            this.setGeneEnds(tran);
            this.setExonID(newExon, tran.getGene().getId());
            ChangeList changer = this.beginEdit("split feature");
            AnnotationAddEvent aae = new AnnotationAddEvent((Object)this, newExon);
            changer.addChange(aae);
            changer.executeChanges();
            this.endEdit(changer, true, tran.getGene(), 5);
        } else {
            this.showMessage(0, "Trying to split exon outside allowable exon boundaries");
        }
    }

    public void splitExon(ExonI exon, int basePosition) {
        this.splitExon(exon, basePosition - 1, basePosition + 1);
    }

    public void deleteSelectedFeatures() {
        this.deleteSelectedFeatures(this.annotSet.getLeafFeatures(), null);
    }

    public void deleteSelectedFeatures(Vector features, String description) {
        int i;
        this.checkIfBeyondRange();
        ChangeList changer = null;
        AnnotatedFeatureI gene = null;
        Vector<Transcript> touched_trans = new Vector<Transcript>(1);
        for (i = 0; i < features.size(); ++i) {
            SeqFeatureI sf = (SeqFeatureI)features.elementAt(i);
            if (sf.isExon()) {
                Transcript trans = (Transcript)sf.getRefFeature();
                this.setOwnerAndDate(trans);
                if (!touched_trans.contains(trans)) {
                    touched_trans.addElement(trans);
                }
                gene = trans.getGene();
                if (changer == null) {
                    System.out.println("\n\t****** DELETING FEATURES ******");
                    if (description == null) {
                        description = "delete selected features";
                    }
                    changer = this.beginEdit(description);
                }
                CompoundTransaction ct = this.purgeExon((ExonI)sf);
                this.fireCompoundTransaction(ct);
                continue;
            }
            if (sf.isAnnot() && sf.getAnnotatedFeature().isAnnotTop()) {
                DeleteTransaction dt = this.purgeAnnot(sf.getAnnotatedFeature());
                this.fireTransaction(dt);
                continue;
            }
            System.err.println("WARNING: Deleted feat was neither an exon nor a 1 level annot - not deleted");
        }
        if (changer != null) {
            for (i = 0; i < touched_trans.size(); ++i) {
                Transcript trans = (Transcript)touched_trans.elementAt(i);
                if (trans.getGene() != null) {
                    gene = trans.getGene();
                }
                if (trans.size() <= 0 || !gene.isProteinCodingGene()) continue;
                trans.setPeptideValidity(false);
                if (trans.getFeatureContaining(trans.getTranslationStart()) != null) {
                    trans.setTranslationEndFromStart();
                    continue;
                }
                trans.calcTranslationStartForLongestPeptide();
            }
            this.splitAllGenes(changer, true);
            this.endEdit(changer, true, gene, 5, true);
        }
    }

    private void _setUsed(boolean state) {
        this.annotSet.setUsed(true);
        this.evidenceSet.setUsed(true);
    }

    public boolean deleteExonAllowed() {
        return this.annotSet.getLeafFeatures().size() == 1 && this.annotSet.getLeafFeat(0).isExon();
    }

    public void deleteExon() {
        this.checkIfBeyondRange();
        if (this.deleteExonAllowed()) {
            Vector<SeqFeatureI> feats = new Vector<SeqFeatureI>(1);
            feats.addElement(this.cursorSet.getLeafFeat(0));
            this.deleteSelectedFeatures(feats, "delete exon");
        } else {
            this.showMessage(0, "Cursor selection incompatible with delete exon.");
        }
    }

    private AddTransaction addTranscript(AnnotatedFeatureI gene, Transcript trans) {
        gene.addFeature(trans);
        AddTransaction at = new AddTransaction(this, trans);
        return at;
    }

    private DeleteTransaction purgeAnnot(AnnotatedFeatureI delete_annot) {
        FeatureSetI annotParent = delete_annot.getParent();
        if (annotParent != null) {
            annotParent.deleteFeature(delete_annot);
        }
        DeleteTransaction dt = new DeleteTransaction((SeqFeatureI)delete_annot, annotParent);
        return dt;
    }

    private CompoundTransaction purgeTranscript(AnnotatedFeatureI gene, Transcript trans) {
        this.checkIfBeyondRange();
        CompoundTransaction compoundTransaction = new CompoundTransaction(this);
        gene.deleteFeature(trans);
        AnnotatedFeatureI transClone = trans.cloneAnnot();
        if (gene.size() == 0) {
            DeleteTransaction del = this.purgeAnnot(gene);
            compoundTransaction.addTransaction(del);
        } else {
            DeleteTransaction del = new DeleteTransaction((SeqFeatureI)transClone, gene);
            compoundTransaction.addTransaction(del);
        }
        return compoundTransaction;
    }

    private CompoundTransaction purgeExon(ExonI exon) {
        CompoundTransaction compoundTransaction = new CompoundTransaction(this);
        Transcript tran = (Transcript)exon.getRefFeature();
        AnnotatedFeatureI gene = (AnnotatedFeatureI)tran.getRefFeature();
        tran.deleteExon(exon);
        DeleteTransaction del = new DeleteTransaction((SeqFeatureI)exon, tran);
        compoundTransaction.addTransaction(del);
        if (tran.size() == 0) {
            CompoundTransaction ct = this.purgeTranscript(gene, tran);
            compoundTransaction.addTransaction(ct);
        } else {
            this.setOwnerAndDate(tran);
        }
        return compoundTransaction;
    }

    public void setAs5Prime() {
        this.setExonTerminus(1);
    }

    public void setAs3Prime() {
        this.setExonTerminus(2);
    }

    public void setAsBothEnds() {
        this.setExonTerminus(3);
    }

    public boolean setExonTerminusAllowed() {
        return this.annotSet.getLeafFeatures().size() == 1 && this.evidenceSet.getLeafFeatures().size() == 1;
    }

    public void setExonTerminus(int end) {
        switch (this.annotSet.getLeafFeatures().size()) {
            case 0: {
                this.showMessage(0, "Selected NO features to set end with");
                break;
            }
            case 1: {
                SeqFeatureI firstAnnot = this.annotSet.getLeafFeat(0);
                SeqFeatureI evFeat = this.evidenceSet.getLeafFeat(0);
                if (!this.setExonTerminusAllowed()) {
                    System.err.println("WARNING: setExonTerminusAllowed not allowed");
                } else {
                    this.checkIfBeyondRange();
                }
                if (firstAnnot.isExon()) {
                    this.setAnnotTerminusFromFeature(firstAnnot, evFeat, end);
                    break;
                }
                if (DO_ONE_LEVEL_ANNOTS && this.isOneLevelAnnot(firstAnnot)) {
                    this.setAnnotTerminusFromFeature(firstAnnot, evFeat, end);
                    break;
                }
                this.showMessage(0, "MUST select exactly one exon to set end for");
                break;
            }
            default: {
                this.showMessage(0, "Selected more than 1 feature to use for setting end");
            }
        }
    }

    private void setAnnotTerminusFromFeature(SeqFeatureI annot, SeqFeatureI sf, int endType) {
        int oldStart = annot.getStart();
        int oldEnd = annot.getEnd();
        int newStart = endType == 1 || endType == 3 ? sf.getStart() : oldStart;
        int newEnd = endType == 2 || endType == 3 ? sf.getEnd() : oldEnd;
        this.setAnnotTerminus(annot.getAnnotatedFeature(), oldStart, oldEnd, newStart, newEnd);
    }

    private void setExonTerminus(ExonI exon, int newStart, int newEnd) {
        this.setAnnotTerminus(exon, exon.getStart(), exon.getEnd(), newStart, newEnd);
    }

    public void setAnnotTerminus(AnnotatedFeatureI annFeat, int oldStart, int oldEnd, int newStart, int newEnd) {
        if (!annFeat.getRefFeature().isTranscript() && !DO_ONE_LEVEL_ANNOTS) {
            System.err.println("ERROR: Exon belongs to a " + annFeat.getRefFeature().getClass().getName());
            return;
        }
        Transcript trans = null;
        AnnotatedFeatureI topAnnot = null;
        if (annFeat.isExon()) {
            trans = (Transcript)annFeat.getRefFeature();
            topAnnot = trans.getGene();
            if (this.isExonOverlap(topAnnot, annFeat, newStart, newEnd)) {
                String desc = this.getExonChangeDescription(annFeat, newStart, newEnd);
                this.showMessage(0, "New " + desc + " boundary would overlap existing exon");
                return;
            }
        } else if (annFeat.isAnnotTop()) {
            topAnnot = annFeat;
        }
        if (!this.isRangeOK(annFeat, newStart, newEnd)) {
            return;
        }
        if (newStart == oldStart && newEnd == oldEnd) {
            return;
        }
        Range oldRange = new Range("", oldStart, oldEnd);
        if (newStart != annFeat.getStart()) {
            annFeat.setStart(newStart);
        }
        if (newEnd != annFeat.getEnd()) {
            annFeat.setEnd(newEnd);
        }
        if (annFeat.isExon()) {
            this.setGeneEnds(trans);
        }
        TransactionSubpart ts = TransactionSubpart.LIMITS;
        AnnotationUpdateEvent aue = new AnnotationUpdateEvent((Object)this, annFeat, ts);
        aue.setOldRange(oldRange);
        ChangeList changer = this.beginEdit("set exon terminus");
        changer.addChange(aue);
        CompoundTransaction merge = this.consolidateGenes(topAnnot, true);
        if (merge != null) {
            changer.addChange(merge.generateAnnotationChangeEvent());
        }
        this.splitAllGenes(changer, true);
        this.endEdit(changer);
    }

    private String getExonChangeDescription(AnnotatedFeatureI exon, int newStart, int newEnd) {
        if (newStart != exon.getStart() && newEnd != exon.getEnd()) {
            return "Both termini";
        }
        if (newStart != exon.getStart()) {
            return "5Prime";
        }
        if (newEnd != exon.getEnd()) {
            return "3Prime";
        }
        return "(neither end changed)";
    }

    public void takeOwnership(Vector features) {
        ChangeList changer = this.beginEdit("take ownership");
        AnnotatedFeatureI gene = null;
        for (int i = 0; i < features.size(); ++i) {
            AnnotatedFeatureI sf = (AnnotatedFeatureI)features.elementAt(i);
            this.setOwnerAndDate(sf);
            if (!(sf instanceof Transcript)) continue;
            gene = ((Transcript)sf).getGene();
        }
        this.endEdit(changer, true, gene, 5);
    }

    public void disown(Vector features) {
        ChangeList changer = this.beginEdit("disowning");
        AnnotatedFeatureI gene = null;
        for (int i = 0; i < features.size(); ++i) {
            AnnotatedFeatureI sf = (AnnotatedFeatureI)features.elementAt(i);
            sf.setOwner(null);
            if (!(sf instanceof Transcript)) continue;
            gene = ((Transcript)sf).getGene();
        }
        this.endEdit(changer, true, gene, 5);
    }

    public void setTranscriptStatus(Transcript t) {
        boolean status;
        ChangeList changer = this.beginEdit("set status");
        boolean bl = status = t.getProperty("status") != null && t.getProperty("status").equals(ALL_DONE);
        if (!status) {
            t.replaceProperty("status", ALL_DONE);
        } else {
            t.replaceProperty("status", NOT_DONE);
        }
        SeqFeatureI gene = t.getRefFeature();
        this.setOwnerAndDate(t);
        this.endEdit(changer, true, gene, 5);
    }

    public boolean assignAnnotationNameAllowed() {
        return this.evidenceSet.getLeafFeatures().size() == 1 && this.annotSet.getLeafFeatures().size() == 1;
    }

    public void assignAnnotationName() {
        SeqFeatureI evidence = this.evidenceSet.getLeafFeat(0);
        SeqFeatureI annot = this.annotSet.getLeafFeat(0);
        if (annot instanceof ExonI) {
            annot = annot.getRefFeature();
        }
        String newName = evidence.getName();
        if (evidence instanceof FeaturePairI) {
            SeqFeatureI hit = ((FeaturePairI)evidence).getHitFeature();
            SequenceI seq = hit.getRefSequence();
            if (seq != null && seq.getName() != null) {
                newName = seq.getName();
            } else if (hit.getName() != null) {
                newName = hit.getName();
            }
        }
        annot.setName(newName);
    }

    private void setGeneEnds(Transcript trans) {
        AnnotatedFeatureI gene = trans.getGene();
        if (gene == null) {
            return;
        }
        for (int i = 0; i < gene.size(); ++i) {
            ((Transcript)gene.getFeatureAt(i)).adjustEdges();
        }
        gene.adjustEdges();
        if (gene.isProteinCodingGene()) {
            if (trans.getFeatureContaining(trans.getTranslationStart()) != null) {
                trans.setTranslationEndFromStart();
            } else {
                trans.calcTranslationStartForLongestPeptide();
            }
            trans.setPeptideValidity(false);
        }
        this.setOwnerAndDate(trans);
    }

    private boolean findSplits(AnnotatedFeatureI gene, Vector groups) {
        boolean split = false;
        if (gene.size() == 0) {
            if (DEBUG) {
                System.err.println("findSplits: gene " + gene.getName() + " has no transcripts!");
            }
            return false;
        }
        Hashtable linkSets = new Hashtable();
        if (gene.getProperty("dicistronic") != null && gene.getProperty("dicistronic").equals("true")) {
            System.out.println("Not splitting dicistronic gene " + gene.getName() + ".\nIf you want to split it, pull it up in the Annotation Info Editor and uncheck the 'Is Dicistronic?' checkbox.");
            return false;
        }
        for (int i = 0; i < gene.size(); ++i) {
            SeqFeatureI trans1 = gene.getFeatureAt(i);
            Vector<SeqFeatureI> links = new Vector<SeqFeatureI>();
            linkSets.put(trans1, links);
            for (int j = i + 1; j < gene.size(); ++j) {
                SeqFeatureI trans2 = gene.getFeatureAt(j);
                if (!this.areOverlapping(trans1, trans2)) continue;
                links.addElement(trans2);
            }
        }
        Vector alreadyAdded = new Vector();
        for (int i = 0; i < gene.size(); ++i) {
            SeqFeatureI trans1 = gene.getFeatureAt(i);
            if (alreadyAdded.contains(trans1)) continue;
            Vector<SeqFeatureI> allLinks = new Vector<SeqFeatureI>();
            allLinks.addElement(trans1);
            this._addLinks(trans1, linkSets, allLinks, gene.size());
            for (int j = 0; j < allLinks.size(); ++j) {
                alreadyAdded.addElement(allLinks.elementAt(j));
            }
            if (allLinks.size() == gene.size()) continue;
            groups.addElement(allLinks);
            split = true;
        }
        return split;
    }

    private void _addLinks(SeqFeatureI key, Hashtable linkSets, Vector allLinks, int totLink) {
        Vector links = (Vector)linkSets.get(key);
        for (int i = 0; i < links.size() && allLinks.size() != totLink; ++i) {
            SeqFeatureI sf = (SeqFeatureI)links.elementAt(i);
            if (allLinks.contains(sf)) continue;
            allLinks.addElement(sf);
            this._addLinks(sf, linkSets, allLinks, totLink);
        }
    }

    private boolean findMerges(AnnotatedFeatureI gene, Vector groups) {
        Vector annots = this.annotationCollection.getFeatures();
        for (int i = 0; i < annots.size(); ++i) {
            AnnotatedFeatureI gi = (AnnotatedFeatureI)annots.elementAt(i);
            if (gi == gene || !this.isFirstTierAnnot(gi) || !this.areOverlapping(gi, gene) || groups.contains(gi)) continue;
            groups.addElement(gi);
            this.findMerges(gi, groups);
        }
        return groups.size() > 1;
    }

    private ChangeList splitAllGenes(boolean checkFirst) {
        ChangeList changeList = this.createCoalescer();
        this.splitAllGenes(changeList, checkFirst);
        return changeList;
    }

    private void splitAllGenes(ChangeList changer, boolean checkFirst) {
        Vector annots = this.annotationCollection.getFeatures();
        int split_cnt = 0;
        for (int i = 0; i < annots.size(); ++i) {
            Vector groups;
            AnnotatedFeatureI gene = (AnnotatedFeatureI)annots.elementAt(i);
            if (!this.findSplits(gene, groups = new Vector()) || checkFirst && (!checkFirst || !this.userReallyWantsToSplit(gene))) continue;
            System.err.println("WARNING: Gene " + gene.getName() + " will be split.");
            CompoundTransaction splitTrans = this.splitGene(gene, groups);
            changer.addChange(splitTrans.generateAnnotationChangeEvent(this));
            ++split_cnt;
        }
        if (split_cnt > 0) {
            this.deselect();
        }
    }

    private CompoundTransaction splitGene(AnnotatedFeatureI gene, Vector groups) {
        FeatureSetI geneParent = this.annotationCollection;
        CompoundTransaction splitTransaction = new CompoundTransaction(this);
        splitTransaction.setCompoundType(1);
        splitTransaction.setSeqFeature(gene);
        for (int i = 1; i < groups.size(); ++i) {
            Vector linked = (Vector)groups.elementAt(i);
            AnnotatedFeature newGene = new AnnotatedFeature();
            splitTransaction.setNewSplitFeature(newGene);
            newGene.setStrand(gene.getStrand());
            newGene.setFeatureType(gene.getFeatureType());
            CompoundTransaction parentTransactions = new CompoundTransaction(this);
            for (int j = 0; j < linked.size(); ++j) {
                Transcript trans = (Transcript)linked.elementAt(j);
                UpdateParentTransaction ut = this.moveTranscriptToAnnot(trans, newGene);
                parentTransactions.addTransaction(ut);
            }
            AddTransaction at = new AddTransaction(newGene);
            splitTransaction.addTransaction(at);
            splitTransaction.addTransaction(this.splitGeneSetup(geneParent, gene, newGene));
            this.setTransNameFromGene(gene, false);
            this.setTransNameFromGene(newGene, false);
            splitTransaction.addTransaction(parentTransactions);
        }
        splitTransaction.setSource(this);
        return splitTransaction;
    }

    private UpdateParentTransaction moveTranscriptToAnnot(Transcript trans, AnnotatedFeatureI newParent) {
        AnnotatedFeatureI oldAnnot = trans.getGene();
        oldAnnot.deleteFeature(trans);
        newParent.addFeature(trans);
        if (newParent.isProteinCodingGene()) {
            trans.calcTranslationStartForLongestPeptide();
        }
        this.setOwnerAndDate(trans);
        UpdateParentTransaction upt = new UpdateParentTransaction(this, trans, oldAnnot);
        upt.setOldId(trans.getId());
        return upt;
    }

    private void checkIfBeyondRange() {
        if (this.evidenceSet == null) {
            return;
        }
        Vector features = this.evidenceSet.getLeafFeatures();
        for (int i = 0; i < features.size(); ++i) {
            SeqFeatureI sf;
            Object elem = features.elementAt(i);
            if (!(elem instanceof SeqFeatureI) || (sf = (SeqFeatureI)elem).isContainedByRefSeq()) continue;
            String m = "WARNING: the feature(s) you have selected are not entirely contained within the current sequence region,\nso this edit may not get saved in the database.\n";
            System.err.println(m);
            if (Config.internalMode()) {
                JOptionPane.showMessageDialog(null, m);
            }
            return;
        }
    }

    private void selectFeatures(Vector features, TierViewI view) {
        this.getSelectionManager().select(features, (Object)view);
    }

    private void deselect() {
        this.getSelectionManager().clearSelections();
    }

    private SelectionManager getSelectionManager() {
        return this.getCurationState().getSelectionManager();
    }

    private GuiCurationState getCurationState() {
        return this.curationState;
    }

    private String getUserName() {
        return UserName.getUserName();
    }

    public static void setDebug(boolean debug) {
        DEBUG = debug;
    }

    public static void debugPrint(String m) {
        if (DEBUG) {
            System.out.println(m);
        }
    }

    public static void setDoOneLevelAnnots(boolean doOne) {
        DO_ONE_LEVEL_ANNOTS = doOne;
    }
}

