/*
 * Decompiled with CFR 0.152.
 */
package apollo.editor;

import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.Comment;
import apollo.datamodel.SeqFeatureI;
import apollo.editor.FeatureChangeEvent;
import apollo.editor.Transaction;
import apollo.editor.TransactionSubpart;
import apollo.util.SeqFeatureUtil;

public class AnnotationChangeEvent
extends FeatureChangeEvent {
    private AnnotatedFeatureI annotFeature;
    private AnnotatedFeatureI deletedAnnot;
    private int subpartRank;
    private String oldString;
    private Comment deletedComment;
    private String oldId;
    private Transaction transaction;

    protected AnnotationChangeEvent(Object source) {
        super(source);
    }

    AnnotationChangeEvent(Transaction trans) {
        super(trans.getSource(), trans.getAnnotatedFeature());
        this.setTransaction(trans);
        if (trans.hasSubpart()) {
            this.setSubpart(trans.getSubpart());
        }
    }

    protected AnnotationChangeEvent(Object source, AnnotatedFeatureI feature) {
        super(source, feature);
    }

    protected AnnotationChangeEvent(Object source, AnnotatedFeatureI changedFeat, TransactionSubpart subpart) {
        super(source, changedFeat, subpart);
    }

    void setSource(Object source) {
        this.source = source;
    }

    void setTransaction(Transaction trans) {
        this.transaction = trans;
    }

    boolean hasTransaction() {
        return this.transaction != null;
    }

    Transaction getTransaction() {
        return this.transaction;
    }

    public SeqFeatureI getParentFeature() {
        if (this.parentFeature != null) {
            return this.parentFeature;
        }
        if (this.hasTransaction() && this.getTransaction().getParentFeature() != null) {
            return this.getTransaction().getParentFeature();
        }
        return this.getChangedFeature().getRefFeature();
    }

    public int getNumberOfChildren() {
        return 0;
    }

    public AnnotationChangeEvent getChildChangeEvent(int i) {
        return null;
    }

    public void addTransaction(Transaction trans) {
    }

    public AnnotatedFeatureI getChangedAnnot() {
        if (this.getChangedFeature() == null) {
            return null;
        }
        return this.getChangedFeature().getAnnotatedFeature();
    }

    public AnnotatedFeatureI getDeletedFeature() {
        return this.deletedAnnot;
    }

    public void setDeletedFeature(AnnotatedFeatureI delFeat) {
        this.deletedAnnot = delFeat;
    }

    public AnnotatedFeatureI getAnnotTop() {
        if (super.getChangeTop() != null) {
            return super.getChangeTop().getAnnotatedFeature();
        }
        if (this.getChangedAnnot() == null) {
            return null;
        }
        AnnotatedFeatureI annotTop = SeqFeatureUtil.getAnnotRoot(this.getChangedAnnot());
        this.setChangeTop(annotTop);
        return annotTop;
    }

    public SeqFeatureI getChangeTop() {
        return this.getAnnotTop();
    }

    public void setSubpartRank(int rank) {
        this.subpartRank = rank;
    }

    public int getSubpartRank() {
        return this.subpartRank;
    }

    public void setOldString(String oldString) {
        this.oldString = oldString;
    }

    public boolean isStringChange() {
        return this.getOldString() != null;
    }

    public String getOldString() {
        if (this.hasTransaction() && this.transaction.getSubpart().isString()) {
            return (String)this.transaction.getOldSubpartValue();
        }
        return this.oldString;
    }

    public void setOldComment(Comment comment) {
        this.deletedComment = comment;
    }

    public Comment getOldComment() {
        return this.deletedComment;
    }

    public boolean isCommentChange() {
        return this.getSubpart() == TransactionSubpart.COMMENT;
    }

    public void setOldId(String oldId) {
        this.oldId = oldId;
    }

    public String getOldId() {
        if (this.hasTransaction()) {
            return this.transaction.getOldId();
        }
        return this.oldId;
    }

    public String toString() {
        if (this.hasTransaction()) {
            return this.transaction.toString();
        }
        return super.toString();
    }
}

