/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel.seq;

import apollo.datamodel.Sequence;
import java.util.Hashtable;

public class GenbankSequence
extends Sequence {
    protected String header;
    protected Hashtable properties = null;

    public GenbankSequence(String id, String dna) {
        super(id, dna);
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getHeader() {
        return this.header;
    }

    public void addProperty(String name, String value) {
        if (value != null && !value.equals("")) {
            if (this.properties == null) {
                this.properties = new Hashtable(1, 1.0f);
            }
            String current_value = this.properties.get(name) != null ? (value.endsWith("\n") ? (String)this.properties.get(name) : (String)this.properties.get(name) + " ") : "";
            this.properties.put(name, current_value + value);
        }
    }

    public void removeProperty(String key) {
        if (key != null && !key.equals("")) {
            if (this.properties == null) {
                return;
            }
            if (this.properties.containsKey(key)) {
                this.properties.remove(key);
            }
        }
    }

    public String getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return (String)this.properties.get(name);
    }

    public Hashtable getProperties() {
        if (this.properties == null) {
            this.properties = new Hashtable(1, 1.0f);
        }
        return this.properties;
    }

    protected String getResiduesImpl(int low, int high) {
        int str_high;
        int str_low = low - this.getRange().getStart();
        if (str_low == (str_high = high - this.getRange().getStart())) {
            str_high = str_low + 1;
        }
        String dna = null;
        if (this.residues != null && str_high < this.residues.length()) {
            dna = this.residues.substring(str_low, str_high);
        } else if (this.residues != null && str_low < this.residues.length()) {
            dna = this.residues.substring(str_low);
        }
        return dna;
    }
}

