/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel.seq;

import apollo.config.Config;
import apollo.dataadapter.CGI;
import apollo.datamodel.Range;
import apollo.datamodel.RangeI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.seq.AbstractLazySequence;
import apollo.datamodel.seq.LazySequenceI;
import apollo.gui.Controller;
import apollo.seq.io.FastaFile;
import java.util.Hashtable;
import java.util.Vector;

public class EnsCGISequence
extends AbstractLazySequence
implements LazySequenceI {
    String server;

    public EnsCGISequence(String id, Controller c, RangeI loc, String server) {
        super(id, c);
        this.setRange(loc);
        this.setServer(server);
    }

    protected boolean needInclusiveEnd() {
        return false;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public SequenceI getSubSequence(int start, int end) {
        Range subLoc = new Range(this.getRange().getName(), this.getRange().getStart() + start - 1, this.getRange().getStart() + end - 1);
        return new EnsCGISequence(this.getName(), this.llco.getController(), subLoc, this.server);
    }

    protected String getResiduesFromSourceImpl(int low, int high) {
        int realStart = low;
        int realEnd = high;
        Hashtable<String, String> var = new Hashtable<String, String>();
        var.put("vc_start", String.valueOf(new Integer(realStart)));
        var.put("vc_end", String.valueOf(new Integer(realEnd)));
        var.put("chr", this.getRange().getName());
        var.put("seqonly", "1");
        String host = this.server;
        int port = Config.getCGIPort();
        String cgistr = "perl/apolloview";
        CGI cgi = new CGI(host, port, cgistr, var, System.out);
        cgi.run();
        FastaFile fa = new FastaFile(cgi.getInput(), false);
        Vector seqs = fa.getSeqs();
        if (seqs.size() == 1) {
            System.out.println("Returning sequence");
            return ((SequenceI)seqs.elementAt(0)).getResidues();
        }
        System.out.println("Returning null");
        return null;
    }

    public static void main(String[] argv) {
        Controller c = new Controller();
        EnsCGISequence seq = new EnsCGISequence("Dummy", c, new Range("22", 20000000, 20100000), "www.ensembl.org");
        seq.getCacher().setMinChunkSize(100);
        System.out.println("Sequence first 10 = " + seq.getResidues(1, 10));
        System.out.println("Sequence 100-110 = " + seq.getResidues(100, 110));
        System.out.println("Sequence 10000-11010 = " + seq.getResidues(10000, 11010));
        System.out.println("Sequence 1-12010 = " + seq.getResidues(1, 12010));
    }
}

