/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel;

import apollo.datamodel.AnnotatedFeature;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.ExonI;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.Protein;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.Sequence;
import apollo.datamodel.SequenceI;
import apollo.util.QuickSort;
import java.util.Vector;

public class Transcript
extends AnnotatedFeature {
    protected SequenceI cDNA = null;
    protected SequenceI peptide = null;
    private boolean peptideValidity = true;
    private boolean allow_nonconsensus_splicing = false;
    private Protein proteinFeat;
    public static final String TRANSCRIPT_TYPE = "transcript";

    public Transcript() {
        this.setup();
    }

    public Transcript(FeatureSetI fs) {
        super(fs, "apollo.datamodel.Exon");
        this.setup();
    }

    private void setup() {
        this.setFeatureType(TRANSCRIPT_TYPE);
        this.annotationRoot = false;
    }

    private void addExonWithOverlapCheck(ExonI exon, boolean sort) {
        int i;
        Vector<ExonI> overlaps = new Vector<ExonI>();
        int setSize = this.features.size();
        for (i = 0; i < setSize; ++i) {
            if (!this.getFeatureAt(i).overlaps(exon)) continue;
            overlaps.addElement(this.getExonAt(i));
        }
        for (i = 0; i < overlaps.size(); ++i) {
            exon.merge((ExonI)overlaps.elementAt(i));
            this.deleteExon((ExonI)overlaps.elementAt(i));
        }
        this.addFeature(exon, sort);
    }

    public void addExon(ExonI exon) {
        this.setPeptideValidity(false);
        if (this.features.size() != 0 && !this.trans_spliced && this.getExonAt(0).getStrand() != exon.getStrand()) {
            String msg = "ERROR: strand inconsistent in addExon() to " + this.getName() + ".\n" + "Exon " + exon.getStart() + "-" + exon.getEnd() + " has strand " + exon.getStrand() + ", whereas the first exon in that gene has strand " + this.getExonAt(0).getStrand() + "\n\tSetting trans_spliced to true";
            System.err.println(msg);
            this.trans_spliced = true;
        }
        this.addExonWithOverlapCheck(exon, !this.trans_spliced);
    }

    public void sortExons() {
        this.sort(this.getStrand());
    }

    public void addFeature(SeqFeatureI feature) {
        this.addExon((ExonI)feature);
    }

    public void deleteExon(ExonI exon) {
        this.deleteFeature(exon);
    }

    public Vector getExons() {
        return this.features;
    }

    public ExonI getExonAt(int i) {
        return (ExonI)this.getFeatureAt(i);
    }

    public String get_cDNA() {
        if (!this.haveWholeSequence() && this.cDNA != null) {
            if (this.cDNA.getResidues() == null) {
                return super.get_cDNA();
            }
            return this.cDNA.getResidues();
        }
        String na = super.get_cDNA();
        if (na != null && !na.equals("")) {
            if (this.cDNA == null) {
                this.cDNA = new Sequence(this.getName(), na);
                this.cDNA.setResidueType("RNA");
                if (this.peptide != null) {
                    this.peptide.clearResidues();
                    this.setPeptideValidity(false);
                }
            } else if (this.cDNA.getResidues() == null || !this.cDNA.getResidues().equals(na)) {
                this.cDNA.setResidues(na);
                this.setPeptideValidity(false);
            }
        }
        return this.cDNA != null ? this.cDNA.getResidues() : na;
    }

    public boolean haveWholeSequence() {
        return this.isContainedByRefSeq();
    }

    public SequenceI get_cDNASequence() {
        if (this.cDNA == null) {
            this.get_cDNA();
        }
        return this.cDNA;
    }

    public void set_cDNASequence(SequenceI cDNA) {
        this.cDNA = cDNA;
    }

    public String translate() {
        if (!this.isProteinCodingGene() || !this.hasRefSequence()) {
            this.setPeptideValidity(false);
            return "";
        }
        String aa = super.translate();
        if (this.peptide == null) {
            this.peptide = new Sequence(null, aa);
            this.peptide.setResidueType("AA");
        } else if (!(aa == null || aa.equals("") || aa.indexOf("*") >= 0 || this.peptide.hasResidues() && aa.equals(this.peptide.getResidues()))) {
            this.peptide.setResidues(aa);
        }
        this.setPeptideValidity(true);
        return this.peptide.getResidues();
    }

    public SequenceI getPeptideSequence() {
        if (this.peptide == null && this.isProteinCodingGene()) {
            this.peptide = new Sequence(null, "");
            this.peptide.setResidueType("AA");
            this.translate();
        } else if (!this.getPeptideValidity()) {
            this.translate();
        }
        return this.peptide;
    }

    public void setPeptideSequence(SequenceI pep) {
        this.peptide = pep;
    }

    public void setPeptideValidity(boolean validity) {
        this.peptideValidity = validity;
        if (!this.peptideValidity) {
            if (this.cDNA != null) {
                this.cDNA.setChecksum("");
            }
            if (this.peptide != null) {
                this.peptide.setChecksum("");
            }
        }
    }

    public boolean getPeptideValidity() {
        return this.peptideValidity;
    }

    public String toString() {
        return this.getName();
    }

    public void sortTransSpliced() {
        Object exon;
        int index;
        int i;
        int setSize = this.size();
        if (setSize == 0) {
            return;
        }
        int[] coord = new int[setSize];
        Object[] obj = new SeqFeatureI[setSize];
        for (int i2 = 0; i2 < setSize; ++i2) {
            SeqFeatureI sf = this.getFeatureAt(i2);
            coord[i2] = sf.getStart();
            obj[i2] = sf;
        }
        QuickSort.sort(coord, obj);
        SeqFeatureI start_span = this.getFeatureContaining(this.getTranslationStart());
        int strand = start_span.getStrand();
        int count = 0;
        for (i = 0; i < setSize; ++i) {
            index = strand == 1 ? i : setSize - i - 1;
            exon = obj[index];
            if (exon.getStrand() != strand) continue;
            this.features.setElementAt(exon, i);
            ++count;
        }
        strand *= -1;
        for (i = 0; i < setSize; ++i) {
            index = strand == 1 ? i : setSize - i - 1;
            exon = obj[index];
            if (exon.getStrand() != strand) continue;
            this.features.setElementAt(exon, i + count);
        }
    }

    public boolean hasPeptideSequence() {
        return this.getPeptideSequence() != null;
    }

    public String getTopLevelType() {
        if (this.getRefFeature() == null) {
            if (this.biotype == null || this.biotype.equals("")) {
                return this.getFeatureType();
            }
            return this.biotype;
        }
        return this.getRefFeature().getTopLevelType();
    }

    public AnnotatedFeatureI getGene() {
        return (AnnotatedFeatureI)this.getRefFeature();
    }

    public boolean isProteinCodingGene() {
        if (this.getGene() != null) {
            return this.getGene().isProteinCodingGene();
        }
        return true;
    }

    public int getNonConsensusAcceptorNum() {
        int odd = -1;
        int exon_cnt = this.size();
        if (this.isProteinCodingGene() && exon_cnt > 1) {
            for (int i = 0; i < exon_cnt && odd == -1; ++i) {
                if (!((ExonI)this.getFeatureAt(i)).isNonConsensusAcceptor()) continue;
                odd = i;
            }
        }
        return odd;
    }

    public int getNonConsensusDonorNum() {
        int odd = -1;
        int exon_cnt = this.size();
        if (this.isProteinCodingGene() && exon_cnt > 1) {
            for (int i = 0; i < exon_cnt && odd == -1; ++i) {
                if (!((ExonI)this.getFeatureAt(i)).isNonConsensusDonor()) continue;
                odd = i;
            }
        }
        return odd;
    }

    public boolean nonConsensusSplicingOkay() {
        return this.allow_nonconsensus_splicing;
    }

    public void nonConsensusSplicingOkay(boolean okay) {
        this.allow_nonconsensus_splicing = okay;
    }

    public boolean isTranscript() {
        return true;
    }

    public Protein getProteinFeat() {
        if (!this.isProteinCodingGene()) {
            return null;
        }
        if (this.proteinFeat != null) {
            return this.proteinFeat;
        }
        this.proteinFeat = new Protein(this);
        return this.proteinFeat;
    }

    public boolean hasProteinFeat() {
        return this.getProteinFeat() != null;
    }

    void setProteinFeat(Protein prot) {
        this.proteinFeat = prot;
    }
}

