/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Synonym
implements Serializable {
    protected String name;
    protected Hashtable properties = null;
    private String owner;
    private int ownerId;

    public Synonym() {
    }

    public Synonym(String syn) {
        this.name = syn;
    }

    public Synonym(String name, String owner) {
        this.name = name;
        this.owner = owner;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwnerId(int ownerId) {
        this.ownerId = ownerId;
    }

    public int getOwnerId() {
        return this.ownerId;
    }

    public Synonym cloneSynonym() {
        Synonym clone = new Synonym(this.name);
        clone.setProperties(this.getProperties());
        return clone;
    }

    public void clearProperties() {
        this.properties = null;
    }

    public void addProperty(String key, String value) {
        if (value != null && !value.equals("")) {
            Vector values;
            if (this.properties == null) {
                this.properties = new Hashtable(1, 1.0f);
            }
            if (this.properties.get(key) == null) {
                values = new Vector();
                this.properties.put(key, values);
            } else {
                values = (Vector)this.properties.get(key);
            }
            values.addElement(value);
        }
    }

    public void removeProperty(String key) {
        if (key != null && !key.equals("")) {
            if (this.properties == null) {
                return;
            }
            if (this.properties.containsKey(key)) {
                this.properties.remove(key);
            }
        }
    }

    public void replaceProperty(String key, String value) {
        this.removeProperty(key);
        this.addProperty(key, value);
    }

    public String getProperty(String key) {
        if (this.properties == null || this.properties.get(key) == null) {
            return "";
        }
        Vector values = (Vector)this.properties.get(key);
        return (String)values.lastElement();
    }

    public Vector getPropertyMulti(String key) {
        if (this.properties == null) {
            return null;
        }
        return (Vector)this.properties.get(key);
    }

    public Hashtable getProperties() {
        if (this.properties == null) {
            this.properties = new Hashtable(1, 1.0f);
        }
        Hashtable hash = new Hashtable(1, 1.0f);
        Enumeration e = this.properties.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            String value = (String)((Vector)this.properties.get(key)).elementAt(0);
            hash.put(key, value);
        }
        return hash;
    }

    public Hashtable getPropertiesMulti() {
        if (this.properties == null) {
            this.properties = new Hashtable(1, 1.0f);
        }
        return this.properties;
    }

    public void setProperties(Hashtable props) {
        this.properties = props;
    }

    public String toString() {
        return this.getName();
    }
}

