/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel;

import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.StrandedFeatureSetI;
import apollo.util.FeatureList;
import apollo.util.Visitor;
import java.util.Vector;

public class StrandedFeatureSet
extends FeatureSet
implements StrandedFeatureSetI {
    protected FeatureSetI forward;
    protected FeatureSetI reverse;

    public StrandedFeatureSet(FeatureSetI forward_set, FeatureSetI reverse_set) {
        this.forward = forward_set;
        this.reverse = reverse_set;
        this.forward.setStrand(1);
        this.reverse.setStrand(-1);
        this.forward.setRefFeature(this);
        this.reverse.setRefFeature(this);
        this.setStrand(0);
    }

    public StrandedFeatureSet() {
        this((FeatureSetI)new FeatureSet(), new FeatureSet());
    }

    public FeatureSetI getForwardSet() {
        return this.forward;
    }

    public FeatureSetI getReverseSet() {
        return this.reverse;
    }

    public int size() {
        int tmp = this.forward == null ? 0 : this.forward.size();
        return tmp += this.reverse == null ? 0 : this.reverse.size();
    }

    public void addFeature(SeqFeatureI feature) {
        if (feature.getStrand() == -1) {
            this.reverse.addFeature(feature, true);
        } else if (feature.getStrand() == 1) {
            this.forward.addFeature(feature, true);
        } else {
            this.forward.addFeature(feature);
            this.reverse.addFeature(feature);
        }
        this.adjustEdges(feature);
    }

    public void addFeature(SeqFeatureI feature, boolean sortFlag) {
        if (feature.getStrand() == -1) {
            this.reverse.addFeature(feature, sortFlag);
        } else if (feature.getStrand() == 1) {
            this.forward.addFeature(feature, sortFlag);
        } else {
            this.forward.addFeature(feature, sortFlag);
            this.reverse.addFeature(feature, sortFlag);
        }
        this.adjustEdges(feature);
    }

    public void deleteFeature(SeqFeatureI feature) {
        this.forward.deleteFeature(feature);
        this.reverse.deleteFeature(feature);
    }

    public SeqFeatureI deleteFeatureAt(int i) {
        if (i < this.forward.size()) {
            SeqFeatureI sf = this.forward.deleteFeatureAt(i);
            return sf;
        }
        int size = this.forward.size();
        int num = i - size;
        if (num < this.reverse.size()) {
            SeqFeatureI sf = this.reverse.deleteFeatureAt(num);
            return sf;
        }
        return null;
    }

    public SeqFeatureI getFeatureAt(int i) {
        SeqFeatureI sf = null;
        if (i < this.forward.size()) {
            sf = this.forward.getFeatureAt(i);
        } else {
            int size = this.forward.size();
            int num = i - size;
            if (num < this.reverse.size()) {
                sf = this.reverse.getFeatureAt(num);
            }
        }
        return sf;
    }

    public Vector getFeatures() {
        int i;
        Vector<SeqFeatureI> tmp = new Vector<SeqFeatureI>();
        for (i = 0; i < this.forward.size(); ++i) {
            tmp.addElement(this.forward.getFeatureAt(i));
        }
        for (i = 0; i < this.reverse.size(); ++i) {
            tmp.addElement(this.reverse.getFeatureAt(i));
        }
        return tmp;
    }

    public FeatureList getLeafFeatsOver(int pos) {
        FeatureList leaves = this.forward.getLeafFeatsOver(pos);
        leaves.addAll(this.reverse.getLeafFeatsOver(pos));
        return leaves;
    }

    public int getStart() {
        int tmp2;
        int tmp1 = this.forward.getStart();
        if (tmp1 < (tmp2 = this.reverse.getStart())) {
            return tmp1;
        }
        return tmp2;
    }

    public int getEnd() {
        int end = 1;
        boolean set = false;
        if (this.forward != null && this.forward.hasDescendents()) {
            end = this.forward.getEnd();
            set = true;
        }
        if (this.reverse != null && this.reverse.hasDescendents() && this.reverse.getEnd() > end) {
            end = this.reverse.getEnd();
            set = true;
        }
        if (!set) {
            System.out.println("Warning: No features to getEnd() for");
        }
        return end;
    }

    public void setRefSequence(SequenceI seq) {
        this.refSeq = seq;
        this.forward.setRefSequence(seq);
        this.reverse.setRefSequence(seq);
    }

    public SeqFeatureI getSeqFeat(int strand, String type) {
        FeatureSetI strandFS = this.getFeatSetForStrand(strand);
        for (int i = 0; i < strandFS.size(); ++i) {
            SeqFeatureI grandChild = strandFS.getFeatureAt(i);
            if (!grandChild.getFeatureType().equals(type)) continue;
            return grandChild;
        }
        return null;
    }

    public FeatureSetI getFeatSetForStrand(int strand) {
        if (strand == 1) {
            return this.getForwardSet();
        }
        return this.getReverseSet();
    }

    public StrandedFeatureSetI getStrandedFeatSetAncestor() {
        return this;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

