/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel;

import apollo.datamodel.AbstractSequence;
import apollo.datamodel.SequenceI;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Sequence
extends AbstractSequence
implements SequenceI {
    private char[] dna_chars;
    protected String residues;

    public Sequence(String id, String residues) {
        super(id);
        this.setResidues(residues);
    }

    public int getLength() {
        if (this.residues != null && !this.residues.equals("")) {
            return this.residues.length();
        }
        return this.length;
    }

    public char getBaseAt(int loc) {
        return this.residues.charAt(this.translateRangeToStringCoords(loc));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        String dna_temp = this.residues;
        this.residues = null;
        if (dna_temp != null) {
            this.dna_chars = new char[dna_temp.length()];
            dna_temp.getChars(0, dna_temp.length(), this.dna_chars, 0);
        }
        out.defaultWriteObject();
        this.dna_chars = null;
        this.residues = dna_temp;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.dna_chars != null) {
            this.setResidues(new String(this.dna_chars));
        }
        this.dna_chars = null;
    }

    public SequenceI getSubSequence(int start, int end) {
        return new Sequence(this.getName(), this.getResidues(start, end));
    }

    public void setResidues(String seqString) {
        if (seqString != null) {
            this.residues = seqString.toUpperCase();
            this.length = this.residues.length();
        }
    }

    public void clearResidues() {
        this.residues = "";
        this.length = 0;
    }

    public String getResidues() {
        return this.residues;
    }

    protected String getResiduesImpl(int rangeStart, int rangeEnd) {
        if (this.residues != null && this.residues.length() > 0 && rangeStart >= 0 && rangeEnd >= 0) {
            int substringStart = this.translateRangeToStringCoords(rangeStart);
            int substringEnd = this.translateRangeToStringCoords(rangeEnd);
            if (substringEnd > this.residues.length()) {
                substringEnd = this.residues.length();
            }
            return this.residues.substring(substringStart, substringEnd);
        }
        return "";
    }

    private int translateRangeToStringCoords(int rangeCoord) {
        if (!this.hasRange()) {
            return rangeCoord;
        }
        return rangeCoord - this.getRange().getStart();
    }

    protected String getResiduesImpl(int start) {
        if (this.residues != null) {
            return this.residues.substring(this.translateRangeToStringCoords(start));
        }
        return "";
    }
}

