/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel;

import apollo.datamodel.CurationSet;
import apollo.datamodel.FeaturePairI;
import apollo.datamodel.Link;
import apollo.util.FeatureList;
import java.util.ArrayList;
import java.util.Vector;

public class LinkSet {
    private ArrayList links = new ArrayList();
    private String species1;
    private String species2;
    private CurationSet wrappedCurationLinkSet;
    private boolean linkedByName = true;

    public LinkSet() {
        this(true);
    }

    public LinkSet(boolean linkedByName) {
        this.linkedByName = linkedByName;
    }

    public LinkSet(FeatureList links, String species1, String species2) {
        this.setSpecies1(species1);
        this.setSpecies2(species2);
        this.addLinks(links);
    }

    public LinkSet(CurationSet curLinkSet, String species1, String species2) {
        this.setSpecies1(species1);
        this.setSpecies2(species2);
        this.wrappedCurationLinkSet = curLinkSet;
        this.getFeatsFromWrappedCurationLinkSet();
    }

    public void addLinks(LinkSet linkSet) {
        this.links.addAll(linkSet.links);
    }

    private void addLinks(FeatureList links) {
        links.setFeaturePairsOnly(true);
        for (int i = 0; i < links.size(); ++i) {
            links.add(new Link(links.getFeaturePair(i)));
        }
    }

    private void getFeatsFromWrappedCurationLinkSet() {
        Vector forwardSet = this.wrappedCurationLinkSet.getResults().getForwardSet().getFeatures();
        for (int j = 0; j < forwardSet.size(); ++j) {
            this.addLink((FeaturePairI)forwardSet.get(j));
        }
        Vector reverseSet = this.wrappedCurationLinkSet.getResults().getReverseSet().getFeatures();
        for (int j = 0; j < reverseSet.size(); ++j) {
            this.addLink((FeaturePairI)reverseSet.get(j));
        }
    }

    public boolean linkedByName() {
        return this.linkedByName;
    }

    public boolean linkedByFeature() {
        return !this.linkedByName;
    }

    public String getName() {
        return this.species1 + "-" + this.species2;
    }

    public void addLink(FeaturePairI link) {
        this.links.add(new Link(link));
    }

    public void addLink(Link link) {
        if (link == null) {
            return;
        }
        this.links.add(link);
    }

    public Link getLink(int i) {
        return (Link)this.links.get(i);
    }

    public int size() {
        return this.links.size();
    }

    boolean hasLinks() {
        return this.size() > 0;
    }

    public void setSpecies1(String species1) {
        this.species1 = species1;
    }

    public String getSpecies1() {
        return this.species1;
    }

    public void setSpecies2(String species2) {
        this.species2 = species2;
    }

    public String getSpecies2() {
        return this.species2;
    }

    public LinkSet findLinksWithName(String name) {
        LinkSet ls = new LinkSet();
        for (int i = 0; i < this.size(); ++i) {
            Link link = this.getLink(i);
            if (!link.hasName(name)) continue;
            ls.addLink(link);
        }
        return ls;
    }

    public boolean contains(Link link) {
        return this.links.contains(link);
    }

    public void clear() {
        this.links.clear();
    }
}

