/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel;

import apollo.datamodel.FeaturePairI;
import apollo.datamodel.SeqFeatureI;

public class Link {
    private SeqFeatureI link1Feature;
    private SeqFeatureI link2Feature;
    private SeqFeatureI species1Feature;
    private SeqFeatureI species2Feature;
    private boolean hasSpeciesFeatures = false;
    private boolean hasPercentIdentity = true;
    private boolean typeIsFeat1 = true;

    public Link(SeqFeatureI link1Feature, SeqFeatureI link2Feature, boolean hasSpec, boolean hasPercentIdentity) {
        this.link1Feature = link1Feature;
        this.link2Feature = link2Feature;
        this.hasSpeciesFeatures = hasSpec;
        this.hasPercentIdentity = hasPercentIdentity;
    }

    public Link(FeaturePairI wrappedFeatPair) {
        this.link1Feature = wrappedFeatPair.getQueryFeature();
        this.link2Feature = wrappedFeatPair.getHitFeature();
        this.hasSpeciesFeatures = false;
    }

    public void setSpeciesFeature1(SeqFeatureI species1) {
        this.species1Feature = species1;
    }

    public void setSpeciesFeature2(SeqFeatureI species2) {
        this.species2Feature = species2;
    }

    public void setTypeIsFeat1(boolean state) {
        this.typeIsFeat1 = state;
    }

    public String getType() {
        if (this.typeIsFeat1 && this.getSpeciesFeature1() != null) {
            return this.getSpeciesFeature1().getFeatureType();
        }
        if (this.getSpeciesFeature2() != null) {
            return this.getSpeciesFeature2().getFeatureType();
        }
        return null;
    }

    public String getName1() {
        return this.link1Feature.getName();
    }

    public String getName2() {
        return this.link2Feature.getName();
    }

    public boolean hasNames() {
        if (this.getName1() == null) {
            return false;
        }
        if (this.getName1().equals("no_name")) {
            return false;
        }
        if (this.getName2() == null) {
            return false;
        }
        return !this.getName2().equals("no_name");
    }

    boolean hasName(String name) {
        if (this.getName1().equals(name)) {
            return true;
        }
        return this.getName2().equals(name);
    }

    public int getLow1() {
        return this.link1Feature.getLow();
    }

    public int getHigh1() {
        return this.link1Feature.getHigh();
    }

    public int getLow2() {
        return this.link2Feature.getLow();
    }

    public int getHigh2() {
        return this.link2Feature.getHigh();
    }

    public int getStrand1() {
        return this.link1Feature.getStrand();
    }

    public boolean isForwardStrand1() {
        return this.getStrand1() == 1;
    }

    public int getStrand2() {
        return this.link2Feature.getStrand();
    }

    public boolean isForwardStrand2() {
        return this.getStrand2() == 1;
    }

    public double getPercentIdentity() {
        if (!this.hasPercentIdentity()) {
            return 0.0;
        }
        return this.getSpeciesFeature1().getScore();
    }

    public boolean hasPercentIdentity() {
        return this.hasPercentIdentity;
    }

    public boolean hasSpeciesFeatures() {
        return this.hasSpeciesFeatures;
    }

    public SeqFeatureI getSpeciesFeature1() {
        if (this.species1Feature == null) {
            return this.link1Feature;
        }
        return this.species1Feature;
    }

    public SeqFeatureI getSpeciesFeature2() {
        if (this.species2Feature == null) {
            return this.link2Feature;
        }
        return this.species2Feature;
    }

    public SeqFeatureI getLinkedSpeciesFeature(SeqFeatureI feat) {
        if (this.getSpeciesFeature1() == feat) {
            return this.getSpeciesFeature2();
        }
        if (this.getSpeciesFeature2() == feat) {
            return this.getSpeciesFeature1();
        }
        return null;
    }
}

