/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel;

import apollo.datamodel.CurationSet;
import apollo.datamodel.DbXref;
import apollo.datamodel.Synonym;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Identifier
implements Serializable,
Cloneable {
    String description;
    Vector synonyms;
    Hashtable dbXrefs;

    public Identifier(String description) {
        this.setDescription(description);
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getDescription() {
        return this.description;
    }

    public Vector getSynonyms() {
        return this.getSynonyms(false);
    }

    public Vector getSynonyms(boolean excludeInternalSynonyms) {
        if (this.synonyms == null) {
            return new Vector();
        }
        if (!excludeInternalSynonyms) {
            return this.synonyms;
        }
        Vector<Synonym> syns = new Vector<Synonym>();
        for (int i = 0; i < this.synSize(); ++i) {
            Synonym syn = (Synonym)this.synonyms.elementAt(i);
            if (syn.getProperty("is_internal").equals("1")) continue;
            syns.add(syn);
        }
        return syns;
    }

    private int synSize() {
        if (this.synonyms == null) {
            return 0;
        }
        return this.synonyms.size();
    }

    public void addSynonym(String syn) {
        this.addSynonym(this.synSize(), new Synonym(syn));
    }

    public void addSynonym(int index, String syn) {
        this.addSynonym(index, new Synonym(syn));
    }

    public void addSynonym(Synonym syn) {
        this.addSynonym(this.synSize(), syn);
    }

    public void addSynonym(int index, Synonym syn) {
        if (syn != null && syn.getName() != null && !syn.getName().equals("")) {
            if (this.synonyms == null) {
                this.synonyms = new Vector();
            }
            this.alreadyInList(syn, this.synonyms);
            this.synonyms.add(index, syn);
        } else if (CurationSet.DEBUG) {
            String m = "Syn not added as its null/empty " + syn;
            if (syn != null) {
                m = m + " name " + syn.getName();
            }
            System.out.println(m);
        }
    }

    boolean hasSynonym(String name) {
        if (this.synonyms == null) {
            return false;
        }
        return this.alreadyInList(new Synonym(name), this.synonyms);
    }

    private boolean alreadyInList(Synonym syn, Vector synonyms) {
        String name = syn.getName();
        for (int i = 0; i < synonyms.size(); ++i) {
            Synonym s = (Synonym)synonyms.elementAt(i);
            if (!name.equals(s.getName())) continue;
            return true;
        }
        return false;
    }

    public void deleteSynonym(Synonym nym) {
        if (this.synonyms != null) {
            this.synonyms.remove(nym);
        }
    }

    public void deleteSynonym(String nym) {
        if (this.synonyms != null) {
            for (int i = 0; i < this.synonyms.size(); ++i) {
                Synonym syn = (Synonym)this.synonyms.elementAt(i);
                if (!syn.getName().equals(nym)) continue;
                this.synonyms.remove(syn);
            }
        }
    }

    public void clearSynonyms() {
        if (this.synonyms != null) {
            this.synonyms.clear();
        }
    }

    public void nullSynonyms() {
        this.synonyms = null;
    }

    public Vector getDbXrefs() {
        Vector xref_vect = new Vector();
        if (this.dbXrefs != null) {
            Enumeration e = this.dbXrefs.elements();
            while (e.hasMoreElements()) {
                xref_vect.addElement(e.nextElement());
            }
        }
        return xref_vect;
    }

    public void addDbXref(DbXref dbxref) {
        String key;
        if (dbxref != null && (key = dbxref.getDbName() + dbxref.getIdValue()) != null && !key.equals("")) {
            if (this.dbXrefs == null) {
                this.dbXrefs = new Hashtable(1);
            }
            this.dbXrefs.put(key, dbxref);
        }
    }

    public void deleteDbXref(DbXref dbxref) {
        String key;
        if (this.dbXrefs != null && dbxref != null && (key = dbxref.getDbName() + dbxref.getIdValue()) != null && !key.equals("")) {
            this.dbXrefs.remove(key);
        }
    }

    public void nullDbXrefs() {
        this.dbXrefs = null;
    }

    public String toString() {
        return "[" + this.description + "][" + this.getSynonyms().toString() + "][" + this.getDbXrefs().toString();
    }

    public Object clone() {
        try {
            int i;
            Identifier clone = (Identifier)super.clone();
            clone.nullSynonyms();
            for (i = 0; i < this.getSynonyms().size(); ++i) {
                Synonym syn = (Synonym)this.getSynonyms().elementAt(i);
                clone.addSynonym(syn.cloneSynonym());
            }
            clone.nullDbXrefs();
            for (i = 0; i < this.getDbXrefs().size(); ++i) {
                DbXref xref = (DbXref)this.getDbXrefs().elementAt(i);
                clone.addDbXref(new DbXref(xref.getIdType(), xref.getIdValue(), xref.getDbName()));
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

