/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel;

import apollo.datamodel.FeaturePairI;
import apollo.datamodel.Score;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class FeaturePair
extends SeqFeature
implements FeaturePairI {
    SeqFeatureI query;
    SeqFeatureI hit;
    private static final String cigarDelims = "MDI";
    private String cigar = "";

    public FeaturePair(SeqFeatureI f1, SeqFeatureI f2) {
        this.query = f1;
        this.setHitFeature(f2);
    }

    public void setQueryFeature(SeqFeatureI feature) {
        this.query = feature;
    }

    public SeqFeatureI getQueryFeature() {
        return this.query;
    }

    public void setHitFeature(SeqFeatureI feature) {
        this.hit = feature;
        this.hit.setQueryFeature(this);
    }

    public SeqFeatureI getHitFeature() {
        return this.hit;
    }

    public boolean hasHitFeature() {
        return this.hit != null;
    }

    public void setLow(int low) {
        this.query.setLow(low);
    }

    public int getLow() {
        return this.query.getLow();
    }

    public void setHigh(int high) {
        this.query.setHigh(high);
    }

    public int getHigh() {
        return this.query.getHigh();
    }

    public void setStart(int start) {
        this.query.setStart(start);
    }

    public int getStart() {
        return this.query.getStart();
    }

    public void setEnd(int end) {
        this.query.setEnd(end);
    }

    public int getEnd() {
        return this.query.getEnd();
    }

    public void setStrand(int strand) {
        this.query.setStrand(strand);
    }

    public int getStrand() {
        return this.query.getStrand();
    }

    public void setName(String name) {
        this.query.setName(name);
    }

    public String getName() {
        if (this.query.getName().equals("no_name")) {
            SequenceI seq = this.hit.getRefSequence();
            if (seq != null && seq.getName() != null) {
                this.query.setName(seq.getName());
            } else {
                this.query.setName(this.hit.getName() != null ? this.hit.getName() : "");
            }
        }
        return this.query.getName();
    }

    public void setId(String id) {
        this.query.setId(id);
    }

    public String getId() {
        return this.query.getId();
    }

    public double getScore() {
        return this.query.getScore();
    }

    public double getScore(String name) {
        return this.query.getScore(name);
    }

    public Hashtable getScores() {
        return this.query.getScores();
    }

    public void setScore(double score) {
        this.query.setScore(score);
    }

    public void addScore(Score s) {
        this.query.addScore(s);
    }

    public void addScore(double score) {
        this.query.addScore(score);
    }

    public void addScore(String name, double score) {
        this.query.addScore(name, score);
    }

    public void addScore(String name, String score) {
        this.query.addScore(name, score);
    }

    public void addProperty(String name, String value) {
        this.query.addProperty(name, value);
    }

    public void removeProperty(String key) {
        this.query.removeProperty(key);
    }

    public String getProperty(String name) {
        return this.query.getProperty(name);
    }

    public Hashtable getProperties() {
        return this.query.getProperties();
    }

    public void setFeatureType(String type) {
        this.query.setFeatureType(type);
    }

    public String getTopLevelType() {
        return this.query.getTopLevelType();
    }

    public String getFeatureType() {
        return this.query.getFeatureType();
    }

    public void setProgramName(String name) {
        this.query.setProgramName(name);
    }

    public String getProgramName() {
        return this.query.getProgramName();
    }

    public String getResidues() {
        return this.query.getResidues();
    }

    public void setRefSequence(SequenceI seq) {
        this.query.setRefSequence(seq);
    }

    public SequenceI getRefSequence() {
        return this.query.getRefSequence();
    }

    public String getRefId() {
        return this.query.getRefId();
    }

    public SeqFeatureI getRefFeature() {
        return this.query.getRefFeature();
    }

    public void setRefFeature(SeqFeatureI feature) {
        this.query.setRefFeature(feature);
    }

    public int getFrame() {
        return this.query.getFrame();
    }

    public String getHname() {
        return this.hit.getName();
    }

    public void setHname(String name) {
        this.hit.setName(name);
    }

    public int getHstart() {
        return this.hit.getStart();
    }

    public void setHstart(int start) {
        this.hit.setStart(start);
    }

    public int getHend() {
        return this.hit.getEnd();
    }

    public void setHend(int end) {
        this.hit.setEnd(end);
    }

    public void setHlow(int low) {
        this.hit.setLow(low);
    }

    public int getHlow() {
        return this.hit.getLow();
    }

    public void setHhigh(int high) {
        this.hit.setHigh(high);
    }

    public int getHhigh() {
        return this.hit.getHigh();
    }

    public void setHstrand(int strand) {
        this.hit.setStrand(strand);
    }

    public int getHstrand() {
        return this.hit.getStrand();
    }

    public SequenceI getHitSequence() {
        return this.hit.getRefSequence();
    }

    public void setHitSequence(SequenceI hit_seq) {
        this.hit.setRefSequence(hit_seq);
    }

    public static void main(String[] args) {
        SeqFeature sf1 = new SeqFeature(100, 200, "pog", 1);
        SeqFeature sf2 = new SeqFeature(100, 200, "pog", -1);
        sf1.setName("query");
        sf2.setName("hit");
        System.out.println("Features " + sf1);
        System.out.println("Features " + sf2);
        FeaturePair fp = new FeaturePair(sf1, sf2);
        System.out.println("Feature is " + fp);
        System.out.println("Left/right overlaps " + fp.getLeftOverlap(sf1) + " " + fp.getRightOverlap(sf1));
        System.out.println("Overlap " + fp.isExactOverlap(sf1) + " " + fp.isExactOverlap(sf2));
        System.out.println("Feature is " + fp);
        System.out.println("Overlap " + fp.isExactOverlap(sf1) + " " + fp.isExactOverlap(sf2));
    }

    public String getDisplayId() {
        SequenceI seq = this.hit.getRefSequence();
        if (seq != null) {
            return seq.getName();
        }
        return this.getFeatureType() + " result" + this.getName();
    }

    public void setCigar(String cigar) {
        if (cigar != null) {
            this.cigar = cigar;
        }
    }

    public String getCigar() {
        return this.cigar;
    }

    protected boolean hasCigar() {
        return !this.isEmptyOrNull(this.cigar);
    }

    public String getExplicitAlignment() {
        return this.query.getExplicitAlignment();
    }

    public void setExplicitAlignment(String align) {
        this.query.setExplicitAlignment(align);
    }

    private boolean isEmptyOrNull(String s) {
        if (s == null) {
            return true;
        }
        return s.equals("");
    }

    public void parseCigar() {
        if (!this.hasCigar()) {
            return;
        }
        if (this.isEmptyOrNull(this.getResidues())) {
            return;
        }
        if (this.isEmptyOrNull(this.getHitFeature().getResidues())) {
            return;
        }
        if (this.isEmptyOrNull(this.getCigar())) {
            return;
        }
        StringTokenizer cigarTokens = new StringTokenizer(this.getCigar(), cigarDelims, true);
        String q_seq = this.getResidues();
        String h_seq = this.getHitFeature().getResidues();
        StringBuffer q_alignment = new StringBuffer();
        StringBuffer h_alignment = new StringBuffer();
        int q_units = this.getRefSequence().getResidueType() == null || this.getRefSequence().getResidueType().equals("DNA") ? 1 : 3;
        int h_units = this.alignmentIsPeptide() ? 3 : 1;
        int length = 1;
        String type = cigarTokens.hasMoreTokens() ? cigarTokens.nextToken() : null;
        String next_type = null;
        while (type != null) {
            if (cigarTokens.hasMoreTokens()) {
                String piece = cigarTokens.nextToken();
                if (cigarDelims.indexOf(piece) >= 0) {
                    length = 1;
                    next_type = piece;
                } else {
                    try {
                        length = Integer.parseInt(piece.trim());
                        next_type = cigarTokens.hasMoreTokens() ? cigarTokens.nextToken() : null;
                    }
                    catch (Exception e) {
                        System.out.println("Could not parse " + this.getCigar() + " did not get an integer");
                        next_type = piece;
                    }
                }
            } else if (type.equals("M")) {
                length = 1;
                next_type = null;
            } else {
                next_type = null;
                System.out.println("Could not parse " + this.getCigar() + " did not get match at end");
                break;
            }
            if (type.equals("M")) {
                q_seq = this.appendAlignment(q_alignment, q_seq, length / q_units, q_units);
                h_seq = this.appendAlignment(h_alignment, h_seq, length / h_units, h_units);
            } else if (type.equals("D")) {
                this.padAlignment(q_alignment, length);
                h_seq = this.appendAlignment(h_alignment, h_seq, length / h_units, h_units);
            } else if (type.equals("I")) {
                q_seq = this.appendAlignment(q_alignment, q_seq, length / q_units, q_units);
                this.padAlignment(h_alignment, length);
            }
            type = next_type;
        }
        this.setAlignment(q_alignment.toString());
        this.getHitFeature().setAlignment(h_alignment.toString());
    }

    private String appendAlignment(StringBuffer alignment, String seq, int length, int units) {
        String match = seq.substring(0, length);
        if (units == 1) {
            alignment.append(match);
        } else {
            for (int i = 0; i < match.length(); ++i) {
                alignment.append(match.charAt(i) + "  ");
            }
        }
        return seq.substring(length);
    }

    private void padAlignment(StringBuffer alignment, int length) {
        for (int i = 0; i < length; ++i) {
            alignment.append('-');
        }
    }

    public boolean hasAlignable() {
        if (this.hasRealAlignment()) {
            return true;
        }
        return super.hasAlignable();
    }

    private boolean hasRealAlignment() {
        return this.getAlignment() != null && this.getHitFeature().getAlignment() != null;
    }
}

