/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel;

import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import java.io.Serializable;
import java.util.Hashtable;

public class EvidenceFinder
implements Serializable {
    private FeatureSetI fset;
    private Hashtable nameHash;

    public EvidenceFinder(FeatureSetI fset) {
        this.setFeatureSet(fset);
    }

    public void setFeatureSet(FeatureSetI fset) {
        this.fset = fset;
        this.nameHash = new Hashtable();
        this._hashSet(this.fset);
    }

    private void _hashSet(FeatureSetI subSet) {
        if (subSet != null) {
            for (int i = 0; i < subSet.size(); ++i) {
                SeqFeatureI sf = subSet.getFeatureAt(i);
                this._putName(sf);
                if (!sf.canHaveChildren()) continue;
                this._hashSet((FeatureSetI)sf);
            }
        }
    }

    private void _putName(SeqFeatureI sf) {
        if (sf.getId() != null) {
            this.nameHash.put(sf.getId(), sf);
        }
    }

    public SeqFeatureI findEvidence(String id) {
        if (id != null) {
            if (this.nameHash.containsKey(id)) {
                return (SeqFeatureI)this.nameHash.get(id);
            }
            return null;
        }
        System.out.println("Null id in findEvidence.");
        return null;
    }
}

