/*
 * Decompiled with CFR 0.152.
 */
package apollo.datamodel;

import apollo.dataadapter.NotImplementedException;
import apollo.datamodel.DbXref;
import apollo.datamodel.RangeI;
import apollo.datamodel.SequenceEdit;
import apollo.datamodel.SequenceI;
import apollo.datamodel.seq.GAMESequence;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import org.bdgp.util.DNAUtils;

public abstract class AbstractSequence
implements SequenceI {
    String name;
    String accession;
    String description;
    Vector dbxrefs = new Vector();
    String residue_type = null;
    String checksum;
    protected int length = 0;
    protected RangeI genomicRange = null;
    protected HashMap genomic_errors;
    private Date update_date;
    private String organism;
    private boolean needShiftFromOneToZeroBasedCoords = true;

    public AbstractSequence(String id) {
        this.setName(id);
        if (id == null || id.equals("")) {
            this.setName("no_name");
        }
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setDescription(String desc) {
        if (desc != null && !desc.equals("")) {
            this.description = desc;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setChecksum(String checksum) {
        if (checksum != null) {
            this.checksum = checksum;
        }
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void addDbXref(String db, String acc) {
        this.addDbXref(db, acc, 1);
    }

    public void addDbXref(String db, String acc, int isCurrent) {
        if (db != null && !db.equals("") && acc != null && !acc.equals("")) {
            DbXref dbxref = new DbXref("id", acc, db);
            dbxref.setDbName(db);
            dbxref.setIdValue(acc);
            dbxref.setCurrent(isCurrent);
            this.dbxrefs.addElement(dbxref);
        }
    }

    public void addDbXref(DbXref xref) {
        this.dbxrefs.addElement(xref);
    }

    public Vector getDbXrefs() {
        return this.dbxrefs;
    }

    public char getBaseAt(int loc) {
        return this.getResidues(loc, loc).charAt(0);
    }

    public abstract SequenceI getSubSequence(int var1, int var2);

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name != null && !name.equals("")) {
            this.name = name;
        }
    }

    public boolean hasName() {
        return this.name != "no_name";
    }

    public void setRange(RangeI loc) {
        this.genomicRange = loc;
    }

    public RangeI getRange() {
        return this.genomicRange;
    }

    protected boolean hasRange() {
        return this.genomicRange != null;
    }

    public String getAccessionNo() {
        return this.accession;
    }

    public void setAccessionNo(String acc) {
        this.accession = acc;
    }

    public void setResidues(String seqString) {
        throw new NotImplementedException("setResidues will not always be implemented");
    }

    public void clearResidues() {
        this.setResidues("");
        this.setLength(0);
    }

    public boolean hasResidues() {
        return this.getResidues() != null && !this.getResidues().equals("");
    }

    public String getResidues() {
        if (this.getRange() == null) {
            return this.getResidues(1, this.getLength());
        }
        return this.getResidues(this.getRange().getStart(), this.getRange().getEnd());
    }

    public final String getResidues(int start, int end) {
        if (start <= end) {
            start = this.pegLimits(start);
            end = this.pegLimits(end);
            if (this.needInclusiveEnd()) {
                end = this.makeEndInclusive(end);
            }
            if (this.needShiftFromOneToZeroBasedCoords()) {
                start = this.shiftFromOneToZeroBased(start);
                end = this.shiftFromOneToZeroBased(end);
            }
            return this.getResiduesImpl(start, end);
        }
        return DNAUtils.reverseComplement((String)this.getResidues(end, start));
    }

    protected boolean needInclusiveEnd() {
        return true;
    }

    private int makeEndInclusive(int nonInclusiveEnd) {
        return nonInclusiveEnd + 1;
    }

    protected void setNeedShiftFromOneToZeroBasedCoords(boolean needShift) {
        this.needShiftFromOneToZeroBasedCoords = needShift;
    }

    protected boolean needShiftFromOneToZeroBasedCoords() {
        return this.getRange() == null && this.needShiftFromOneToZeroBasedCoords;
    }

    protected int shiftFromOneToZeroBased(int coord) {
        return coord - 1;
    }

    protected int pegLimits(int value) {
        if (this.getRange() == null || this.getRange().getStart() < 0) {
            if (value < 1) {
                value = 1;
            }
            if (value > this.getLength()) {
                value = this.getLength();
            }
        } else {
            RangeI range = this.getRange();
            if (value < range.getStart()) {
                value = range.getStart();
            }
            if (value > range.getEnd()) {
                value = range.getEnd();
            }
        }
        return value;
    }

    protected abstract String getResiduesImpl(int var1, int var2);

    protected abstract String getResiduesImpl(int var1);

    public String getReverseComplement() {
        return DNAUtils.reverseComplement((String)this.getResidues());
    }

    public boolean isSequenceAvailable(long position) {
        if (this instanceof GAMESequence && !((GAMESequence)this).hasSequence()) {
            return false;
        }
        if (this.getRange() != null) {
            return position >= (long)this.getRange().getStart() && position <= (long)this.getRange().getEnd();
        }
        return position >= 1L && position <= (long)this.getLength();
    }

    public int getFrame(long base, boolean forward) {
        long genomic_start;
        int frame = -1;
        long genomic_length = this.getRange() == null ? this.getLength() : this.getRange().getEnd();
        long l = genomic_start = this.getRange() == null ? 1L : (long)this.getRange().getStart();
        if (genomic_length > 0L && base <= genomic_length && base > 0L) {
            long offset = forward ? base - genomic_start : genomic_length - base;
            frame = (int)(offset % 3L);
        }
        return frame;
    }

    public String getResidueType() {
        return this.residue_type;
    }

    public boolean hasResidueType() {
        return this.residue_type != null;
    }

    public boolean isAA() {
        return this.residue_type == "AA";
    }

    public void setResidueType(String res_type) {
        if (res_type == "DNA" || res_type == "AA" || res_type == "RNA") {
            this.residue_type = res_type;
        }
    }

    public boolean usesGenomicCoords() {
        return this.getRange() != null;
    }

    public boolean isLazy() {
        return false;
    }

    public boolean isNewerThan(Date recentDate) {
        if (this.update_date == null || recentDate == null) {
            return false;
        }
        return recentDate.compareTo(this.update_date) <= 0;
    }

    public void setDate(Date update_date) {
        this.update_date = update_date;
    }

    public boolean isSequencingErrorPosition(int base_position) {
        if (this.genomic_errors != null) {
            return this.genomic_errors.get("" + base_position) != null;
        }
        return false;
    }

    public SequenceEdit getSequencingErrorAtPosition(int base_position) {
        if (this.genomic_errors != null) {
            return (SequenceEdit)this.genomic_errors.get("" + base_position);
        }
        return null;
    }

    public HashMap getGenomicErrors() {
        return this.genomic_errors;
    }

    public boolean addSequencingErrorPosition(String operation, int pos, String residue) {
        return this.addSequenceEdit(operation, pos, residue, null);
    }

    public boolean addSequenceEdit(SequenceEdit seq_edit) {
        if (seq_edit != null) {
            return this.addSequenceEdit(seq_edit.getEditType(), seq_edit.getPosition(), seq_edit.getResidue(), seq_edit);
        }
        return false;
    }

    private boolean addSequenceEdit(String operation, int pos, String residue, SequenceEdit seq_edit) {
        boolean edited = false;
        if (operation.equals("nucleotide_insertion") || operation.equals("nucleotide_deletion") || operation.equals("substitution")) {
            String key;
            if (this.genomic_errors == null) {
                this.genomic_errors = new HashMap(1);
            }
            if (!this.genomic_errors.containsKey(key = "" + pos)) {
                if (seq_edit == null) {
                    seq_edit = new SequenceEdit(operation, pos, residue);
                    seq_edit.setRefSequence(this);
                }
                this.genomic_errors.put(key, seq_edit);
                edited = true;
            }
        }
        return edited;
    }

    public boolean removeSequenceEdit(SequenceEdit seqEdit) {
        if (this.genomic_errors == null) {
            return false;
        }
        String key = seqEdit.getHashKey();
        if (!this.genomic_errors.containsKey(key)) {
            return false;
        }
        this.genomic_errors.remove(key);
        return true;
    }

    public String getOrganism() {
        return this.organism;
    }

    public void setOrganism(String organism) {
        if (organism != null && !organism.equals("")) {
            this.organism = organism;
        }
    }
}

