/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.synteny.builder;

import apollo.dataadapter.NonFatalDataAdapterException;
import apollo.dataadapter.ensj.FatalException;
import apollo.dataadapter.synteny.builder.AdapterModel;
import apollo.dataadapter.synteny.builder.Model;
import apollo.dataadapter.synteny.builder.View;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.tree.DefaultMutableTreeNode;

public class Controller {
    public static String MOUSE_LEFT_CLICK_ON_TREE = "MOUSE_LEFT_CLICK_ON_TREE";
    public static String CREATE_BUTTON = "CREATE_BUTTON";
    public static String UPDATE_BUTTON = "UPDATE_BUTTON";
    public static String DELETE_BUTTON = "DELETE_BUTTON";
    public static String CREATE_SET_BUTTON = "CREATE_SET_BUTTON";
    public static String DELETE_SET_BUTTON = "DELETE_SET_BUTTON";
    public static String DROPDOWN_SELECT_SET = "DROPDOWN_SELECT_SET";
    public static String DROPDOWN_KEY_PRESSED = "DROPDOWN_KEY_PRESSED";
    Model model;
    View view;
    List listeners = new ArrayList();
    private boolean _ignoreEvents;

    public Controller(Model model, View view) {
        this.model = model;
        this.view = view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(String eventKey) {
        block21: {
            this.setIgnoreEvents(true);
            try {
                this.getModel().updateSelectedModelFromAdapter();
                if (eventKey.equals(MOUSE_LEFT_CLICK_ON_TREE)) {
                    this.handleMouseLeftClickOnTree();
                } else if (eventKey.equals(CREATE_BUTTON)) {
                    this.handleCreateNode();
                } else if (eventKey.equals(UPDATE_BUTTON)) {
                    this.handleUpdateNode();
                } else if (eventKey.equals(DELETE_BUTTON)) {
                    this.handleDeleteNode();
                } else if (eventKey.equals(CREATE_SET_BUTTON)) {
                    this.handleCreateSet();
                } else if (eventKey.equals(DELETE_SET_BUTTON)) {
                    this.handleDeleteSet();
                } else if (eventKey.equals(DROPDOWN_SELECT_SET)) {
                    this.handleSetSelected();
                } else if (eventKey.equals(DROPDOWN_KEY_PRESSED)) {
                    this.handleDropDownKeyPress();
                }
            }
            catch (NonFatalDataAdapterException exception) {
                if (this.getView() != null) {
                    this.getModel().setMessage(exception.getMessage());
                    this.getView().read(this.getModel());
                    break block21;
                }
                throw exception;
            }
            finally {
                this.setIgnoreEvents(false);
            }
        }
    }

    public void handleSetSelected() {
        String selectedSet = this.getModel().getSelectedAdapterSet();
        if (this.getView() != null && (selectedSet = this.getView().getSelectedSetName()) != null && selectedSet.trim().length() <= 0) {
            selectedSet = null;
        }
        if (this.getModel().getAdapterSets().get(selectedSet) == null) {
            return;
        }
        this.getModel().setSelectedAdapterSet(selectedSet);
        this.getModel().createAdaptersAndGUIs(selectedSet);
        this.getModel().setReloadAll();
        this.getView().read(this.getModel());
        if (selectedSet == null) {
            this.getView().disableAdapterPanel();
        } else {
            this.getView().enableAdapterPanel();
        }
        this.notifyListeners();
    }

    public void handleDropDownKeyPress() {
    }

    public void handleCreateSet() {
        String setName = this.getView().getNewSetName();
        if (this.getModel().getAdapterSets().get(setName) != null) {
            throw new NonFatalDataAdapterException("An adapter set with this name already exists");
        }
        this.getModel().addAdapterSet(setName);
        this.getModel().setSelectedAdapterSet(setName);
        this.getModel().toXML();
        this.setModel(Model.fromXML());
        this.getModel().createAdaptersAndGUIs(setName);
        this.getModel().setReloadAll();
        this.getView().read(this.getModel());
        this.getView().enableAdapterPanel();
        this.notifyListeners();
    }

    public void handleDeleteSet() {
        String set = this.getModel().getSelectedAdapterSet();
        this.getModel().getAdapterSets().remove(set);
        this.getModel().setSelectedAdapterSet(null);
        this.getModel().setSelectedAdapterName(null, null);
        this.getModel().toXML();
        this.setModel(Model.fromXML());
        this.getModel().setReloadAll();
        this.getView().disableAdapterPanel();
        this.getView().read(this.getModel());
        this.notifyListeners();
    }

    public void handleCreateNode() {
        AdapterModel selectedModel = this.getModel().getSelectedAdapterModel();
        String set = this.getModel().getSelectedAdapterSet();
        int selectedAdapterIndex = this.getModel().getSelectedAdapterIndex(set);
        AdapterModel newModel = this.getView().getNewAdapterModel(this.getModel());
        this.validateAdapterModel(newModel);
        this.getModel().getAdapterModels(set).add(selectedAdapterIndex + 1, newModel);
        this.getModel().toXML();
        this.setModel(Model.fromXML());
        String setName = this.getModel().getSelectedAdapterSet();
        if (setName == null) {
            throw new FatalException("Programming error: node updated without a selected set!");
        }
        this.getModel().createAdaptersAndGUIs(setName);
        this.getModel().setSelectedAdapterName(set, newModel.getName());
        this.getModel().setReloadAll();
        this.getView().read(this.getModel());
        this.notifyListeners();
    }

    public void handleUpdateNode() {
        this.getView().update(this.getModel());
        AdapterModel selectedModel = this.getModel().getSelectedAdapterModel();
        try {
            this.validateAdapterModel(selectedModel);
        }
        catch (NonFatalDataAdapterException exception) {
            this.setModel(Model.fromXML());
            this.getModel().setReloadAll();
            this.getView().read(this.getModel());
            this.notifyListeners();
            throw exception;
        }
        this.getModel().toXML();
        this.setModel(Model.fromXML());
        String setName = this.getModel().getSelectedAdapterSet();
        if (setName == null) {
            throw new FatalException("Programming error: node updated without a selected set!");
        }
        this.getModel().createAdaptersAndGUIs(setName);
        this.getModel().setReloadAll();
        this.getView().read(this.getModel());
        this.notifyListeners();
    }

    public void handleDeleteNode() {
        this.getModel().setReloadAll();
        String set = this.getModel().getSelectedAdapterSet();
        if (this.getModel().getSelectedAdapterModel().getType().equals(AdapterModel.MAIN_TYPE) && this.getModel().getAdapterModels(set).size() > 1) {
            throw new NonFatalDataAdapterException("Cant remove main adapter - it still has child adapters");
        }
        this.getModel().getAdapterModels(set).remove(this.getModel().getSelectedAdapterModel());
        this.getModel().toXML();
        this.setModel(Model.fromXML());
        String setName = this.getModel().getSelectedAdapterSet();
        if (setName == null) {
            throw new FatalException("Programming error: node updated without a selected set!");
        }
        this.getModel().createAdaptersAndGUIs(setName);
        this.getModel().setReloadAll();
        this.getView().read(this.getModel());
        this.notifyListeners();
    }

    public void handleMouseLeftClickOnTree() {
        DefaultMutableTreeNode node = this.view.getSelectedNode();
        String selectedNodeKey = null;
        String set = this.getModel().getSelectedAdapterSet();
        if (node != null) {
            selectedNodeKey = (String)node.getUserObject();
            this.getModel().setSelectedAdapterName(set, selectedNodeKey);
            this.getModel().setReloadTree(false);
            this.getModel().setReloadGUIs(false);
            this.getView().read(this.getModel());
        }
    }

    private void setModel(Model model) {
        this.model = model;
    }

    public Model getModel() {
        return this.model;
    }

    public View getView() {
        return this.view;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Test");
        View view = new View();
        Model model = Model.fromXML();
        Controller controller = new Controller(model, view);
        view.setController(controller);
        view.initialiseGUI();
        frame.getContentPane().add((Component)view, "Center");
        frame.pack();
        frame.show();
        view.read(model);
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    public void clearActionListeners() {
        this.listeners.clear();
    }

    private List getListenerList() {
        return this.listeners;
    }

    private void notifyListeners() {
        for (int i = 0; i < this.getListenerList().size(); ++i) {
            ((ActionListener)this.getListenerList().get(i)).actionPerformed(new ActionEvent(this, 0, "Model reread"));
        }
    }

    private void validateAdapterModel(AdapterModel model) {
        int i;
        AdapterModel mainModel = null;
        String set = this.getModel().getSelectedAdapterSet();
        if (model.getName() == null || model.getName().trim().length() <= 0) {
            throw new NonFatalDataAdapterException("New node must have a non-empty name");
        }
        for (i = 0; i < this.getModel().getAdapterModels(set).size(); ++i) {
            if (model.equals(this.getModel().getAdapterModels(set).get(i)) || !model.getName().equals(((AdapterModel)this.getModel().getAdapterModels(set).get(i)).getName())) continue;
            throw new NonFatalDataAdapterException("New node must have a unique name");
        }
        for (i = 0; i < this.getModel().getAdapterModels(set).size(); ++i) {
            if (!((AdapterModel)this.getModel().getAdapterModels(set).get(i)).getType().equals(AdapterModel.MAIN_TYPE)) continue;
            mainModel = (AdapterModel)this.getModel().getAdapterModels(set).get(i);
        }
        if (mainModel == null && !model.getType().equals(AdapterModel.MAIN_TYPE)) {
            throw new NonFatalDataAdapterException("Programming error: The system must create one (and only one) 'MAIN_TYPE' adapter in the set");
        }
        if (model.getType().equals(AdapterModel.MAIN_TYPE) && mainModel != null && !model.equals(mainModel)) {
            throw new NonFatalDataAdapterException("Programming error: New node cannot have 'MAIN' type, as there is already a 'MAIN' adapter");
        }
    }

    public void setIgnoreEvents(boolean value) {
        this._ignoreEvents = value;
    }

    public boolean ignoreEvents() {
        return this._ignoreEvents;
    }
}

