/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.synteny.builder;

import apollo.dataadapter.AbstractApolloAdapter;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterGUI;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.NonFatalDataAdapterException;
import apollo.dataadapter.synteny.builder.AdapterModel;
import apollo.dataadapter.synteny.builder.BuilderAdapter;
import apollo.dataadapter.synteny.builder.Controller;
import apollo.dataadapter.synteny.builder.Model;
import apollo.dataadapter.synteny.builder.View;
import apollo.datamodel.CurationSet;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.bdgp.io.DataAdapter;
import org.bdgp.io.DataAdapterException;
import org.bdgp.io.IOOperation;
import org.bdgp.swing.AbstractDataAdapterUI;
import org.bdgp.util.MultiProperties;

public class BuilderAdapterGUI
extends AbstractDataAdapterUI
implements ApolloDataAdapterGUI {
    private Properties properties;
    private IOOperation operation;
    private Controller controller;
    private View view;

    public BuilderAdapterGUI(IOOperation operation, Model model) {
        this.operation = operation;
        this.view = new View();
        this.controller = new Controller(model, this.view);
        this.view.setController(this.controller);
        this.view.initialiseGUI();
        this.getController().addActionListener(new ModelChangeListener());
        this.buildGUI();
        String set = model.getSelectedAdapterSet();
        if (set != null) {
            model.createAdaptersAndGUIs(set);
        }
        this.view.read(model);
    }

    public void resetChildProperties() {
        this.setChildProperties();
    }

    public void setChildProperties() {
        Model model = this.getController().getModel();
        Iterator guiKeys = model.getAdapterGUIMap().keySet().iterator();
        HashMap guis = model.getAdapterGUIMap();
        String selectedAdapterSet = model.getSelectedAdapterSet();
        while (guiKeys.hasNext()) {
            String key = (String)guiKeys.next();
            Properties propertiesFromModel = model.getModelWithName(selectedAdapterSet, key).getProperties();
            ((AbstractDataAdapterUI)guis.get(key)).setProperties(propertiesFromModel);
        }
    }

    public void getChildProperties() {
        Model model = this.getController().getModel();
        Iterator guiKeys = model.getAdapterGUIMap().keySet().iterator();
        HashMap guis = model.getAdapterGUIMap();
        String selectedAdapterSet = model.getSelectedAdapterSet();
        while (guiKeys.hasNext()) {
            String key = (String)guiKeys.next();
            Properties propertiesFromAdapterGUI = ((AbstractDataAdapterUI)model.getAdapterGUIMap().get(key)).getProperties();
            model.getModelWithName(selectedAdapterSet, key).setProperties(propertiesFromAdapterGUI);
            model.toXML();
        }
    }

    public Properties createStateInformation() throws ApolloAdapterException {
        String selectedAdapterSet = this.getController().getModel().getSelectedAdapterSet();
        Iterator adapterKeys = this.getController().getModel().getAdapterModels(selectedAdapterSet).iterator();
        MultiProperties compositeProperties = new MultiProperties();
        String mainAdapterKey = this.getController().getModel().getMainAdapterModel(selectedAdapterSet).getName();
        while (adapterKeys.hasNext()) {
            String region;
            String adapterKey = ((AdapterModel)adapterKeys.next()).getName();
            System.out.println("Child adapter key: " + adapterKey);
            ApolloDataAdapterGUI adapterGUI = (ApolloDataAdapterGUI)this.getController().getModel().getAdapterGUIMap().get(adapterKey);
            System.out.println("Child adapter gui class: " + adapterGUI.getClass().getName());
            Properties stateInformation = adapterGUI.createStateInformation();
            System.out.println("Child adapter state info: " + stateInformation);
            compositeProperties.setProperties(adapterKey, stateInformation);
            if (!adapterKey.equals(mainAdapterKey) || (region = stateInformation.getProperty("region")) == null) continue;
            compositeProperties.setProperty("region", region);
        }
        return compositeProperties;
    }

    public Controller getController() {
        return this.controller;
    }

    public View getView() {
        return this.view;
    }

    private void buildGUI() {
        this.setLayout(new BorderLayout());
        this.add(this.getView(), "Center");
    }

    public Object doOperation(Object values) throws DataAdapterException {
        Object curationSet = null;
        BuilderAdapter adapter = (BuilderAdapter)this.getDataAdapter();
        CurationSet returnSet = new CurationSet();
        HashMap adapterMap = this.getController().getModel().getAdapterMap();
        try {
            if (this.getOperation().equals((Object)ApolloDataAdapterI.OP_READ_DATA)) {
                MultiProperties compositeProperties = (MultiProperties)this.createStateInformation();
                ((AbstractApolloAdapter)this.getDataAdapter()).clearStateInformation();
                ((AbstractApolloAdapter)this.getDataAdapter()).setStateInformation((Properties)compositeProperties);
                returnSet = ((AbstractApolloAdapter)this.getDataAdapter()).getCurationSet();
                return returnSet;
            }
            throw new ApolloAdapterException("This adapter cannot be used to write data");
        }
        catch (NonFatalDataAdapterException exception) {
            throw new ApolloAdapterException(exception.getMessage());
        }
    }

    public void setProperties(Properties input) {
        this.properties = input;
        this.setChildProperties();
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        this.getChildProperties();
        return properties;
    }

    public DataAdapter getDataAdapter() {
        return this.driver;
    }

    private IOOperation getOperation() {
        return this.operation;
    }

    public class ModelChangeListener
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            System.err.println("Model changed - adapter gui isn't doing anything!");
        }
    }
}

