/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.synteny.builder;

import java.util.Iterator;
import java.util.Properties;

public class AdapterModel {
    private String type;
    private String name;
    private String adapterClassName;
    private Properties properties;
    public static String MAIN_TYPE = "MAIN_TYPE";
    public static String CHILD_TYPE = "CHILD_TYPE";

    public AdapterModel(String name, String adapterClass, String type) {
        this.name = name;
        this.adapterClassName = adapterClass;
        this.type = type;
        this.properties = new Properties();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newValue) {
        this.name = newValue;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAdapterClassName() {
        return this.adapterClassName;
    }

    public void setAdapterClassName(String newValue) {
        this.adapterClassName = newValue;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties newValue) {
        this.properties = newValue;
    }

    public void addProperty(String key, String value) {
        this.getProperties().setProperty(key, value);
    }

    public String getProperty(String key) {
        return this.getProperties().getProperty(key);
    }

    public String toXML(String indent) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(indent).append("<adapter>\n").append(indent).append("\t<name>").append(this.getName()).append("</name>\n").append(indent).append("\t<class>").append(this.getAdapterClassName()).append("</class>\n").append(indent).append("\t<type>").append(this.getType()).append("</type>\n");
        if (this.getProperties().size() > 0) {
            Iterator<Object> keys = this.getProperties().keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                buffer.append(indent).append("\t<property>\n").append(indent).append("\t\t<key>").append(key).append("</key>\n").append(indent).append("\t\t<value>").append(this.getProperty(key)).append("</value>\n").append(indent).append("\t</property>\n");
            }
        }
        buffer.append(indent).append("</adapter>\n");
        return buffer.toString();
    }
}

