/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.synteny;

import apollo.config.Config;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.KaryotypeAdapter;
import apollo.dataadapter.KaryotypeAdapterI;
import apollo.dataadapter.NonFatalDataAdapterException;
import apollo.dataadapter.SyntenyAdapter;
import apollo.dataadapter.SyntenyAdapterI;
import apollo.dataadapter.ensj.EnsJAdapterGUI;
import apollo.dataadapter.ensj.model.LocationModel;
import apollo.dataadapter.ensj19.CompositeDataSourceConfigurationPanel;
import apollo.dataadapter.synteny.FullEnsJDBCSyntenyPanel;
import apollo.dataadapter.synteny.SyntenyAdapterGUI;
import apollo.datamodel.Chromosome;
import apollo.datamodel.ChromosomeBand;
import apollo.datamodel.Karyotype;
import apollo.datamodel.SyntenyRegion;
import apollo.util.GuiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.bdgp.io.DataAdapter;
import org.bdgp.io.IOOperation;
import org.bdgp.swing.AbstractDataAdapterUI;
import org.ensembl.compara.driver.ComparaDriver;
import org.ensembl.compara.driver.ComparaDriverFactory;
import org.ensembl.compara.driver.MemberAdaptor;
import org.ensembl.datamodel.FeaturePair;
import org.ensembl.datamodel.KaryotypeBand;
import org.ensembl.datamodel.Location;
import org.ensembl.driver.AdaptorException;
import org.ensembl.driver.ConfigurationException;
import org.ensembl.driver.CoordinateSystemAdaptor;
import org.ensembl.driver.CoreDriver;
import org.ensembl.driver.DriverManager;
import org.ensembl.driver.KaryotypeBandAdaptor;

public class SyntenyComparaAdapterGUI
extends AbstractDataAdapterUI {
    private String querySpecies;
    private String hitSpecies;
    private String logicalQuerySpecies;
    private String logicalHitSpecies;
    private JDialog frame;
    private JButton fullPanelButton;
    private SyntenyAdapterGUI parent;
    private DataAdapter adapter;
    private FullEnsJDBCSyntenyPanel thePanel;
    private CompositeDataSourceConfigurationPanel dataConfigChooser;
    private JPanel dataSourceConfigurationPanel;
    private JButton showDataSourceConfiguration;
    private JCheckBox addHighConservationDnaAligns = new JCheckBox("Highly Conserved Dna-Dna Aligns");
    private JCheckBox addDnaAligns = new JCheckBox("Dna-Dna Aligns");
    private JCheckBox addProteinAligns = new JCheckBox("Protein-Protein Aligns");
    private JCheckBox addDnaAlignsToSingleSpeciesPanes = new JCheckBox("Add Dna Aligns To Each Species' Results");
    static /* synthetic */ Class class$javax$swing$JDialog;

    public SyntenyComparaAdapterGUI(IOOperation op) {
        this.buildGUI();
    }

    private KaryotypeAdapterI createKaryotypeAdapter() {
        KaryotypeAdapter adapter = new KaryotypeAdapter();
        try {
            adapter.setName("karyotype adapter");
            adapter.setType("karyotype adapter");
            EnsJAdapterGUI querySpeciesAdapter = (EnsJAdapterGUI)this.getParentAdapter().getAdapterGUIs().get(this.getQuerySpecies());
            Properties querySpeciesProperties = querySpeciesAdapter.getProperties();
            this.validateDatabaseInfoSpecified(this.getQuerySpecies(), querySpeciesProperties);
            EnsJAdapterGUI hitSpeciesAdapter = (EnsJAdapterGUI)this.getParentAdapter().getAdapterGUIs().get(this.getHitSpecies());
            Properties hitSpeciesProperties = hitSpeciesAdapter.getProperties();
            this.validateDatabaseInfoSpecified(this.getHitSpecies(), hitSpeciesProperties);
            CoreDriver speciesDriver = DriverManager.load((Properties)querySpeciesProperties);
            adapter.addKaryotype(new Karyotype(this.querySpecies, this.fetchAllApolloChromosomesWithDriver(speciesDriver)));
            speciesDriver = DriverManager.load((Properties)hitSpeciesProperties);
            adapter.addKaryotype(new Karyotype(this.hitSpecies, this.fetchAllApolloChromosomesWithDriver(speciesDriver)));
        }
        catch (AdaptorException exception) {
            throw new NonFatalDataAdapterException(exception.getMessage());
        }
        return adapter;
    }

    private Vector fetchAllApolloChromosomesWithDriver(CoreDriver speciesDriver) throws AdaptorException {
        KaryotypeBandAdaptor bandAdaptor = speciesDriver.getKaryotypeBandAdaptor();
        CoordinateSystemAdaptor coordSystemAdaptor = speciesDriver.getCoordinateSystemAdaptor();
        Vector<Chromosome> apolloChromosomes = new Vector<Chromosome>();
        Vector<ChromosomeBand> apolloChromosomeBands = new Vector<ChromosomeBand>();
        Iterator chromosomes = coordSystemAdaptor.fetchTopLevelLocations().iterator();
        while (chromosomes.hasNext()) {
            Location ensjChromoLoc = (Location)chromosomes.next();
            if (ensjChromoLoc.getCoordinateSystem().getName().indexOf("chromosome") == -1 || ensjChromoLoc.getSeqRegionName().indexOf("_NT") != -1) continue;
            try {
                Iterator bands = bandAdaptor.fetch(ensjChromoLoc.getCoordinateSystem(), ensjChromoLoc.getSeqRegionName()).iterator();
                while (bands.hasNext()) {
                    KaryotypeBand ensjChromosomeBand = (KaryotypeBand)bands.next();
                    ChromosomeBand apolloChromosomeBand = new ChromosomeBand(ensjChromosomeBand.getBand(), ensjChromosomeBand.getLocation().getSeqRegionName(), ensjChromosomeBand.getLocation().getStart(), ensjChromosomeBand.getLocation().getEnd(), ensjChromosomeBand.getStain());
                    apolloChromosomeBands.add(apolloChromosomeBand);
                }
            }
            catch (Exception e) {
                System.err.println("Caught exception fetching bands - ignoring as it probably means theres no karyotype data");
                bandAdaptor = null;
            }
            Chromosome apolloChromosome = new Chromosome(this.querySpecies, ensjChromoLoc.getSeqRegionName(), apolloChromosomeBands);
            apolloChromosome.setLength(new Long(ensjChromoLoc.getEnd()).intValue());
            apolloChromosome.setCoordSystem(ensjChromoLoc.getCoordinateSystem().getVersion() + "--" + ensjChromoLoc.getCoordinateSystem().getName());
            apolloChromosome.setPLength(0);
            apolloChromosome.setQLength(apolloChromosome.getLength());
            apolloChromosome.setCentroLength(0);
            apolloChromosomes.add(apolloChromosome);
        }
        return apolloChromosomes;
    }

    private SyntenyAdapterI createSyntenyAdapter(KaryotypeAdapterI karyotypeAdapter) {
        Properties comparaProps = this.getDataConfigChooser().getChooser("compara").getProperties();
        SyntenyAdapter syntenyAdapter = new SyntenyAdapter();
        Karyotype queryKaryotype = karyotypeAdapter.getKaryotypeBySpeciesName(this.getQuerySpecies());
        syntenyAdapter.setName("synteny adapter");
        syntenyAdapter.setType("synteny adapter");
        syntenyAdapter.setKaryotypeAdapter(karyotypeAdapter);
        try {
            ComparaDriver comparaDriver = ComparaDriverFactory.createComparaDriver((Properties)comparaProps);
            MemberAdaptor memberAdaptor = (MemberAdaptor)comparaDriver.getAdaptor("member");
            Iterator chromosomesForQuerySpecies = karyotypeAdapter.getKaryotypeBySpeciesName(this.getQuerySpecies()).getChromosomes().iterator();
            while (chromosomesForQuerySpecies.hasNext()) {
                Chromosome queryChromosome = (Chromosome)chromosomesForQuerySpecies.next();
                List fps = memberAdaptor.fetch(this.convertLogicalNameToSpeciesName(this.querySpecies), this.convertLogicalNameToSpeciesName(this.hitSpecies), queryChromosome.getDisplayId());
                Iterator ensjFeaturePairs = fps.iterator();
                while (ensjFeaturePairs.hasNext()) {
                    FeaturePair ensjFeaturePair = (FeaturePair)ensjFeaturePairs.next();
                    Location queryLocation = ensjFeaturePair.getLocation();
                    Location hitLocation = ensjFeaturePair.getHitLocation();
                    Karyotype hitKaryotype = karyotypeAdapter.getKaryotypeBySpeciesName(this.getHitSpecies());
                    SyntenyRegion apolloSyntenyRegion = new SyntenyRegion(queryChromosome, queryLocation.getStart(), queryLocation.getEnd(), hitKaryotype.getChromosomeByName(hitLocation.getSeqRegionName()), hitLocation.getStart(), hitLocation.getEnd(), hitLocation.getStrand());
                    syntenyAdapter.addSyntenyRegionForChromosome(queryChromosome.getDisplayId(), apolloSyntenyRegion);
                }
            }
        }
        catch (ConfigurationException exception) {
            throw new NonFatalDataAdapterException(exception.getMessage());
        }
        catch (AdaptorException exception) {
            throw new NonFatalDataAdapterException(exception.getMessage());
        }
        return syntenyAdapter;
    }

    protected void buildGUI() {
        this.setLayout(new GridBagLayout());
        this.fullPanelButton = new JButton("View Full Synteny Panel");
        JLabel explainLabel = new JLabel("...shows synteny blocks between species, when available");
        FullPanelListener fullPanelListener = new FullPanelListener();
        this.fullPanelButton.addActionListener(fullPanelListener);
        this.add(this.getAddHighConservationDnaAligns(), GuiUtil.makeConstraintAt(0, 0, 1));
        this.add(this.getAddDnaAligns(), GuiUtil.makeConstraintAt(0, 1, 1));
        this.add(this.getAddProteinAligns(), GuiUtil.makeConstraintAt(0, 2, 1));
        this.add(this.getDnaAlignsIntoSingleSpecies(), GuiUtil.makeConstraintAt(0, 3, 1));
        this.add(this.fullPanelButton, GuiUtil.makeConstraintAt(0, 4, 1));
        this.add(explainLabel, GuiUtil.makeConstraintAt(1, 4, 1));
        this.buildDataSourceConfigurationPanel();
        this.add(this.getDataSourceConfigurationPanel(), GuiUtil.makeConstraintAt(0, 5, 2));
    }

    public Properties createStateInformation() throws ApolloAdapterException {
        Properties stateInfo = new Properties();
        String apolloRoot = System.getProperty("APOLLO_ROOT");
        File logFile = new File(apolloRoot + "/conf/logging_info_level.conf");
        if (!logFile.exists()) {
            throw new ApolloAdapterException("The following file must be provided to support ensj - conf/logging_info_level.conf");
        }
        stateInfo.put("loggingFile", apolloRoot + "/conf/logging_info_level.conf");
        stateInfo.setProperty("querySpecies", this.getQuerySpecies());
        stateInfo.setProperty("hitSpecies", this.getHitSpecies());
        EnsJAdapterGUI querySpeciesAdapter = (EnsJAdapterGUI)this.getParentAdapter().getAdapterGUIs().get(this.getQuerySpecies());
        EnsJAdapterGUI hitSpeciesAdapter = (EnsJAdapterGUI)this.getParentAdapter().getAdapterGUIs().get(this.getHitSpecies());
        LocationModel querySpeciesLocation = querySpeciesAdapter.getModel().getLocationModel();
        LocationModel hitSpeciesLocation = hitSpeciesAdapter.getModel().getLocationModel();
        if (this.hasRangeInformation(querySpeciesLocation)) {
            stateInfo.put("chromosome", querySpeciesLocation.getSelectedSeqRegion());
            stateInfo.put("coordsystem", querySpeciesLocation.getSelectedCoordSystem());
            stateInfo.put("start", querySpeciesLocation.getStart());
            stateInfo.put("end", querySpeciesLocation.getEnd());
        }
        if (this.hasRangeInformation(hitSpeciesLocation)) {
            stateInfo.setProperty("hitChr", hitSpeciesLocation.getSelectedSeqRegion());
            stateInfo.put("hitCoordSys", hitSpeciesLocation.getSelectedCoordSystem());
            stateInfo.setProperty("hitStart", hitSpeciesLocation.getStart());
            stateInfo.setProperty("hitEnd", hitSpeciesLocation.getEnd());
        }
        if (querySpeciesLocation.isStableIDLocation()) {
            stateInfo.setProperty("stableId", querySpeciesLocation.getStableID());
        }
        if (hitSpeciesLocation.isStableIDLocation()) {
            stateInfo.setProperty("hitStableId", hitSpeciesLocation.getStableID());
        }
        stateInfo.putAll((Map<?, ?>)this.getDataConfigChooser().getChooser("compara").getProperties());
        stateInfo.put("highConservationDnaAligns", String.valueOf(this.getAddHighConservationDnaAligns().isSelected()));
        stateInfo.put("dnaAligns", String.valueOf(this.getAddDnaAligns().isSelected()));
        stateInfo.put("proteinAligns", String.valueOf(this.getAddProteinAligns().isSelected()));
        stateInfo.put("dnaAlignsIntoSingleSpecies", String.valueOf(this.getDnaAlignsIntoSingleSpecies().isSelected()));
        this.validateDatabaseInfoSpecified("compara", stateInfo);
        return stateInfo;
    }

    private void validateDatabaseInfoSpecified(String speciesName, Properties properties) {
        String host = properties.getProperty("host");
        String port = properties.getProperty("port");
        String database = properties.getProperty("database");
        if (host == null || host.trim().length() <= 0) {
            throw new NonFatalDataAdapterException(speciesName + " database host name must be provided");
        }
        if (port == null || port.trim().length() <= 0) {
            throw new NonFatalDataAdapterException(speciesName + " database port  must be provided");
        }
        if (database == null || database.trim().length() <= 0) {
            throw new NonFatalDataAdapterException(speciesName + " database name must be provided");
        }
    }

    private void addPropertiesWithPrefix(Properties properties, String prefix, Properties additionalProperties) {
        Iterator<Object> keys = properties.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = additionalProperties.getProperty(key);
            key = prefix + "." + key;
            properties.put(key, value);
        }
    }

    public void setInput(Object input) {
        if (input instanceof HashMap) {
            HashMap theInput = (HashMap)input;
            this.frame.dispose();
        } else if (input instanceof AbstractDataAdapterUI) {
            this.setParentAdapter((SyntenyAdapterGUI)((Object)input));
            this.getParentAdapter().getSharedData().put(this.getQuerySpecies() + "-" + this.getHitSpecies(), this);
        }
    }

    public void setProperties(Properties properties) {
        this.querySpecies = properties.getProperty("querySpecies");
        this.hitSpecies = properties.getProperty("hitSpecies");
        if (properties.getProperty("jdbc_driver") == null || properties.getProperty("jdbc_driver").trim().length() <= 0) {
            properties.setProperty("jdbc_driver", "org.gjt.mm.mysql.Driver");
        }
        if (properties.getProperty("host") == null || properties.getProperty("host").trim().length() <= 0) {
            properties.setProperty("host", "kaka.sanger.ac.uk");
        }
        if (properties.getProperty("port") == null || properties.getProperty("port").trim().length() <= 0) {
            properties.setProperty("port", "3306");
        }
        if (properties.getProperty("user") == null || properties.getProperty("user").trim().length() <= 0) {
            properties.setProperty("user", "anonymous");
        }
        if (properties.getProperty("ensembl_driver") == null || properties.getProperty("ensembl_driver").trim().length() <= 0) {
            properties.setProperty("ensembl_driver", "org.ensembl19.driver.plugin.compara.ComparaMySQLDriver");
        }
        if (properties.getProperty("database") == null || properties.getProperty("database").trim().length() <= 0) {
            properties.setProperty("database", "ensembl_compara_9_1");
        }
        this.getDataConfigChooser().setProperties(properties);
        this.getDataConfigChooser().populateEnsemblDatabases();
        String db = properties.getProperty("database");
        this.getDataConfigChooser().getChooser("compara").setSelectedEnsemblDatabase(properties.getProperty("database"));
        this.getDataSourceConfigurationPanel().add((Component)this.dataConfigChooser, GuiUtil.makeConstraintAt(0, 1, 1));
        String booleanString = properties.getProperty("proteinAligns");
        if (booleanString == null || booleanString.trim().length() <= 0) {
            this.getAddProteinAligns().setSelected(true);
        } else {
            this.getAddProteinAligns().setSelected(Boolean.valueOf(booleanString));
        }
        booleanString = properties.getProperty("dnaAligns");
        if (booleanString == null || booleanString.trim().length() <= 0) {
            this.getAddDnaAligns().setSelected(true);
        } else {
            this.getAddDnaAligns().setSelected(Boolean.valueOf(booleanString));
        }
        booleanString = properties.getProperty("highConservationDnaAligns");
        if (booleanString == null || booleanString.trim().length() <= 0) {
            this.getAddHighConservationDnaAligns().setSelected(true);
        } else {
            this.getAddHighConservationDnaAligns().setSelected(Boolean.valueOf(booleanString));
        }
        booleanString = properties.getProperty("dnaAlignsIntoSingleSpecies");
        if (booleanString == null || booleanString.trim().length() <= 0) {
            this.getDnaAlignsIntoSingleSpecies().setSelected(true);
        } else {
            this.getDnaAlignsIntoSingleSpecies().setSelected(Boolean.valueOf(booleanString));
        }
    }

    private String getQuerySpecies() {
        return this.querySpecies;
    }

    private String getHitSpecies() {
        return this.hitSpecies;
    }

    private SyntenyAdapterGUI getParentAdapter() {
        return this.parent;
    }

    private void setParentAdapter(SyntenyAdapterGUI newValue) {
        this.parent = newValue;
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        Properties tempProperties = this.getDataConfigChooser().getPrefixedProperties();
        properties.putAll((Map<?, ?>)tempProperties);
        properties.put("proteinAligns", String.valueOf(new Boolean(this.getAddProteinAligns().isSelected())));
        properties.put("dnaAligns", String.valueOf(new Boolean(this.getAddDnaAligns().isSelected())));
        properties.put("highConservationDnaAligns", String.valueOf(new Boolean(this.getAddHighConservationDnaAligns().isSelected())));
        properties.put("dnaAlignsIntoSingleSpecies", String.valueOf(new Boolean(this.getDnaAlignsIntoSingleSpecies().isSelected())));
        return properties;
    }

    private String convertLogicalNameToSpeciesName(String logicalName) {
        HashMap speciesNames = Config.getStyle("apollo.dataadapter.synteny.SyntenyAdapter").getSyntenySpeciesNames();
        Iterator logicalNames = speciesNames.keySet().iterator();
        String shortName = null;
        while (logicalNames.hasNext()) {
            int index;
            String longName = (String)logicalNames.next();
            shortName = longName.substring((index = longName.indexOf(".")) + 1);
            if (!shortName.equals(logicalName)) continue;
            return (String)speciesNames.get(longName);
        }
        throw new NonFatalDataAdapterException("No logical species name matches the name input:" + shortName);
    }

    private JPanel buildDataSourceConfigurationPanel() {
        this.dataSourceConfigurationPanel = new JPanel();
        this.dataSourceConfigurationPanel.setLayout(new GridBagLayout());
        this.dataSourceConfigurationPanel.setBorder(BorderFactory.createTitledBorder("Data Sources"));
        this.showDataSourceConfiguration = new JButton("Show Data Source Configuration");
        this.showDataSourceConfiguration.addActionListener(new ShowDataSourceConfigurationActionListener());
        this.dataSourceConfigurationPanel.add((Component)this.getShowDataSourceConfigurationButton(), GuiUtil.makeConstraintAt(0, 0, 1));
        this.dataConfigChooser = new CompositeDataSourceConfigurationPanel(new String[]{"compara"});
        this.dataConfigChooser.setVisible(false);
        this.dataSourceConfigurationPanel.add((Component)this.dataConfigChooser, GuiUtil.makeConstraintAt(0, 1, 1));
        return this.dataSourceConfigurationPanel;
    }

    private CompositeDataSourceConfigurationPanel getDataConfigChooser() {
        return this.dataConfigChooser;
    }

    private JPanel getDataSourceConfigurationPanel() {
        return this.dataSourceConfigurationPanel;
    }

    private JButton getShowDataSourceConfigurationButton() {
        return this.showDataSourceConfiguration;
    }

    public Object doOperation(Object values) throws ApolloAdapterException {
        try {
            Properties stateInformation = this.createStateInformation();
            ((ApolloDataAdapterI)this.getDataAdapter()).setStateInformation(stateInformation);
            return ((ApolloDataAdapterI)this.getDataAdapter()).getCurationSet();
        }
        catch (NonFatalDataAdapterException exception) {
            throw new ApolloAdapterException("Problem loading data:" + exception.getMessage(), exception);
        }
    }

    public void setDataAdapter(DataAdapter adapter) {
        this.adapter = adapter;
    }

    public DataAdapter getDataAdapter() {
        return this.adapter;
    }

    private JCheckBox getAddDnaAligns() {
        return this.addDnaAligns;
    }

    private JCheckBox getAddHighConservationDnaAligns() {
        return this.addHighConservationDnaAligns;
    }

    private JCheckBox getAddProteinAligns() {
        return this.addProteinAligns;
    }

    private JCheckBox getDnaAlignsIntoSingleSpecies() {
        return this.addDnaAlignsToSingleSpeciesPanes;
    }

    private boolean hasRangeInformation(LocationModel locationModel) {
        boolean hasLocation = false;
        if (!locationModel.isStableIDLocation()) {
            hasLocation = locationModel.getSelectedCoordSystem() != null && locationModel.getSelectedSeqRegion() != null && locationModel.getStart() != null && locationModel.getEnd() != null;
        }
        return hasLocation;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class FullPanelListener
    implements ActionListener {
        public void actionPerformed(ActionEvent theEvent) {
            try {
                KaryotypeAdapterI karyotypeAdapter = SyntenyComparaAdapterGUI.this.createKaryotypeAdapter();
                SyntenyAdapterI syntenyAdapter = SyntenyComparaAdapterGUI.this.createSyntenyAdapter(karyotypeAdapter);
                SyntenyComparaAdapterGUI.this.thePanel = new FullEnsJDBCSyntenyPanel(SyntenyComparaAdapterGUI.this.getQuerySpecies(), SyntenyComparaAdapterGUI.this.getHitSpecies(), karyotypeAdapter, syntenyAdapter, SyntenyComparaAdapterGUI.this.getParentAdapter());
                SyntenyComparaAdapterGUI.this.thePanel.init();
                SyntenyComparaAdapterGUI.this.frame = new JDialog((Frame)null, "range chooser", true);
                SyntenyComparaAdapterGUI.this.frame.setDefaultCloseOperation(2);
                SyntenyComparaAdapterGUI.this.frame.getContentPane().setLayout(new BorderLayout());
                SyntenyComparaAdapterGUI.this.frame.getContentPane().add("Center", SyntenyComparaAdapterGUI.this.thePanel);
                SyntenyComparaAdapterGUI.this.frame.setSize(700, 700);
                SyntenyComparaAdapterGUI.this.frame.show();
            }
            catch (NonFatalDataAdapterException exception) {
                JOptionPane.showMessageDialog(null, exception.getMessage());
            }
        }
    }

    public class ShowDataSourceConfigurationActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            JDialog dialog = (JDialog)SwingUtilities.getAncestorOfClass(class$javax$swing$JDialog == null ? (class$javax$swing$JDialog = SyntenyComparaAdapterGUI.class$("javax.swing.JDialog")) : class$javax$swing$JDialog, (Component)((Object)SyntenyComparaAdapterGUI.this));
            if (SyntenyComparaAdapterGUI.this.getShowDataSourceConfigurationButton().getLabel().equals("Show Data Source Configuration")) {
                SyntenyComparaAdapterGUI.this.getDataConfigChooser().setVisible(true);
                SyntenyComparaAdapterGUI.this.getShowDataSourceConfigurationButton().setLabel("Hide Data Source Configuration");
                dialog.pack();
            } else {
                SyntenyComparaAdapterGUI.this.getDataConfigChooser().setVisible(false);
                SyntenyComparaAdapterGUI.this.getShowDataSourceConfigurationButton().setLabel("Show Data Source Configuration");
                dialog.pack();
            }
        }
    }
}

