/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.synteny;

import apollo.config.Config;
import apollo.config.Style;
import apollo.dataadapter.AbstractApolloAdapter;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.ensj.EnsJAdapterGUI;
import apollo.dataadapter.ensj.model.LocationModel;
import apollo.dataadapter.synteny.FullEnsJDBCSyntenyPanel;
import apollo.dataadapter.synteny.SyntenyAdapter;
import apollo.dataadapter.synteny.SyntenyComparaAdapter;
import apollo.dataadapter.synteny.SyntenyComparaAdapterGUI;
import apollo.datamodel.CompositeDataHolder;
import apollo.datamodel.CurationSet;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.SyntenyRegion;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import org.bdgp.io.DataAdapter;
import org.bdgp.io.DataAdapterException;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;
import org.bdgp.swing.AbstractDataAdapterUI;

public class SyntenyAdapterGUI
extends AbstractDataAdapterUI {
    private Map adapterGUIs = new HashMap();
    private List adapterLabelList;
    private HashMap sharedData = new HashMap();
    protected SyntenyAdapter driver;
    protected IOOperation op;
    private Properties props;
    private JButton fullPanelButton;
    private FullEnsJDBCSyntenyPanel thePanel;
    private JTabbedPane tabbedPane;
    private static final String speciesNumberPropName = "SyntenySpeciesNumber";
    private JComboBox speciesNumberDropdownList;
    private int numberOfSpeciesToLoad = 1;

    public SyntenyAdapterGUI(IOOperation op, SyntenyAdapter adapter) {
        this.op = op;
        this.driver = adapter;
        this.setAdapterLabelList(this.buildAdapterLabelList());
        this.buildGUI();
    }

    public void setDataAdapter(DataAdapter driver) {
        Iterator names = this.getAdapter().getAdapters().keySet().iterator();
        this.driver = (SyntenyAdapter)driver;
        while (names.hasNext()) {
            String speciesName = (String)names.next();
            AbstractApolloAdapter theAdapter = (AbstractApolloAdapter)this.getAdapter().getAdapters().get(speciesName);
            DataAdapterUI theAdapterUI = (DataAdapterUI)this.getAdapterGUIs().get(speciesName);
            theAdapterUI.setDataAdapter((DataAdapter)theAdapter);
        }
    }

    public void setInput(Object input) {
        Iterator iterator = this.getAdapter().getAdapters().values().iterator();
        HashMap<String, String> nextInput = new HashMap<String, String>();
        if (!(input instanceof HashMap)) {
            return;
        }
        String logicalQuerySpecies = (String)((HashMap)input).get("logicalQuerySpecies");
        String logicalHitSpecies = (String)((HashMap)input).get("logicalHitSpecies");
        String comparaName = logicalQuerySpecies + "-" + logicalHitSpecies;
        String reverseComparaName = logicalHitSpecies + "-" + logicalQuerySpecies;
        SyntenyRegion region = (SyntenyRegion)((HashMap)input).get("region");
        if (region == null) {
            return;
        }
        Iterator adapterNames = this.getAdapter().getAdapters().keySet().iterator();
        while (adapterNames.hasNext()) {
            AbstractDataAdapterUI theUI;
            String adapterName = (String)adapterNames.next();
            if (adapterName.equals(logicalQuerySpecies)) {
                nextInput.clear();
                nextInput.put("coordsys", region.getChromosome1().getCoordSystem());
                nextInput.put("chr", region.getChromosome1().getDisplayId());
                nextInput.put("start", String.valueOf(region.getStart1()));
                nextInput.put("end", String.valueOf(region.getEnd1()));
                theUI = (AbstractDataAdapterUI)this.getAdapterGUIs().get(adapterName);
                theUI.setInput(nextInput);
                continue;
            }
            if (adapterName.equals(logicalHitSpecies)) {
                nextInput.clear();
                nextInput.put("coordsys", region.getChromosome2().getCoordSystem());
                nextInput.put("chr", region.getChromosome2().getDisplayId());
                nextInput.put("start", String.valueOf(region.getStart2()));
                nextInput.put("end", String.valueOf(region.getEnd2()));
                theUI = (AbstractDataAdapterUI)this.getAdapterGUIs().get(adapterName);
                theUI.setInput(nextInput);
                continue;
            }
            if (!adapterName.equals(comparaName) && !adapterName.equals(reverseComparaName)) continue;
            nextInput.clear();
            nextInput.put("chr", region.getChromosome1().getDisplayId());
            nextInput.put("start", String.valueOf(region.getStart1()));
            nextInput.put("end", String.valueOf(region.getEnd1()));
            nextInput.put("hitChr", region.getChromosome2().getDisplayId());
            nextInput.put("hitStart", String.valueOf(region.getStart2()));
            nextInput.put("hitEnd", String.valueOf(region.getEnd2()));
            theUI = (AbstractDataAdapterUI)this.getAdapterGUIs().get(adapterName);
            theUI.setInput(nextInput);
        }
    }

    public Properties getProperties() {
        Properties returnedProperties = new Properties();
        Properties combinedChildProperties = new Properties();
        Iterator names = this.getAdapter().getAdapters().keySet().iterator();
        if (this.addNumSpeciesDropdown()) {
            String state = this.speciesNumberDropdownList.getSelectedItem().toString();
            combinedChildProperties.put(speciesNumberPropName, state);
        }
        while (names.hasNext()) {
            String speciesName = (String)names.next();
            Properties childProperties = ((AbstractDataAdapterUI)this.getAdapterGUIs().get(speciesName)).getProperties();
            Iterator<Object> childPropertyNames = childProperties.keySet().iterator();
            while (childPropertyNames.hasNext()) {
                String childPropertyName = (String)childPropertyNames.next();
                combinedChildProperties.setProperty(speciesName + ":" + childPropertyName, childProperties.getProperty(childPropertyName));
            }
        }
        return combinedChildProperties;
    }

    public void setProperties(Properties combinedProperties) {
        Properties childProperty;
        String speciesName;
        int index;
        String numSpeciesStr;
        Iterator<Object> combinedPropertyNames = combinedProperties.keySet().iterator();
        HashMap<String, Properties> childPropertiesMap = new HashMap<String, Properties>();
        if (this.addNumSpeciesDropdown() && (numSpeciesStr = combinedProperties.getProperty(speciesNumberPropName)) != null) {
            int numSpecies = new Integer(numSpeciesStr);
            if (numSpecies > this.getConfiggedNumberOfSpecies()) {
                numSpecies = this.getConfiggedNumberOfSpecies();
            }
            if (numSpecies > 0) {
                this.speciesNumberDropdownList.setSelectedIndex(numSpecies - 1);
            }
        }
        while (combinedPropertyNames.hasNext()) {
            String combinedPropertyName = (String)combinedPropertyNames.next();
            String propertyValue = (String)combinedProperties.get(combinedPropertyName);
            index = combinedPropertyName.indexOf(":");
            if (index <= 0) continue;
            speciesName = combinedPropertyName.substring(0, index);
            String childPropertyName = combinedPropertyName.substring(index + 1);
            childProperty = (Properties)childPropertiesMap.get(speciesName);
            if (childProperty == null) {
                childProperty = new Properties();
                childPropertiesMap.put(speciesName, childProperty);
            }
            childProperty.put(childPropertyName, propertyValue);
        }
        HashMap syntenyStyleSpeciesProperties = Config.getStyle("apollo.dataadapter.synteny.SyntenyAdapter").getSyntenySpeciesProperties();
        Iterator adaptorNames = this.getAdapter().getAdapters().keySet().iterator();
        while (adaptorNames.hasNext()) {
            speciesName = (String)adaptorNames.next();
            childProperty = (Properties)childPropertiesMap.get(speciesName);
            if (childProperty == null) {
                childProperty = new Properties();
            }
            Iterator styleKeyIterator = syntenyStyleSpeciesProperties.keySet().iterator();
            while (styleKeyIterator.hasNext()) {
                String styleKey = (String)styleKeyIterator.next();
                if (styleKey.indexOf(speciesName) <= 0) continue;
                index = styleKey.lastIndexOf(".");
                childProperty.put(styleKey.substring(index + 1), syntenyStyleSpeciesProperties.get(styleKey));
            }
            ((AbstractDataAdapterUI)this.getAdapterGUIs().get(speciesName)).setProperties(childProperty);
        }
    }

    private List buildAdapterLabelList() {
        List syntenySpeciesOrder = this.getSyntenyStyle().getSyntenySpeciesAndLinkOrder();
        ArrayList<String> newList = new ArrayList<String>();
        for (int i = 0; i < syntenySpeciesOrder.size(); ++i) {
            int index = ((String)syntenySpeciesOrder.get(i)).lastIndexOf(".");
            newList.add(((String)syntenySpeciesOrder.get(i)).substring(index + 1));
        }
        return newList;
    }

    private Style getSyntenyStyle() {
        return Config.getStyle("apollo.dataadapter.synteny.SyntenyAdapter");
    }

    public Object doOperation(Object values) throws DataAdapterException {
        CompositeDataHolder compositeDataHolder;
        boolean actNaively = this.getAdapter().getStyle().getNaiveCrossSpeciesDataLoading();
        CurationSet masterCurationSet = new CurationSet();
        CurationSet childCurationSet = null;
        Iterator adapterNames = null;
        String speciesName = null;
        DataAdapterUI adapterUI = null;
        this.getAdapter().setChildAdapterStyles();
        if (this.getOperation().equals((Object)ApolloDataAdapterI.OP_WRITE_DATA)) {
            CompositeDataHolder compData = (CompositeDataHolder)values;
            for (int i = 0; i < compData.numberOfSpecies(); ++i) {
                childCurationSet = compData.getCurationSet(i);
                adapterUI = (DataAdapterUI)this.getAdapterGUIs().get(compData.getSpecies(i));
                adapterUI.doOperation((Object)childCurationSet);
            }
            return null;
        }
        if (actNaively) {
            adapterNames = this.getAdapter().getAdapters().keySet().iterator();
            compositeDataHolder = new CompositeDataHolder();
            while (adapterNames.hasNext()) {
                speciesName = (String)adapterNames.next();
                adapterUI = (AbstractDataAdapterUI)this.getAdapterGUIs().get(speciesName);
                childCurationSet = (CurationSet)adapterUI.doOperation(values);
                childCurationSet.setOrganism(speciesName);
                masterCurationSet.addCurationSet(speciesName, childCurationSet);
            }
        } else {
            if (this.getAdapter().curSetHasSyntenyLinks()) {
                CompositeDataHolder compositeDataHolder2 = this.getAdapter().loadSpeciesThatContainLinks(this.getNumberOfSpeciesToLoad());
                return compositeDataHolder2;
            }
            System.out.println("adapter.curSetHasSyntenyLinks() returns false. thus im expecting an ensj data adapter...");
            int startAdapterIndex = this.findStartAdapterIndex();
            this.findUpstreamCurationSets(startAdapterIndex, masterCurationSet, values);
            this.findDownstreamCurationSets(startAdapterIndex, masterCurationSet, values);
            Vector setNames = new Vector();
            for (int i = 0; i < this.getAdapterLabelList().size(); i += 2) {
                setNames.add(this.getAdapterLabelList().get(i));
            }
            masterCurationSet.setChildSetOrderedNames(setNames);
        }
        this.addComparaFeaturesIntoSingleSpeciesSets(masterCurationSet);
        compositeDataHolder = new CompositeDataHolder(masterCurationSet);
        return compositeDataHolder;
    }

    private void addComparaFeaturesIntoSingleSpeciesSets(CurationSet masterCurationSet) throws ApolloAdapterException {
        String speciesName = null;
        CurationSet curationSet = null;
        String comparaKey = (String)this.getAdapterLabelList().get(1);
        AbstractApolloAdapter abstractAdapter = (AbstractApolloAdapter)this.getAdapter().getAdapters().get(comparaKey);
        SyntenyComparaAdapter adapter = null;
        List featurePairList = null;
        String doFetch = null;
        HashMap<String, SequenceI> sequenceHash = new HashMap<String, SequenceI>();
        if (abstractAdapter instanceof SyntenyComparaAdapter) {
            adapter = (SyntenyComparaAdapter)abstractAdapter;
            doFetch = adapter.getStateInformation().getProperty("dnaAlignsIntoSingleSpecies");
        }
        if (doFetch != null && doFetch.trim().length() > 0 && doFetch.equals("true")) {
            int i;
            for (i = 0; i < this.getAdapterLabelList().size(); i += 2) {
                speciesName = (String)this.getAdapterLabelList().get(i);
                curationSet = masterCurationSet.getCurationSet(speciesName);
                sequenceHash.put(adapter.convertLogicalNameToSpeciesName(speciesName), curationSet.getRefSequence());
            }
            for (i = 0; i < this.getAdapterLabelList().size(); i += 2) {
                speciesName = (String)this.getAdapterLabelList().get(i);
                curationSet = masterCurationSet.getCurationSet(speciesName);
                String chromosome = curationSet.getChromosome();
                int start = curationSet.getStart();
                int end = curationSet.getEnd();
                featurePairList = adapter.fetchAllAlignFeatures(speciesName, chromosome, start, end, sequenceHash);
                for (int j = 0; j < featurePairList.size(); ++j) {
                    curationSet.getResults().addFeature((SeqFeatureI)featurePairList.get(j));
                }
            }
        }
    }

    private int findStartAdapterIndex() throws ApolloAdapterException {
        EnsJAdapterGUI adapterGUI = null;
        for (int i = 0; i < this.getAdapterLabelList().size(); i += 2) {
            String speciesName = (String)this.getAdapterLabelList().get(i);
            Object adapGuiObj = this.getAdapterGUIs().get(speciesName);
            if (!(adapGuiObj instanceof EnsJAdapterGUI)) {
                String m = "Error: expecting EnsJAdapterGUI for synteny, got " + adapGuiObj + " abandoning ship!";
                System.out.println(m);
                this.debugTrace();
                throw new ApolloAdapterException(m);
            }
            adapterGUI = (EnsJAdapterGUI)adapGuiObj;
            adapterGUI.getController().handleEventForKey("UPDATE");
            if (!this.hasRangeInformation(adapterGUI) && !this.hasStableIdInformation(adapterGUI)) continue;
            return i;
        }
        throw new ApolloAdapterException("No species had sufficient starting information - range or gene stable id");
    }

    private void findUpstreamCurationSets(int startIndex, CurationSet masterCurationSet, Object values) throws DataAdapterException {
        for (int i = startIndex; i < this.getAdapterLabelList().size() - 1; i += 2) {
            String querySpeciesName = (String)this.getAdapterLabelList().get(i);
            String hitSpeciesName = (String)this.getAdapterLabelList().get(i + 2);
            EnsJAdapterGUI querySpeciesAdapterGUI = (EnsJAdapterGUI)this.getAdapterGUIs().get(querySpeciesName);
            EnsJAdapterGUI hitSpeciesAdapterGUI = (EnsJAdapterGUI)this.getAdapterGUIs().get(hitSpeciesName);
            String comparaName = querySpeciesName + "-" + hitSpeciesName;
            SyntenyComparaAdapterGUI comparaAdapterGUI = (SyntenyComparaAdapterGUI)((Object)this.getAdapterGUIs().get(comparaName));
            if (comparaAdapterGUI == null) {
                comparaName = hitSpeciesName + "-" + querySpeciesName;
                comparaAdapterGUI = (SyntenyComparaAdapterGUI)((Object)this.getAdapterGUIs().get(comparaName));
            }
            if (comparaAdapterGUI == null) {
                throw new IllegalStateException("No compara adapter set for species: " + querySpeciesName + "-" + hitSpeciesName);
            }
            this.doAppropriateFetchesForInputQueryHitAndComparaAdapters(values, querySpeciesName, querySpeciesAdapterGUI, comparaName, comparaAdapterGUI, hitSpeciesName, hitSpeciesAdapterGUI, masterCurationSet);
        }
    }

    private void findDownstreamCurationSets(int startIndex, CurationSet masterCurationSet, Object values) throws DataAdapterException {
        for (int i = startIndex; i >= 2; i -= 2) {
            String querySpeciesName = (String)this.getAdapterLabelList().get(i - 2);
            String hitSpeciesName = (String)this.getAdapterLabelList().get(i);
            EnsJAdapterGUI querySpeciesAdapterGUI = (EnsJAdapterGUI)this.getAdapterGUIs().get(querySpeciesName);
            EnsJAdapterGUI hitSpeciesAdapterGUI = (EnsJAdapterGUI)this.getAdapterGUIs().get(hitSpeciesName);
            String comparaName = querySpeciesName + "-" + hitSpeciesName;
            SyntenyComparaAdapterGUI comparaAdapterGUI = (SyntenyComparaAdapterGUI)((Object)this.getAdapterGUIs().get(comparaName));
            if (comparaAdapterGUI == null) {
                comparaName = hitSpeciesName + "-" + querySpeciesName;
                comparaAdapterGUI = (SyntenyComparaAdapterGUI)((Object)this.getAdapterGUIs().get(comparaName));
            }
            if (comparaAdapterGUI == null) {
                throw new IllegalStateException("No compara adapter set for species: " + querySpeciesName + "-" + hitSpeciesName);
            }
            this.doAppropriateFetchesForInputQueryHitAndComparaAdapters(values, querySpeciesName, querySpeciesAdapterGUI, comparaName, comparaAdapterGUI, hitSpeciesName, hitSpeciesAdapterGUI, masterCurationSet);
        }
    }

    private void doAppropriateFetchesForInputQueryHitAndComparaAdapters(Object values, String querySpeciesName, EnsJAdapterGUI querySpeciesAdapterGUI, String comparaName, SyntenyComparaAdapterGUI comparaAdapterGUI, String hitSpeciesName, EnsJAdapterGUI hitSpeciesAdapterGUI, CurationSet masterCurationSet) throws DataAdapterException {
        if (this.hasRangeInformation(querySpeciesAdapterGUI) && this.hasRangeInformation(hitSpeciesAdapterGUI)) {
            this.doTwoSidedFetch(values, querySpeciesName, querySpeciesAdapterGUI, comparaName, comparaAdapterGUI, hitSpeciesName, hitSpeciesAdapterGUI, masterCurationSet);
        } else if (this.hasRangeInformation(querySpeciesAdapterGUI)) {
            this.doOneSidedFetch(values, querySpeciesName, querySpeciesAdapterGUI, comparaName, comparaAdapterGUI, hitSpeciesName, hitSpeciesAdapterGUI, masterCurationSet);
        } else if (this.hasRangeInformation(hitSpeciesAdapterGUI)) {
            this.doOneSidedFetch(values, hitSpeciesName, hitSpeciesAdapterGUI, comparaName, comparaAdapterGUI, querySpeciesName, querySpeciesAdapterGUI, masterCurationSet);
        } else if (this.hasStableIdInformation(querySpeciesAdapterGUI)) {
            this.doOneSidedFetch(values, querySpeciesName, querySpeciesAdapterGUI, comparaName, comparaAdapterGUI, hitSpeciesName, hitSpeciesAdapterGUI, masterCurationSet);
        } else if (this.hasStableIdInformation(hitSpeciesAdapterGUI)) {
            this.doOneSidedFetch(values, hitSpeciesName, hitSpeciesAdapterGUI, comparaName, comparaAdapterGUI, querySpeciesName, querySpeciesAdapterGUI, masterCurationSet);
        }
    }

    private void doTwoSidedFetch(Object values, String querySpeciesName, EnsJAdapterGUI querySpeciesAdapterGUI, String comparaName, SyntenyComparaAdapterGUI comparaAdapterGUI, String hitSpeciesName, EnsJAdapterGUI hitSpeciesAdapterGUI, CurationSet masterCurationSet) throws DataAdapterException {
        CurationSet comparaCurationSet = null;
        CurationSet querySpeciesCurationSet = null;
        CurationSet hitSpeciesCurationSet = null;
        if (masterCurationSet.getCurationSet(querySpeciesName) == null) {
            querySpeciesCurationSet = (CurationSet)querySpeciesAdapterGUI.doOperation(values);
            querySpeciesCurationSet.setOrganism(querySpeciesName);
            masterCurationSet.addCurationSet(querySpeciesName, querySpeciesCurationSet);
        }
        if (masterCurationSet.getCurationSet(hitSpeciesName) == null) {
            hitSpeciesCurationSet = (CurationSet)hitSpeciesAdapterGUI.doOperation(values);
            hitSpeciesCurationSet.setOrganism(hitSpeciesName);
            masterCurationSet.addCurationSet(hitSpeciesName, hitSpeciesCurationSet);
        }
        if (masterCurationSet.getCurationSet(comparaName) == null) {
            comparaCurationSet = (CurationSet)comparaAdapterGUI.doOperation(values);
            masterCurationSet.addCurationSet(comparaName, comparaCurationSet);
        }
    }

    private void doOneSidedFetch(Object values, String querySpeciesName, EnsJAdapterGUI querySpeciesAdapterGUI, String comparaName, SyntenyComparaAdapterGUI comparaAdapterGUI, String hitSpeciesName, EnsJAdapterGUI hitSpeciesAdapterGUI, CurationSet masterCurationSet) throws DataAdapterException {
        CurationSet comparaCurationSet;
        CurationSet querySpeciesCurationSet = masterCurationSet.getCurationSet(querySpeciesName);
        if (querySpeciesCurationSet == null) {
            querySpeciesCurationSet = (CurationSet)querySpeciesAdapterGUI.doOperation(values);
            querySpeciesCurationSet.setOrganism(querySpeciesName);
            masterCurationSet.addCurationSet(querySpeciesName, querySpeciesCurationSet);
        }
        if ((comparaCurationSet = masterCurationSet.getCurationSet(comparaName)) == null) {
            comparaCurationSet = (CurationSet)comparaAdapterGUI.doOperation(values);
            masterCurationSet.addCurationSet(comparaName, comparaCurationSet);
        }
        String chromosome = comparaCurationSet.getChromosome();
        int start = comparaCurationSet.getStart();
        int end = comparaCurationSet.getEnd();
        String stableId = ((SyntenyComparaAdapter)comparaAdapterGUI.getDataAdapter()).getStableId();
        LocationModel hitSpeciesLocationModel = hitSpeciesAdapterGUI.getModel().getLocationModel();
        hitSpeciesAdapterGUI.getController().handleEventForKey("FIND_COORD_SYSTEMS");
        if (stableId != null && stableId.trim().length() > 0) {
            hitSpeciesLocationModel.setStableID(stableId);
            hitSpeciesLocationModel.setStableIDLocation(true);
        } else if (start > 0) {
            int i;
            String coordSystem = null;
            for (i = 0; i < hitSpeciesLocationModel.getCoordSystems().size() && coordSystem == null; ++i) {
                if (!((String)hitSpeciesLocationModel.getCoordSystems().get(i)).endsWith("chromosome")) continue;
                coordSystem = (String)hitSpeciesLocationModel.getCoordSystems().get(i);
            }
            for (i = 0; i < hitSpeciesLocationModel.getCoordSystems().size() && coordSystem == null; ++i) {
                if (!((String)hitSpeciesLocationModel.getCoordSystems().get(i)).endsWith("scaffold")) continue;
                coordSystem = (String)hitSpeciesLocationModel.getCoordSystems().get(i);
            }
            if (coordSystem == null) {
                coordSystem = (String)hitSpeciesLocationModel.getCoordSystems().get(0);
            }
            hitSpeciesLocationModel.setStableIDLocation(false);
            hitSpeciesLocationModel.setSelectedCoordSystem(coordSystem);
            hitSpeciesLocationModel.setSelectedSeqRegion(chromosome);
            hitSpeciesLocationModel.setStart(String.valueOf(start));
            hitSpeciesLocationModel.setEnd(String.valueOf(end));
        }
        hitSpeciesAdapterGUI.getController().handleEventForKey("READ");
        CurationSet hitSpeciesCurationSet = masterCurationSet.getCurationSet(hitSpeciesName);
        if (hitSpeciesCurationSet == null) {
            hitSpeciesCurationSet = (CurationSet)hitSpeciesAdapterGUI.doOperation(values);
            hitSpeciesCurationSet.setOrganism(hitSpeciesName);
            masterCurationSet.addCurationSet(hitSpeciesName, hitSpeciesCurationSet);
        }
    }

    private boolean hasRangeInformation(EnsJAdapterGUI adapterGUI) {
        LocationModel locationModel = adapterGUI.getModel().getLocationModel();
        boolean hasLocation = false;
        if (!locationModel.isStableIDLocation()) {
            hasLocation = locationModel.getSelectedCoordSystem() != null && locationModel.getSelectedSeqRegion() != null && locationModel.getStart() != null && locationModel.getEnd() != null;
        }
        return hasLocation;
    }

    private boolean hasStableIdInformation(EnsJAdapterGUI adapterGUI) {
        String stableId;
        LocationModel locationModel = adapterGUI.getModel().getLocationModel();
        String actualStableId = null;
        if (locationModel.isStableIDLocation() && (stableId = locationModel.getStableID()) != null && stableId.trim().length() > 0) {
            actualStableId = stableId;
        }
        return actualStableId != null && actualStableId.trim().length() > 0 && !actualStableId.equals("null");
    }

    private Style getStyle() {
        return this.getAdapter().getStyle();
    }

    private boolean isRead() {
        return this.getOperation() == ApolloDataAdapterI.OP_READ_DATA;
    }

    private boolean addNumSpeciesDropdown() {
        return this.isRead() && this.getStyle().addSyntenySpeciesNumDropdown();
    }

    private void buildGUI() {
        this.setTabbedPane(new JTabbedPane());
        Iterator adapters = this.getAdapterLabelList().iterator();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        if (this.addNumSpeciesDropdown()) {
            this.buildNumberOfSpeciesDropdownList(gbc);
        }
        while (adapters.hasNext()) {
            String adapterName = (String)adapters.next();
            AbstractApolloAdapter adapter = (AbstractApolloAdapter)this.getAdapter().getAdapters().get(adapterName);
            if (adapter == null) {
                System.out.println("Could not get adapter " + adapterName);
            }
            DataAdapterUI adapterUI = adapter.getUI(this.getOperation());
            this.getAdapterGUIs().put(adapterName, adapterUI);
            adapterUI.setInput((Object)adapterName);
            adapterUI.setInput((Object)this);
            this.getTabbedPane().addTab(adapterName, (Component)adapterUI);
        }
        this.enableTabbedPanes(this.addNumSpeciesDropdown());
        this.add(this.getTabbedPane(), gbc);
    }

    private void buildNumberOfSpeciesDropdownList(GridBagConstraints gbc) {
        this.speciesNumberDropdownList = new JComboBox();
        this.speciesNumberDropdownList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                Integer i = (Integer)SyntenyAdapterGUI.this.speciesNumberDropdownList.getSelectedItem();
                SyntenyAdapterGUI.this.setNumberOfSpeciesToLoad(i);
            }
        });
        for (int i = 1; i <= this.getConfiggedNumberOfSpecies(); ++i) {
            this.speciesNumberDropdownList.addItem(new Integer(i));
        }
        JLabel label = new JLabel("Select Number of Species to Load :  ");
        Box b = new Box(0);
        b.add(label);
        b.add(this.speciesNumberDropdownList);
        gbc.gridx = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 160, 0, 0);
        this.add(b, gbc);
        gbc.insets = new Insets(0, 0, 0, 0);
    }

    private int getConfiggedNumberOfSpecies() {
        return this.getSyntenyStyle().getNumberOfSpecies();
    }

    private void setNumberOfSpeciesToLoad(int i) {
        this.numberOfSpeciesToLoad = i;
        this.enableTabbedPanes(i - 1);
    }

    private int getNumberOfSpeciesToLoad() {
        return this.numberOfSpeciesToLoad;
    }

    private void enableTabbedPanes(int index) {
        for (int i = 0; i < this.getTabbedPane().getTabCount(); ++i) {
            this.getTabbedPane().setEnabledAt(i, i <= index);
        }
        if (this.getTabbedPane().getSelectedIndex() > index) {
            this.getTabbedPane().setSelectedIndex(0);
        }
    }

    private void enableTabbedPanes(boolean justFirstSpecies) {
        boolean enable = !justFirstSpecies;
        for (int i = 1; i < this.getTabbedPane().getTabCount(); ++i) {
            this.getTabbedPane().setEnabledAt(i, enable);
        }
        this.getTabbedPane().setSelectedIndex(0);
    }

    private JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    private void setTabbedPane(JTabbedPane newValue) {
        this.tabbedPane = newValue;
    }

    private SyntenyAdapter getAdapter() {
        return this.driver;
    }

    public Map getAdapterGUIs() {
        return this.adapterGUIs;
    }

    protected IOOperation getOperation() {
        return this.op;
    }

    private void setAdapterLabelList(List list) {
        this.adapterLabelList = list;
    }

    public List getAdapterLabelList() {
        return this.adapterLabelList;
    }

    public HashMap getSharedData() {
        return this.sharedData;
    }

    String getHitFromUser(String[] names) {
        String initial = names[0];
        String m = "Select a hit to display";
        return (String)JOptionPane.showInputDialog(null, m, m, -1, null, names, initial);
    }

    private void debugPrint(String m) {
        if (Config.DEBUG) {
            System.out.println(m);
        }
    }

    private void debugTrace() {
        this.debugPrint("DEBUG stacktrace:");
        if (Config.DEBUG) {
            new Throwable().printStackTrace();
        }
    }
}

