/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.synteny;

import apollo.config.Config;
import apollo.config.Style;
import apollo.dataadapter.AbstractApolloAdapter;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.NonFatalDataAdapterException;
import apollo.dataadapter.NotImplementedException;
import apollo.dataadapter.synteny.EmbeddedLinkSynteny;
import apollo.dataadapter.synteny.SyntenyAdapterGUI;
import apollo.datamodel.CompositeDataHolder;
import apollo.datamodel.CurationSet;
import apollo.datamodel.DbXref;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.bdgp.io.DataAdapterException;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;

public class SyntenyAdapter
extends AbstractApolloAdapter {
    private Map adapters;
    private List dataAdapterList = new ArrayList(4);
    IOOperation[] supportedOperations = new IOOperation[]{ApolloDataAdapterI.OP_READ_DATA, ApolloDataAdapterI.OP_READ_SEQUENCE, ApolloDataAdapterI.OP_WRITE_DATA};
    private Map syntenyOpToUI = new HashMap(3);

    public SyntenyAdapter() {
        this.adapters = this.buildAdapters();
    }

    public Map getAdapters() {
        return this.adapters;
    }

    public ApolloDataAdapterI getSpeciesAdapter(String species) {
        Object obj = this.getAdapters().get(species);
        if (obj instanceof ApolloDataAdapterI) {
            return (ApolloDataAdapterI)obj;
        }
        return null;
    }

    void setChildAdapterStyles() {
        Iterator i = this.getAdapters().values().iterator();
        while (i.hasNext()) {
            ((ApolloDataAdapterI)i.next()).setStyle(this.getStyle());
        }
    }

    public String getName() {
        return "Synteny";
    }

    public String getType() {
        return "Multiple Species and Compara Data";
    }

    public DataInputType getInputType() {
        return DataInputType.FILE;
    }

    public String getInput() {
        throw new NotImplementedException("Not yet implemented");
    }

    public IOOperation[] getSupportedOperations() {
        return this.supportedOperations;
    }

    public DataAdapterUI getUI(IOOperation op) {
        Object ui = (DataAdapterUI)this.syntenyOpToUI.get(op);
        if (ui == null) {
            ui = new SyntenyAdapterGUI(op, this);
            this.syntenyOpToUI.put(op, ui);
        }
        return ui;
    }

    public void setRegion(String region) throws ApolloAdapterException {
        throw new NotImplementedException("Not yet implemented");
    }

    public Properties getStateInformation() {
        Properties props = new Properties();
        return props;
    }

    public void setStateInformation(Properties props) {
    }

    public CurationSet getCurationSet() throws ApolloAdapterException {
        throw new NotImplementedException("Not yet implemented");
    }

    private void setSequence(SeqFeatureI sf, CurationSet curationSet) {
        throw new NotImplementedException("Not yet implemented");
    }

    public SequenceI getSequence(String id) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public SequenceI getSequence(DbXref dbxref) throws ApolloAdapterException {
        throw new NotImplementedException("Not yet implemented");
    }

    public SequenceI getSequence(DbXref dbxref, int start, int end) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public Vector getSequences(DbXref[] dbxref) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public Vector getSequences(DbXref[] dbxref, int[] start, int[] end) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public void commitChanges(CompositeDataHolder cdh) throws ApolloAdapterException {
        for (int i = 0; i < this.getNumberOfChildAdapters(); ++i) {
            this.getChildAdapter(i).commitChanges(cdh.getCurationSet(i));
        }
    }

    public void commitChanges(CurationSet curationSet) throws ApolloAdapterException {
        Iterator adapterNames = curationSet.getChildCurationSets().keySet().iterator();
        String adapterName = null;
        ApolloDataAdapterI adapter = null;
        CurationSet singleSpeciesCurationSet = null;
        boolean allowSave = false;
        HashMap properties = Config.getStyle("apollo.dataadapter.synteny.SyntenyAdapter").getSyntenySpeciesProperties();
        String dataAdapterClassName = null;
        String dataAdapterKey = null;
        while (adapterNames.hasNext()) {
            adapterName = (String)adapterNames.next();
            if (adapterName.indexOf("-") > 0) continue;
            dataAdapterKey = "Species." + adapterName + ".DataAdapter";
            dataAdapterClassName = (String)properties.get(dataAdapterKey);
            adapter = (ApolloDataAdapterI)this.getAdapters().get(adapterName);
            singleSpeciesCurationSet = curationSet.getCurationSet(adapterName);
            if (singleSpeciesCurationSet == null) {
                throw new ApolloAdapterException("Expecting curation set for species: " + adapterName + " -- not supplied");
            }
            adapter.commitChanges(singleSpeciesCurationSet);
        }
    }

    public String getRawAnalysisResults(String id) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public void init() {
    }

    private Map buildAdapters() {
        AbstractApolloAdapter dataAdapter;
        Class<?> dataAdapterClass;
        String dataAdapterName;
        String dataAdapterKey;
        String shortLogicalName;
        int index;
        String logicalName;
        int i;
        if (this.getSyntenyStyle() == null) {
            System.err.println("Can't build Synteny adapter--failed to load Synteny style");
            return null;
        }
        HashMap properties = this.getSyntenyStyle().getSyntenySpeciesProperties();
        HashMap<String, AbstractApolloAdapter> returnMap = new HashMap<String, AbstractApolloAdapter>();
        for (i = 0; i < this.getSyntenyStyle().getNumberOfSyntenySpecies(); ++i) {
            logicalName = this.getSyntenyStyle().getSyntenySpeciesString(i);
            index = logicalName.indexOf(".");
            shortLogicalName = logicalName.substring(index + 1);
            dataAdapterKey = "Species." + shortLogicalName + ".DataAdapter";
            dataAdapterName = (String)properties.get(dataAdapterKey);
            if (dataAdapterName == null) {
                dataAdapterName = this.getSyntenyStyle().getDefaultSyntenyDataAdapterString();
            }
            if (dataAdapterName == null) {
                throw new NonFatalDataAdapterException("No data adapter name found for key: " + dataAdapterKey);
            }
            try {
                dataAdapterClass = Class.forName(dataAdapterName);
                dataAdapter = (AbstractApolloAdapter)dataAdapterClass.newInstance();
                dataAdapter.setSpecies(shortLogicalName);
                dataAdapter.setCurationNumber(i);
                this.dataAdapterList.add(dataAdapter);
                returnMap.put(shortLogicalName, dataAdapter);
                continue;
            }
            catch (ClassNotFoundException exception) {
                if (Config.DEBUG) {
                    exception.printStackTrace();
                }
                throw new IllegalStateException("cant create data adapter");
            }
            catch (InstantiationException exception) {
                if (Config.DEBUG) {
                    exception.printStackTrace();
                }
                throw new IllegalStateException("cant create data adapter");
            }
            catch (IllegalAccessException exception) {
                if (Config.DEBUG) {
                    exception.printStackTrace();
                }
                throw new IllegalStateException("cant create data adapter");
            }
        }
        for (i = 0; i < this.getSyntenyStyle().getSyntenyLinkOrder().size(); ++i) {
            logicalName = (String)this.getSyntenyStyle().getSyntenyLinkOrder().get(i);
            index = logicalName.indexOf(".");
            shortLogicalName = logicalName.substring(index + 1);
            dataAdapterKey = "Species." + shortLogicalName + ".DataAdapter";
            dataAdapterName = (String)properties.get(dataAdapterKey);
            if (dataAdapterName == null) {
                dataAdapterName = this.getSyntenyStyle().getDefaultSyntenyDataAdapterString();
            }
            if (dataAdapterName == null) {
                throw new NonFatalDataAdapterException("No data adapter name found for key: " + dataAdapterKey);
            }
            try {
                dataAdapterClass = Class.forName(dataAdapterName);
                dataAdapter = (AbstractApolloAdapter)dataAdapterClass.newInstance();
                dataAdapter.setSpecies(shortLogicalName);
                this.dataAdapterList.add(dataAdapter);
                returnMap.put(shortLogicalName, dataAdapter);
                continue;
            }
            catch (ClassNotFoundException exception) {
                throw new IllegalStateException("cant create data adapter");
            }
            catch (InstantiationException exception) {
                throw new IllegalStateException("cant create data adapter");
            }
            catch (IllegalAccessException exception) {
                throw new IllegalStateException("cant create data adapter");
            }
        }
        return returnMap;
    }

    boolean curSetHasSyntenyLinks() {
        for (int i = 0; i < this.getNumberOfChildAdapters(); ++i) {
            if (!this.getChildAdapter(i).hasLinkData()) continue;
            return true;
        }
        return false;
    }

    private String getSpeciesLogicalName(String fullNameField) {
        int index = fullNameField.indexOf(".");
        return fullNameField.substring(index + 1);
    }

    private String logicalToStyleLogicalString(String logicalName) {
        return "Name." + logicalName;
    }

    public int getNumberOfChildAdapters() {
        return this.dataAdapterList.size();
    }

    public ApolloDataAdapterI getChildAdapter(int i) {
        return (ApolloDataAdapterI)this.dataAdapterList.get(i);
    }

    private Style getSyntenyStyle() {
        return Config.getStyle(this.getClass().getName());
    }

    private boolean logicalNameIsLink(String logicalName) {
        String fullSpeciesName = this.getSpeciesNameForLogicalName(logicalName);
        if (fullSpeciesName == null) {
            return false;
        }
        if (fullSpeciesName.toLowerCase().equals("compara")) {
            return true;
        }
        return fullSpeciesName.toLowerCase().equals("links");
    }

    private String getSpeciesNameForLogicalName(String logicalName) {
        String styleNameString = this.logicalToStyleLogicalString(logicalName);
        return (String)this.getSyntenyStyle().getSyntenySpeciesNames().get(styleNameString);
    }

    public CompositeDataHolder loadSpeciesThatContainLinks(int numberOfSpecies) throws DataAdapterException {
        EmbeddedLinkSynteny embeddedSynteny = new EmbeddedLinkSynteny(this);
        CompositeDataHolder cdh = embeddedSynteny.loadSpeciesAndLinks(numberOfSpecies);
        return cdh;
    }

    public void loadNewSpeciesFromLink(SeqFeatureI link, CompositeDataHolder compData) throws DataAdapterException {
        EmbeddedLinkSynteny gs = new EmbeddedLinkSynteny(this);
        gs.loadNewSpeciesFromLink(link, compData.getSpeciesComparison(0));
    }

    public void clearStateInformation() {
    }

    public boolean isComposite() {
        return true;
    }
}

