/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.synteny;

import apollo.dataadapter.synteny.AbstractLinker;
import apollo.dataadapter.synteny.ResultAnnotPairI;
import apollo.datamodel.Link;
import apollo.datamodel.SeqFeatureI;

class ResultPeptidePair
implements ResultAnnotPairI {
    private SeqFeatureI result;
    private SeqFeatureI transcript;
    private boolean transcriptIsFromTopSpecies = false;
    private AbstractLinker linker;

    ResultPeptidePair(SeqFeatureI feat1, SeqFeatureI feat2, AbstractLinker linker) {
        this.linker = linker;
        if (this.featFromAnnotSpecies(feat1)) {
            this.transcript = feat1;
            this.result = feat2;
            this.transcriptIsFromTopSpecies = true;
        } else {
            this.transcript = feat2;
            this.result = feat1;
            this.transcriptIsFromTopSpecies = false;
        }
    }

    private boolean featFromAnnotSpecies(SeqFeatureI feat) {
        return !this.linker.featFromLinkSpecies1(feat);
    }

    protected SeqFeatureI getTranscript() {
        return this.transcript;
    }

    protected SeqFeatureI getResult() {
        return this.result;
    }

    public boolean isLinked() {
        String pepName = this.transcript.getName();
        if (this.transcript.hasPeptideSequence()) {
            pepName = this.transcript.getPeptideSequence().getName();
        } else if (this.transcript.isProteinCodingGene()) {
            System.out.println("WARNING: transcript " + pepName + " has no pep seq. Check that " + "there is sequence data.");
        }
        return this.result.getHitFeature().getName().equals(pepName);
    }

    public Link createLink() {
        int pepHitEnd;
        SeqFeatureI peptideResultHit = this.result.getHitFeature();
        int pepHitStart = peptideResultHit.getStart();
        int midPepHit = (pepHitStart + (pepHitEnd = peptideResultHit.getEnd())) / 2;
        int genomicMid = this.getGenomicPosition(midPepHit);
        SeqFeatureI hitExon = this.transcript.getFeatureContaining(genomicMid);
        if (hitExon == null) {
            System.out.println("Unable to find transcript " + this.transcript.getName() + " exon for " + "result " + this.result.getName() + " hit coords " + pepHitStart + "-" + pepHitEnd + ". Check data.");
            return null;
        }
        int genHitStart = this.getGenomicPosition(pepHitStart);
        int genHitEnd = this.getGenomicPosition(pepHitEnd);
        int genHitLow = hitExon.getStrand() == 1 ? genHitStart : genHitEnd;
        int genHitHigh = hitExon.getStrand() == 1 ? genHitEnd : genHitStart;
        SeqFeatureI hitExonFragment = hitExon.cloneFeature();
        if (hitExonFragment.getLow() < genHitLow) {
            hitExonFragment.setLow(genHitLow);
        }
        if (hitExonFragment.getHigh() > genHitHigh) {
            hitExonFragment.setHigh(genHitHigh);
        }
        Link link = null;
        boolean hasSpecFeat = this.linker.hasSpeciesFeature();
        if (this.transcriptIsFromTopSpecies) {
            link = new Link(hitExonFragment, this.result, hasSpecFeat, this.linker.hasPercentIdentity());
            link.setSpeciesFeature1(hitExon);
            link.setTypeIsFeat1(false);
        } else {
            link = new Link(this.result, hitExonFragment, hasSpecFeat, this.linker.hasPercentIdentity());
            link.setSpeciesFeature2(hitExon);
        }
        return link;
    }

    protected int getGenomicPosition(int hitPosition) {
        return this.getTranscript().getGenomicPosForPeptidePos(hitPosition);
    }
}

