/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.synteny;

import apollo.config.Config;
import apollo.dataadapter.KaryotypeAdapterI;
import apollo.dataadapter.SyntenyAdapterI;
import apollo.dataadapter.synteny.ChromosomePanel;
import apollo.datamodel.Chromosome;
import apollo.datamodel.Karyotype;
import apollo.gui.StatusBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;
import org.bdgp.swing.AbstractDataAdapterUI;

public class FullEnsJDBCSyntenyPanel
extends JPanel {
    String org1;
    String org2;
    JPanel chrPanel = new JPanel();
    StatusBar sb = new StatusBar();
    SyntenyAdapterI sa;
    KaryotypeAdapterI ka;
    AbstractDataAdapterUI callback;
    String logicalQuerySpecies;
    String logicalHitSpecies;

    public FullEnsJDBCSyntenyPanel(String org1, String org2, KaryotypeAdapterI ka, SyntenyAdapterI sa, AbstractDataAdapterUI theCallback) {
        this.logicalQuerySpecies = org1;
        this.logicalHitSpecies = org2;
        this.org1 = this.convertLogicalNameToSpeciesName(this.logicalQuerySpecies);
        this.org2 = this.convertLogicalNameToSpeciesName(this.logicalHitSpecies);
        this.ka = ka;
        this.sa = sa;
        this.callback = theCallback;
    }

    private AbstractDataAdapterUI getCallback() {
        return this.callback;
    }

    public void init() {
        int count = 1;
        Vector<ChromosomePanel> panels = new Vector<ChromosomePanel>();
        this.setLayout(new BorderLayout());
        Karyotype org1Kary = this.ka.getKaryotypeBySpeciesName(this.getLogicalQuerySpecies());
        Karyotype org2Kary = this.ka.getKaryotypeBySpeciesName(this.getLogicalHitSpecies());
        Vector org1chrs = org1Kary.getChromosomes();
        int nRow = org1chrs.size() / 6;
        if (nRow * 6 != org1chrs.size()) {
            ++nRow;
        }
        this.chrPanel.setLayout(new GridLayout(org1chrs.size() / 6, 6));
        this.chrPanel.setBackground(Color.white);
        for (int cc = 0; cc < org1chrs.size(); ++cc) {
            Chromosome chr1 = (Chromosome)org1chrs.elementAt(cc);
            String chr = chr1.getDisplayId();
            Vector regions = this.sa.getSyntenyRegionsByChromosome(chr1);
            ChromosomePanel cp = null;
            if (regions.size() != 0) {
                cp = new ChromosomePanel(chr1, regions, null, this.sb, this.getCallback(), this.getLogicalQuerySpecies(), this.getLogicalHitSpecies());
                panels.addElement(cp);
                this.chrPanel.add(cp);
            } else {
                Vector tmpreg = new Vector();
                cp = new ChromosomePanel(chr1, tmpreg, null, this.sb, this.getCallback(), this.getLogicalQuerySpecies(), this.getLogicalHitSpecies());
                panels.addElement(cp);
                this.chrPanel.add(cp);
            }
            ++count;
        }
        this.add((Component)this.chrPanel, "Center");
        this.add((Component)this.sb, "South");
    }

    private String convertLogicalNameToSpeciesName(String logicalName) {
        HashMap speciesNames = Config.getStyle("apollo.dataadapter.synteny.SyntenyAdapter").getSyntenySpeciesNames();
        Iterator logicalNames = speciesNames.keySet().iterator();
        String shortName = null;
        while (logicalNames.hasNext()) {
            int index;
            String longName = (String)logicalNames.next();
            shortName = longName.substring((index = longName.indexOf(".")) + 1);
            if (!shortName.equals(logicalName)) continue;
            return (String)speciesNames.get(longName);
        }
        throw new IllegalStateException("No logical species name matches the name input:" + shortName);
    }

    private String getLogicalQuerySpecies() {
        return this.logicalQuerySpecies;
    }

    private String getLogicalHitSpecies() {
        return this.logicalHitSpecies;
    }
}

