/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.synteny;

import apollo.config.Config;
import apollo.config.FeatureProperty;
import apollo.config.PropertyScheme;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.synteny.AbstractLinker;
import apollo.dataadapter.synteny.LinkerI;
import apollo.dataadapter.synteny.SyntenyAdapter;
import apollo.datamodel.CompositeDataHolder;
import apollo.datamodel.CurationSet;
import apollo.datamodel.LinkSet;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SpeciesComparison;
import org.bdgp.io.DataAdapterException;
import org.bdgp.io.IOOperation;

class EmbeddedLinkSynteny {
    private SyntenyAdapter syntenyAdapter;
    private SpeciesComparison speciesComparison;

    EmbeddedLinkSynteny(SyntenyAdapter syntenyAdapter) {
        this.syntenyAdapter = syntenyAdapter;
    }

    CompositeDataHolder loadSpeciesAndLinks(int numberOfSpecies) throws DataAdapterException {
        if (numberOfSpecies == 1) {
            SpeciesComparison sc = this.loadOneCuration();
            return new CompositeDataHolder(sc);
        }
        CompositeDataHolder cdh = new CompositeDataHolder();
        SpeciesComparison previousComp = null;
        for (int i = 0; i < numberOfSpecies - 1; ++i) {
            SpeciesComparison newComp = this.makeSpeciesComparison(i, previousComp);
            cdh.addSpeciesComparison(newComp);
            previousComp = newComp;
        }
        return cdh;
    }

    private SpeciesComparison loadOneCuration() throws DataAdapterException {
        CurationSet cs = this.loadCurationSet(0);
        return new SpeciesComparison(this.getSpeciesName(0), cs);
    }

    private SpeciesComparison makeSpeciesComparison(int firstSpeciesIndex, SpeciesComparison previousComparison) throws DataAdapterException {
        SpeciesComparison sc = new SpeciesComparison();
        CurationSet cs1 = previousComparison == null ? this.loadCurationSet(firstSpeciesIndex) : previousComparison.getCurationSet2();
        CurationSet cs2 = this.loadCurationSet(firstSpeciesIndex + 1);
        String firstSpec = this.getSpeciesName(firstSpeciesIndex);
        String secondSpec = this.getSpeciesName(firstSpeciesIndex + 1);
        SpeciesComparison comp = new SpeciesComparison(firstSpec, cs1, secondSpec, cs2);
        this.getLinksFromCurationSets(comp);
        return comp;
    }

    private String getSpeciesName(int speciesIndex) {
        return this.syntenyAdapter.getChildAdapter(speciesIndex).getSpecies();
    }

    public void loadNewSpeciesFromLink(SeqFeatureI feat, SpeciesComparison specComp) throws DataAdapterException {
        this.setSpeciesComparison(specComp);
        this.loadCurationSetForFeat(feat);
        this.getLinksFromCurationSets(specComp);
    }

    private void setSpeciesComparison(SpeciesComparison sc) {
        this.speciesComparison = sc;
    }

    private SpeciesComparison getSpeciesComparison() {
        if (this.speciesComparison == null) {
            this.speciesComparison = new SpeciesComparison();
        }
        return this.speciesComparison;
    }

    private CurationSet loadCurationSet(int adapterIndex) throws DataAdapterException {
        ApolloDataAdapterI adap = this.syntenyAdapter.getChildAdapter(adapterIndex);
        IOOperation op = ApolloDataAdapterI.OP_READ_DATA;
        Object values = null;
        return (CurationSet)adap.getUI(op).doOperation(values);
    }

    private void loadCurationSetForFeat(SeqFeatureI linkFeat) throws DataAdapterException {
        ApolloDataAdapterI adap = this.syntenyAdapter.getChildAdapter(1);
        if (!this.featFromCurSet1(linkFeat)) {
            adap = this.syntenyAdapter.getChildAdapter(0);
        }
        LinkerI linker = this.getLinker(linkFeat);
        CurationSet cs = linker.getCurationSetForLink(adap, linkFeat);
        if (this.featFromCurSet1(linkFeat)) {
            this.speciesComparison.setCurationSet2(adap.getSpecies(), cs);
        } else {
            this.speciesComparison.setCurationSet1(adap.getSpecies(), cs);
        }
    }

    private void getLinksFromCurationSets(SpeciesComparison speciesComp) {
        LinkSet linkSet;
        block3: {
            linkSet = new LinkSet(false);
            try {
                for (int i = 0; i < this.getPropertyScheme().getLinkedFeatPropsSize(); ++i) {
                    FeatureProperty linkedProp = this.getPropertyScheme().getLinkedFeatProp(i);
                    LinkerI linker = this.getLinker(linkedProp);
                    linkSet.addLinks(linker.createLinksFromSpeciesComp(speciesComp));
                }
            }
            catch (NullPointerException e) {
                System.out.println("Species link retrieval failed due to a null pointer exception. Organism may be null\n" + e.getMessage() + e);
                if (!Config.DEBUG) break block3;
                e.printStackTrace();
            }
        }
        speciesComp.setLinks(linkSet);
    }

    private FeatureProperty getFeatProp(SeqFeatureI feat) {
        return this.getPropertyScheme().getFeatureProperty(feat.getTopLevelType());
    }

    private PropertyScheme getPropertyScheme() {
        return Config.getPropertyScheme();
    }

    private boolean featFromCurSet1(SeqFeatureI feat) {
        String species1 = this.getSpeciesComparison().getCurationSet1().getOrganism();
        return feat.getRefSequence().getOrganism().equals(species1);
    }

    private LinkerI getLinker(SeqFeatureI featLink) {
        return this.getLinker(this.getFeatProp(featLink));
    }

    private LinkerI getLinker(FeatureProperty linkedProp) {
        return AbstractLinker.getLinker(linkedProp);
    }
}

