/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.synteny;

import apollo.dataadapter.synteny.ChromosomeDrawer;
import apollo.dataadapter.synteny.SyntenyMenu;
import apollo.datamodel.Chromosome;
import apollo.datamodel.SyntenyRegion;
import apollo.gui.StatusBar;
import apollo.util.QuickSort;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.bdgp.swing.AbstractDataAdapterUI;

public class ChromosomePanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private Chromosome chr;
    private Vector regions;
    private Hashtable colours;
    private Vector hitChrs;
    private Hashtable hitRegions;
    private Vector drawers;
    private Vector hitOrder;
    private StatusBar sb;
    private AbstractDataAdapterUI callback;
    String logicalQuerySpecies;
    String logicalHitSpecies;

    public ChromosomePanel(Chromosome chr, Vector regions) {
        this(chr, regions, null, null);
        this.setColours();
    }

    public ChromosomePanel(Chromosome chr, Vector regions, StatusBar sb) {
        this(chr, regions, null, sb, null, null, null);
        this.setColours();
    }

    public ChromosomePanel(Chromosome chr, Vector regions, Hashtable colours, StatusBar sb) {
        this(chr, regions, colours, sb, null, null, null);
    }

    public ChromosomePanel(Chromosome chr, Vector regions, Hashtable colours, StatusBar sb, AbstractDataAdapterUI theCallback, String querySpecies, String hitSpecies) {
        this.chr = chr;
        this.regions = regions;
        this.colours = colours;
        this.sb = sb;
        this.callback = theCallback;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        if (colours == null) {
            this.setColours();
        }
        this.logicalQuerySpecies = querySpecies;
        this.logicalHitSpecies = hitSpecies;
        this.init();
    }

    private AbstractDataAdapterUI getCallback() {
        return this.callback;
    }

    public void init() {
        this.hitChrs = new Vector();
        this.hitRegions = new Hashtable();
        this.hitOrder = new Vector();
        this.regions = this.sortRegions(this.regions);
        for (int i = 0; i < this.regions.size(); ++i) {
            Vector tmpreg;
            SyntenyRegion reg = (SyntenyRegion)this.regions.elementAt(i);
            Chromosome chr = reg.getChromosome2();
            if (!this.hitOrder.contains(chr)) {
                this.hitOrder.addElement(chr);
            }
            if (!this.hitRegions.containsKey(chr)) {
                tmpreg = new Vector();
                tmpreg.addElement(reg);
                this.hitRegions.put(chr, tmpreg);
                continue;
            }
            tmpreg = (Vector)this.hitRegions.get(chr);
            tmpreg.addElement(reg);
        }
    }

    public void setColours() {
        this.colours = new Hashtable();
        for (int i = 0; i < this.regions.size(); ++i) {
            Color c;
            SyntenyRegion sr = (SyntenyRegion)this.regions.elementAt(i);
            if (!this.colours.containsKey(sr.getChromosome2())) {
                c = new Color((int)(255.0 * Math.random()), (int)(255.0 * Math.random()), (int)(255.0 * Math.random()));
                this.colours.put(sr.getChromosome2(), c.brighter());
            }
            if (this.colours.containsKey(sr.getChromosome1())) continue;
            c = new Color((int)(255.0 * Math.random()), (int)(255.0 * Math.random()), (int)(255.0 * Math.random()));
            this.colours.put(sr.getChromosome1(), c.brighter());
        }
    }

    public void paint(Graphics g) {
        this.drawers = new Vector();
        g.setColor(Color.white);
        g.fillRect(0, 0, this.size().width, this.size().height);
        int xoffset = 10;
        int yoffset = 10;
        int block = this.size().width / 12;
        ChromosomeDrawer cd = new ChromosomeDrawer(this.chr, this.regions, this.colours, false);
        this.drawers.addElement(cd);
        cd.draw(g, this.size().width / 2 - block, yoffset, 2 * block, this.size().height - 20);
        int sideCount = (this.hitOrder.size() + 1) / 2;
        if (sideCount == 0) {
            return;
        }
        int hitHeight = (this.size().height - 20) / sideCount;
        int count = 0;
        int leftpos = yoffset;
        int rightpos = yoffset;
        for (int j = 0; j < this.hitOrder.size(); ++j) {
            Chromosome chr = (Chromosome)this.hitOrder.elementAt(j);
            Vector regions = (Vector)this.hitRegions.get(chr);
            ChromosomeDrawer cd1 = new ChromosomeDrawer(chr, regions, this.colours, true);
            this.drawers.addElement(cd1);
            if (count % 2 == 0) {
                cd1.draw(g, block, leftpos, block, hitHeight);
                leftpos += hitHeight;
            } else {
                cd1.draw(g, 10 * block, rightpos, block, hitHeight);
                rightpos += hitHeight;
            }
            g.setColor(Color.black);
            for (int i = 0; i < regions.size(); ++i) {
                SyntenyRegion sr = (SyntenyRegion)regions.elementAt(i);
                Rectangle rect1 = cd1.regionToRectangle(sr);
                Rectangle rect2 = cd.regionToRectangle(sr);
                int tmpx1 = rect1.width + 1;
                int tmpx2 = rect2.x;
                if (count % 2 != 0) {
                    tmpx1 = rect1.x - 1;
                    tmpx2 = rect2.width + 1;
                }
                int tmpy1 = (rect1.y + rect1.height) / 2;
                int tmpy2 = (rect2.y + rect2.height) / 2;
                g.drawLine(tmpx1, tmpy1, tmpx2, tmpy2);
            }
            ++count;
        }
    }

    private SyntenyRegion getRegion(int x, int y) {
        for (int i = 0; i < this.drawers.size(); ++i) {
            ChromosomeDrawer cd = (ChromosomeDrawer)this.drawers.elementAt(i);
            SyntenyRegion sr = cd.pixelBoxToRegion(x, y);
            if (sr == null) continue;
            return sr;
        }
        return null;
    }

    private int getBase(int x, int y) {
        for (int i = 0; i < this.drawers.size(); ++i) {
            ChromosomeDrawer cd = (ChromosomeDrawer)this.drawers.elementAt(i);
            int base = cd.pixelToBase(x, y);
            if (base == -1) continue;
            return base;
        }
        return -1;
    }

    public void mouseEntered(MouseEvent evt) {
        this.requestFocus();
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        SyntenyRegion reg = this.getRegion(e.getX(), e.getY());
        if (reg != null) {
            SyntenyMenu popup = new SyntenyMenu(this, reg, this.getCallback(), this.getLogicalQuerySpecies(), this.getLogicalHitSpecies());
            popup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void mouseMoved(MouseEvent e) {
        SyntenyRegion reg = this.getRegion(e.getX(), e.getY());
        if (this.sb != null) {
            int base = this.getBase(e.getX(), e.getY());
            if (base != -1) {
                this.sb.setPositionPane(String.valueOf(base));
            } else {
                this.sb.setPositionPane("");
            }
            if (reg != null) {
                int start1 = reg.getStart1() / 100000;
                double s1 = (double)start1 / 10.0;
                int start2 = reg.getStart2() / 100000;
                double s2 = (double)start2 / 10.0;
                int end1 = reg.getEnd1() / 100000;
                double e1 = (double)end1 / 10.0;
                int end2 = reg.getEnd2() / 100000;
                double e2 = (double)end2 / 10.0;
                String mouseregion = new String(this.getLogicalHitSpecies() + reg.getChromosome2().getDisplayId() + " " + s2 + "M - " + e2 + "M");
                String humanregion = new String(this.getLogicalQuerySpecies() + reg.getChromosome1().getDisplayId() + " " + s1 + "M - " + e1 + "M");
                this.sb.setFeaturePane(humanregion + " " + mouseregion);
            } else {
                this.sb.setFeaturePane("");
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    public Vector sortRegions(Vector regions) {
        Object[] rarr = new SyntenyRegion[regions.size()];
        int[] startarr = new int[regions.size()];
        for (int i = 0; i < regions.size(); ++i) {
            SyntenyRegion reg = (SyntenyRegion)regions.elementAt(i);
            rarr[i] = reg;
            startarr[i] = reg.getStart1();
        }
        QuickSort.sort(startarr, rarr);
        Vector<Object> newregions = new Vector<Object>();
        for (int i = 0; i < rarr.length; ++i) {
            newregions.addElement(rarr[i]);
        }
        return newregions;
    }

    public static void main(String[] args) {
    }

    private String getLogicalQuerySpecies() {
        return this.logicalQuerySpecies;
    }

    private String getLogicalHitSpecies() {
        return this.logicalHitSpecies;
    }
}

