/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.sample;

import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.NonFatalDataAdapterException;
import apollo.dataadapter.sample.SampleAdapter;
import apollo.datamodel.CurationSet;
import apollo.util.GuiUtil;
import java.awt.GridBagLayout;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.bdgp.io.DataAdapter;
import org.bdgp.io.IOOperation;
import org.bdgp.swing.AbstractDataAdapterUI;

public class SampleAdapterGUI
extends AbstractDataAdapterUI {
    private IOOperation operation;
    private JLabel numberLabel = new JLabel("Number of features : ");
    private JLabel lastChosenLabel = new JLabel("");
    private JTextField numberTextField = new JTextField(10);

    public SampleAdapterGUI(IOOperation operation) {
        this.operation = operation;
        this.buildGUI();
    }

    private void buildGUI() {
        this.setLayout(new GridBagLayout());
        this.add(this.getNumberLabel(), GuiUtil.makeConstraintAt(0, 0, 1));
        this.add(this.getNumberTextField(), GuiUtil.makeConstraintAt(1, 0, 1));
        this.add(this.getLastChosenLabel(), GuiUtil.makeConstraintAt(2, 0, 1));
    }

    public Object doOperation(Object values) throws ApolloAdapterException {
        SampleAdapter adapter = (SampleAdapter)this.getDataAdapter();
        Properties stateInformation = new Properties();
        try {
            if (this.getOperation().equals((Object)ApolloDataAdapterI.OP_READ_DATA)) {
                stateInformation.setProperty("NUMBER_OF_FEATURES", String.valueOf(this.getNumberOfFeatures()));
                adapter.setStateInformation(stateInformation);
                CurationSet set = adapter.getCurationSet();
                return set;
            }
            throw new ApolloAdapterException("This adapter cannot be used to write data");
        }
        catch (NonFatalDataAdapterException exception) {
            throw new ApolloAdapterException(exception.getMessage());
        }
    }

    public void setProperties(Properties input) {
        String lastChosen = null;
        lastChosen = input.getProperty("NUMBER_OF_FEATURES");
        if (lastChosen != null && lastChosen.trim().length() > 0) {
            this.getLastChosenLabel().setText(" ( " + lastChosen + " ) ");
        }
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.setProperty("NUMBER_OF_FEATURES", String.valueOf(this.getNumberOfFeatures()));
        return properties;
    }

    public DataAdapter getDataAdapter() {
        return this.driver;
    }

    private IOOperation getOperation() {
        return this.operation;
    }

    private JLabel getNumberLabel() {
        return this.numberLabel;
    }

    private JLabel getLastChosenLabel() {
        return this.lastChosenLabel;
    }

    private JTextField getNumberTextField() {
        return this.numberTextField;
    }

    private int getNumberOfFeatures() {
        String numberString = this.getNumberTextField().getText();
        int number = 0;
        try {
            number = Integer.valueOf(numberString);
        }
        catch (NumberFormatException exception) {
            throw new NonFatalDataAdapterException("Please enter a valid integer number of features");
        }
        return number;
    }
}

