/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.otter;

import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.otter.OtterAdapter;
import apollo.datamodel.CurationSet;
import apollo.util.GuiUtil;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.bdgp.io.DataAdapter;
import org.bdgp.io.IOOperation;
import org.bdgp.swing.AbstractDataAdapterUI;

public class OtterAdapterGUI
extends AbstractDataAdapterUI {
    protected DataAdapter driver;
    protected IOOperation op;
    private JLabel inputFileLabel;
    private JTextField inputFileField;
    private JLabel outputFileLabel;
    private JTextField outputFileField;
    private Properties props;

    public OtterAdapterGUI(IOOperation op) {
        this.op = op;
        this.inputFileLabel = new JLabel("Otter Input File:");
        this.inputFileField = new JTextField(20);
        this.outputFileLabel = new JLabel("Otter Output File:");
        this.outputFileField = new JTextField(20);
        this.buildGUI();
    }

    public void setProperties(Properties in) {
    }

    public Properties getProperties() {
        return new Properties();
    }

    public void buildGUI() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        internalPanel.add((Component)this.inputFileLabel, GuiUtil.makeConstraintAt(0, 0, 1));
        internalPanel.add((Component)this.inputFileField, GuiUtil.makeConstraintAt(0, 1, 1));
        internalPanel.add((Component)this.outputFileLabel, GuiUtil.makeConstraintAt(1, 0, 1));
        internalPanel.add((Component)this.outputFileField, GuiUtil.makeConstraintAt(1, 1, 1));
        this.add(internalPanel);
    }

    public void setDataAdapter(DataAdapter driver) {
        this.driver = driver;
    }

    public DataAdapter getDataAdapter() {
        return this.driver;
    }

    public Object doOperation(Object values) throws ApolloAdapterException {
        FileOutputStream outputStream;
        File outputFile;
        FileInputStream theInputStream;
        String fileName = this.inputFileField.getText();
        if (fileName == null || fileName.trim().length() <= 0) {
            fileName = "/auto/acari/vvi/src/apollo-current/apollo/src/java/apollo/dataadapter/otter/parser/test4.xml";
        }
        try {
            theInputStream = new FileInputStream(fileName);
        }
        catch (FileNotFoundException theException) {
            throw new ApolloAdapterException("File not found");
        }
        fileName = this.outputFileField.getText();
        if (fileName == null || fileName.trim().length() <= 0) {
            fileName = "/auto/acari/vvi/src/apollo-current/apollo/src/java/apollo/dataadapter/otter/parser/annotation-output.xml";
        }
        if ((outputFile = new File(fileName)).exists()) {
            outputFile.delete();
        }
        try {
            outputFile.createNewFile();
            outputStream = new FileOutputStream(outputFile);
        }
        catch (IOException theException) {
            throw new ApolloAdapterException("problems creating output file", theException);
        }
        ((OtterAdapter)this.getDataAdapter()).setInputStream(theInputStream);
        ((OtterAdapter)this.getDataAdapter()).setOutputStream(outputStream);
        if (this.op.equals((Object)ApolloDataAdapterI.OP_READ_DATA)) {
            CurationSet curationSet = ((ApolloDataAdapterI)this.driver).getCurationSet();
            return curationSet;
        }
        return null;
    }
}

