/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.genbank;

import apollo.dataadapter.genbank.GenbankRead;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class PublicDbFeature {
    private String type;
    private HashMap tagValues = new HashMap(3);
    private StringBuffer location;
    private GenbankRead parent;
    private String active_tag = null;
    private Vector locs = null;
    private static final int key_offset = 5;
    private boolean initialized = false;
    private boolean missing5prime = false;
    private boolean extend3prime = false;
    private boolean extend5prime = false;

    protected PublicDbFeature(GenbankRead parent) {
        this.parent = parent;
    }

    protected String getFeatureType(String current_line) {
        String str = current_line.substring(5);
        int index = str.indexOf(32);
        if (index > 0) {
            this.location = new StringBuffer();
            this.type = str.substring(0, index);
            this.location.append(str.substring(index).trim());
        }
        return this.type;
    }

    protected String getFeatureType() {
        return this.type;
    }

    protected boolean forSameFeature(String current_line) {
        return current_line.charAt(5) == ' ';
    }

    protected boolean addToFeature(String current_line) {
        if (this.forSameFeature(current_line)) {
            String str = current_line.substring(5).trim();
            if (str.charAt(0) != '/' && this.active_tag == null) {
                this.location.append(str);
            } else {
                this.setTagValue(str);
            }
            return true;
        }
        return false;
    }

    protected Vector getValues(String tag) {
        Object vals;
        if (!this.initialized) {
            this.initialized = true;
            this.initSynonyms();
            this.initLocations();
        }
        if ((vals = this.tagValues.get(tag)) != null && vals instanceof Vector) {
            return (Vector)vals;
        }
        return null;
    }

    protected HashMap getTagValues() {
        return this.tagValues;
    }

    protected String getValue(String tag) {
        StringBuffer val = new StringBuffer();
        Vector all_vals = this.getValues(tag);
        if (all_vals != null) {
            int val_count = all_vals.size();
            for (int i = 0; i < val_count; ++i) {
                val.append((String)all_vals.elementAt(i));
                if (i >= val_count - 1) continue;
                val.append(" ");
            }
        }
        return val.toString();
    }

    protected HashMap getDbXrefs() {
        return (HashMap)this.tagValues.get("db_xref");
    }

    protected Vector getSynonyms() {
        return this.getValues("synonyms");
    }

    protected boolean missing5prime() {
        return this.missing5prime;
    }

    protected int getCodonStart() {
        int offset = 0;
        String offset_str = this.getValue("codon_start");
        if (offset_str != null && !offset_str.equals("")) {
            try {
                offset = Integer.parseInt(offset_str);
                --offset;
            }
            catch (Exception e) {
                offset = 0;
            }
        }
        return offset;
    }

    protected void initSynonyms() {
        int index;
        Vector<String> syns = null;
        String note = this.getValue("note");
        int n = index = note != null ? note.indexOf("synonyms:") : -1;
        if (index >= 0) {
            syns = new Vector<String>(1);
            String prefix = note.substring(0, index);
            String syns_str = note.substring(index + "synonyms:".length()).trim();
            String suffix = "";
            int end = syns_str.indexOf(59);
            if (end > 0) {
                syns_str = syns_str.substring(0, end);
                if ((index = note.indexOf(59, index) + 1) < note.length()) {
                    suffix = note.substring(index);
                }
            }
            while (syns_str.length() > 0) {
                String syn;
                end = syns_str.indexOf(44);
                if (end > 0) {
                    syn = syns_str.substring(0, end);
                    syns_str = ++end < syns_str.length() ? syns_str.substring(end) : "";
                } else {
                    syn = syns_str;
                    syns_str = "";
                }
                syns.addElement(syn);
            }
            Vector note_vec = (Vector)this.tagValues.get("note");
            note_vec.removeElementAt(0);
            note_vec.addElement(prefix + suffix);
        }
        if (syns != null) {
            this.tagValues.put("synonyms", syns);
        }
    }

    private void setTagValue(String content) {
        String value;
        String tag;
        String db_tag = null;
        String db_value = null;
        Object synonyms = null;
        if (content.charAt(0) == '/') {
            int index = content.indexOf("=");
            if (index >= 0) {
                tag = content.substring(1, index);
                value = content.substring(index + "=".length());
                index = (value = this.stripQuotes(value)).indexOf(58);
                if (!(index <= 0 || tag.equals("note") || tag.equals("gene") || tag.equals("method") || tag.equals("date") || tag.endsWith("synonym") || tag.equals("product") || tag.equals("prot_desc"))) {
                    if (!tag.equals("db_xref")) {
                        tag = value.substring(0, index);
                        String tmp = value.substring(index + ":".length());
                        System.out.println("setTagValue: changing tag " + tag + " from " + value + " to " + tmp);
                        value = tmp;
                    } else {
                        db_tag = value.substring(0, index);
                        db_value = value.substring(index + ":".length());
                    }
                }
                this.active_tag = tag;
            } else if (content.charAt(0) == '/') {
                tag = content.substring(1);
                value = "true";
            } else {
                tag = this.active_tag;
                value = content;
            }
        } else {
            tag = this.active_tag;
            value = content;
            value = this.stripQuotes(value);
        }
        if (db_tag == null) {
            if (!value.equalsIgnoreCase("unknown")) {
                Vector<String> current_vec = (Vector<String>)this.tagValues.get(tag);
                if (current_vec == null) {
                    current_vec = new Vector<String>();
                    this.tagValues.put(tag, current_vec);
                } else if (content.charAt(0) != '/' || tag.equals("note")) {
                    int i = current_vec.size() - 1;
                    String current_value = (String)current_vec.elementAt(i);
                    current_vec.removeElementAt(i);
                    value = current_value + " " + value;
                }
                if (!value.equals("") && !value.equals(".")) {
                    current_vec.addElement(value);
                }
            }
        } else {
            HashMap<String, String> current_dbs = (HashMap<String, String>)this.tagValues.get(tag);
            if (current_dbs == null) {
                current_dbs = new HashMap<String, String>();
                this.tagValues.put(tag, current_dbs);
            }
            current_dbs.put(db_tag, db_value);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.type + " at " + this.location.toString() + "\n");
        Iterator keys = this.tagValues.keySet().iterator();
        while (keys.hasNext()) {
            String tag = (String)keys.next();
            if (tag.equals("translation") || tag.equals("method") || tag.equals("db_xref")) continue;
            buf.append("\t" + tag + " = " + this.getValue(tag) + "\n");
        }
        return buf.toString();
    }

    private String stripQuotes(String value) {
        if (value.equals("")) {
            return "";
        }
        if (value.charAt(0) == '\"') {
            value = value.substring(1);
        }
        if (value.length() >= 1 && value.charAt(value.length() - 1) == '\"') {
            return value.substring(0, value.length() - 1);
        }
        return value;
    }

    protected Vector getLocation() {
        if (!this.initialized) {
            this.initialized = true;
            this.initSynonyms();
            this.initLocations();
        }
        return this.locs;
    }

    protected void initLocations() {
        this.locs = new Vector();
        this.parseLocations(this.location.toString(), this.locs);
        if (this.extend5prime) {
            this.missing5prime = true;
        }
    }

    private void parseLocations(String location_str, Vector locs) {
        if (location_str != null && !location_str.equals("")) {
            int next_locs;
            String operation_str = null;
            int index_start = 0;
            int index_end = 0;
            if (location_str.startsWith("complement(")) {
                Vector comp_vect = new Vector();
                index_start = "complement(".length();
                index_end = this.indexOfClosingParen(location_str, index_start);
                operation_str = this.substringLocation(location_str, index_start, index_end);
                this.parseLocations(operation_str, comp_vect);
                int cmp_count = comp_vect.size();
                for (int i = cmp_count - 1; i >= 0; --i) {
                    int[] span = (int[])comp_vect.elementAt(i);
                    comp_vect.remove(span);
                    int tmp = span[0];
                    span[0] = span[1];
                    span[1] = tmp;
                    locs.addElement(span);
                }
                if (this.extend3prime) {
                    this.extend5prime = true;
                    this.extend3prime = false;
                } else if (this.extend5prime) {
                    this.extend5prime = false;
                    this.extend3prime = true;
                }
            } else if (location_str.startsWith("join(")) {
                index_start = "join(".length();
                index_end = this.indexOfClosingParen(location_str, index_start);
                operation_str = this.substringLocation(location_str, index_start, index_end);
                this.parseLocations(operation_str, locs);
            } else if (location_str.startsWith("order(")) {
                index_start = "order(".length();
                index_end = this.indexOfClosingParen(location_str, index_start);
                operation_str = this.substringLocation(location_str, index_start, index_end);
                this.parseLocations(operation_str, locs);
            } else if (!Character.isDigit(location_str.charAt(0))) {
                if (location_str.charAt(0) == '<') {
                    this.extend5prime = true;
                    this.parseLocations(location_str.substring(1), locs);
                } else if (location_str.indexOf(58) > 0) {
                    System.out.println("Ignoring indirect location reference in " + location_str);
                    this.parseLocations(location_str.substring(location_str.indexOf(58) + 1), locs);
                } else {
                    this.parseLocations(location_str.substring(1), locs);
                }
            } else {
                index_start = 0;
                index_end = this.indexOfNextNonDigit(location_str, index_start);
                String pos_str = "";
                try {
                    int high;
                    boolean no_high;
                    pos_str = this.substringLocation(location_str, index_start, index_end);
                    int low = Integer.parseInt(pos_str);
                    boolean bl = no_high = index_end < location_str.length() && location_str.charAt(index_end) == ',' || index_end >= location_str.length();
                    if (no_high) {
                        high = low;
                    } else {
                        if (location_str.charAt(index_start = ++index_end) == '>') {
                            this.extend3prime = true;
                            ++index_start;
                        }
                        if (Character.isDigit(location_str.charAt(index_start))) {
                            index_end = this.indexOfNextNonDigit(location_str, index_start);
                            pos_str = this.substringLocation(location_str, index_start, index_end);
                            high = Integer.parseInt(pos_str);
                            if (high != low) {
                                low += (high - low + 1) / 2;
                                high = low + 1;
                            }
                        } else {
                            if (location_str.charAt(++index_start) == '>') {
                                this.extend3prime = true;
                                ++index_start;
                            }
                            index_end = this.indexOfNextNonDigit(location_str, index_start);
                            pos_str = this.substringLocation(location_str, index_start, index_end);
                            high = Integer.parseInt(pos_str);
                        }
                    }
                    int[] pos = new int[]{low, ++high};
                    locs.addElement(pos);
                }
                catch (Exception e) {
                    System.err.println("Unable to parse location from " + pos_str);
                }
            }
            int index_comma = index_end < location_str.length() ? location_str.indexOf(",", index_end) : -1;
            int n = next_locs = index_comma >= 0 ? index_comma + 1 : 0;
            if (next_locs > 0 && next_locs < location_str.length()) {
                this.parseLocations(location_str.substring(next_locs), locs);
            }
        }
    }

    private int indexOfNextNonDigit(String location_str, int index_start) {
        int index_end;
        for (index_end = index_start; index_end < location_str.length() && Character.isDigit(location_str.charAt(index_end)); ++index_end) {
        }
        return index_end;
    }

    private String substringLocation(String location_str, int index_start, int index_end) {
        try {
            return index_end < location_str.length() ? location_str.substring(index_start, index_end) : (index_start < location_str.length() ? location_str.substring(index_start) : location_str);
        }
        catch (Exception e) {
            System.out.println("Could not substring " + location_str + " index_start=" + index_start + " index_end=" + index_end);
            new Throwable().printStackTrace();
            return null;
        }
    }

    private int indexOfClosingParen(String location_str, int index_start) {
        int index_end = index_start;
        int open_paren_count = 1;
        while (index_end < location_str.length() && open_paren_count != 0) {
            if (location_str.charAt(index_end) == ')') {
                --open_paren_count;
            } else if (location_str.charAt(index_end) == '(') {
                ++open_paren_count;
            }
            if (open_paren_count == 0) continue;
            ++index_end;
        }
        return index_end;
    }
}

