/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.genbank;

import apollo.dataadapter.genbank.FeatureValidatorI;
import apollo.datamodel.AnnotatedFeature;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.Comment;
import apollo.datamodel.CurationSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.Transcript;
import java.util.Vector;

public class PeptideValidator
implements FeatureValidatorI {
    private static String[] specials = new String[]{"short CDS OK", "Probable mutation", "computed ORF is questionable", "Probable pseudogene", "Hand edit", "Known mutation", "CDS edit"};

    public String validateFeature(FeatureSetI fs, CurationSet curation, String prefix, String suffix) {
        AnnotatedFeature gene;
        StringBuffer buf = new StringBuffer();
        if (fs instanceof AnnotatedFeature && !this.okaySwissProt(gene = (AnnotatedFeature)fs)) {
            int count = gene.size();
            for (int i = 0; i < count; ++i) {
                Transcript transcript = (Transcript)gene.getFeatureAt(i);
                SequenceI pep = transcript.getPeptideSequence();
                if (pep != null) {
                    if (pep.getLength() <= 50) {
                        buf.append(this.knownProblem(gene, transcript, prefix, " is only " + pep.getLength() + "aa ", suffix));
                    } else {
                        buf.append(this.proportionallyShort(pep, gene, transcript, prefix, suffix));
                    }
                    buf.append(this.validateStart(gene, transcript, pep, prefix, suffix));
                    buf.append(this.validatePepID(gene, transcript, pep, prefix, suffix));
                } else {
                    buf.append(prefix + " peptide not provided " + suffix);
                }
                if (transcript.getEnd() != transcript.getTranslationEnd()) continue;
                buf.append(prefix + " missing stop codon on 3' end " + suffix);
            }
        }
        return buf.toString();
    }

    private String getComment(AnnotatedFeatureI sf, String clue) {
        String text = "";
        clue = clue.toLowerCase();
        Vector comments = sf.getComments();
        for (int i = 0; i < comments.size() && text.equals(""); ++i) {
            Comment comment = (Comment)comments.elementAt(i);
            String tmp = comment.getText().toLowerCase();
            if (tmp.indexOf(clue) < 0) continue;
            text = comment.getText();
        }
        return text;
    }

    private void getAllComments(AnnotatedFeatureI sf, StringBuffer buf) {
        Vector comments = sf.getComments();
        for (int i = 0; i < comments.size(); ++i) {
            Comment comment = (Comment)comments.elementAt(i);
            buf.append(buf.length() > 0 ? "--" : "");
            buf.append(comment.getText());
        }
    }

    private boolean okaySwissProt(AnnotatedFeatureI gene) {
        String sp_comment = gene.getProperty("sp_status");
        boolean match = false;
        if (!sp_comment.equals("")) {
            match = sp_comment.startsWith("Perfect match to ");
        }
        return match;
    }

    private String proportionallyShort(SequenceI pep, AnnotatedFeature gene, Transcript transcript, String prefix, String suffix) {
        int t_length = -1;
        String text = this.getComment(transcript, "dicistronic");
        if (!text.equals("")) {
            int t_count = gene.size();
            int tss = transcript.getTranslationStart();
            int tes = transcript.getTranslationEnd();
            int strand = transcript.getStrand();
            String id = transcript.getId();
            boolean adjusted = false;
            for (int i = 0; i < t_count && !adjusted; ++i) {
                Transcript alt = (Transcript)gene.getFeatureAt(i);
                text = this.getComment(transcript, "monocistronic");
                if (alt.getId().equals(id) || !text.equals("")) continue;
                int alt_tss = alt.getTranslationStart();
                int alt_tes = alt.getTranslationEnd();
                adjusted = true;
                if (strand == 1 && alt_tss < tss || strand == -1 && alt_tss > tss) {
                    int upstream_index = transcript.getIndexContaining(tss);
                    t_length = transcript.getSplicedLength(upstream_index, transcript.size());
                    continue;
                }
                int downstream_index = transcript.getIndexContaining(tes);
                if (downstream_index < transcript.size()) {
                    ++downstream_index;
                }
                t_length = transcript.getSplicedLength(0, downstream_index);
            }
            if (!adjusted) {
                return prefix + " Unpartnered dicistronic transcript " + transcript.getName() + suffix;
            }
        } else {
            text = this.getComment(transcript, "shared first exon");
            if (!text.equals("")) {
                t_length = transcript.getSplicedLength(1, transcript.size());
            }
        }
        if (t_length < 0) {
            t_length = transcript.getSplicedLength();
        }
        int orf_length = pep.getLength() * 3;
        String error_msg = "";
        if ((double)orf_length <= (double)t_length * 0.2) {
            error_msg = this.knownProblem(gene, transcript, prefix, " peptide is " + pep.getLength() + "aa which is only " + orf_length * 100 / t_length + "% of transcript " + t_length + "bp (full-length=" + transcript.getSplicedLength() + ") ", suffix);
        }
        return error_msg;
    }

    private String knownProblem(AnnotatedFeature gene, Transcript transcript, String prefix, String error_msg, String suffix) {
        if (!gene.isProblematic() && !transcript.isProblematic()) {
            String text = "";
            for (int i = 0; i < specials.length && text.equals(""); ++i) {
                text = this.getComment(gene, specials[i]);
                if (!text.equals("")) continue;
                text = this.getComment(transcript, specials[i]);
            }
            if (text.equals("")) {
                StringBuffer buf = new StringBuffer();
                this.getAllComments(gene, buf);
                this.getAllComments(transcript, buf);
                String sp_comment = gene.getProperty("sp_status");
                if (!sp_comment.equals("")) {
                    buf.append(buf.length() > 0 ? "--" : "");
                    buf.append(sp_comment);
                }
                return prefix + error_msg + buf.toString() + suffix;
            }
            return "";
        }
        return "";
    }

    private String validateStart(AnnotatedFeature gene, Transcript transcript, SequenceI pep, String prefix, String suffix) {
        StringBuffer buf = new StringBuffer();
        String clue = "no ATG translation start identified";
        String comment = this.getComment(gene, clue);
        if (comment.equals("")) {
            comment = this.getComment(transcript, clue);
        }
        if (comment.equals("") && (comment = this.getComment(gene, clue = "Unconventional translation start")).equals("")) {
            comment = this.getComment(transcript, clue);
        }
        if (comment.equals("") && pep.getResidues().charAt(0) != 'M') {
            buf.append(prefix + "  " + pep.getResidues().charAt(0) + " is an unusual start codon " + suffix);
        }
        int tss = transcript.getTranslationStart();
        int gap = transcript.getFeaturePosition(tss) - 1;
        if ((gene.isMissing5prime() || transcript.isMissing5prime()) && gap > 2) {
            buf.append(prefix + "  " + transcript.getId() + " 5' partial has TSS at " + tss + " beyond start by " + gap + " bases " + suffix);
        }
        return buf.toString();
    }

    private String validatePepID(AnnotatedFeature gene, Transcript transcript, SequenceI pep, String prefix, String suffix) {
        StringBuffer buf = new StringBuffer();
        String mRNA_name = transcript.get_cDNASequence().getName();
        String pep_name = pep.getName();
        int indexR = mRNA_name.indexOf("-R");
        int indexP = pep_name.indexOf("-P");
        if (indexR < 0) {
            buf.append(prefix + "  " + mRNA_name + " doesn't follow -RA syntax " + suffix);
        } else if (indexP < 0) {
            buf.append(prefix + "  " + pep_name + " doesn't follow -PA syntax " + suffix);
        } else if (mRNA_name.charAt(indexR + 2) != pep_name.charAt(indexP + 2)) {
            buf.append(prefix + " mis-matched suffixes in " + mRNA_name + " and " + pep_name + "  " + suffix);
        } else {
            String rna_prefix = mRNA_name.substring(0, indexR);
            String pep_prefix = pep_name.substring(0, indexP);
            String gene_id = gene.getId();
            if (!gene_id.equals(rna_prefix) || !gene_id.equals(pep_prefix)) {
                buf.append(prefix + " mis-matched IDs gene=" + gene_id + " mRNA=" + mRNA_name + " peptide=" + pep_name + "  " + suffix);
            }
        }
        return buf.toString();
    }
}

