/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.genbank;

import apollo.config.Config;
import apollo.config.OverlapI;
import apollo.dataadapter.genbank.FeatureValidatorI;
import apollo.dataadapter.genbank.PeptideNote;
import apollo.dataadapter.genbank.XrefUtil;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.Comment;
import apollo.datamodel.CurationSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.StrandedFeatureSetI;
import apollo.datamodel.Transcript;
import apollo.seq.io.FastaFile;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.StreamTokenizer;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class GenbankValidator {
    private static boolean DEBUG = false;
    private int gene_cnt;
    private CurationSet curation;
    private Hashtable validator_hash;
    private Hashtable patches_hash;
    private String database = "";
    private String tech = "";
    private String organism = "";
    private String genotype = "";
    private Vector db_xrefs = new Vector(1);
    private static String[] specials = new String[]{"Hand edit", "Known mutation", "trans spliced", "CDS edit"};
    private static String[] GB_exceptions = new String[]{"RNA editing", "reasons given in citation", "ribosomal slippage", "trans splicing", "artificial frameshift", "nonconsensus splice site"};
    private static final String read_through_note1 = "A UGA codon at amino acid position ";
    private static final String read_through_note2 = "is replaced by a selenocysteine allowing read through";
    private static String[] splices = new String[]{"junctions", "aberrant splice", "nonconsensus splice", "non-consensus splice", "no conventional splice", "non conventional splice", "TG splice", "GC splice", "GG splice", "CT splice", "AT/AC splice", "AT-AC splice", "splice donor site postulated", "Unconventional splice supported by ", "GC splice donor site postulated", "Unconventional splice site postulated", "Unconventional splice (CC/CT)", "Unconventional splice donor and acceptor sites", "Unconventional splice site acceptor postulated", "Unconventional GA splice site postulated", "without consensus splice", "doesn't fall at a conserved splice"};

    public boolean setValidationFile(String valid_filename) {
        this.validator_hash = new Hashtable();
        this.patches_hash = new Hashtable();
        File validation_file = null;
        try {
            validation_file = new File(valid_filename);
        }
        catch (Exception e) {
            System.err.println("Error: could not open validation file " + valid_filename + " because: " + e.getMessage());
            return false;
        }
        try {
            StreamTokenizer tokenizer = new StreamTokenizer(new BufferedReader(new FileReader(validation_file)));
            tokenizer.eolIsSignificant(true);
            tokenizer.slashStarComments(true);
            tokenizer.slashSlashComments(true);
            boolean EOF = false;
            int tokType = 0;
            Stack<String> words = new Stack<String>();
            while (!EOF) {
                tokType = tokenizer.nextToken();
                if (tokType == -1) {
                    EOF = true;
                    continue;
                }
                if (tokType != 10) {
                    if (tokenizer.sval == null) continue;
                    words.push(tokenizer.sval);
                    continue;
                }
                if (words.size() == 2) {
                    String class_name = (String)words.pop();
                    String feature_type = (String)words.pop();
                    if (feature_type.equalsIgnoreCase("database")) {
                        this.database = class_name;
                    } else if (feature_type.equalsIgnoreCase("tech")) {
                        this.tech = class_name;
                    } else if (feature_type.equalsIgnoreCase("organism")) {
                        this.organism = class_name;
                    } else if (feature_type.equalsIgnoreCase("genotype")) {
                        this.genotype = class_name;
                    } else if (feature_type.equalsIgnoreCase("db_xref")) {
                        this.db_xrefs.addElement(new XrefUtil(class_name));
                    } else {
                        Vector<FeatureValidatorI> validators = (Vector<FeatureValidatorI>)this.validator_hash.get(feature_type);
                        if (validators == null) {
                            validators = new Vector<FeatureValidatorI>();
                            this.validator_hash.put(feature_type, validators);
                        }
                        try {
                            Class<?> check_class = Class.forName(class_name);
                            if (check_class == null) {
                                System.out.println("GenbankValidator.setValidationFile: unable to create class " + class_name);
                            } else {
                                FeatureValidatorI check = (FeatureValidatorI)check_class.newInstance();
                                validators.add(check);
                            }
                        }
                        catch (Exception e) {
                            System.err.println("GenbankValidator.setValidationFile: couldn't create a " + class_name + " because " + e.toString());
                        }
                    }
                }
                String pep = null;
                if (words.size() == 6) {
                    pep = (String)words.pop();
                }
                if (words.size() == 5) {
                    String note = (String)words.pop();
                    String acc = (String)words.pop();
                    String pep_id = (String)words.pop();
                    String gene_name = (String)words.pop();
                    if (!gene_name.equals("-")) {
                        String key = gene_name + (pep_id.equals("-") ? "" : "::" + pep_id);
                        PeptideNote patch = (PeptideNote)this.patches_hash.get(key);
                        if (patch == null) {
                            patch = new PeptideNote();
                        } else {
                            System.out.println("Hey second patch for " + key);
                        }
                        patch.setGeneName(gene_name);
                        patch.setPeptideId(pep_id);
                        patch.setAccession(acc);
                        patch.setNote(note);
                        patch.setPeptide(pep);
                        this.patches_hash.put(key, patch);
                    }
                } else if (words.size() > 0) {
                    System.out.println("Couldn't parse line in validation file " + valid_filename + ":");
                    while (words.size() > 0) {
                        System.out.print(words.pop() + "\t");
                    }
                    System.out.print("\n");
                }
                words.removeAllElements();
            }
        }
        catch (Exception e) {
            System.err.println("Could not parse validation file " + validation_file + " because: " + e.getMessage());
        }
        return true;
    }

    public String getDatabase() {
        return this.database;
    }

    public Vector getXrefs() {
        return this.db_xrefs;
    }

    public String getTech() {
        return this.tech;
    }

    public String getOrganism() {
        return this.organism;
    }

    public String getGenotype() {
        return this.genotype;
    }

    public void checkCuration(CurationSet curation, DataOutputStream report) {
        this.curation = curation;
        StrandedFeatureSetI annots = curation.getAnnots();
        int annot_count = annots.size();
        try {
            if (annot_count > 0) {
                this.gene_cnt = 0;
                for (int i = 0; i < annot_count; ++i) {
                    AnnotatedFeatureI gene = (AnnotatedFeatureI)annots.getFeatureAt(i);
                    String type = gene.getFeatureType().toLowerCase();
                    if (gene.isProteinCodingGene()) {
                        ++this.gene_cnt;
                    }
                    String prefix = this.getPrefix(gene, type);
                    report.writeBytes(this.checkFeature(gene, type, prefix));
                    report.writeBytes(this.checkFeature(gene, "all", prefix));
                    report.writeBytes(this.checkOverlap(gene, i + 1, annots, prefix));
                    report.writeBytes(this.checkDuplicates(gene, i + 1, annots, prefix));
                }
                report.writeBytes("Found " + this.gene_cnt + " genes\n");
            } else {
                StrandedFeatureSetI results = curation.getResults();
                int result_count = results.size();
                if (result_count > 0) {
                    for (int i = 0; i < result_count; ++i) {
                        FeatureSetI fs = (FeatureSetI)results.getFeatureAt(i);
                        String type = fs.getFeatureType().toLowerCase();
                        String prefix = this.getPrefix(fs, type);
                        report.writeBytes(this.checkFeature(fs, type, prefix));
                    }
                }
            }
        }
        catch (Exception ex) {
            System.err.println("exception writing validation report");
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        try {
            report.close();
        }
        catch (Exception ex) {
            System.err.println("exception closing validation report");
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    protected String checkFeature(FeatureSetI fs, String type, String prefix) {
        Vector validators;
        StringBuffer buf = new StringBuffer();
        if (this.validator_hash != null && (validators = (Vector)this.validator_hash.get(type)) != null) {
            int check_total = validators.size();
            for (int i = 0; i < check_total; ++i) {
                FeatureValidatorI v = (FeatureValidatorI)validators.elementAt(i);
                buf.append(v.validateFeature(fs, this.curation, prefix, "\n"));
            }
        }
        return buf.toString();
    }

    protected boolean sameName(String name, SeqFeatureI test) {
        return name.equals(test.getName()) || name.equals(test.getId());
    }

    protected String sameName(SeqFeatureI sf, SeqFeatureI test, String prefix) {
        if (this.sameName(sf.getName(), test)) {
            return prefix + " has same symbol as " + test.getId() + "," + test.getName() + "\n";
        }
        if (this.sameName(sf.getId(), test)) {
            return prefix + " has same ID as " + test.getId() + "," + test.getName() + "\n";
        }
        return "";
    }

    private String checkDuplicates(AnnotatedFeatureI gene, int begin_index, StrandedFeatureSetI annots, String prefix) {
        StringBuffer buf = new StringBuffer();
        int annot_count = annots.size();
        int trans_count = gene.size();
        boolean duplicate = false;
        for (int i = begin_index; i < annot_count && !duplicate; ++i) {
            AnnotatedFeatureI test = (AnnotatedFeatureI)annots.getFeatureAt(i);
            int test_count = test.size();
            buf.append(this.sameName(gene, test, prefix));
            for (int k = 0; k < test_count && buf.length() == 0; ++k) {
                Transcript test_trans = (Transcript)test.getFeatureAt(k);
                buf.append(this.sameName(gene, test_trans, prefix));
            }
            for (int j = 0; j < trans_count && buf.length() == 0; ++j) {
                Transcript trans = (Transcript)gene.getFeatureAt(j);
                buf.append(this.sameName(trans, test, prefix));
                for (int k = 0; k < test_count && buf.length() == 0; ++k) {
                    Transcript test_trans = (Transcript)test.getFeatureAt(k);
                    buf.append(this.sameName(trans, test_trans, prefix));
                }
            }
        }
        return buf.toString();
    }

    private boolean ignoreTransposons(AnnotatedFeatureI gene) {
        Transcript transcript;
        boolean ignore = !this.getComment(gene, "transposon overlap OK").equals("");
        int transcript_count = gene.size();
        for (int i = 0; i < transcript_count && !ignore; ignore |= !this.getComment(transcript = (Transcript)gene.getFeatureAt(i), "transposon overlap OK").equals(""), ++i) {
        }
        return ignore;
    }

    private String checkOverlap(AnnotatedFeatureI gene, int begin_index, StrandedFeatureSetI annots, String prefix) {
        StringBuffer buf = new StringBuffer();
        OverlapI checker = Config.getOverlapper(gene);
        int annot_count = annots.size();
        boolean ignore_transposon = this.ignoreTransposons(gene);
        boolean is_transposon = gene.getFeatureType().equals("transposable_element");
        int trans_count = gene.size();
        for (int i = begin_index; i < annot_count; ++i) {
            Transcript trans;
            AnnotatedFeatureI test = (AnnotatedFeatureI)annots.getFeatureAt(i);
            boolean test_is_transposon = test.getFeatureType().equals("transposable_element");
            if (ignore_transposon && test_is_transposon || is_transposon && this.ignoreTransposons(test) || !checker.areOverlapping(gene, test)) continue;
            boolean overlap_okay = gene.isProblematic() || !this.getComment(gene, "Shares CDS").equals("");
            for (int j = 0; j < trans_count && !overlap_okay; overlap_okay |= (trans = (Transcript)gene.getFeatureAt(j)).isProblematic() || !this.getComment(trans, "Shares CDS").equals(""), ++j) {
            }
            if (overlap_okay) continue;
            buf.append(prefix + " overlaps " + test.getName() + "\n");
        }
        return buf.toString();
    }

    private String getPrefix(FeatureSetI fs, String type) {
        String prefix = type + " ERROR:  " + fs.getId() + "," + fs.getName() + "," + fs.getProperty("gbunit");
        if (fs instanceof AnnotatedFeatureI) {
            prefix = prefix + "," + ((Transcript)fs.getFeatures().elementAt(0)).getOwner();
        }
        prefix = prefix + "\t";
        return prefix;
    }

    private String getComment(AnnotatedFeatureI sf, String clue) {
        String text = "";
        Vector comments = sf.getComments();
        for (int i = 0; i < comments.size() && text.equals(""); ++i) {
            Comment comment = (Comment)comments.elementAt(i);
            if (comment.getText().indexOf(clue) < 0) continue;
            text = comment.getText();
        }
        return text;
    }

    public String patchPeptideCheck(AnnotatedFeatureI gene, Transcript transcript, String header, DataOutputStream report) {
        SequenceI pep = transcript.getPeptideSequence();
        String key = gene.getName() + "::" + pep.getName();
        PeptideNote patch = (PeptideNote)this.patches_hash.get(key);
        String text = "";
        String gene_text = "";
        for (int i = 0; i < specials.length && text.equals(""); ++i) {
            gene_text = text = this.getComment(gene, specials[i]);
            if (!text.equals("")) continue;
            text = this.getComment(transcript, specials[i]);
        }
        if (!text.equals("")) {
            if (patch == null) {
                String prefix = this.getPrefix(gene, gene.getFeatureType().toLowerCase());
                try {
                    if (!gene_text.equals("") && gene.size() > 1) {
                        report.writeBytes(prefix + transcript.getName() + " will not be submitted " + "\n");
                        return null;
                    }
                    report.writeBytes(prefix + key + " no patch " + text + "\n");
                }
                catch (Exception ex) {
                    System.err.println("exception writing validation report");
                    System.out.println(ex.getMessage());
                    ex.printStackTrace();
                }
            } else {
                pep.setResidues(patch.getPeptide(pep.getResidues()));
            }
        } else if (patch != null) {
            String prefix = this.getPrefix(gene, gene.getFeatureType().toLowerCase());
            try {
                report.writeBytes(prefix + " no comment " + "\n");
            }
            catch (Exception ex) {
                System.err.println("exception writing validation report");
                System.out.println(ex.getMessage());
                ex.printStackTrace();
            }
            pep.setResidues(patch.getPeptide(pep.getResidues()));
        }
        String residues = pep.getResidues();
        String clue = "Unconventional translation start";
        String comment = this.getComment(gene, clue);
        if (comment.equals("")) {
            comment = this.getComment(transcript, clue);
        }
        if (!comment.equals("")) {
            residues = "M" + residues.substring(1);
        }
        return FastaFile.format(header, residues, 50);
    }

    public String addNote(String except, PeptideNote patch) {
        StringBuffer buf = new StringBuffer();
        String note = patch.getNote();
        if (!except.equals(note)) {
            buf.append("\t\t\tnote\t" + note);
            String acc = patch.getAccession();
            if (!acc.equals("") && !acc.equals("-")) {
                buf.append(". Used peptide of " + acc);
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    public int getExceptPos(PeptideNote patch) {
        String note;
        int index;
        int position = 0;
        if (patch != null && (index = (note = patch.getNote()).indexOf("position ")) >= 0) {
            try {
                int end_index = note.indexOf(" ", index += "position ".length());
                String number = end_index >= 0 ? note.substring(index, end_index) : note.substring(index);
                position = Integer.parseInt(number);
            }
            catch (Exception e) {
                System.out.println(patch.getPeptideId() + " couldn't parse out position from " + note);
                position = 0;
            }
        }
        return position;
    }

    protected String getTranslExcept(Transcript transcript, int offset) {
        StringBuffer buf = new StringBuffer();
        int aa_position = transcript.readThroughStopPosition();
        if (aa_position > 0) {
            String aa = "Sec";
            buf.append("\t\t\ttransl_except\t(pos:" + aa_position + ".." + (aa_position + 2 * transcript.getStrand()) + ",aa:" + aa + ")\n");
            int trans_pos = transcript.getFeaturePosition(aa_position);
            buf.append("\t\t\tnote\tA UGA codon at amino acid position " + (trans_pos / 3 + 1) + read_through_note2 + "\n");
        }
        if (transcript.unConventionalStart()) {
            int tss = transcript.getTranslationStart() - offset;
            buf.append("\t\t\ttransl_except\t(pos:" + tss + ".." + (tss + 2 * transcript.getStrand()) + "," + "aa:Met)\n");
        }
        return buf.toString();
    }

    public String getException(Transcript transcript) {
        StringBuffer buf = new StringBuffer();
        if (transcript.isTransSpliced()) {
            buf.append("\t\t\texception\ttrans splicing\n");
        }
        if (transcript.plus1FrameShiftPosition() > 0) {
            buf.append("\t\t\texception\tribosomal slippage plus 1 at " + transcript.plus1FrameShiftPosition() + "\n");
        }
        if (transcript.minus1FrameShiftPosition() > 0) {
            buf.append("\t\t\texception\tribosomal slippage minus 1 at " + transcript.minus1FrameShiftPosition() + "\n");
        }
        if ((transcript.getNonConsensusAcceptorNum() >= 0 || transcript.getNonConsensusDonorNum() >= 0) && transcript.nonConsensusSplicingOkay()) {
            buf.append("\t\t\texception\tnonconsensus splice site\n");
        }
        return buf.toString();
    }
}

