/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.genbank;

import apollo.dataadapter.genbank.PublicDbFeature;
import apollo.datamodel.AnnotatedFeature;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.Comment;
import apollo.datamodel.CurationSet;
import apollo.datamodel.DbXref;
import apollo.datamodel.Exon;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.RangeI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.Sequence;
import apollo.datamodel.SequenceI;
import apollo.datamodel.StrandedFeatureSet;
import apollo.datamodel.StrandedFeatureSetI;
import apollo.datamodel.Transcript;
import apollo.datamodel.seq.GenbankSequence;
import java.io.BufferedReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class GenbankRead {
    private static Hashtable genbank_hash = null;
    private static Vector transcript_id_tags;
    private static Vector annot_id_tags;
    private static Vector annot_name_tags;
    private static Hashtable featureTag_hash;
    static final int BEGINNING_OF_ENTRY = 0;
    static final String BEGINNING_OF_ENTRY_STRING = "ID";
    static final int END_OF_ENTRY = 1;
    static final String END_OF_ENTRY_STRING = "//";
    static final int SEQUENCE = 2;
    static final String SEQUENCE_STRING = "SQ";
    static final int FEATURE = 3;
    static final String FEATURE_STRING = "FT";
    static final int FEATURE_HEADER = 4;
    static final String FEATURE_HEADER_STRING = "FH";
    static final int DEFINITION = 5;
    static final String DEFINITION_STRING = "DE";
    static final int ACCESSION = 6;
    static final String ACCESSION_STRING = "AC";
    static final int ORGANISM = 7;
    static final String ORGANISM_STRING = "OS";
    static final int REF_KEY = 8;
    static final String REF_KEY_STRING = "RK";
    private static final int MISC = 9;
    private static final int max_attempts = 500;
    private static final int EMBL_CONTENT_OFFSET = 5;
    private static final int GENBANK_CONTENT_OFFSET = 12;
    private int content_offset;
    private int line_number = 0;
    private String current_line;
    private String current_content;
    private String current_first_word = "";
    private String current_line_key;
    private int current_line_type;
    private HashMap annots_hash;
    private HashMap trans_hash;
    private boolean curation_range_set;

    public boolean loadCurationSet(CurationSet curation, BufferedReader input) {
        boolean success;
        int attempts = 0;
        this.line_number = 0;
        this.current_line_type = -1;
        String first_line = null;
        this.getCurrentInput(input);
        while (attempts++ < 500 && first_line == null) {
            if (this.current_line == null) {
                attempts = 500;
                continue;
            }
            int index = this.current_line.indexOf("LOCUS       ");
            if (index < 0) {
                index = this.current_line.indexOf("ID   ");
            }
            if (index >= 0) {
                this.current_line = first_line = this.current_line.substring(index);
                this.current_line_type = this.getLineType(this.current_line);
                this.current_content = this.getRestOfLine(this.current_line, this.content_offset);
                continue;
            }
            this.getCurrentInput(input);
        }
        boolean bl = success = first_line != null;
        if (success && (success &= this.beginEntry(curation) != null)) {
            GenbankSequence seq = (GenbankSequence)curation.getRefSequence();
            seq.addProperty("LOCUS", this.current_line + "\n");
            success &= this.readAbout(curation, input);
        }
        if (!success) {
            System.out.println("GenBank read failed");
        }
        return success;
    }

    private boolean readAbout(CurationSet curation, BufferedReader input) {
        boolean done = false;
        GenbankSequence seq = (GenbankSequence)curation.getRefSequence();
        this.getCurrentInput(input);
        block10: while (this.current_line != null && !done) {
            if (!this.isEMBL() && !this.current_first_word.equals("")) {
                seq.addProperty(this.current_first_word, this.current_line + "\n");
            }
            switch (this.current_line_type) {
                case 1: {
                    this.addAnnotations(curation.getAnnots());
                    done = true;
                    continue block10;
                }
                case 2: {
                    this.readSequence(curation, input);
                    continue block10;
                }
                case 3: 
                case 4: {
                    this.readFeature(curation, input);
                    continue block10;
                }
                case 5: {
                    if (seq.getDescription() != null) {
                        seq.setDescription(seq.getDescription() + " " + this.current_content);
                    } else {
                        seq.setDescription(this.current_content);
                    }
                    this.getCurrentInput(input);
                    continue block10;
                }
                case 6: {
                    int index = this.current_content.indexOf(59);
                    if (index < 0) {
                        index = this.current_content.indexOf(32);
                    }
                    if (index < 0) {
                        seq.setAccessionNo(this.current_content);
                    } else {
                        seq.setAccessionNo(this.current_content.substring(0, index));
                    }
                    this.getCurrentInput(input);
                    continue block10;
                }
                case 7: {
                    seq.setOrganism(this.current_content);
                    this.getCurrentInput(input);
                    continue block10;
                }
                case 8: {
                    String id;
                    String db;
                    int index;
                    if (this.isEMBL()) {
                        this.erasePeriod();
                        index = this.current_content.indexOf("; ");
                        db = this.current_content.substring(0, index);
                        id = this.current_content.substring(index + 2);
                    } else {
                        index = this.current_line.indexOf(" ");
                        db = this.current_line.substring(0, index);
                        id = this.current_content;
                    }
                    seq.addDbXref(db, id);
                    this.getCurrentInput(input);
                    continue block10;
                }
                case 9: {
                    if (!this.current_content.equals(".") && this.isEMBL()) {
                        seq.addProperty(this.current_line_key, this.current_content);
                    }
                    this.getCurrentInput(input);
                    continue block10;
                }
            }
            System.out.println("GenbankRead: forgot to deal with line type \"" + this.current_line_type + "\" (current content = " + this.current_content + ")");
            return false;
        }
        if (this.current_line_type != 1) {
            System.out.println("GenbankRead: didn't find end of record (//) but saving annotations anyway.");
            this.addAnnotations(curation.getAnnots());
        }
        return true;
    }

    private void getCurrentInput(BufferedReader input) {
        this.current_line = this.readLineFromInput(input);
        if (this.current_line != null) {
            boolean within_html = true;
            while (within_html) {
                int html1 = this.current_line.indexOf("<");
                int html2 = this.current_line.indexOf(">") + 1;
                within_html = html1 >= 0 && html2 > 0 && html2 > html1;
                if (!(within_html = within_html && this.current_line.indexOf("   gene   ") < 0 && this.current_line.indexOf("   mRNA   ") < 0)) continue;
                String prefix = this.current_line.substring(0, html1);
                String suffix = html2 < this.current_line.length() ? this.current_line.substring(html2) : "";
                this.current_line = prefix + suffix;
            }
            this.current_line = this.replaceInString(this.current_line, "&gt;", ">");
            this.current_line = this.replaceInString(this.current_line, "&lt;", "<");
            this.current_line_type = this.getLineType(this.current_line);
            this.current_content = this.getRestOfLine(this.current_line, this.content_offset);
        }
    }

    private String readLineFromInput(BufferedReader input) {
        ++this.line_number;
        try {
            return input.readLine();
        }
        catch (Exception e) {
            System.out.println("Unable to read line " + this.line_number);
            return null;
        }
    }

    private String replaceInString(String current_line, String get_out, String put_in) {
        boolean seeking = true;
        while (seeking) {
            int sgml = current_line.indexOf(get_out);
            seeking = sgml >= 0;
            if (!seeking) continue;
            String prefix = current_line.substring(0, sgml);
            int index = sgml + get_out.length();
            String suffix = index < current_line.length() ? current_line.substring(index) : "";
            current_line = prefix + put_in + suffix;
        }
        return current_line;
    }

    public int getLineType(String line) {
        String line_key = null;
        if (line.length() >= 2 && (line.charAt(0) == '/' || Character.isLetter(line.charAt(0))) && (line.charAt(1) == '/' || Character.isLetter(line.charAt(1))) && (line.length() == 2 || line.length() == 3 && line.endsWith(" ") || line.length() == 4 && line.endsWith("  ") || line.length() >= 5 && line.substring(2, 5).equals("   "))) {
            line_key = line.substring(0, 2);
            this.content_offset = 5;
        } else if (line.length() > 0) {
            if (Character.isLetter(line.charAt(0))) {
                int first_space = line.indexOf(32);
                if (first_space == -1) {
                    line_key = (String)genbank_hash.get(line);
                } else {
                    String first_word = line.substring(0, first_space);
                    if (!first_word.equals("")) {
                        this.current_first_word = first_word;
                    }
                    line_key = (String)genbank_hash.get(first_word);
                }
                if (line_key != null) {
                    this.content_offset = 12;
                }
            } else if (12 < line.length()) {
                String sub_key = line.substring(0, 12).trim();
                line_key = (String)genbank_hash.get(sub_key);
            }
        }
        if (line_key != null) {
            this.current_line_key = line_key;
            if (line_key.startsWith(BEGINNING_OF_ENTRY_STRING)) {
                return 0;
            }
            if (line_key.startsWith(ORGANISM_STRING)) {
                return 7;
            }
            if (line_key.startsWith(END_OF_ENTRY_STRING)) {
                return 1;
            }
            if (line_key.startsWith(SEQUENCE_STRING)) {
                return 2;
            }
            if (line_key.startsWith(FEATURE_HEADER_STRING)) {
                return 4;
            }
            if (line_key.startsWith(FEATURE_STRING)) {
                return 3;
            }
            if (line_key.startsWith(DEFINITION_STRING)) {
                return 5;
            }
            if (line_key.startsWith(ACCESSION_STRING)) {
                return 6;
            }
            return 9;
        }
        return this.current_line_type;
    }

    private String getRestOfLine(String line, int content_offset) {
        if (line.length() > content_offset) {
            return line.substring(content_offset).trim();
        }
        return "";
    }

    private void addSynonyms(AnnotatedFeatureI annot, Vector synonyms) {
        if (synonyms != null) {
            for (int i = 0; i < synonyms.size(); ++i) {
                String syn = (String)synonyms.elementAt(i);
                annot.addSynonym(syn);
            }
        }
    }

    private void addDbXref(AnnotatedFeatureI annot, HashMap db_xrefs) {
        if (db_xrefs != null) {
            Iterator keys = db_xrefs.keySet().iterator();
            while (keys.hasNext()) {
                String db = (String)keys.next();
                String id = (String)db_xrefs.get(db);
                annot.addDbXref(new DbXref("id", id, db));
            }
        }
    }

    private void addDbXref(SequenceI seq, HashMap db_xrefs) {
        if (db_xrefs != null) {
            Iterator keys = db_xrefs.keySet().iterator();
            while (keys.hasNext()) {
                String db = (String)keys.next();
                String id = (String)db_xrefs.get(db);
                seq.addDbXref(db, id);
            }
        }
    }

    private void setDescription(CurationSet curation, GenbankSequence seq, PublicDbFeature pub_feat) {
        HashMap tagValues = pub_feat.getTagValues();
        Iterator keys = tagValues.keySet().iterator();
        while (keys.hasNext()) {
            String tag = (String)keys.next();
            String value = pub_feat.getValue(tag);
            if (value == null || value.equals("")) continue;
            if (tag.equals("chromosome")) {
                curation.setChromosome(value);
                continue;
            }
            if (tag.equals("organism")) {
                seq.setOrganism(value);
                continue;
            }
            seq.setDescription(seq.getDescription() + " " + value);
            seq.addProperty(tag, value);
        }
        this.addDbXref(seq, pub_feat.getDbXrefs());
    }

    private void setDescription(AnnotatedFeatureI af, PublicDbFeature pub_feat) {
        HashMap tagValues = pub_feat.getTagValues();
        Iterator keys = tagValues.keySet().iterator();
        while (keys.hasNext()) {
            Transcript transcript;
            String value;
            String tag = (String)keys.next();
            if (tag.equals("gene") || tag.equals("db_xref") || (value = pub_feat.getValue(tag)) == null || value.equals("") || value.equals(af.getName()) || value.equals(af.getId())) continue;
            if (tag.equals("map")) {
                tag = "cyto_range";
            }
            if (tag.equals("note")) {
                Comment comment = new Comment();
                comment.setText(value);
                af.addComment(comment);
                continue;
            }
            af.addProperty(tag, value);
            if (tag.equals("codon_start") && af instanceof Transcript) {
                transcript = (Transcript)af;
                try {
                    transcript.setTranslationStart(transcript.getTranslationStart() + (Integer.parseInt(value) - 1));
                    transcript.setPeptideValidity(true);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!tag.equals("translation") || !(af instanceof Transcript)) continue;
            transcript = (Transcript)af;
            String seq_id = af.getProperty(af.getProperty(transcript.getProperty("prot_desc")));
            if (seq_id == null) {
                seq_id = af.getProperty("gene") + " sequence";
            }
            if (value.indexOf("\"") > 0) {
                value = value.substring(0, value.indexOf("\""));
            }
            Sequence seq = new Sequence(seq_id, value);
            seq.setResidueType("AA");
            transcript.setPeptideSequence(seq);
            transcript.setPeptideValidity(true);
        }
        this.addDbXref(af, pub_feat.getDbXrefs());
        this.addSynonyms(af, pub_feat.getSynonyms());
    }

    private void setLocation(RangeI sf, Vector locs) {
        int loc_count = locs.size();
        if (sf instanceof Transcript) {
            Transcript transcript = (Transcript)sf;
            for (int i = 0; i < loc_count; ++i) {
                int[] loc = (int[])locs.elementAt(i);
                Exon exon = new Exon();
                int strand = loc[0] > loc[1] ? -1 : 1;
                exon.setStrand(strand);
                exon.setStart(loc[0]);
                exon.setEnd(loc[1]);
                if (transcript.getStrand() != strand) {
                    transcript.setStrand(strand);
                }
                transcript.addExon(exon);
            }
        } else {
            if (loc_count != 1) {
                System.out.println("Odd, " + loc_count + " locs parsed");
            }
            if (loc_count == 0) {
                return;
            }
            int[] loc = (int[])locs.elementAt(0);
            int strand = loc[0] > loc[1] ? -1 : 1;
            sf.setStrand(strand);
            sf.setStart(loc[0]);
            sf.setEnd(loc[1]);
        }
    }

    private void addTranslationStart(FeatureSetI fs, PublicDbFeature pub_feat) {
        Vector locs = pub_feat.getLocation();
        if (locs.size() > 0 && !pub_feat.missing5prime()) {
            int[] loc = (int[])locs.elementAt(0);
            int strand = loc[0] > loc[1] ? -1 : 1;
            int tss = 0;
            if (strand == -1) {
                int loc_count = locs.size();
                for (int i = 0; i < loc_count; ++i) {
                    loc = (int[])locs.elementAt(i);
                    if (loc[0] <= tss) continue;
                    tss = loc[0];
                }
            } else {
                tss = loc[0];
            }
            fs.setTranslationStart(tss += pub_feat.getCodonStart() * fs.getStrand(), false);
        }
    }

    private void readFeature(CurationSet curation, BufferedReader input) {
        GenbankSequence seq = (GenbankSequence)curation.getRefSequence();
        StrandedFeatureSet annotations = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
        annotations.setName("Annotations");
        annotations.setFeatureType("Annotation");
        annotations.setRefSequence(curation.getRefSequence());
        curation.setAnnots(annotations);
        StrandedFeatureSet results = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
        results.setRefSequence(curation.getRefSequence());
        curation.setResults(results);
        while (this.current_line != null && this.current_line_type != 3) {
            this.getCurrentInput(input);
        }
        while (this.current_line != null && this.current_line_type == 3) {
            PublicDbFeature current_feature = new PublicDbFeature(this);
            String key = current_feature.getFeatureType(this.current_line);
            this.getCurrentInput(input);
            while (this.current_line != null && this.current_line_type == 3 && current_feature.addToFeature(this.current_line)) {
                this.getCurrentInput(input);
            }
            if (key == null) {
                System.out.println("GenBank read error: no key in line " + this.current_line);
                continue;
            }
            if (key.equals("source")) {
                if (!this.curation_range_set) {
                    this.setLocation(curation, current_feature.getLocation());
                    this.setDescription(curation, seq, current_feature);
                    this.curation_range_set = true;
                    continue;
                }
                System.out.println("Got 'source' key, but curation range is not set--this should be treated as a clone. (?)");
                continue;
            }
            if (key.equals("gene") || key.equals("locus_tag")) {
                AnnotatedFeatureI annotation = this.buildAnnotation(current_feature);
                this.setLocation(annotation, current_feature.getLocation());
                this.setDescription(annotation, current_feature);
                continue;
            }
            if (key.equals("mRNA") || key.equals("rRNA") || key.equals("tRNA") || key.equals("scRNA") || key.equals("snRNA") || key.equals("snoRNA")) {
                Transcript fs = this.buildTranscript(current_feature);
                AnnotatedFeatureI annot = (AnnotatedFeatureI)fs.getRefFeature();
                String value = current_feature.getValue("gene");
                if (value != null && !value.equals("")) {
                    annot.setName(value);
                }
                if (!key.equals("mRNA")) {
                    annot.setFeatureType(key);
                }
                this.setDescription(fs, current_feature);
                continue;
            }
            if (key.equals("CDS")) {
                this.setTranscriptCDS(current_feature);
                continue;
            }
            if (key.equals("repeat_region") || key.equals("repeat_unit") || key.equals("LTR") || key.equals("satellite")) {
                this.setTransposon(current_feature, key);
                continue;
            }
            if (key.equals("misc_feature")) {
                this.setGeneric(current_feature, "miscellaneous curator's observation");
                continue;
            }
            if (!(key.equals("variation") || key.equals("intron") || key.equals("exon") || key.equals("polyA_site"))) {
                this.setGeneric(current_feature, key);
                continue;
            }
            System.out.println("GenbankRead: still not dealing with " + key + " features; next line is " + this.line_number);
        }
    }

    private void readSequence(CurationSet curation, BufferedReader input) {
        SequenceI seq = curation.getRefSequence();
        this.getCurrentInput(input);
        StringBuffer sequence_buffer = new StringBuffer(seq.getLength());
        while (this.current_line != null && this.current_line.length() > 0 && this.current_line_type == 2) {
            if (this.current_line.charAt(0) == ' ') {
                String seq_str;
                if (this.isEMBL()) {
                    int index = this.current_line.lastIndexOf(32);
                    seq_str = this.current_line.substring(0, index).trim();
                } else {
                    seq_str = this.current_line.substring(10);
                }
                for (int i = 0; i < seq_str.length(); ++i) {
                    char this_char = seq_str.charAt(i);
                    if (Character.isLetter(this_char) || this_char == '.' || this_char == '-' || this_char == '*') {
                        sequence_buffer.append(this_char);
                        continue;
                    }
                    if (Character.isSpaceChar(this_char)) continue;
                    System.err.println("Sequence file contains a character that is not a letter: " + this_char + " in line " + this.line_number);
                }
            }
            this.getCurrentInput(input);
        }
        seq.setResidues(sequence_buffer.toString());
    }

    private boolean isEMBL() {
        return this.content_offset == 5;
    }

    private void erasePeriod() {
        this.current_content = this.current_content.replace('.', ' ').trim();
    }

    private SequenceI beginEntry(CurationSet curation) {
        this.annots_hash = new HashMap();
        this.trans_hash = new HashMap();
        this.curation_range_set = false;
        GenbankSequence seq = null;
        if (!this.current_content.equals("")) {
            this.current_content = this.current_content.replace('.', ' ').trim();
            int index = this.current_content.indexOf(" ");
            String seq_id = index > 0 ? this.current_content.substring(0, index) : this.current_content;
            seq = new GenbankSequence(seq_id, "");
            String key = this.isEMBL() ? " BP" : " bp";
            index = this.current_content.indexOf(key);
            if (index > 0) {
                String str = this.current_content.substring(0, index);
                String prefix = "";
                String suffix = index < this.current_content.length() ? this.current_content.substring(index) : "";
                index = str.lastIndexOf(32);
                if (index > 0) {
                    prefix = str.substring(0, index);
                    str = str.substring(index);
                }
                try {
                    int length = Integer.parseInt(str.trim());
                    seq.setLength(length);
                    seq.setHeader(prefix + suffix);
                }
                catch (Exception e) {
                    System.err.println("Unable to parse length from " + this.current_content + " from \"" + str + "\"");
                }
            }
            if (this.current_content.indexOf("DNA") > 0) {
                seq.setResidueType("DNA");
            } else if (this.current_content.indexOf("RNA") > 0) {
                seq.setResidueType("RNA");
            } else {
                System.out.println("GenbankRead: couldn't parse residue type from " + this.current_content);
            }
            curation.addSequence(seq);
            curation.setRefSequence(seq);
            curation.setName(seq.getName());
        }
        return seq;
    }

    private AnnotatedFeatureI buildAnnotation(PublicDbFeature pub_feat) {
        AnnotatedFeature annotation = new AnnotatedFeature();
        String id = this.getAnnotationId(pub_feat);
        String name = this.getAnnotationName(pub_feat);
        if (id == null || id.equals("")) {
            id = pub_feat.getValue("protein_id");
        }
        if (id == null || id.equals("")) {
            id = pub_feat.getFeatureType() + (this.annots_hash.size() + 1);
        }
        if (name == null || name.equals("")) {
            name = id;
        }
        annotation.setId(id);
        annotation.setName(name);
        if (!pub_feat.getValue("pseudo").equals("")) {
            annotation.setFeatureType("pseudogene");
        }
        this.annots_hash.put(id, annotation);
        return annotation;
    }

    private Transcript buildTranscript(PublicDbFeature pub_feat) {
        Transcript trans = new Transcript();
        this.setLocation(trans, pub_feat.getLocation());
        return this.buildTranscript(pub_feat, trans);
    }

    private Transcript buildTranscript(PublicDbFeature pub_feat, Transcript transcript) {
        AnnotatedFeatureI annotation = this.getAnnotation(pub_feat, true);
        String id = this.getTranscriptId(pub_feat);
        if (id == null || id.equals("")) {
            id = annotation.getId();
        }
        transcript.setId(id);
        transcript.setName(id);
        transcript.setMissing5prime(pub_feat.missing5prime());
        this.trans_hash.put(id, transcript);
        if (annotation.getStrand() != transcript.getStrand()) {
            annotation.setStrand(transcript.getStrand());
        }
        if (!pub_feat.getValue("pseudo").equals("")) {
            annotation.setFeatureType("pseudogene");
        }
        annotation.addFeature(transcript, true);
        return transcript;
    }

    private AnnotatedFeatureI getFeatureById(PublicDbFeature pub_feat, Vector id_tags, HashMap feature_hash) {
        AnnotatedFeatureI af = null;
        for (int i = 0; i < id_tags.size() && af == null; ++i) {
            String tag = (String)id_tags.elementAt(i);
            String id = pub_feat.getValue(tag);
            af = id != null && !id.equals("") ? (AnnotatedFeatureI)feature_hash.get(id) : null;
        }
        return af;
    }

    private AnnotatedFeatureI getAnnotation(PublicDbFeature pub_feat, boolean build) {
        AnnotatedFeatureI annotation = this.getFeatureById(pub_feat, annot_id_tags, this.annots_hash);
        if (annotation == null) {
            annotation = this.getFeatureById(pub_feat, annot_name_tags, this.annots_hash);
        }
        if (annotation == null) {
            if (build) {
                annotation = this.buildAnnotation(pub_feat);
            } else {
                String name = pub_feat.getValue("gene");
                if (name != null && !name.equals("")) {
                    Iterator keys = this.annots_hash.keySet().iterator();
                    while (keys.hasNext() && annotation == null) {
                        String id = (String)keys.next();
                        AnnotatedFeatureI af = (AnnotatedFeatureI)this.annots_hash.get(id);
                        annotation = af.getName().equals(name) ? af : null;
                    }
                }
            }
        }
        return annotation;
    }

    private Vector getContainingTranscripts(AnnotatedFeatureI fs) {
        Vector<AnnotatedFeatureI> trans = new Vector<AnnotatedFeatureI>();
        Iterator keys = this.trans_hash.keySet().iterator();
        while (keys.hasNext()) {
            int fs_end_index;
            int af_end_index;
            int af_start_index;
            String id = (String)keys.next();
            AnnotatedFeatureI af = (AnnotatedFeatureI)this.trans_hash.get(id);
            if (!af.isProteinCodingGene() || af.getTranslationStart() != 0 || !af.contains(fs) || (af_start_index = af.getIndexContaining(fs.getStart())) < 0 || (af_end_index = af.getIndexContaining(fs.getEnd())) != (fs_end_index = fs.size() - 1) + af_start_index) continue;
            boolean matches = true;
            for (int j = 0; j <= fs_end_index && matches; ++j) {
                SeqFeatureI af_sf = af.getFeatureAt(af_start_index + j);
                SeqFeatureI fs_sf = fs.getFeatureAt(j);
                if (af_sf == null || fs_sf == null) {
                    System.out.println("Checking annotation at index " + (af_start_index + j) + " for match to " + j + " sizes are " + af.size() + " and " + fs.size());
                }
                if (j == 0 && j == fs_end_index) {
                    matches &= af_sf.contains(fs_sf);
                    continue;
                }
                if (j == 0) {
                    matches &= af_sf.getEnd() == fs_sf.getEnd();
                    continue;
                }
                if (j == fs_end_index) {
                    matches &= af_sf.getStart() == fs_sf.getStart();
                    continue;
                }
                matches &= af_sf.isExactOverlap(fs_sf);
            }
            if (!matches) continue;
            trans.addElement(af);
        }
        return trans;
    }

    private AnnotatedFeatureI findSame(AnnotatedFeatureI fs, HashMap feat_hash) {
        Iterator keys = feat_hash.keySet().iterator();
        AnnotatedFeatureI same = null;
        while (keys.hasNext() && same == null) {
            String id = (String)keys.next();
            AnnotatedFeatureI current_fs = (AnnotatedFeatureI)feat_hash.get(id);
            if (!this.areSameLocation(fs, current_fs)) continue;
            same = current_fs;
        }
        return same;
    }

    private String getFeatureId(PublicDbFeature pub_feat, Vector tags, boolean debug) {
        String id = "";
        for (int i = 0; i < tags.size() && (id == null || id.equals("")); ++i) {
            String tag = (String)tags.elementAt(i);
            id = pub_feat.getValue(tag);
            if (!debug) continue;
            System.out.println(tag + " is \"" + id + "\"");
        }
        return id;
    }

    private String getTranscriptId(PublicDbFeature pub_feat) {
        return this.getFeatureId(pub_feat, transcript_id_tags, false);
    }

    private String getAnnotationId(PublicDbFeature pub_feat) {
        String id = this.getFeatureId(pub_feat, annot_id_tags, false);
        if (id == null || id.equals("")) {
            id = this.getFeatureId(pub_feat, annot_name_tags, false);
        }
        return id;
    }

    private String getAnnotationName(PublicDbFeature pub_feat) {
        return this.getFeatureId(pub_feat, annot_name_tags, false);
    }

    private AnnotatedFeatureI getTranscript(PublicDbFeature pub_feat) {
        Transcript trial_fs = new Transcript();
        this.setLocation(trial_fs, pub_feat.getLocation());
        return this.getTranscript(pub_feat, trial_fs);
    }

    private AnnotatedFeatureI getTranscript(PublicDbFeature pub_feat, Transcript trial_fs) {
        AnnotatedFeatureI af;
        AnnotatedFeatureI transcript = this.getFeatureById(pub_feat, transcript_id_tags, this.trans_hash);
        if (transcript == null && (af = this.getAnnotation(pub_feat, false)) != null) {
            for (int i = 0; i < af.size() && transcript == null; ++i) {
                AnnotatedFeatureI fs = (AnnotatedFeatureI)af.getFeatureAt(i);
                transcript = this.findSame(fs, this.trans_hash);
            }
        }
        if (transcript == null) {
            transcript = this.buildTranscript(pub_feat, trial_fs);
        }
        return transcript;
    }

    private void setTranscriptCDS(PublicDbFeature pub_feat) {
        if (pub_feat.getValue("transl_table") != null && !pub_feat.getValue("transl_table").equals("")) {
            System.out.println("Warning: CDS " + pub_feat.getValue("product") + " uses alternative translation table (" + pub_feat.getValue("transl_table") + ")\n Can't yet deal with alternative translation tables--not loading this CDS.");
            return;
        }
        Transcript trial_cds = new Transcript();
        this.setLocation(trial_cds, pub_feat.getLocation());
        Vector trans = this.getContainingTranscripts(trial_cds);
        Vector vals = pub_feat.getValues("product");
        if (vals != null && vals.size() > 0) {
            for (int i = vals.size() - 1; i >= 0; --i) {
                AnnotatedFeatureI fs = null;
                String hope = (String)vals.elementAt(i);
                int index = hope.indexOf("-P");
                if (index >= 0) {
                    String id = hope.substring(0, index) + "-R" + hope.substring(index + "-P".length());
                    fs = (AnnotatedFeatureI)this.trans_hash.get(id);
                }
                if (fs == null) {
                    if (trans.size() > 0) {
                        fs = (AnnotatedFeatureI)trans.elementAt(0);
                        trans.removeElementAt(0);
                    } else {
                        fs = this.buildTranscript(pub_feat);
                    }
                } else {
                    trans.removeElement(fs);
                }
                this.buildCDS(fs, pub_feat);
                vals.removeElement(hope);
            }
        } else {
            AnnotatedFeatureI fs = trans.size() > 0 ? (AnnotatedFeatureI)trans.elementAt(0) : this.buildTranscript(pub_feat, trial_cds);
            this.buildCDS(fs, pub_feat);
        }
    }

    private void buildCDS(AnnotatedFeatureI fs, PublicDbFeature pub_feat) {
        this.addTranslationStart(fs, pub_feat);
        this.setDescription(fs, pub_feat);
    }

    private void setTransposon(PublicDbFeature pub_feat, String key) {
        AnnotatedFeatureI af;
        Transcript trial_fs = new Transcript();
        String type = null;
        this.setLocation(trial_fs, pub_feat.getLocation());
        AnnotatedFeatureI transposon = this.findSame(trial_fs, this.trans_hash);
        if (transposon == null) {
            String id;
            transposon = trial_fs;
            af = this.findSame(transposon, this.annots_hash);
            if (af == null) {
                af = this.buildAnnotation(pub_feat);
            }
            if ((id = pub_feat.getValue("transposon")) == null || id.equals("")) {
                id = af.getId();
                type = pub_feat.getValue("rpt_type");
                if (type == null || type.equals("")) {
                    type = key;
                }
            } else {
                type = "transposable_element";
            }
            transposon.setId(id);
            transposon.setName(id);
            this.setDescription(af, pub_feat);
            this.trans_hash.put(id, transposon);
            if (af.getStrand() != transposon.getStrand()) {
                af.setStrand(transposon.getStrand());
            }
            af.addFeature(transposon, true);
        } else {
            af = (AnnotatedFeatureI)transposon.getRefFeature();
        }
        af.setFeatureType(type);
        if (af.getName().equals(af.getId())) {
            af.setName(transposon.getName());
        }
        this.setDescription(transposon, pub_feat);
    }

    private void setGeneric(PublicDbFeature pub_feat, String type) {
        Transcript trial_fs = new Transcript();
        this.setLocation(trial_fs, pub_feat.getLocation());
        AnnotatedFeatureI fs = this.findSame(trial_fs, this.trans_hash);
        if (fs == null) {
            fs = this.getTranscript(pub_feat, trial_fs);
        }
        AnnotatedFeatureI af = (AnnotatedFeatureI)fs.getRefFeature();
        af.setFeatureType(type);
        fs.setName(af.getName());
        this.setDescription(fs, pub_feat);
    }

    private void setTranslationEnds(AnnotatedFeatureI gene) {
        Vector transcripts = gene.getFeatures();
        int trans_cnt = transcripts.size();
        for (int i = 0; i < trans_cnt; ++i) {
            Transcript fs = (Transcript)transcripts.elementAt(i);
            int tss = fs.getTranslationStart();
            if (tss > 0) {
                fs.setTranslationStart(tss, true);
                int start = fs.getStart();
                if (!fs.unConventionalStart() || tss != start && tss != start + fs.getStrand() && tss != start + 2 * fs.getStrand()) continue;
                fs.calcTranslationStartForLongestPeptide();
                continue;
            }
            fs.calcTranslationStartForLongestPeptide();
        }
    }

    private void addAnnotations(StrandedFeatureSetI annotations) {
        if (this.annots_hash != null) {
            Iterator keys = this.annots_hash.keySet().iterator();
            while (keys.hasNext()) {
                String id = (String)keys.next();
                AnnotatedFeatureI annot = (AnnotatedFeatureI)this.annots_hash.get(id);
                if (annot.size() > 0) {
                    annotations.addFeature(annot);
                    if (!annot.isProteinCodingGene()) continue;
                    this.setTranslationEnds(annot);
                    continue;
                }
                AnnotatedFeatureI af = (AnnotatedFeatureI)this.annots_hash.get("no_name");
                if (af == null || !af.overlaps(annot)) continue;
                af.setName(annot.getName());
                af.setId(annot.getId());
            }
        }
    }

    public boolean areSameLocation(SeqFeatureI sa, SeqFeatureI sb) {
        boolean overlap = false;
        if (sb.canHaveChildren() && sb.getNumberOfChildren() > 0) {
            FeatureSetI fb = (FeatureSetI)sb;
            for (int i = 0; i < fb.size() && !overlap; ++i) {
                overlap = this.areSameLocation(sa, fb.getFeatureAt(i));
            }
        } else if (sa.canHaveChildren() && sa.getNumberOfChildren() > 0) {
            FeatureSetI fa = (FeatureSetI)sa;
            for (int i = 0; i < fa.size() && !overlap; ++i) {
                overlap = this.areSameLocation(fa.getFeatureAt(i), sb);
            }
        } else if (sa.overlaps(sb)) {
            overlap = sa.isExactOverlap(sb);
        }
        return overlap;
    }

    static {
        genbank_hash = new Hashtable();
        genbank_hash.put("LOCUS", BEGINNING_OF_ENTRY_STRING);
        genbank_hash.put("DEFINITION", DEFINITION_STRING);
        genbank_hash.put("ACCESSION", ACCESSION_STRING);
        genbank_hash.put("NID", "NID");
        genbank_hash.put("VERSION", "DT");
        genbank_hash.put("KEYWORDS", "KW");
        genbank_hash.put("SOURCE", ORGANISM_STRING);
        genbank_hash.put("ORGANISM", "OC");
        genbank_hash.put("REFERENCE", "RP");
        genbank_hash.put("AUTHORS", "RA");
        genbank_hash.put("TITLE", "RT");
        genbank_hash.put("JOURNAL", "RL");
        genbank_hash.put("PUBMED", REF_KEY_STRING);
        genbank_hash.put("MEDLINE", REF_KEY_STRING);
        genbank_hash.put("COMMENT", "CC");
        genbank_hash.put("FEATURES", FEATURE_HEADER_STRING);
        genbank_hash.put("source", FEATURE_STRING);
        genbank_hash.put("BASE", SEQUENCE_STRING);
        genbank_hash.put("ORIGIN", SEQUENCE_STRING);
        transcript_id_tags = null;
        annot_id_tags = null;
        annot_name_tags = null;
        transcript_id_tags = new Vector();
        transcript_id_tags.addElement("product");
        transcript_id_tags.addElement("transcript_id");
        transcript_id_tags.addElement("protein_id");
        transcript_id_tags.addElement("codon_start");
        annot_id_tags = new Vector();
        annot_id_tags.addElement("locus_tag");
        annot_id_tags.addElement("transposon");
        annot_name_tags = new Vector();
        annot_name_tags.addElement("gene");
        annot_name_tags.addElement("standard_name");
        annot_name_tags.addElement("allele");
        annot_name_tags.addElement("label");
        annot_name_tags.addElement("note");
        featureTag_hash = null;
        featureTag_hash = new Hashtable();
        featureTag_hash.put("map", "cyto_range");
        featureTag_hash.put("RBS", "ribosomal_binding_site");
        featureTag_hash.put("transposon", "transposable_element");
        featureTag_hash.put("misc_RNA", "ncRNA");
    }
}

