/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.genbank;

import apollo.config.Config;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.FileTabPanel;
import apollo.dataadapter.GuiTabPanel;
import apollo.dataadapter.genbank.GenbankAdapter;
import apollo.dataadapter.genbank.PublicDbPanel;
import apollo.datamodel.CompositeDataHolder;
import apollo.datamodel.CurationSet;
import apollo.gui.GenericFileAdapterGUI;
import apollo.gui.ProxyDialog;
import apollo.util.IOUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.bdgp.io.DataAdapter;
import org.bdgp.io.DataAdapterException;
import org.bdgp.io.IOOperation;

public class GenbankAdapterGUI
extends GenericFileAdapterGUI {
    private static int tabbedIndex = 0;
    private JTabbedPane tabbedPane;
    private static final String indexPropString = "PubTabIndex";
    private GuiTabPanel[] pubPanels;
    private int FileTabIndex = 0;
    private Color filePanelColor = new Color(255, 218, 185);
    private Color genbankPanelColor = new Color(244, 240, 245);
    private static JRadioButton tabular = new JRadioButton("GenBank tabular format (save to directory)");
    private static JRadioButton humanReadable = new JRadioButton("GenBank human readable format (save to file)", true);

    public GenbankAdapterGUI(IOOperation op) {
        this.op = op;
        if (this.op == ApolloDataAdapterI.OP_READ_DATA) {
            this.initPanels();
            this.buildGUIForReading();
        } else {
            this.buildGUIForWriting();
            this.attachListeners();
        }
    }

    private void initPanels() {
        FileTabPanel file = new FileTabPanel((Component)((Object)this), this.filePanelColor);
        PublicDbPanel gb = new PublicDbPanel("Accession", "Accession #", DataInputType.URL, "AE003603", this.genbankPanelColor);
        this.pubPanels = new GuiTabPanel[]{file, gb};
    }

    public void buildGUIForReading() {
        this.tabbedPane = new JTabbedPane();
        for (int i = 0; i < this.pubPanels.length; ++i) {
            this.pubPanels[i].insertIntoTabbedPane(this.tabbedPane, i);
        }
        this.tabbedPane.setSelectedIndex(tabbedIndex);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                tabbedIndex = GenbankAdapterGUI.this.tabbedPane.getSelectedIndex();
            }
        });
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.add(this.tabbedPane);
        JButton proxyButton = new JButton("Proxy settings...");
        proxyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProxyDialog pd = new ProxyDialog(null);
                pd.setVisible(true);
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(Box.createHorizontalStrut(300));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(Box.createHorizontalStrut(150));
        buttonPanel.add(proxyButton);
        buttonPanel.add(Box.createHorizontalGlue());
        this.add(buttonPanel);
    }

    public void buildGUIForWriting() {
        super.buildGUI();
        ButtonGroup format = new ButtonGroup();
        format.add(tabular);
        format.add(humanReadable);
        JPanel formatPanel = new JPanel();
        formatPanel.setLayout(new BorderLayout());
        this.panel.add("South", formatPanel);
        formatPanel.add("North", tabular);
        formatPanel.add("South", humanReadable);
    }

    public void setDataAdapter(DataAdapter driver) {
        if (this.op.equals((Object)ApolloDataAdapterI.OP_WRITE_DATA)) {
            super.setDataAdapter(driver);
        } else {
            this.driver = driver;
        }
        if (driver == null) {
            System.err.println("GenbankAdapterGUI.setDataAdapter: driver is null!");
            try {
                new Throwable().printStackTrace();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public Object doOperation(Object values) throws DataAdapterException {
        if (this.op.equals((Object)ApolloDataAdapterI.OP_WRITE_DATA)) {
            ((GenbankAdapter)this.driver).setInputType(DataInputType.DIR);
            String path = this.getSelectedPath();
            path = IOUtil.findFile(path, true);
            boolean wantTabular = tabular.isSelected();
            try {
                File pathFile = new File(path);
                if (!(!wantTabular || pathFile.isDirectory() && pathFile.canRead())) {
                    JOptionPane.showMessageDialog(null, "Need a valid directory.  Can't write to directory " + path, "Warning", 2);
                    return null;
                }
                if (!(wantTabular || pathFile != null && !pathFile.isDirectory() && IOUtil.canWriteToDirectory(path))) {
                    JOptionPane.showMessageDialog(null, "Need a valid file.  Can't write to file " + path + ".\n" + (pathFile == null ? "pathFile is null" : "") + (pathFile.isDirectory() ? pathFile + " is a directory" : "") + (!IOUtil.canWriteToDirectory(path) ? "Can't write to directory for " + path : ""), "Warning", 2);
                    return null;
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Can't write to " + (wantTabular ? "directory " : "file ") + path, "Warning", 2);
                return null;
            }
            ((GenbankAdapter)this.driver).setInput(path);
            String validation_config = Config.getRootDir() + "/conf/validation.conf";
            if (validation_config != null) {
                ((GenbankAdapter)this.driver).setValidationFile(validation_config);
            }
            if (((GenbankAdapter)this.driver).getInput().equals(path)) {
                ((GenbankAdapter)this.driver).commitChanges(((CompositeDataHolder)values).getCurationSet(0), wantTabular);
            } else {
                System.out.println("Unable to write to " + (wantTabular ? "directory " : "file "));
            }
            return null;
        }
        if (this.op.equals((Object)ApolloDataAdapterI.OP_READ_DATA)) {
            ((GenbankAdapter)this.driver).setDatabase(this.getCurrentTabPanel().getDatabase());
            ((GenbankAdapter)this.driver).setInputType(this.getCurrentTabPanel().getInputType());
            ((GenbankAdapter)this.driver).setInput(this.getCurrentInput());
            CurationSet curation = ((GenbankAdapter)this.driver).getCurationSet();
            if (curation == null) {
                JOptionPane.showMessageDialog(null, "Read failed", "Warning", 2);
            }
            return curation;
        }
        return null;
    }

    private String getCurrentInput() {
        return this.getCurrentTabPanel().getCurrentInput();
    }

    private GuiTabPanel getCurrentTabPanel() {
        return this.pubPanels[this.tabbedPane.getSelectedIndex()];
    }

    public Properties getProperties() {
        if (this.op == ApolloDataAdapterI.OP_WRITE_DATA) {
            return super.getProperties();
        }
        this.getCurrentTabPanel().addSelectedToHistory();
        Properties out = new Properties();
        for (int i = 0; i < this.pubPanels.length; ++i) {
            this.pubPanels[i].putHistoryInProperties(out);
        }
        out.put(indexPropString, "" + tabbedIndex);
        return out;
    }

    public void browseFiles(JComboBox list) {
        String selectedPath = this.getSelectedPath();
        File currentFile = new File(selectedPath);
        File browseFile = GenbankAdapterGUI.fileBrowser(currentFile, (Component)((Object)this));
        if (browseFile == null) {
            return;
        }
        list.configureEditor(list.getEditor(), browseFile.toString());
    }

    public static File fileBrowser(File currentFile, Component parent) {
        String startPath = currentFile != null && currentFile.exists() ? currentFile.getPath() : System.getProperty("user.home");
        JFileChooser chooser = new JFileChooser(startPath);
        if (tabular.isSelected()) {
            chooser.setFileSelectionMode(1);
            chooser.setApproveButtonText("Save to this directory");
        } else {
            chooser.setApproveButtonText("Save to this file");
        }
        int returnVal = chooser.showOpenDialog(parent);
        File file = chooser.getSelectedFile();
        if (file == null) {
            JOptionPane.showMessageDialog(parent, "No " + (tabular.isSelected() ? "directory " : "file ") + " selected", "Error", 0);
            return null;
        }
        if (returnVal != 0) {
            return null;
        }
        return file;
    }

    public void setProperties(Properties in) {
        if (in == null) {
            return;
        }
        if (this.op == ApolloDataAdapterI.OP_WRITE_DATA) {
            super.setProperties(in);
        } else {
            for (int i = 0; i < this.pubPanels.length; ++i) {
                this.pubPanels[i].retrieveHistoryFromProperties(in);
            }
            String indexStr = in.getProperty(indexPropString);
            if (indexStr != null) {
                tabbedIndex = Integer.parseInt(indexStr);
                this.tabbedPane.setSelectedIndex(tabbedIndex);
            }
        }
    }
}

