/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.genbank;

import apollo.config.Config;
import apollo.dataadapter.AbstractApolloAdapter;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.NotImplementedException;
import apollo.dataadapter.genbank.GenbankAdapterGUI;
import apollo.dataadapter.genbank.GenbankRead;
import apollo.dataadapter.genbank.GenbankReport;
import apollo.dataadapter.genbank.GenbankValidator;
import apollo.dataadapter.genbank.XrefUtil;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.Comment;
import apollo.datamodel.CurationSet;
import apollo.datamodel.DbXref;
import apollo.datamodel.Exon;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.SequenceI;
import apollo.datamodel.StrandedFeatureSetI;
import apollo.datamodel.Synonym;
import apollo.datamodel.Transcript;
import apollo.seq.io.FastaFile;
import apollo.util.IOUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;
import org.bdgp.util.ProgressEvent;

public class GenbankAdapter
extends AbstractApolloAdapter {
    private String LABEL = "GenBank/EMBL format";
    private static boolean DEBUG = false;
    private boolean commit_acc = false;
    GenbankValidator validator = null;
    boolean NO_GUI = false;
    private File genbank_file;
    private DataOutputStream report_os;
    String region;
    String database = "";
    String tech = "";
    String organism = "";
    String genotype = "";
    Vector db_xrefs = null;
    private int offset;
    SequenceI curated_seq = null;
    IOOperation[] supportedOperations = new IOOperation[]{ApolloDataAdapterI.OP_READ_DATA, ApolloDataAdapterI.OP_WRITE_DATA};

    public GenbankAdapter() {
        this.setName(this.LABEL);
    }

    public GenbankAdapter(DataInputType inputType, String input) {
        this.setInputType(inputType);
        this.setInput(input);
        this.setName(this.LABEL);
    }

    public GenbankAdapter(DataInputType inputType, String input, boolean noGUI) {
        this(inputType, input);
        this.NO_GUI = noGUI;
        this.setName(this.LABEL);
    }

    public void init() {
    }

    public String getType() {
        return this.getName();
    }

    public IOOperation[] getSupportedOperations() {
        return this.supportedOperations;
    }

    public DataAdapterUI getUI(IOOperation op) {
        if (op.equals((Object)ApolloDataAdapterI.OP_WRITE_DATA) || op.equals((Object)ApolloDataAdapterI.OP_READ_DATA)) {
            return new GenbankAdapterGUI(op);
        }
        return null;
    }

    public void setInput(String input) {
        if (this.getInputType() == null || this.getInputType() != null && this.getInputType().equals(DataInputType.DIR)) {
            File input_dir = new File(input);
            if (input_dir.isDirectory() && input_dir.canWrite()) {
                super.setInputType(DataInputType.DIR);
                super.setInput(input);
            } else if (this.getInputType() != null) {
                super.setInputType(DataInputType.FILE);
                super.setInput(input);
            }
        } else {
            super.setInput(input);
        }
    }

    public void commitAccessions(boolean commit_acc) {
        this.commit_acc = commit_acc;
    }

    public void setValidationFile(String valid_filename) {
        this.validator = new GenbankValidator();
        if (!this.validator.setValidationFile(valid_filename)) {
            this.validator = null;
            System.out.println("Couldn't parse validation file " + valid_filename);
        } else {
            this.database = this.validator.getDatabase();
            this.tech = this.validator.getTech();
            this.organism = this.validator.getOrganism();
            this.genotype = this.validator.getGenotype();
            this.db_xrefs = this.validator.getXrefs();
        }
    }

    public Properties getStateInformation() {
        Properties props = new Properties();
        props.put("InputString", this.getInput());
        props.put("Input Type", this.getInputType().toString());
        props.put("database", this.getDatabase());
        return props;
    }

    public void setStateInformation(Properties props) {
        this.setInput(props.getProperty("InputString"));
        String typeString = props.getProperty("Input Type");
        try {
            this.setInputType(DataInputType.stringToType(typeString));
        }
        catch (DataInputType.UnknownTypeException e) {
            System.out.println(e.getMessage() + " Can not set genbank adapter state info");
        }
        this.setDatabase(props.getProperty("database"));
    }

    public SequenceI getSequence(String id) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public SequenceI getSequence(DbXref dbxref) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public SequenceI getSequence(DbXref dbxref, int start, int end) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public Vector getSequences(DbXref[] dbxref) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public Vector getSequences(DbXref[] dbxref, int[] start, int[] end) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public void setRegion(SequenceI seq) throws ApolloAdapterException {
        if (seq != null) {
            this.curated_seq = seq;
            this.setRegion(seq.getName());
        }
    }

    public void setRegion(String region) throws ApolloAdapterException {
        this.region = region;
    }

    public void commitChanges(CurationSet curation, boolean wantTabular) {
        File out = new File(this.getInput());
        if (wantTabular) {
            this.saveTabular(curation, out);
        } else {
            GenbankReport.save(curation, out);
        }
    }

    private void saveTabular(CurationSet curation, File dir) {
        boolean okay_commit;
        boolean bl = okay_commit = dir.isDirectory() && dir.canWrite();
        if (!okay_commit) {
            System.err.println("GenbankAdapter.saveTabular: directory " + dir + " is not writeable--can't save.");
            return;
        }
        System.out.println("Saving GenBank tabular format to directory " + dir);
        String report_file = this.commit_acc ? this.outputFileStem(curation) + ".acc.rpt" : this.outputFileStem(curation) + ".annot.rpt";
        this.report_os = this.openGenbankFile(dir, report_file);
        if (this.commit_acc) {
            this.commitAccessions(curation, dir);
        } else {
            Vector omit = new Vector();
            this.commitGenomic(curation, dir);
            this.commitPeptides(curation, dir, omit);
            this.commitTranscripts(curation, dir, omit);
            this.commitTable(curation, dir, omit);
        }
        if (this.validator != null) {
            this.validator.checkCuration(curation, this.report_os);
        }
    }

    private void commitGenomic(CurationSet curation, File dir) {
        DataOutputStream dos = this.openGenbankFile(dir, this.outputFileStem(curation) + ".fsa");
        try {
            dos.writeBytes(this.writeFasta(curation));
            try {
                dos.close();
            }
            catch (Exception ex) {
                System.err.println("caught exception closing " + this.genbank_file.getName());
                System.out.println(ex.getMessage());
                ex.printStackTrace();
            }
        }
        catch (Exception ex) {
            System.err.println("caught exception writing " + this.genbank_file.getName());
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    private void commitTranscripts(CurationSet curation, File dir, Vector omit) {
        DataOutputStream dos = this.openGenbankFile(dir, this.outputFileStem(curation) + ".rna");
        try {
            StrandedFeatureSetI annots = curation.getAnnots();
            for (int i = 0; i < annots.size(); ++i) {
                AnnotatedFeatureI gene = (AnnotatedFeatureI)annots.getFeatureAt(i);
                dos.writeBytes(this.writeTranscript(gene, dir, omit));
            }
            try {
                dos.close();
            }
            catch (Exception ex) {
                System.err.println("caught exception closing " + this.genbank_file.getName());
                System.out.println(ex.getMessage());
                ex.printStackTrace();
            }
        }
        catch (Exception ex) {
            System.err.println("caught exception writing " + this.genbank_file.getName());
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    private void commitPeptides(CurationSet curation, File dir, Vector omit) {
        DataOutputStream dos = this.openGenbankFile(dir, this.outputFileStem(curation) + ".pep");
        try {
            StrandedFeatureSetI annots = curation.getAnnots();
            for (int i = 0; i < annots.size(); ++i) {
                AnnotatedFeatureI gene = (AnnotatedFeatureI)annots.getFeatureAt(i);
                dos.writeBytes(this.writePeptide(gene, dir, omit));
            }
            try {
                dos.close();
            }
            catch (Exception ex) {
                System.err.println("caught exception closing " + this.genbank_file.getName());
                System.out.println(ex.getMessage());
                ex.printStackTrace();
            }
        }
        catch (Exception ex) {
            System.err.println("caught exception writing " + this.genbank_file.getName());
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    private void commitTable(CurationSet curation, File dir, Vector omit) {
        DataOutputStream dos = this.openGenbankFile(dir, this.outputFileStem(curation) + ".tbl");
        try {
            dos.writeBytes(">Feature " + this.getGenomeId(curation) + "\n");
            StrandedFeatureSetI annots = curation.getAnnots();
            this.offset = curation.getStart() - 1;
            for (int i = 0; i < annots.size(); ++i) {
                AnnotatedFeatureI gene = (AnnotatedFeatureI)annots.getFeatureAt(i);
                dos.writeBytes(this.writeGene(gene, omit));
            }
            try {
                dos.close();
            }
            catch (Exception ex) {
                System.err.println("caught exception closing " + this.genbank_file.getName());
                System.out.println(ex.getMessage());
                ex.printStackTrace();
            }
        }
        catch (Exception ex) {
            System.err.println("caught exception writing " + this.genbank_file.getName());
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    private void commitAccessions(CurationSet curation, File dir) {
        DataOutputStream dos = this.openGenbankFile(dir, this.outputFileStem(curation) + ".acc");
        try {
            StrandedFeatureSetI results = curation.getResults();
            for (int i = 0; i < results.size(); ++i) {
                FeatureSetI fs = (FeatureSetI)results.getFeatureAt(i);
                dos.writeBytes(this.writeAccession(fs));
            }
            try {
                dos.close();
            }
            catch (Exception ex) {
                System.err.println("caught exception closing " + this.genbank_file.getName());
                System.out.println(ex.getMessage());
                ex.printStackTrace();
            }
        }
        catch (Exception ex) {
            System.err.println("caught exception writing " + this.genbank_file.getName());
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    private DataOutputStream openGenbankFile(File dir, String file_name) {
        this.genbank_file = new File(dir, file_name);
        DataOutputStream dos = null;
        try {
            if (!this.genbank_file.exists()) {
                this.genbank_file.createNewFile();
            }
            dos = new DataOutputStream(new FileOutputStream(this.genbank_file));
        }
        catch (Exception ex) {
            System.err.println("caught exception opening " + this.genbank_file.getName() + " for writing");
            System.out.println(ex.getMessage());
        }
        return dos;
    }

    protected String writeFasta(CurationSet curation) {
        String chrom;
        StringBuffer buf = new StringBuffer();
        if (this.database.equalsIgnoreCase("flybase")) {
            String arm = curation.getRefSequence().getName();
            int index = arm.indexOf(".");
            if (index > 0) {
                arm = arm.substring(0, index);
            }
            chrom = "[chromosome=" + arm + "] ";
        } else {
            chrom = "";
        }
        String org = this.organism.equals("") ? "" : "[organism=" + this.organism + "] ";
        String geno = this.genotype.equals("") ? "" : "[genotype=\"" + this.genotype + "\"]";
        String techno = this.tech.equals("") ? "" : "[tech=" + this.tech + "] ";
        String header = ">" + this.getGenomeId(curation) + " " + org + chrom + techno + geno + "\n";
        String dna = curation.getResidues();
        if (dna != null && !dna.equals("")) {
            buf.append(FastaFile.format(header, dna, 50));
        }
        return buf.toString();
    }

    protected static String getGenbankType(String type) {
        String gb_type = "";
        gb_type = type.equalsIgnoreCase("gene") || type.equalsIgnoreCase("pseudogene") ? "gene" : (type.equals("snRNA") || type.equals("snoRNA") || type.equals("tRNA") || type.equals("rRNA") ? type : (type.equalsIgnoreCase("transposable_element") ? "repeat_region" : (type.equalsIgnoreCase("misc. non-coding RNA") ? "misc_RNA" : (type.equalsIgnoreCase("miscellaneous curator's observation") || type.equalsIgnoreCase("misc. curator's observation") ? "misc_feature" : type + "=say_what?"))));
        return gb_type;
    }

    protected String getIds(AnnotatedFeatureI gene, Transcript transcript) {
        return "\t\t\ttranscript_id\t" + this.getSequenceId(gene, transcript.get_cDNASequence(), transcript) + "\n" + "\t\t\tprotein_id\t" + this.getProteinId(gene, transcript.getPeptideSequence(), transcript) + "\n";
    }

    protected String getGeneProduct(AnnotatedFeatureI gene, Transcript transcript, String CDS_start, String CDS_stop, String except, int na_except_pos) {
        SeqFeatureI start_span;
        StringBuffer buf = new StringBuffer();
        int tss = transcript.getTranslationStart();
        int phase = 0;
        if (gene.isMissing5prime() || transcript.isMissing5prime()) {
            phase = transcript.getFeaturePosition(tss) - 1;
        }
        int start_index = (start_span = transcript.getFeatureContaining(tss)) != null ? transcript.getFeatureIndex(start_span) : 0;
        SequenceI pep = transcript.getPeptideSequence();
        int end_base = transcript.getLastBaseOfStopCodon();
        Vector exons = transcript.getFeatures();
        int end_index = exons.size();
        boolean found_end = false;
        for (int i = start_index; i < end_index && !found_end; ++i) {
            Exon exon = (Exon)exons.elementAt(i);
            boolean contains_tss = i == start_index;
            found_end = exon.contains(end_base);
            if (contains_tss && phase == 0) {
                buf.append(CDS_start + (tss - this.offset) + "\t");
            } else if (contains_tss && phase > 0) {
                buf.append(CDS_start + (exon.getStart() - this.offset) + "\t");
            } else {
                buf.append(exon.getStart() - this.offset + "\t");
            }
            if (na_except_pos > 0 && exon.contains(na_except_pos)) {
                buf.append("" + (na_except_pos - transcript.getStrand()));
                if (contains_tss) {
                    buf.append("\tCDS\n");
                } else {
                    buf.append("\n");
                }
                buf.append(na_except_pos + transcript.getStrand() + "\t");
                contains_tss = false;
                except = this.validator.getException(transcript);
            }
            if (found_end) {
                buf.append(CDS_stop + (end_base - this.offset));
            } else {
                buf.append(exon.getEnd() - this.offset);
            }
            if (contains_tss) {
                buf.append("\tCDS\n");
                continue;
            }
            buf.append("\n");
        }
        buf.append("\t\t\tproduct\t" + GenbankAdapter.getSequenceName(gene, pep, transcript) + "\n");
        buf.append(this.getIds(gene, transcript));
        buf.append("\t\t\tprot_desc\t" + GenbankAdapter.getProteinDesc(gene, transcript) + "\n");
        if (phase > 0) {
            buf.append("\t\t\tcodon_start\t" + (phase + 1) + "\n");
        }
        if (!except.equals("")) {
            buf.append(except);
        }
        return buf.toString();
    }

    protected String getLocus(AnnotatedFeatureI gene, String tag) {
        if (gene.getName().equals(gene.getId())) {
            if (tag.equals("transposon")) {
                return "\t\t\tnote\tsymbol=" + gene.getId() + "\n";
            }
            return "\t\t\tlocus_tag\t" + gene.getId() + "\n";
        }
        if (tag.equals("transposon")) {
            return "\t\t\tnote\tsymbol=" + gene.getName() + "\n";
        }
        return "\t\t\t" + tag + "\t" + gene.getName() + "\n" + "\t\t\tlocus_tag\t" + gene.getId() + "\n";
    }

    private String getGeneInterval(AnnotatedFeatureI gene, String gene_has_start, String gene_has_stop, String gb_type) {
        return gene_has_start + (gene.getStart() - this.offset) + "\t" + gene_has_stop + (gene.getEnd() - this.offset) + "\t" + gb_type + "\n";
    }

    protected String writeGene(AnnotatedFeatureI gene, Vector omit) {
        String date_note;
        boolean not_a_gene;
        StringBuffer buf = new StringBuffer();
        String gene_has_start = GenbankAdapter.get5primeStart(gene);
        String gene_has_stop = GenbankAdapter.get3primeStop(gene);
        String gb_type = GenbankAdapter.getGenbankType(gene.getFeatureType());
        boolean bl = not_a_gene = !gene.isProteinCodingGene();
        if (gb_type.equals("repeat_region")) {
            buf.append(this.getGeneInterval(gene, gene_has_start, gene_has_stop, gb_type));
            buf.append(this.getLocus(gene, "transposon"));
        } else {
            buf.append(this.getGeneInterval(gene, gene_has_start, gene_has_stop, "gene"));
            buf.append(this.getLocus(gene, "gene"));
        }
        if (gb_type.equals("gene") && gene.getFeatureType().equalsIgnoreCase("pseudogene")) {
            buf.append("\t\t\tpseudo\n");
        }
        buf.append(this.getSynonyms(gene, gb_type));
        buf.append(this.getCyto(gene));
        if (!gb_type.equals("repeat_region") && !gb_type.equals("gene")) {
            buf.append(this.getGeneInterval(gene, gene_has_start, gene_has_stop, gb_type));
            if (gb_type.equals("tRNA")) {
                String aa = gene.getProperty("aminoacid");
                if (!aa.equals("")) {
                    buf.append("\t\t\tproduct\ttRNA-" + aa + "\n");
                }
            } else {
                buf.append(this.getNotes(gene));
            }
        }
        buf.append(this.getDbXrefs(gene));
        if (gene.size() > 0 && (date_note = gene.getFeatureAt(0).getProperty("date")) != null && !date_note.equals("")) {
            buf.append("\t\t\tnote\tlast curated on " + date_note + "\n");
        }
        if (gb_type.equals("gene")) {
            Vector transcripts = gene.getFeatures();
            int count = transcripts.size();
            for (int i = 0; i < count; ++i) {
                Transcript transcript = (Transcript)transcripts.elementAt(i);
                if (omit.contains(transcript)) continue;
                String CDS_start = gene_has_start.equals("") ? GenbankAdapter.get5primeStart(transcript) : gene_has_start;
                String CDS_stop = gene_has_stop.equals("") ? GenbankAdapter.get3primeStop(transcript) : gene_has_stop;
                Vector exons = transcript.getFeatures();
                for (int j = 0; j < exons.size(); ++j) {
                    Exon exon = (Exon)exons.elementAt(j);
                    if (j == 0) {
                        buf.append(CDS_start);
                    }
                    buf.append(exon.getStart() - this.offset + "\t");
                    if (j == exons.size() - 1) {
                        buf.append(CDS_stop);
                    }
                    buf.append(exon.getEnd() - this.offset);
                    if (j == 0) {
                        buf.append("\tmRNA\n");
                        continue;
                    }
                    buf.append("\n");
                }
                buf.append("\t\t\tproduct\t" + GenbankAdapter.getSequenceName(gene, transcript.get_cDNASequence(), transcript) + "\n");
                if (!not_a_gene && transcript != null) {
                    buf.append(this.getIds(gene, transcript));
                    String except = "";
                    int na_except_pos = 0;
                    if (this.validator != null && (except = this.validator.getTranslExcept(transcript, this.offset)).equals("")) {
                        except = this.validator.getException(transcript);
                        buf.append(except);
                    }
                    buf.append(this.getGeneProduct(gene, transcript, CDS_start, CDS_stop, except, na_except_pos));
                    continue;
                }
                if (gene.getFeatureType().equalsIgnoreCase("pseudogene")) {
                    buf.append("\t\t\tpseudo\n");
                    continue;
                }
                buf.append("\t\t\t" + gene.getFeatureType() + "\n");
            }
        }
        return buf.toString();
    }

    protected String writeTranscript(AnnotatedFeatureI gene, File dir, Vector omit) {
        StringBuffer buf = new StringBuffer();
        if (gene.isProteinCodingGene()) {
            String symbol = "[gene=" + gene.getName() + "] ";
            String gene_id = gene.getName().equals(gene.getId()) ? "" : "[gene_syn=" + gene.getId() + "] ";
            String acc = gene.getProperty("gbunit");
            Vector transcripts = gene.getFeatures();
            int count = transcripts.size();
            for (int i = 0; i < count; ++i) {
                Transcript transcript = (Transcript)transcripts.elementAt(i);
                if (omit.contains(transcript)) continue;
                SequenceI rna = transcript.get_cDNASequence();
                if (rna != null) {
                    String header = ">" + this.getSequenceId(gene, rna, transcript) + " " + (acc != null && !acc.equals("") ? "(" + acc + ") " : "") + symbol + gene_id + "\n";
                    buf.append(FastaFile.format(header, rna.getResidues(), 50));
                    continue;
                }
                System.err.println("ERROR: " + transcript.getName() + " IS NOT TRANSCRIBED??!!??" + " (" + transcript.getOwner() + ")");
            }
        }
        return buf.toString();
    }

    protected String writePeptide(AnnotatedFeatureI gene, File dir, Vector omit) {
        StringBuffer buf = new StringBuffer();
        if (gene.isProteinCodingGene()) {
            String symbol = "[gene=" + gene.getName() + "] ";
            String gene_id = gene.getName().equals(gene.getId()) ? "" : "[gene_syn=" + gene.getId() + "] ";
            String acc = gene.getProperty("gbunit");
            Vector transcripts = gene.getFeatures();
            int count = transcripts.size();
            for (int i = 0; i < count; ++i) {
                Transcript transcript = (Transcript)transcripts.elementAt(i);
                SequenceI pep = transcript.getPeptideSequence();
                if (pep != null) {
                    String header = ">" + this.getSequenceId(gene, pep, transcript) + " " + (acc != null && !acc.equals("") ? "(" + acc + ") " : "") + symbol + gene_id + "[prot_desc=" + GenbankAdapter.getProteinDesc(gene, transcript) + "]\n";
                    if (this.validator != null) {
                        String fasta = this.validator.patchPeptideCheck(gene, transcript, header, this.report_os);
                        if (fasta != null) {
                            buf.append(fasta);
                            continue;
                        }
                        omit.addElement(transcript);
                        continue;
                    }
                    buf.append(FastaFile.format(header, pep.getResidues(), 50));
                    continue;
                }
                System.err.println("ERROR: " + transcript.getName() + " DOES NOT TRANSLATE??!!??" + " (" + transcript.getOwner() + ")");
            }
        }
        return buf.toString();
    }

    protected String writeAccession(FeatureSetI fs) {
        StringBuffer buf = new StringBuffer();
        if (fs.getProgramName().equalsIgnoreCase("gbunits") || fs.getProgramName().equalsIgnoreCase("assembly")) {
            Vector spans = fs.getFeatures();
            int count = spans.size();
            for (int i = 0; i < count; ++i) {
                FeatureSetI sf = (FeatureSetI)spans.elementAt(i);
                String name = sf.getName();
                int index = name.indexOf(".");
                if (index > 0) {
                    name = name.substring(0, index);
                }
                buf.append(sf.getStart() + "\t" + sf.getEnd() + "\t" + name + "\n");
            }
        }
        return buf.toString();
    }

    public static String get5primeStart(AnnotatedFeatureI sf) {
        String starter;
        String string = starter = sf.isMissing5prime() ? "<" : "";
        if (starter.equals("") && sf.size() > 0 && sf.getFeatureAt(0) instanceof Transcript) {
            int trans_count = sf.size();
            int missing_count = 0;
            for (int i = 0; i < trans_count && i == missing_count; ++i) {
                Transcript transcript = (Transcript)sf.getFeatureAt(i);
                if (!transcript.isMissing5prime()) continue;
                ++missing_count;
            }
            starter = missing_count == trans_count ? "<" : "";
        }
        return starter;
    }

    public static String get3primeStop(AnnotatedFeatureI sf) {
        String stop;
        String string = stop = sf.isMissing3prime() ? ">" : "";
        if (stop.equals("") && sf.size() > 0 && sf.getFeatureAt(0) instanceof Transcript) {
            int trans_count = sf.size();
            int missing_count = 0;
            for (int i = 0; i < trans_count && i == missing_count; ++i) {
                Transcript transcript = (Transcript)sf.getFeatureAt(i);
                if (!transcript.isMissing3prime()) continue;
                ++missing_count;
            }
            stop = missing_count == trans_count ? ">" : "";
        }
        return stop;
    }

    private String getComment(AnnotatedFeatureI sf, String clue) {
        String text = "";
        String lc_clue = clue.toLowerCase();
        Vector comments = sf.getComments();
        for (int i = 0; i < comments.size() && text.equals(""); ++i) {
            Comment comment = (Comment)comments.elementAt(i);
            if (comment.getText().toLowerCase().indexOf(lc_clue) < 0) continue;
            text = comment.getText().trim();
        }
        return text;
    }

    private String getNotes(AnnotatedFeatureI gene) {
        StringBuffer buf = new StringBuffer();
        Vector comments = gene.getComments();
        for (int i = 0; i < comments.size(); ++i) {
            Comment comment = (Comment)comments.elementAt(i);
            if (comment.isInternal()) continue;
            String note = comment.getText().trim();
            note = note.replace('\n', ' ');
            buf.append("\t\t\tnote\t" + note + "\n");
        }
        return buf.toString();
    }

    private String getSynonyms(AnnotatedFeatureI gene, String gb_type) {
        StringBuffer buf = new StringBuffer();
        Vector syns = gene.getSynonyms();
        for (int i = 0; i < syns.size(); ++i) {
            Synonym synObject = (Synonym)syns.elementAt(i);
            String syn = synObject.getName();
            if (syn.equals("") || syn.indexOf("temp") >= 0 || syn.equals(gene.getName()) || syn.equals(gene.getId())) continue;
            if (gb_type.equals("repeat_region")) {
                buf.append("\t\t\tnote\tsynonym=" + syn + "\n");
                continue;
            }
            buf.append("\t\t\tgene_syn\t" + syn + "\n");
        }
        return buf.toString();
    }

    private String getDbXrefs(AnnotatedFeatureI gene) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.db_xrefs.size(); ++i) {
            XrefUtil xref = (XrefUtil)this.db_xrefs.elementAt(i);
            buf.append(xref.getGenBankXref(gene));
        }
        return buf.toString();
    }

    public static String getDbXref(SequenceI seq) {
        String acc = "";
        Vector xrefs = seq.getDbXrefs();
        for (int i = 0; i < xrefs.size() && acc.equals(""); ++i) {
            DbXref xref = (DbXref)xrefs.elementAt(i);
            if (xref.getIdValue() == null || xref.getIdValue().equals("")) continue;
            acc = xref.getIdValue();
        }
        return acc;
    }

    private String getCyto(AnnotatedFeatureI gene) {
        StringBuffer buf = new StringBuffer();
        String cyto = gene.getProperty("cyto_range");
        if (cyto != null && !cyto.equals("")) {
            buf.append("\t\t\tmap\t" + cyto + "\n");
        }
        return buf.toString();
    }

    private String getGenomeId(CurationSet curation) {
        String seq_id = GenbankAdapter.getDbXref(curation.getRefSequence()).equals("") ? curation.getRefSequence().getName() : GenbankAdapter.getDbXref(curation.getRefSequence());
        String region = curation.getName();
        int index = region.indexOf(".");
        if (index > 0) {
            region = region.substring(0, index);
        }
        return "gnl|" + this.database + "|" + seq_id + "|gb|" + region;
    }

    public static String getProteinDesc(AnnotatedFeatureI gene, Transcript transcript) {
        if (gene.size() == 1) {
            return gene.getName() + " gene product";
        }
        return gene.getName() + " gene product from transcript " + GenbankAdapter.getSequenceName(gene, transcript.get_cDNASequence(), transcript);
    }

    public static String getSequenceName(AnnotatedFeatureI gene, SequenceI seq, Transcript transcript) {
        if (seq != null) {
            return seq.getName();
        }
        System.err.println("No seq for " + transcript.getName());
        return "";
    }

    private String getSequenceId(AnnotatedFeatureI gene, SequenceI seq, Transcript transcript) {
        String name;
        String seq_id = name = GenbankAdapter.getSequenceName(gene, seq, transcript);
        if (!name.equals("") && this.knownToGenbank(transcript)) {
            seq_id = "gnl|" + this.database + "|" + name;
        }
        return seq_id;
    }

    private String getProteinId(AnnotatedFeatureI gene, SequenceI seq, Transcript transcript) {
        String name = GenbankAdapter.getSequenceName(gene, seq, transcript);
        String seq_id = "";
        if (!name.equals("")) {
            seq_id = this.knownToGenbank(transcript) ? "gnl|" + this.database + "|" + name + "|gb|" + transcript.getProperty("protein_id") : "lcl|" + name;
        }
        return seq_id;
    }

    protected boolean knownToGenbank(Transcript transcript) {
        return !transcript.getProperty("protein_id").equals("");
    }

    private String outputFileStem(CurationSet curation) {
        String name = curation.getName();
        name = name.replace(':', '_');
        return name;
    }

    public String getRawAnalysisResults(String id) throws ApolloAdapterException {
        throw new NotImplementedException();
    }

    public CurationSet getCurationSet() throws ApolloAdapterException {
        CurationSet curation = new CurationSet();
        try {
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(10.0), "Finding data..."));
            InputStream stream = this.getInputStream(this.getInputType(), this.getInput());
            BufferedInputStream bis = new BufferedInputStream(stream);
            InputStreamReader reader = new InputStreamReader(bis);
            if (!this.NO_GUI) {
                super.clearOldData();
            }
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(15.0), "Reading " + this.getInput() + "..."));
            GenbankRead gbio = new GenbankRead();
            System.out.println("Loading " + this.getInput() + "...");
            if (gbio.loadCurationSet(curation, new BufferedReader(reader))) {
                return curation;
            }
            return null;
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
            throw new ApolloAdapterException(ex2.getMessage());
        }
    }

    private InputStream getInputStream(DataInputType type, String input) throws ApolloAdapterException {
        InputStream stream = null;
        if (input == null) {
            String message = "The input was null. Neither filename nor URL given";
            System.err.println(message);
            throw new ApolloAdapterException(message);
        }
        if (type == DataInputType.FILE) {
            try {
                String path = IOUtil.findFile(input, false);
                System.out.println("Trying to open file " + input);
                stream = new FileInputStream(path);
            }
            catch (Exception ex) {
                throw new ApolloAdapterException("Error: could not open " + input + " for reading.");
            }
        }
        if (type == DataInputType.URL) {
            String query_str = null;
            if (!input.startsWith("http://")) {
                Hashtable pubDbToURL = Config.getPublicDbList();
                String url_str = (String)pubDbToURL.get(this.getDatabase());
                if (url_str != null) {
                    int index;
                    if (!url_str.startsWith("http://")) {
                        url_str = "http://" + url_str;
                    }
                    if ((index = url_str.indexOf(42)) > 0) {
                        query_str = url_str.substring(0, index) + input;
                        if (++index < url_str.length()) {
                            query_str = query_str + url_str.substring(index);
                        }
                    } else {
                        query_str = url_str + input;
                    }
                }
            } else {
                query_str = input;
            }
            try {
                System.out.println("Trying to open URL " + query_str);
                URL url = new URL(query_str);
                stream = url.openStream();
            }
            catch (Exception ex1) {
                stream = null;
                throw new ApolloAdapterException("Error: could not open " + input + " for reading using \"" + query_str + "\"");
            }
        }
        return stream;
    }
}

