/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.gamexml;

import apollo.config.Config;
import apollo.datamodel.AnnotatedFeature;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.Comment;
import apollo.datamodel.CurationSet;
import apollo.datamodel.DbXref;
import apollo.datamodel.Exon;
import apollo.datamodel.ExonI;
import apollo.datamodel.Range;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.Transcript;
import apollo.editor.AddTransaction;
import apollo.editor.CompoundTransaction;
import apollo.editor.DeleteTransaction;
import apollo.editor.Transaction;
import apollo.editor.TransactionManager;
import apollo.editor.TransactionSubpart;
import apollo.editor.UpdateTransaction;
import apollo.util.FeatureList;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TransactionXMLAdapter {
    public static final String EXT_NAME = ".tnxml";
    private String fileName;
    private DateFormat dateFormat = DateFormat.getDateTimeInstance();
    private Writer writer;

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void setFileName(String annotFileName) {
        this.fileName = this.parseFileName(annotFileName);
    }

    private Writer getWriter() throws IOException {
        if (this.writer == null) {
            if (this.fileName == null) {
                throw new IOException("Transaction xml adapter has no file/writer set");
            }
            FileWriter fileWriter = new FileWriter(this.fileName);
            this.writer = new BufferedWriter(fileWriter);
        }
        return this.writer;
    }

    private String parseFileName(String annotFileName) {
        int index1 = annotFileName.indexOf(File.separator);
        int index2 = -1;
        index2 = annotFileName.lastIndexOf(".");
        String tranFileName = index2 == -1 ? annotFileName + EXT_NAME : annotFileName.substring(0, index2) + EXT_NAME;
        return tranFileName;
    }

    public static void loadTransactions(String fileName, CurationSet curation) throws IOException {
        TransactionXMLAdapter tnAdapter = new TransactionXMLAdapter();
        tnAdapter.setFileName(fileName);
        tnAdapter.load(curation);
    }

    public void save(List transactions) throws IOException {
        this.save(transactions, true);
    }

    public void save(List transactions, boolean writingSeparateFile) throws IOException {
        System.out.println("Saving " + transactions.size() + " transaction objects");
        StringBuffer buffer = new StringBuffer();
        if (writingSeparateFile) {
            buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        }
        String indent = "  ";
        if (!writingSeparateFile) {
            buffer.append(indent);
        }
        buffer.append("<apolloTransactions>\n");
        this.saveTransactions(transactions, buffer, indent);
        if (!writingSeparateFile) {
            buffer.append(indent);
        }
        buffer.append("</apolloTransactions>\n");
        this.saveToFile(buffer);
        if (writingSeparateFile) {
            this.getWriter().close();
        }
        System.out.println("Saved annotation change transactions to " + this.fileName);
    }

    private void saveTransactions(List transactions, StringBuffer buffer, String indent) {
        Transaction ts = null;
        Iterator it = transactions.iterator();
        while (it.hasNext()) {
            ts = (Transaction)it.next();
            if (ts instanceof DeleteTransaction) {
                this.saveDeleteTransaction((DeleteTransaction)ts, buffer, indent);
                continue;
            }
            if (ts instanceof UpdateTransaction) {
                this.saveUpdateTransaction((UpdateTransaction)ts, buffer, indent);
                continue;
            }
            if (ts instanceof AddTransaction) {
                this.saveAddTransaction((AddTransaction)ts, buffer, indent);
                continue;
            }
            if (!ts.isCompound()) continue;
            this.saveCompoundTransaction((CompoundTransaction)ts, buffer, indent);
        }
    }

    private void saveCompoundTransaction(CompoundTransaction tn, StringBuffer buffer, String indent) {
        this.saveTransactions(tn.getTransactions(), buffer, indent);
    }

    private void saveExon(ExonI exon, SeqFeatureI parent, String indent, StringBuffer buffer, boolean needEnding) {
        buffer.append(indent);
        buffer.append("<exon start=\"");
        buffer.append(exon.getStart());
        buffer.append("\" end=\"");
        buffer.append(exon.getEnd());
        if (parent != null) {
            buffer.append("\" parentName=\"");
            buffer.append(parent.getName());
            buffer.append("\" id=\"");
            buffer.append(exon.getId());
        }
        buffer.append("\">\n");
        if (needEnding) {
            this.endElement("exon", indent, buffer);
        }
    }

    private SeqFeatureI loadExon(Element exonElm, CurationSet curation) {
        String startStr = exonElm.getAttribute("start");
        int start = Integer.parseInt(startStr);
        String endStr = exonElm.getAttribute("end");
        int end = Integer.parseInt(endStr);
        String tranName = exonElm.getAttribute("parentName");
        SeqFeatureI tran = this.getFeatureByName(curation, tranName);
        if (tran == null) {
            return null;
        }
        Vector features = tran.getFeatures();
        if (features == null || features.size() == 0) {
            return null;
        }
        SeqFeatureI feature = null;
        Iterator it = features.iterator();
        while (it.hasNext()) {
            feature = (SeqFeatureI)it.next();
            if (feature.getStart() != start || feature.getEnd() != end) continue;
            return feature;
        }
        return null;
    }

    private void saveDeleteTransaction(DeleteTransaction tn, StringBuffer buffer, String indent) {
        SeqFeatureI feature = tn.getSeqFeature();
        SeqFeatureI parent = tn.getParentFeature();
        this.startTnElement(tn, "delete", indent, buffer);
        String indent1 = indent + indent;
        if (feature instanceof ExonI) {
            this.saveExon((ExonI)feature, parent, indent1, buffer, true);
        } else {
            buffer.append(indent1);
            String type = feature.getFeatureType();
            buffer.append("<");
            buffer.append(type);
            buffer.append(" name=\"");
            buffer.append(feature.getName());
            if (feature instanceof AnnotatedFeature) {
                buffer.append("\" id=\"");
                buffer.append(feature.getId());
                if (feature instanceof Transcript && parent != null && parent.getNumberOfChildren() >= 1) {
                    buffer.append("\" parentName=\"");
                    buffer.append(parent.getName());
                }
            } else {
                if (parent == null) {
                    throw new IllegalStateException("TransactionXMLAdapter.saveDeleteTransaction(): in transaction file " + this.fileName + ",\nno parent is defined for " + feature.getName());
                }
                buffer.append("\" parentName=\"");
                buffer.append(parent.getName());
            }
            buffer.append("\">\n");
            if (tn.getSubpart() != null) {
                this.saveSubpart(tn, tn.getOldSubpartValue(), buffer, indent1 + indent, indent);
            }
            this.endElement(type, indent1, buffer);
        }
        this.endElement("delete", indent, buffer);
    }

    private void startTnElement(Transaction tn, String op, String indent, StringBuffer buffer) {
        buffer.append(indent);
        buffer.append("<");
        buffer.append(op);
        buffer.append(" author=\"");
        buffer.append(tn.getAuthor());
        buffer.append("\" ts=\"");
        buffer.append(this.dateFormat.format(tn.getDate()));
        buffer.append("\">\n");
    }

    private void startElement(String elmName, String indent, StringBuffer buffer) {
        buffer.append(indent);
        buffer.append("<");
        buffer.append(elmName);
        buffer.append(">\n");
    }

    private void endElement(String elmName, String indent, StringBuffer buffer) {
        buffer.append(indent);
        buffer.append("</");
        buffer.append(elmName);
        buffer.append(">\n");
    }

    private void saveUpdateTransaction(UpdateTransaction tn, StringBuffer buffer, String indent) {
        TransactionSubpart subpart = tn.getSubpart();
        SeqFeatureI feature = tn.getSeqFeature();
        Object preValue = tn.getOldSubpartValue();
        if (preValue == null) {
            if (Config.DEBUG) {
                String m = "DEBUG: Programmer error: prevalue is null for UpdateTransaction on " + feature.getName() + " subpart " + subpart + ". Transaction ignored.";
                System.out.println(m);
            }
            return;
        }
        this.startTnElement(tn, "update", indent, buffer);
        String indent1 = indent + indent;
        String type = feature.getFeatureType();
        if (feature instanceof ExonI) {
            this.saveExon((ExonI)feature, feature.getParent(), indent1, buffer, false);
        } else {
            buffer.append(indent1);
            buffer.append("<");
            buffer.append(type);
            buffer.append(" name=\"");
            buffer.append(feature.getName());
            buffer.append("\">\n");
        }
        String indent2 = indent1 + indent;
        String subpartName = subpart.toString();
        if (subpart == TransactionSubpart.LIMITS || subpart == TransactionSubpart.PEPTIDE_LIMITS) {
            buffer.append(indent2);
            buffer.append("<");
            buffer.append(subpartName);
            buffer.append(" start=\"");
            Range oldRange = (Range)preValue;
            buffer.append(oldRange.getStart());
            buffer.append("\" end=\"");
            buffer.append(oldRange.getEnd());
            buffer.append("\" />\n");
        } else if (subpart == TransactionSubpart.PARENT) {
            buffer.append(indent2);
            buffer.append("<");
            buffer.append(subpartName);
            buffer.append(" name=\"");
            SeqFeatureI parentFeature = (SeqFeatureI)preValue;
            if (parentFeature != null) {
                buffer.append(parentFeature.getName());
            } else {
                buffer.append("null");
            }
            buffer.append("\" />\n");
        } else {
            this.startElement(subpartName, indent2, buffer);
            if (subpart == TransactionSubpart.COMMENT || subpart == TransactionSubpart.SYNONYM) {
                buffer.append(indent2 + indent);
                buffer.append("<rank>");
                buffer.append(tn.getSubpartRank());
                buffer.append("</rank>\n");
            }
            buffer.append(indent2 + indent);
            buffer.append("<value>");
            buffer.append(preValue.toString());
            buffer.append("</value>\n");
            this.endElement(subpartName, indent2, buffer);
        }
        this.endElement(type, indent1, buffer);
        this.endElement("update", indent, buffer);
    }

    private void saveAddTransaction(AddTransaction tn, StringBuffer buffer, String indent) {
        SeqFeatureI feature = tn.getSeqFeature();
        this.startTnElement(tn, "add", indent, buffer);
        String indent1 = indent + indent;
        if (feature instanceof ExonI) {
            this.saveExon((ExonI)feature, feature.getParent(), indent1, buffer, true);
        } else {
            buffer.append(indent1);
            String type = feature.getFeatureType();
            buffer.append("<");
            buffer.append(type);
            buffer.append(" name=\"");
            buffer.append(feature.getName());
            buffer.append("\">\n");
            if (tn.getSubpart() != null) {
                this.saveSubpart(tn, tn.getNewSubpartValue(), buffer, indent1 + indent, indent);
            }
            this.endElement(type, indent1, buffer);
        }
        this.endElement("add", indent, buffer);
    }

    private void saveSubpart(Transaction tn, Object subpartValue, StringBuffer buffer, String indent2, String indent) {
        String subpartName = tn.getSubpart().toString();
        this.startElement(subpartName, indent2, buffer);
        if (tn.getSubpart() == TransactionSubpart.COMMENT) {
            this.saveComment((Comment)subpartValue, indent2 + indent, buffer);
        } else if (tn.getSubpart() == TransactionSubpart.DBXREF) {
            this.saveDbxref((DbXref)subpartValue, indent2 + indent, buffer);
        } else {
            buffer.append(indent2 + indent);
            buffer.append("<value>");
            buffer.append(subpartValue.toString());
            buffer.append("</value>\n");
        }
        this.endElement(subpartName, indent2, buffer);
    }

    private void saveDbxref(DbXref dbxref, String indent, StringBuffer buffer) {
        buffer.append(indent);
        buffer.append("<xref_db>");
        buffer.append(dbxref.getDbName());
        buffer.append("</xref_db>\n");
        buffer.append(indent);
        buffer.append("<db_xref_id>");
        buffer.append(dbxref.getIdValue());
        buffer.append("</db_xref_id>\n");
    }

    private DbXref loadDbxref(Element dbxrefElm, AnnotatedFeatureI feature) {
        Object tmp;
        String id = null;
        String dbName = null;
        NodeList list = dbxrefElm.getChildNodes();
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            tmp = list.item(i);
            if (tmp.getNodeName().equals("xref_db")) {
                dbName = tmp.getFirstChild().getNodeValue();
                continue;
            }
            if (!tmp.getNodeName().equals("db_xref_id")) continue;
            id = tmp.getFirstChild().getNodeValue();
        }
        if (feature.getDbXrefs() != null) {
            Iterator it = feature.getDbXrefs().iterator();
            while (it.hasNext()) {
                tmp = (DbXref)it.next();
                if (!((DbXref)tmp).getIdValue().equals(id) || !((DbXref)tmp).getDbName().equals(dbName)) continue;
                return tmp;
            }
        }
        return null;
    }

    private void saveComment(Comment comment, String indent, StringBuffer buffer) {
        if (comment == null) {
            System.out.println("Apollo Transaction has null comment.");
            return;
        }
        buffer.append(indent);
        buffer.append("<text>");
        if (comment.getText() != null && !comment.getText().equals("")) {
            buffer.append(comment.getText());
        } else {
            System.out.println("Saving transaction with faulty comment. It has no text.");
        }
        buffer.append("</text>\n");
        buffer.append(indent);
        buffer.append("<person>");
        buffer.append(comment.getPerson());
        buffer.append("</person>\n");
        buffer.append(indent);
        buffer.append("<ts>");
        buffer.append(comment.getTimeStamp());
        buffer.append("</ts>\n");
    }

    private Comment loadComment(Element commentElm, boolean needCreate, AnnotatedFeatureI feature) throws SubpartException {
        String text = null;
        String person = null;
        String ts = null;
        long tsLong = 0L;
        NodeList list = commentElm.getChildNodes();
        int size = list.getLength();
        if (size == 0) {
            throw new SubpartException("Comment xml has no body");
        }
        for (int i = 0; i < size; ++i) {
            Node node = list.item(i);
            String nodeName = node.getNodeName();
            try {
                if (nodeName.equals("text")) {
                    text = this.getFirstChildString(node);
                    continue;
                }
                if (nodeName.equals("person")) {
                    person = this.getFirstChildString(node);
                    continue;
                }
                if (!nodeName.equals("ts")) continue;
                ts = this.getFirstChildString(node);
                tsLong = Long.parseLong(ts);
                continue;
            }
            catch (NoChildException nce) {
                throw new SubpartException("Comment " + nodeName + " is empty");
            }
        }
        if (text == null) {
            throw new SubpartException("Failed to get text for comment");
        }
        Comment comment = null;
        if (needCreate) {
            comment = new Comment(null, text, person, tsLong);
        } else {
            Vector comments = feature.getComments();
            if (comments != null) {
                Iterator it = comments.iterator();
                while (it.hasNext()) {
                    Comment tmp = (Comment)it.next();
                    if (!tmp.getPerson().equals(person) || !tmp.getText().equals(text)) continue;
                    comment = tmp;
                    break;
                }
            }
            if (comment == null) {
                throw new SubpartException("Transaction Comment not found in data, person: " + person + " text: " + text);
            }
        }
        return comment;
    }

    private String getFirstChildString(Node node) throws NoChildException {
        Node childNode = node.getFirstChild();
        if (childNode == null) {
            throw new NoChildException();
        }
        return childNode.getNodeValue();
    }

    private void saveToFile(StringBuffer buffer) throws IOException {
        Writer writer = this.getWriter();
        writer.write(buffer.toString());
        writer.flush();
    }

    private void load(CurationSet curation) throws IOException {
        if (this.fileName == null) {
            throw new IllegalStateException("TransactionXMLAdapter.load(): no transaction file name defined");
        }
        File file = new File(this.fileName);
        if (!file.exists()) {
            return;
        }
        System.out.println("Loading transactions from " + this.fileName + "...");
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            doc = builder.parse(file);
        }
        catch (Exception e) {
            System.err.println("TransactionXMLAdapter.load(): error in transaction file " + this.fileName + ":\n" + e);
            e.printStackTrace();
        }
        if (doc == null) {
            return;
        }
        Element root = doc.getDocumentElement();
        this.getTransFromTopElement(root, curation);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void getTransFromTopElement(Element root, CurationSet curation) {
        TransactionManager transactionList = new TransactionManager();
        if (curation.hasTransactionManager()) {
            transactionList = curation.getTransactionManager();
        }
        NodeList tranElms = root.getChildNodes();
        int size = tranElms.getLength();
        Node tmp = null;
        Element elm = null;
        Transaction tn = null;
        int i = 0;
        while (true) {
            if (i >= size) {
                curation.setTransactionManager(transactionList);
                return;
            }
            tmp = tranElms.item(i);
            if (tmp.getNodeType() == 1) {
                block13: {
                    elm = (Element)tmp;
                    String name = elm.getNodeName();
                    try {
                        if (name.equals("delete")) {
                            tn = this.loadDeleteTransaction(elm, curation);
                            break block13;
                        }
                        if (name.equals("add")) {
                            tn = this.loadAddTransaction(elm, curation);
                            break block13;
                        }
                        if (name.equals("update")) {
                            tn = this.loadUpdateTransaction(elm, curation);
                        } else if (!name.equals("compound")) {
                            // empty if block
                        }
                    }
                    catch (SubpartException se) {
                        System.out.println("Dropping " + name + " Transaction due to faulty subpart, " + "(element #" + i + ") " + se.getMessage());
                    }
                    catch (IllegalArgumentException e) {
                        System.out.println("\nThere are problems with transaction file " + this.fileName + "\nTransactions will not be loaded:\n" + e.getMessage() + "\n");
                        System.out.println("But don't worry--Apollo should run fine.  It doesn't need the transactions;\nthose are mostly useful for updating your database.");
                        return;
                    }
                }
                if (tn != null) {
                    transactionList.addTransaction(tn);
                }
            }
            ++i;
        }
    }

    private Transaction loadUpdateTransaction(Element elm, CurationSet curation) {
        UpdateTransaction tn = new UpdateTransaction();
        this.startLoadTransaction(tn, elm);
        Element featureElm = this.getFirstElm(elm);
        if (featureElm == null) {
            throw new IllegalArgumentException("TransactionXMLAdapter.loadUpdateTransaction():  in transaction file " + this.fileName + ",\n found invalid transaction element.");
        }
        String typeName = featureElm.getNodeName();
        SeqFeatureI updatedFeature = null;
        if (typeName.equals("exon")) {
            updatedFeature = this.loadExon(featureElm, curation);
        } else {
            String name = featureElm.getAttribute("name");
            if (name != null && name.length() > 0) {
                updatedFeature = this.getFeatureByName(curation, name);
            }
        }
        if (updatedFeature == null) {
            throw new IllegalArgumentException("TransactionXMLAdapter.loadUpdateTransaction():  in transaction file " + this.fileName + ",\n cannot find the updated SeqFeaureI.");
        }
        tn.setSeqFeature(updatedFeature);
        Element subpartElm = this.getFirstElm(featureElm);
        if (subpartElm == null) {
            throw new IllegalArgumentException("TransactionXMLAdapter.loadUpdateTransaction():  in transaction file " + this.fileName + ",\n no subpart specified for a UpdateTransaction.");
        }
        String subpartName = subpartElm.getNodeName();
        TransactionSubpart tsSubpart = TransactionSubpart.stringToSubpart(subpartName);
        tn.setSubpart(tsSubpart);
        if (tsSubpart == TransactionSubpart.LIMITS || tsSubpart == TransactionSubpart.PEPTIDE_LIMITS) {
            Range oldRange = new Range();
            String start = subpartElm.getAttribute("start");
            oldRange.setStart(Integer.parseInt(start));
            String end = subpartElm.getAttribute("end");
            oldRange.setEnd(Integer.parseInt(end));
            tn.setOldSubpartValue(oldRange);
        } else if (tsSubpart == TransactionSubpart.PARENT) {
            if (updatedFeature instanceof ExonI) {
                String name = subpartElm.getAttribute("name");
                SeqFeatureI oldParent = this.getFeatureByName(curation, name);
                if (oldParent == null) {
                    throw new IllegalArgumentException("TransactionXMLAdapter.loadUpdateTransaction():  in transaction file " + this.fileName + ",\n cannot find old parent for a UpdateTransaction.");
                }
                tn.setOldSubpartValue(oldParent);
            }
        } else {
            NodeList list = subpartElm.getChildNodes();
            int size = list.getLength();
            for (int i = 0; i < size; ++i) {
                Node tmp = list.item(i);
                if (tmp.getNodeName().equals("rank")) {
                    String text = tmp.getFirstChild().getNodeValue();
                    tn.setSubpartRank(Integer.parseInt(text));
                    continue;
                }
                if (!tmp.getNodeName().equals("value")) continue;
                Element valueElm = (Element)tmp;
                String text = valueElm.getFirstChild().getNodeValue();
                if (text.equals("true") || text.equals("false")) {
                    tn.setOldSubpartValue(Boolean.valueOf(text));
                    continue;
                }
                tn.setOldSubpartValue(text);
            }
        }
        return tn;
    }

    private Transaction loadAddTransaction(Element elm, CurationSet curation) throws SubpartException, IllegalArgumentException {
        AddTransaction tn = new AddTransaction();
        this.startLoadTransaction(tn, elm);
        Element featureElm = this.getFirstElm(elm);
        if (featureElm == null) {
            throw new IllegalArgumentException("TransactionXMLAdapter.loadAddTransaction():  in transaction file " + this.fileName + " " + ",\n not a valid transaction element.");
        }
        String typeName = featureElm.getNodeName();
        if (typeName.equals("exon")) {
            SeqFeatureI exon = this.loadExon(featureElm, curation);
            if (exon == null) {
                throw new IllegalArgumentException("TransactionXMLAdapter.loadAddTransaction():  in transaction file " + this.fileName + ",\n an exon cannot be found: " + featureElm.getAttribute("start"));
            }
            tn.setSeqFeature(exon);
        } else {
            SeqFeatureI addedFeat;
            String name = featureElm.getAttribute("name");
            if (name != null && name.length() > 0) {
                addedFeat = this.getFeatureByName(curation, name);
                if (addedFeat == null) {
                    throw new IllegalArgumentException("TransactionXMLAdapter.loadAddTransaction(): \n in transaction file " + this.fileName + ", " + "cannot find feature " + name + " for AddTrasaction.");
                }
            } else {
                throw new IllegalArgumentException("TransactionXMLAdapter.loadAddTransaction():  in transaction file " + this.fileName + ",\n " + "no name definied for an AddTransaction.");
            }
            tn.setSeqFeature(addedFeat);
            this.loadSubpart(tn, featureElm);
        }
        return tn;
    }

    private void loadSubpart(Transaction tn, Element featureElm) throws SubpartException {
        boolean needNewComment = tn instanceof DeleteTransaction;
        Element subpartElm = this.getFirstElm(featureElm);
        if (subpartElm == null) {
            return;
        }
        String subpartName = subpartElm.getNodeName();
        TransactionSubpart subpart = TransactionSubpart.stringToSubpart(subpartName);
        tn.setSubpart(subpart);
        Object subpartValue = null;
        if (subpart == TransactionSubpart.COMMENT) {
            subpartValue = this.loadComment(subpartElm, needNewComment, (AnnotatedFeatureI)tn.getSeqFeature());
        } else if (subpart == TransactionSubpart.DBXREF) {
            subpartValue = this.loadDbxref(subpartElm, (AnnotatedFeatureI)tn.getSeqFeature());
        } else {
            Element valueElm = this.getFirstElm(subpartElm);
            subpartValue = valueElm.getFirstChild().getNodeValue();
        }
        if (subpartValue == null) {
            if (Config.DEBUG) {
                System.out.println("DEBUG. null subpart value for trans. Trace:");
                new Throwable().printStackTrace();
            }
            throw new SubpartException("Failed to get subpart value");
        }
        if (tn.isAdd()) {
            tn.setNewSubpartValue(subpartValue);
        } else if (tn.isDelete()) {
            tn.setOldSubpartValue(subpartValue);
        }
    }

    private void startLoadTransaction(Transaction tn, Element tnElm) {
        String ts;
        String author = tnElm.getAttribute("author");
        if (author != null && author.length() > 0) {
            tn.setAuthor(author);
        }
        if ((ts = tnElm.getAttribute("ts")) != null && ts.length() > 0) {
            try {
                Date date = this.dateFormat.parse(ts);
                tn.setDate(date);
            }
            catch (ParseException e) {
                System.err.println("TransactionXMLAdatper.startLoadTransaction():  in transaction file " + this.fileName + ",\n parsing error " + e);
                e.printStackTrace();
            }
        }
    }

    private Element getFirstElm(Element parentElm) {
        NodeList children = parentElm.getChildNodes();
        int size = children.getLength();
        Element childElm = null;
        for (int i = 0; i < size; ++i) {
            Node tmp = children.item(i);
            if (tmp.getNodeType() != 1) continue;
            childElm = (Element)tmp;
            break;
        }
        return childElm;
    }

    private SeqFeatureI createFeature(Element featureElm) {
        String type = featureElm.getNodeName();
        String name = featureElm.getAttribute("name");
        String id = featureElm.getAttribute("id");
        AnnotatedFeature feature = null;
        String typeName = featureElm.getNodeName();
        if (typeName.equals("exon")) {
            int end;
            feature = new Exon();
            int start = Integer.parseInt(featureElm.getAttribute("start"));
            if (start > (end = Integer.parseInt(featureElm.getAttribute("end")))) {
                feature.setStrand(-1);
            } else {
                feature.setStrand(1);
            }
            feature.setStart(start);
            feature.setEnd(end);
        } else if (typeName.equals("transcript")) {
            feature = new Transcript();
        } else {
            feature = new AnnotatedFeature();
            feature.setFeatureType(type);
        }
        if (name != null && name.length() > 0) {
            feature.setName(name);
        }
        if (id != null && id.length() > 0) {
            feature.setId(id);
        }
        return feature;
    }

    private SeqFeatureI getFeatureByName(CurationSet curation, String name) {
        FeatureList features = curation.getAnnots().findFeaturesByName(name);
        if (features == null || features.size() == 0) {
            return null;
        }
        SeqFeatureI feature = (SeqFeatureI)features.get(0);
        return feature;
    }

    private Transaction loadDeleteTransaction(Element elm, CurationSet curation) throws SubpartException {
        DeleteTransaction tn = new DeleteTransaction();
        this.startLoadTransaction(tn, elm);
        Element featureElm = this.getFirstElm(elm);
        if (featureElm == null) {
            throw new IllegalArgumentException("TransactionXMLAdapter.loadDeleteTransaction():  in transaction file " + this.fileName + ",\n " + "invalid delete transaction element.");
        }
        SeqFeatureI deletedFeature = this.createFeature(featureElm);
        tn.setSeqFeature(deletedFeature);
        String parentName = featureElm.getAttribute("parentName");
        if (parentName != null && parentName.length() > 0) {
            SeqFeatureI parentFeature = this.getFeatureByName(curation, parentName);
            if (parentFeature == null && deletedFeature instanceof Transcript) {
                throw new IllegalArgumentException("TransactionXMLAdapter.loadDeleteTransaction:  in transaction file " + this.fileName + ",\n " + "The gene of transcript" + deletedFeature.getName() + "can not be found, potential bug in game transaction save.");
            }
            if (parentFeature == null) {
                throw new IllegalArgumentException("TransactionXMLAdapter.loadDeleteTransaction:  in transaction file " + this.fileName + ",\n " + "parent feature cannot be found for deleted feature" + deletedFeature.getName());
            }
            tn.setParentFeature(parentFeature);
            deletedFeature.setRefFeature(parentFeature);
        }
        this.loadSubpart(tn, featureElm);
        return tn;
    }

    private class SubpartException
    extends Exception {
        private SubpartException(String msg) {
            super(msg);
        }
    }

    private class NoChildException
    extends Exception {
        private NoChildException() {
        }
    }
}

