/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.gamexml;

import apollo.config.ApolloNameAdapterI;
import apollo.config.Config;
import apollo.config.Style;
import apollo.dataadapter.AbstractApolloAdapter;
import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInput;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.Region;
import apollo.dataadapter.StateInformation;
import apollo.dataadapter.TransactionOutputAdapter;
import apollo.dataadapter.chado.ChadoTransactionTransformer;
import apollo.dataadapter.chadoxml.ChadoTransactionXMLWriter;
import apollo.dataadapter.debug.DisplayTool;
import apollo.dataadapter.gamexml.GAMEAdapterGUI;
import apollo.dataadapter.gamexml.GAMESave;
import apollo.dataadapter.gamexml.TransactionXMLAdapter;
import apollo.dataadapter.gamexml.XMLParser;
import apollo.datamodel.AnnotatedFeature;
import apollo.datamodel.AnnotatedFeatureI;
import apollo.datamodel.Comment;
import apollo.datamodel.CurationSet;
import apollo.datamodel.DbXref;
import apollo.datamodel.Exon;
import apollo.datamodel.ExonI;
import apollo.datamodel.FeaturePair;
import apollo.datamodel.FeaturePairI;
import apollo.datamodel.FeatureSet;
import apollo.datamodel.FeatureSetI;
import apollo.datamodel.Protein;
import apollo.datamodel.RangeI;
import apollo.datamodel.SeqFeature;
import apollo.datamodel.SeqFeatureI;
import apollo.datamodel.Sequence;
import apollo.datamodel.SequenceI;
import apollo.datamodel.StrandedFeatureSet;
import apollo.datamodel.StrandedFeatureSetI;
import apollo.datamodel.Synonym;
import apollo.datamodel.Transcript;
import apollo.datamodel.seq.GAMESequence;
import apollo.main.DataLoader;
import apollo.main.LoadUtil;
import apollo.main.Version;
import apollo.util.DateUtil;
import apollo.util.FastaHeader;
import apollo.util.HTMLUtil;
import apollo.util.IOUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.bdgp.io.DataAdapterUI;
import org.bdgp.io.IOOperation;
import org.bdgp.util.ProgressEvent;
import org.bdgp.xml.XMLElement;
import org.w3c.dom.Element;

public class GAMEAdapter
extends AbstractApolloAdapter {
    protected static boolean DEBUG = Config.DEBUG;
    protected boolean NO_GUI = false;
    String region;
    XMLElement game_element = null;
    int element_count = 0;
    SequenceI curated_seq = null;
    StrandedFeatureSetI analyses = null;
    Hashtable all_analyses = null;
    private int padLeft = -1;
    private int padRight = -1;
    static String originalFilename = null;
    private String NAME_LABEL_FOR_WRITING = "GAME XML format";
    private String NAME_LABEL_FOR_READING = "GAME XML format";
    IOOperation[] supportedOperations = new IOOperation[]{ApolloDataAdapterI.OP_READ_DATA, ApolloDataAdapterI.OP_WRITE_DATA, ApolloDataAdapterI.OP_READ_SEQUENCE, ApolloDataAdapterI.OP_APPEND_DATA};
    private static String sesame = "inserted at base ";

    public GAMEAdapter() {
        this.setInputType(DataInputType.FILE);
        this.setName(this.NAME_LABEL_FOR_READING);
    }

    public GAMEAdapter(DataInputType inputType, String input) {
        this.setInputType(inputType);
        this.setInput(input);
    }

    public GAMEAdapter(DataInputType inputType, String input, boolean noGUI) {
        this.NO_GUI = noGUI;
        this.setInputType(inputType);
        this.setInput(input);
    }

    public void init() {
    }

    public String getType() {
        return "GAME XML source (filename, URL, gene=cact, band=34A, or location=3L:12345-67890)";
    }

    public IOOperation[] getSupportedOperations() {
        return this.supportedOperations;
    }

    public void setName(String nameForReading) {
        super.setName(nameForReading);
        this.NAME_LABEL_FOR_READING = nameForReading;
    }

    public DataAdapterUI getUI(IOOperation op) {
        if (!super.operationIsSupported(op)) {
            return null;
        }
        Object ui = super.getCachedUI(op);
        if (ui == null) {
            ui = new GAMEAdapterGUI(op);
            super.cacheUI(op, (DataAdapterUI)ui);
        }
        if (op.equals((Object)ApolloDataAdapterI.OP_WRITE_DATA)) {
            super.setName(this.NAME_LABEL_FOR_WRITING);
        } else {
            super.setName(this.NAME_LABEL_FOR_READING);
        }
        return ui;
    }

    public void setPadLeft(int padLeft) {
        this.padLeft = padLeft;
    }

    public void setPadRight(int padRight) {
        this.padRight = padRight;
    }

    private int getPadLeft() {
        if (this.padLeft == -1) {
            this.padLeft = this.getGAMEStyle().getDefaultPadding();
        }
        return this.padLeft;
    }

    private int getPadRight() {
        if (this.padRight == -1) {
            this.padRight = this.getGAMEStyle().getDefaultPadding();
        }
        return this.padRight;
    }

    public Properties getStateInformation() {
        StateInformation props = new StateInformation();
        props.put("Input Type", this.getInputType().toString());
        if (this.getInput() != null) {
            props.put("InputString", this.getInput());
        }
        return props;
    }

    public void setStateInformation(Properties props) {
        String typeString = props.getProperty("Input Type");
        try {
            DataInputType type = DataInputType.stringToType(typeString);
            String inputString = props.getProperty("InputString");
            this.setDataInput(new DataInput(type, inputString));
        }
        catch (DataInputType.UnknownTypeException e) {
            System.out.println(e.getMessage() + " Can not set game adapter state info");
        }
    }

    public void setRegion(SequenceI seq) throws ApolloAdapterException {
        if (seq != null) {
            this.curated_seq = seq;
            this.setRegion(seq.getName());
        }
    }

    public boolean hasLinkData() {
        return true;
    }

    public void setOriginalFilename(String file) {
        originalFilename = file;
    }

    public static void main(String[] args) throws ApolloAdapterException {
        DEBUG = true;
        String url = "http://www.fruitfly.org/annot/gbunits/xml/AE003650.xml";
        GAMEAdapter databoy = new GAMEAdapter(DataInputType.URL, url);
        GAMEAdapter.testAdapter(databoy);
        databoy = new GAMEAdapter(DataInputType.GENE, "cact");
        GAMEAdapter.testAdapter(databoy);
        databoy = new GAMEAdapter(DataInputType.CYTOLOGY, "34A");
        GAMEAdapter.testAdapter(databoy);
        databoy = new GAMEAdapter(DataInputType.SCAFFOLD, "AE003490");
        GAMEAdapter.testAdapter(databoy);
        String file = "/users/mgibson/cvs/apollo/dev/sanger/data/josh";
        if (args.length > 0) {
            file = args[0];
        }
        databoy = new GAMEAdapter(DataInputType.FILE, file);
        GAMEAdapter.testAdapter(databoy);
        String seq = "actggcgtgctgtgttattagtgatgatgtcgcaatcgtgaatcgatgcatgcacacatcgtgtgtgtggtctgcgaatatggcattccgtaaagtgccgcgcgtatgtcgcgcgattatgatgtatgctgctgatgtagctgtgatattctaatgagtgctgatcgtgatgtagtcgtagtctagctagctagtcgatcgtagctacgtagctagctagcttgtgtgcgcgcgctg";
        databoy = new GAMEAdapter(DataInputType.SEQUENCE, seq);
        GAMEAdapter.testAdapter(databoy);
    }

    private static void testAdapter(GAMEAdapter databoy) {
        try {
            CurationSet curation = databoy.getCurationSet();
            DisplayTool.showFeatureSet(curation.getResults());
        }
        catch (ApolloAdapterException ex) {
            System.err.println("No data to read");
            System.err.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void commitChanges(CurationSet curation) {
        this.commitChanges(curation, true, true);
    }

    public void commitChanges(CurationSet curation, boolean saveAnnots, boolean saveResults) {
        File handle;
        if (this.getInputType() != DataInputType.FILE) {
            DataLoader loader = new DataLoader();
            loader.saveFileDialog(curation);
            return;
        }
        String filename = IOUtil.findFile(this.getInput(), true);
        if (filename == null) {
            filename = this.getInput();
        }
        if (filename == null) {
            return;
        }
        if (Config.getConfirmOverwrite() && (handle = new File(filename)).exists()) {
            if (!LoadUtil.areYouSure(filename + " already exists--overwrite?")) {
                DataLoader loader = new DataLoader();
                loader.saveFileDialog(curation);
                return;
            }
            System.out.println("Overwriting existing file " + filename);
        }
        String msg = "Saving data to file " + filename;
        this.setInput(filename);
        this.fireProgressEvent(new ProgressEvent((Object)this, new Double(10.0), msg));
        if (GAMESave.writeXML(curation, filename, saveAnnots, saveResults, "Apollo version: " + Version.getVersion(), false)) {
            this.saveTransactions(curation, filename);
        } else {
            String message = "Failed to save GAME XML to " + filename;
            System.err.println(message);
            JOptionPane.showMessageDialog(null, message, "Warning", 2);
        }
    }

    private void saveTransactions(CurationSet curation, String fileName) {
        if (curation.getTransactionManager() == null) {
            return;
        }
        try {
            curation.getTransactionManager().coalesce();
            if (Config.outputTransactionXML() && !this.getGAMEStyle().transactionsAreInGameFile()) {
                this.saveApolloTransactions(curation, fileName);
            }
        }
        catch (Exception e) {
            System.err.println("GAMEAdapter.saveTransactions() (game): " + e);
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Apollo Transactions cannot be saved.", "Error", 0);
        }
        try {
            if (Config.isChadoTnOutputNeeded()) {
                ChadoTransactionXMLWriter output = new ChadoTransactionXMLWriter();
                if (curation.isChromosomeArmUsed()) {
                    output.setMapID(curation.getChromosome());
                    output.setMapType("chromosome_arm");
                } else {
                    output.setMapID(curation.getChromosome());
                    output.setMapType("chromosome");
                }
                ((TransactionOutputAdapter)output).setTransformer(new ChadoTransactionTransformer());
                ((TransactionOutputAdapter)output).setTarget(fileName);
                output.commitTransactions(curation.getTransactionManager());
            }
        }
        catch (Exception e) {
            System.err.println("Failed to save chado transactions. GAMEAdapter.saveTransactions() (chado): " + e);
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Chado Transactions cannot be saved.", "Error", 0);
        }
    }

    private void saveApolloTransactions(CurationSet curationSet, String fileName) {
        try {
            TransactionXMLAdapter tnAdapter = new TransactionXMLAdapter();
            tnAdapter.setFileName(fileName);
            tnAdapter.save(curationSet.getTransactionManager().getTransactions());
        }
        catch (IOException e) {
            System.err.println("GAMEAdapter.saveTransactionsInGAME(): " + e);
            e.printStackTrace();
        }
    }

    public CurationSet getCurationSet() throws ApolloAdapterException {
        CurationSet curation = new CurationSet();
        try {
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(5.0), "Finding data..."));
            InputStream xml_stream = this.xmlInputStream(this.getDataInput());
            BufferedInputStream bis = new BufferedInputStream(xml_stream);
            if (!this.NO_GUI) {
                super.clearOldData();
            }
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(10.0), "Reading GAME XML..."));
            XMLParser parser = new XMLParser();
            this.game_element = parser.readXML(bis);
            if (this.game_element == null) {
                String msg = "GAME XML input stream was empty--nothing loaded.";
                System.err.println(msg);
                throw new ApolloAdapterException(msg);
            }
            xml_stream.close();
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(20.0), "Getting genomic sequence..."));
            this.getFocusSequence(curation);
            if (this.curated_seq == null) {
                String m = "Failed to load genomic sequence for the entry.\nOne possible cause could be the absence of a 'seq' element with a\n'focus=true' attribute, which is required (even if it has no 'residues').\n";
                System.err.println(m);
                throw new ApolloAdapterException(m);
            }
            curation.setRefSequence(this.curated_seq);
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(25.0), "Setting genome position..."));
            this.getGenomePosition(curation);
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(30.0), "Reading annotations and results..."));
            this.getResultsAndAnnots(curation);
            if (this.getDataInput().isFile()) {
                this.fireProgressEvent(new ProgressEvent((Object)this, new Double(85.0), "Reading transaction file..."));
                TransactionXMLAdapter.loadTransactions(this.getInput(), curation);
            }
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(90.0), "Cleaning up..."));
            System.out.println("Completed XML parse of " + curation.getName());
            parser.clean();
            this.game_element = null;
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(95.0), "Drawing..."));
        }
        catch (ApolloAdapterException dae) {
            throw dae;
        }
        catch (Exception ex2) {
            System.out.println("Printing stack trace for debugging:");
            ex2.printStackTrace();
            throw new ApolloAdapterException(ex2.getMessage());
        }
        curation.setInputFilename(originalFilename);
        return curation;
    }

    public Boolean addToCurationSet() throws ApolloAdapterException {
        boolean okay = false;
        try {
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(5.0), "Finding data..."));
            InputStream xml_stream = this.xmlInputStream(this.getDataInput());
            BufferedInputStream bis = new BufferedInputStream(xml_stream);
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(10.0), "Reading XML..."));
            XMLParser parser = new XMLParser();
            this.game_element = parser.readXML(bis);
            if (this.game_element == null) {
                throw new ApolloAdapterException("GAME XML input stream was empty--nothing loaded.");
            }
            xml_stream.close();
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(20.0), "Getting genomic sequence..."));
            this.getFocusSequence(this.curation_set);
            this.curation_set.setRefSequence(this.curated_seq);
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(25.0), "Setting genome position..."));
            this.getGenomePosition(this.curation_set);
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(30.0), "Setting annotations and results..."));
            this.getResultsAndAnnots(this.curation_set);
            if (this.getDataInput().isFile()) {
                this.fireProgressEvent(new ProgressEvent((Object)this, new Double(90.0), "Reading transaction file..."));
                TransactionXMLAdapter.loadTransactions(this.getInput(), this.curation_set);
            }
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(90.0), "Cleaning up..."));
            System.out.println("Completed XML parse of " + this.curation_set.getName());
            parser.clean();
            this.game_element = null;
            this.fireProgressEvent(new ProgressEvent((Object)this, new Double(95.0), "Drawing..."));
            okay = true;
        }
        catch (ApolloAdapterException dae) {
            throw dae;
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
            throw new ApolloAdapterException(ex2.getMessage());
        }
        return new Boolean(okay);
    }

    private InputStream xmlInputStream(DataInput dataInput) throws ApolloAdapterException {
        InputStream stream = null;
        DataInputType type = dataInput.getType();
        String input = dataInput.getInputString();
        if (type == DataInputType.FILE) {
            stream = this.getStreamFromFile(input);
            this.setOriginalFilename(input);
        } else if (type == DataInputType.URL) {
            URL url = this.makeUrlFromString(input);
            if (url == null) {
                String message = "Couldn't find URL for " + this.getInput();
                System.err.println(message);
                throw new ApolloAdapterException(message);
            }
            System.err.println("Trying to open URL " + input + " to read GAME XML...");
            stream = IOUtil.getStreamFromUrl(url, "URL " + input + " not found");
            this.setOriginalFilename(url.toString());
        } else if (type == DataInputType.GENE) {
            String err = "Can't connect to URL for request gene=" + input + "--server not responding.";
            String notfound = "Gene " + input + " not found (or server not responding)";
            System.err.println("Looking up GAME XML data for gene " + input + "...");
            stream = IOUtil.getStreamFromUrl(this.getURLForGene(input), err, notfound);
            this.setOriginalFilename(this.getURLForGene(input).toString());
        } else if (type == DataInputType.CYTOLOGY) {
            String err = "Can't connect to URL for band=" + input + "--server not responding.";
            String notfound = "Cytological band " + input + " not found (or server not responding)";
            System.err.println("Looking up GAME XML data for band " + input + "...");
            stream = IOUtil.getStreamFromUrl(this.getURLForBand(input), err, notfound);
            this.setOriginalFilename(this.getURLForBand(input).toString());
        } else if (type == DataInputType.SCAFFOLD) {
            String err = "Can't connect to URL for scaffold=" + input + "--server not responding.";
            String notfound = "Scaffold " + input + " not found (or server not responding)";
            System.err.println("Looking up GAME XML data for scaffold " + input + "...");
            stream = IOUtil.getStreamFromUrl(this.getURLForScaffold(input), err, notfound);
            this.setOriginalFilename(this.getURLForScaffold(input).toString());
        } else if (type == DataInputType.BASEPAIR_RANGE) {
            String err = "Can't connect to URL for requested region--server not responding.";
            String notfound = "Region " + dataInput.getRegion() + " not found (or server not responding)";
            System.err.println("Looking up GAME XML data for range " + dataInput.getRegion() + "...");
            stream = IOUtil.getStreamFromUrl(this.getURLForRange(dataInput.getRegion()), err, notfound);
            this.setOriginalFilename(this.getURLForRange(dataInput.getRegion()).toString());
        }
        return stream;
    }

    private InputStream getStreamFromFile(String filename) throws ApolloAdapterException {
        BufferedReader in;
        FileInputStream stream = null;
        String path = IOUtil.findFile(filename, false);
        try {
            System.out.println("Trying to open GAME XML file " + filename);
            stream = new FileInputStream(path);
        }
        catch (Exception e) {
            stream = null;
            throw new ApolloAdapterException("Error: could not open GAME XML file " + filename + " for reading.");
        }
        try {
            in = new BufferedReader(new FileReader(path));
        }
        catch (Exception e) {
            stream = null;
            throw new ApolloAdapterException("Error: could not open GAME XML file " + path + " for reading.");
        }
        for (int i = 0; i < 12; ++i) {
            String line;
            try {
                line = in.readLine();
            }
            catch (Exception e) {
                in = null;
                throw new ApolloAdapterException("Error: file " + filename + " is empty.");
            }
            if (line == null) {
                in = null;
                throw new ApolloAdapterException("Error: file " + filename + " does not appear to contain GAME XML.");
            }
            if (line.toLowerCase().indexOf("<game") < 0) continue;
            in = null;
            return stream;
        }
        in = null;
        throw new ApolloAdapterException("Error: file " + filename + " does not appear to contain GAME XML.");
    }

    private Style getGAMEStyle() {
        return Config.getStyle(this.getClass().getName());
    }

    public URL makeUrlFromString(String urlString) {
        URL url;
        urlString = this.fillInDatabase(urlString);
        urlString = this.fillInPadding(urlString);
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException ex) {
            System.err.println("caught exception creating URL " + urlString);
            System.out.println(ex.getMessage());
            ex.printStackTrace();
            return null;
        }
        return url;
    }

    public String fillInDatabase(String urlString) {
        String dbField = this.getGAMEStyle().getDatabaseURLField();
        if (dbField == null) {
            return urlString;
        }
        int index = urlString.indexOf(dbField);
        if (index == -1) {
            return urlString;
        }
        StringBuffer sb = new StringBuffer(urlString);
        String dbname = this.getDatabase();
        if (dbname.indexOf("ot available") > 0) {
            return "";
        }
        if (dbname.indexOf(" ") > 0) {
            dbname = dbname.substring(0, dbname.indexOf(" "));
        }
        sb.replace(index, index + dbField.length(), dbname);
        return sb.toString();
    }

    public String getDatabase() {
        if (super.getDatabase() != null) {
            return super.getDatabase();
        }
        return this.getGAMEStyle().getDefaultDatabase();
    }

    public String fillInPadding(String urlString) {
        StringBuffer sb = new StringBuffer(urlString);
        GAMEAdapter.pad(sb, this.getGAMEStyle().getPadLeftURLField(), this.getPadLeft());
        GAMEAdapter.pad(sb, this.getGAMEStyle().getPadRightURLField(), this.getPadRight());
        return sb.toString();
    }

    private static void pad(StringBuffer urlBuff, String field, int pad) {
        if (field == null) {
            return;
        }
        int index = urlBuff.indexOf(field);
        if (index == -1) {
            return;
        }
        urlBuff.replace(index, index + field.length(), pad + "");
    }

    private URL getURLForScaffold(String scaffold) {
        String query = this.getGAMEStyle().getScaffoldUrl() + scaffold;
        URL url = this.makeUrlFromString(query);
        String msg = "Searching for location of scaffold " + scaffold + "...";
        this.fireProgressEvent(new ProgressEvent((Object)this, new Double(2.0), msg));
        return url;
    }

    private URL getURLForGene(String gene) {
        String query = this.getGAMEStyle().getGeneUrl() + gene;
        URL url = this.makeUrlFromString(query);
        String msg = "Searching for location of gene " + gene + "...";
        this.fireProgressEvent(new ProgressEvent((Object)this, new Double(2.0), msg));
        return url;
    }

    private URL getURLForBand(String band) {
        String query = this.getGAMEStyle().getBandUrl() + band;
        URL url = this.makeUrlFromString(query);
        this.fireProgressEvent(new ProgressEvent((Object)this, new Double(2.0), "Searching for cytological location " + band + "--please be patient"));
        return url;
    }

    private URL getURLForRange(Region region) {
        String rangeForUrl = region.getColonDashString();
        String query = this.getGAMEStyle().getRangeUrl() + rangeForUrl;
        URL url = this.makeUrlFromString(query);
        this.fireProgressEvent(new ProgressEvent((Object)this, new Double(5.0), "Searching for region " + rangeForUrl));
        return url;
    }

    private AnnotatedFeatureI getAnnot(XMLElement annot_element, CurationSet curation, StrandedFeatureSetI annots) {
        AnnotatedFeature annot = new AnnotatedFeature();
        annot.setId(annot_element.getID());
        if (annot_element.getAttribute("problem") != null && annot_element.getAttribute("problem").equals("true")) {
            annot.setIsProblematic(true);
        }
        String nickname = null;
        String desc = null;
        Vector elements = annot_element.getChildren();
        for (int i = 0; i < elements.size(); ++i) {
            XMLElement element = (XMLElement)elements.elementAt(i);
            if (element.getType().equals("name")) {
                if (element.getCharData() == null) continue;
                annot.setName(element.getCharData());
                continue;
            }
            if (element.getType().equals("type")) {
                annot.setTopLevelType(element.getCharData());
                annot.setFeatureType(element.getCharData());
                continue;
            }
            if (element.getType().equals("author")) {
                annot.setOwner(element.getCharData());
                continue;
            }
            if (element.getType().equals("synonym") || element.getType().equals("nickname")) {
                Synonym syn = this.getSynonym(element);
                annot.addSynonym(syn);
                nickname = element.getCharData();
                continue;
            }
            if (element.getType().equals("comment")) {
                this.setComment(element, annot);
                continue;
            }
            if (element.getType().equalsIgnoreCase("gene")) {
                this.setGeneInfo(element, annot);
                continue;
            }
            if (element.getType().equals("description")) {
                annot.setDescription(element.getCharData());
                desc = element.getCharData();
                continue;
            }
            if (element.getType().equals("dbxref")) {
                this.setAnnotXref(element, annot);
                continue;
            }
            if (element.getType().equals("aspect")) {
                XMLElement dbx = (XMLElement)element.getChildren().elementAt(0);
                this.setAnnotXref(dbx, annot);
                continue;
            }
            if (element.getType().equals("feature_set")) {
                Transcript transcript = this.getTranscript(element, annot, curation);
                annot.addFeature(transcript);
                String id = transcript.getId();
                if (id == null || id.length() == 0 || id.startsWith("feature_set:")) {
                    ApolloNameAdapterI nameAdapter = this.getCurationState().getNameAdapter(annot);
                    id = nameAdapter.generateId(annots, curation.getName(), transcript);
                }
                transcript.setId(id);
                continue;
            }
            if (element.getType().equals("property")) {
                String type_tag = this.getTypeTag(element);
                if (type_tag.equals("internal_synonym")) {
                    String value = this.getTypeValue(element);
                    Synonym syn = new Synonym(value);
                    syn.addProperty("is_internal", "1");
                    annot.addSynonym(syn);
                    continue;
                }
                this.addOutput(annot, element);
                continue;
            }
            if (!GAMESave.isOneLevelAnnot(annot) || !element.getType().equals("seq_relationship")) continue;
            this.setRange(element, annot, curation.getRefSequence(), curation.getStart() - 1);
        }
        if (annot.getName() == null) {
            if (nickname != null) {
                annot.setName(nickname);
            } else if (desc != null) {
                annot.setName(desc);
            } else {
                annot.setName("");
            }
        }
        this.repairGreek(annot);
        return annot;
    }

    private Synonym getSynonym(XMLElement synElement) {
        String name = synElement.getCharData();
        Synonym syn = new Synonym(name);
        if (synElement.hasAttribute("owner")) {
            syn.setOwner(synElement.getAttribute("owner"));
        }
        return syn;
    }

    private void setComment(XMLElement comment_element, AnnotatedFeatureI sf) {
        String text = null;
        String person = null;
        Date date = null;
        Vector elements = comment_element.getChildren();
        for (int i = 0; i < elements.size(); ++i) {
            XMLElement element = (XMLElement)elements.elementAt(i);
            if (element.getType().equals("text")) {
                text = element.getCharData();
                continue;
            }
            if (element.getType().equals("person")) {
                person = element.getCharData();
                continue;
            }
            if (!element.getType().equals("date")) continue;
            date = DateUtil.makeADate(element.getCharData());
        }
        if (text != null) {
            Comment comment = new Comment();
            comment.setText(text);
            sf.addComment(comment);
            if (comment_element.getAttribute("id") != null) {
                comment.setId(comment_element.getAttribute("id"));
            }
            if (comment_element.getAttribute("internal") != null && comment_element.getAttribute("internal").equals("true") || text.indexOf("nternal view only") >= 0) {
                comment.setIsInternal(true);
            }
            String clue = "no atg translation start identified";
            if (text.toLowerCase().indexOf(clue) >= 0) {
                sf.setMissing5prime(true);
            }
            if (person != null) {
                comment.setPerson(person);
            }
            if (date != null) {
                comment.setTimeStamp(date.getTime());
            }
        }
    }

    private Transcript getTranscript(XMLElement transcript_element, AnnotatedFeatureI gene, CurationSet curation) {
        Transcript transcript = new Transcript();
        transcript.setId(transcript_element.getID());
        int minus1_frameshift = 0;
        int plus1_frameshift = 0;
        String readthrough_stop = null;
        if (transcript_element.getAttribute("problem") != null && transcript_element.getAttribute("problem").equals("true")) {
            transcript.setIsProblematic(true);
        }
        String name = null;
        String desc = null;
        RangeI translateStart = null;
        SeqFeatureI prot = null;
        Vector elements = transcript_element.getChildren();
        for (int i = 0; i < elements.size(); ++i) {
            XMLElement element = (XMLElement)elements.elementAt(i);
            if (element.getType().equals("name")) {
                if (element.getCharData() == null) continue;
                name = element.getCharData();
                transcript.setName(name);
                continue;
            }
            if (element.getType().equals("type")) continue;
            if (element.getType().equals("synonym")) {
                transcript.addSynonym(this.getSynonym(element));
                continue;
            }
            if (element.getType().equals("comment")) {
                this.setComment(element, transcript);
                continue;
            }
            if (element.getType().equals("author")) {
                transcript.setOwner(element.getCharData());
                continue;
            }
            if (element.getType().equals("date")) {
                Date date = DateUtil.makeADate(element.getCharData());
                if (date != null) {
                    transcript.addProperty("date", date.toString());
                    continue;
                }
                transcript.addProperty("date", element.getCharData());
                continue;
            }
            if (element.getType().equals("description")) {
                desc = element.getCharData();
                transcript.setDescription(desc);
                continue;
            }
            if (element.getType().equals("seq_relationship")) {
                this.setRange(element, transcript, curation.getRefSequence(), curation.getStart() - 1);
                gene.setStrand(transcript.getStrand());
                continue;
            }
            if (element.getType().equals("evidence")) {
                this.addEvidence(transcript, element);
                continue;
            }
            if (element.getType().equals("seq")) {
                this.addTranscriptSequence(curation, transcript, element);
                continue;
            }
            if (element.getType().equals("output") || element.getType().equals("property")) {
                String value;
                String type_tag = this.getTypeTag(element);
                if (type_tag.equals("plus_1_translational_frame_shift") || type_tag.equals("plus1_translational_frameshift")) {
                    value = this.getTypeValue(element);
                    plus1_frameshift = Integer.parseInt(value);
                    continue;
                }
                if (type_tag.equals("minus_1_translational_frame_shift") || type_tag.equals("minus1_translational_frameshift")) {
                    value = this.getTypeValue(element);
                    minus1_frameshift = Integer.parseInt(value);
                    continue;
                }
                if (type_tag.equalsIgnoreCase("stop_codon_redefinition_as_selenocysteine")) {
                    value = this.getTypeValue(element);
                    if (!value.toLowerCase().startsWith("t") && !value.equalsIgnoreCase("U")) continue;
                    readthrough_stop = "U";
                    continue;
                }
                if (type_tag.equals("readthrough_stop_codon")) {
                    readthrough_stop = this.getTypeValue(element);
                    continue;
                }
                if (type_tag.equals("internal_synonym")) {
                    value = this.getTypeValue(element);
                    Synonym syn = new Synonym(value);
                    syn.addProperty("is_internal", "1");
                    transcript.addSynonym(syn);
                    continue;
                }
                this.addOutput(transcript, element);
                continue;
            }
            if (element.getType().equals("feature_span")) {
                SeqFeatureI featSpan = this.addTranscriptFeatSpan(element, gene, transcript, curation);
                if (this.isTranslationStart(featSpan)) {
                    translateStart = featSpan;
                }
                if (!featSpan.isProtein()) continue;
                prot = featSpan;
                continue;
            }
            if (element.getCharData() == null || element.getCharData().equals("")) continue;
            System.out.println(transcript_element.getType() + ": Either intentionally ignoring or " + "inadvertently forgetting to parse " + element.getType() + "=" + element.getCharData());
        }
        if (translateStart != null && gene.isProteinCodingGene()) {
            if (transcript.getProperty("missing_start_codon").equals("true")) {
                transcript.calcTranslationStartForLongestPeptide();
            } else {
                boolean foundTranslationStart = transcript.setTranslationStart(translateStart.getStart(), true);
                if (!foundTranslationStart) {
                    transcript.calcTranslationStartForLongestPeptide();
                } else if (transcript.isTransSpliced()) {
                    transcript.sortTransSpliced();
                }
            }
            this.setProteinNameAndId(transcript);
        }
        transcript.setPlus1FrameShiftPosition(plus1_frameshift);
        transcript.setMinus1FrameShiftPosition(minus1_frameshift);
        if (readthrough_stop != null) {
            transcript.setReadThroughStop(readthrough_stop);
        }
        if (name == null) {
            if (desc != null) {
                transcript.setName(desc);
            } else {
                transcript.setName("");
            }
        }
        return transcript;
    }

    private boolean isTranslationStart(SeqFeatureI span) {
        if (span.isProtein()) {
            return true;
        }
        return span.getFeatureType().matches("start_codon|translate offset");
    }

    private void setProteinNameAndId(Transcript transcript) {
        Protein prot = transcript.getProteinFeat();
        if (prot.hasName() && !prot.hasId()) {
            prot.setId(prot.getName());
        } else if (prot.hasId() && !prot.hasName()) {
            prot.setName(prot.getId());
        }
        if (!prot.hasName() && !prot.hasId()) {
            ApolloNameAdapterI na = this.getNameAdapter(transcript);
            String name = na.generatePeptideNameFromTranscriptName(transcript.getName());
            String id = na.generatePeptideIdFromTranscriptId(transcript.getId());
            prot.setName(name);
            prot.setId(id);
        }
    }

    private String setRange(XMLElement range_element, SeqFeatureI feat, SequenceI refSeq, int offset) {
        String align_str = null;
        if (refSeq != null) {
            feat.setRefSequence(refSeq);
        }
        Vector elements = range_element.getChildren();
        XMLElement span_element = null;
        for (int i = 0; i < elements.size(); ++i) {
            XMLElement element = (XMLElement)elements.elementAt(i);
            if (element.getType().equals("span")) {
                span_element = element;
                continue;
            }
            if (!element.getType().equals("alignment")) continue;
            align_str = element.getCharData();
        }
        if (span_element == null) {
            System.err.println("XML is messed up, span element is missing");
            return align_str;
        }
        this.setSpan(span_element, feat, offset);
        return align_str;
    }

    private void setSpan(XMLElement span_element, RangeI feat, int offset) {
        int start = 0;
        int end = 0;
        Vector elements = span_element.getChildren();
        for (int i = 0; i < elements.size(); ++i) {
            XMLElement element = (XMLElement)elements.elementAt(i);
            if (element.getType().equals("start")) {
                start = Integer.parseInt(element.getCharData());
                continue;
            }
            if (!element.getType().equals("end")) continue;
            end = Integer.parseInt(element.getCharData());
        }
        int strand = start < end ? 1 : -1;
        feat.setStrand(strand);
        feat.setStart(start + offset);
        feat.setEnd(end + offset);
    }

    private SequenceI getSpanSequence(XMLElement range_element, CurationSet curation) {
        SequenceI seq = null;
        String seq_id = range_element.getAttribute("seq");
        if (seq_id == null) {
            seq_id = range_element.getAttribute("id");
        }
        if (seq_id != null) {
            seq = this.createSequence(seq_id, curation, true);
        }
        return seq;
    }

    private void addEvidence(AnnotatedFeatureI ga, XMLElement ev_element) {
        String result_id = ev_element.getAttribute("id");
        if (result_id == null || result_id.equals("")) {
            result_id = ev_element.getAttribute("result");
        }
        if (result_id == null || result_id.equals("")) {
            result_id = ev_element.getAttribute("result_id");
        }
        if (result_id != null && !result_id.equals("")) {
            ga.addEvidence(result_id);
        }
    }

    private SeqFeatureI addTranscriptFeatSpan(XMLElement spanElement, AnnotatedFeatureI gene, Transcript transcript, CurationSet curation) {
        SeqFeature span = new SeqFeature();
        Exon exon = null;
        if (spanElement.getAttribute("type") != null) {
            span.setFeatureType(spanElement.getAttribute("type"));
        }
        span.setId(spanElement.getID());
        boolean typeIsNotInGame = true;
        while (spanElement.numChildren() > 0) {
            XMLElement element = spanElement.popChild();
            if (element.getType().equals("type")) {
                String type = element.getCharData();
                if (type.equals("exon") || type.equals("gene")) {
                    exon = new Exon(span);
                    span = exon;
                    if (type.equals("gene")) {
                        System.out.println("Error in game file - exon with type 'gene'");
                    }
                } else if (type.equals("polypeptide")) {
                    span = new Protein(span, transcript);
                }
                span.setFeatureType(type);
                typeIsNotInGame = false;
                continue;
            }
            if (element.getType().equals("seq_relationship")) {
                this.setRange(element, span, curation.getRefSequence(), curation.getStart() - 1);
                transcript.setStrand(span.getStrand());
                gene.setStrand(span.getStrand());
                continue;
            }
            if (element.getType().equals("evidence") && span.hasAnnotatedFeature()) {
                this.addEvidence(span.getAnnotatedFeature(), element);
                continue;
            }
            if (element.getType().equals("name")) {
                span.setName(element.getCharData());
                continue;
            }
            String data = element.getCharData();
            if (data == null || data.equals("")) continue;
            String m = spanElement.getType() + ": Either intentionally ignoring or " + "inadvertently forgetting to parse span type " + element.getType() + "=" + data;
            System.out.println(m);
        }
        if (typeIsNotInGame) {
            exon = new Exon(span);
            span = exon;
            this.debugPrint("GAME transcript feature_span has no type. setting to 'exon'");
        }
        if (span.isExon()) {
            this.addExon(exon, transcript, gene, curation);
        }
        return span;
    }

    private void addExon(ExonI exon, Transcript transcript, AnnotatedFeatureI gene, CurationSet curation) {
        transcript.addExon(exon);
        String id = gene.getId() + ":" + exon.getStart() + "-" + exon.getEnd();
        exon.setId(id);
        if (exon.getName() == null || exon.getName().equals("")) {
            ApolloNameAdapterI nameAdapter = this.getCurationState().getNameAdapter(gene);
            nameAdapter.generateName(curation.getAnnots(), curation.getName(), exon);
        }
    }

    private void getResultsAndAnnots(CurationSet curation) throws ApolloAdapterException {
        StrandedFeatureSetI annotations = curation.getAnnots();
        if (annotations == null) {
            annotations = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
            annotations.setName("Annotations");
            annotations.setFeatureType("Annotation");
            curation.setAnnots(annotations);
        }
        this.analyses = curation.getResults();
        if (this.analyses == null) {
            this.analyses = new StrandedFeatureSet((FeatureSetI)new FeatureSet(), new FeatureSet());
            this.analyses.setName("Analyses");
            curation.setResults(this.analyses);
            this.all_analyses = new Hashtable();
        }
        int count = 0;
        int total = this.game_element.numChildren();
        while (this.game_element.numChildren() > 0) {
            try {
                this.fireProgressEvent(new ProgressEvent((Object)this, new Double(30.0 + (double)(++count) / (double)total * 55.0), "Parsing XML element #" + count));
                XMLElement element = this.game_element.popChild();
                if (element.getType().equals("computational_analysis")) {
                    this.addAnalysis(element, this.analyses, curation, this.all_analyses);
                    continue;
                }
                if (element.getType().equalsIgnoreCase("annotation")) {
                    AnnotatedFeatureI annot = this.getAnnot(element, curation, annotations);
                    annotations.addFeature(annot);
                    continue;
                }
                if (element.getType().equals("seq")) {
                    this.getSequence(element, curation);
                    continue;
                }
                if (element.getType().equals("map_position")) continue;
                if (element.getType().equals("gameTransactions") || element.getType().equals("apolloTransactions")) {
                    this.getTransactions(element, curation);
                    continue;
                }
                System.err.println("Warning--don't know how to handle xml element of type " + element.getType());
            }
            catch (ApolloAdapterException dae) {
                throw dae;
            }
            catch (Exception ex2) {
                System.err.println("Caught exception while parsing XML:");
                ex2.printStackTrace();
                throw new ApolloAdapterException(ex2.getMessage());
            }
        }
    }

    private void addAnalysis(XMLElement analysis_element, StrandedFeatureSetI analyses, CurationSet curation, Hashtable all_analyses) {
        String analysis_id = analysis_element.getID();
        String prog = "";
        String db = "";
        String type = null;
        String date = null;
        String version = null;
        Vector elements = analysis_element.getChildren();
        for (int i = 0; i < elements.size(); ++i) {
            XMLElement element = (XMLElement)elements.elementAt(i);
            if (element.getType().equals("program")) {
                prog = element.getCharData();
                continue;
            }
            if (element.getType().equals("database")) {
                db = element.getCharData();
                continue;
            }
            if (element.getType().equals("type")) {
                type = element.getCharData();
                continue;
            }
            if (element.getType().equals("date")) {
                date = element.getCharData();
                continue;
            }
            if (!element.getType().equals("version")) continue;
            version = element.getCharData();
        }
        FeatureSetI forward_analysis = this.initAnalysis(analyses, 1, prog, db, analysis_id, type, date, version, all_analyses);
        FeatureSetI reverse_analysis = this.initAnalysis(analyses, -1, prog, db, analysis_id, type, date, version, all_analyses);
        String analysis_type = this.getAnalysisType(prog, db);
        for (int i = 0; i < elements.size(); ++i) {
            XMLElement element = (XMLElement)elements.elementAt(i);
            if (element.getType().equals("result_set")) {
                FeatureSetI result = this.getResult(element, analysis_type, curation);
                result.setProgramName(prog);
                result.setDatabase(db);
                if (result.getStrand() == 1) {
                    forward_analysis.addFeature(result);
                    if (forward_analysis.hasFeatureType()) continue;
                    forward_analysis.setFeatureType(result.getFeatureType());
                    continue;
                }
                reverse_analysis.addFeature(result);
                if (reverse_analysis.hasFeatureType()) continue;
                System.out.println("Setting analysis type to " + result.getFeatureType());
                reverse_analysis.setFeatureType(result.getFeatureType());
                continue;
            }
            if (element.getType().equals("property")) {
                this.addOutput(forward_analysis, element);
                this.addOutput(reverse_analysis, element);
                continue;
            }
            if (!element.getType().equals("result_span")) continue;
            SeqFeatureI span = this.getSpan(element, analysis_type, curation);
            span.setProgramName(prog);
            span.setDatabase(db);
            if (span.getStrand() == 1) {
                forward_analysis.addFeature(span);
                if (forward_analysis.hasFeatureType()) continue;
                forward_analysis.setFeatureType(span.getFeatureType());
                continue;
            }
            reverse_analysis.addFeature(span);
            if (reverse_analysis.hasFeatureType()) continue;
            reverse_analysis.setFeatureType(span.getFeatureType());
        }
        boolean fwd = this.addAnalysisIfHasFeatures(forward_analysis, all_analyses, analyses);
        boolean rev = this.addAnalysisIfHasFeatures(reverse_analysis, all_analyses, analyses);
        if (fwd && rev) {
            forward_analysis.setAnalogousOppositeStrandFeature(reverse_analysis);
            reverse_analysis.setAnalogousOppositeStrandFeature(forward_analysis);
        }
    }

    private String getAnalysisType(String prog, String db) {
        String analysis_type = prog != null && !prog.equals("") && db != null && !db.equals("") ? prog + ":" + db : (prog != null && !prog.equals("") ? prog : (db != null && !db.equals("") ? db : "no_type"));
        return analysis_type;
    }

    private boolean addAnalysisIfHasFeatures(FeatureSetI analysis, Hashtable all_analyses, StrandedFeatureSetI analyses) {
        if (all_analyses == null) {
            return false;
        }
        if (all_analyses.containsKey(analysis.getName())) {
            return true;
        }
        if (analysis.size() > 0) {
            all_analyses.put(analysis.getName(), analysis);
            analyses.addFeature(analysis);
            return true;
        }
        return false;
    }

    private FeatureSetI initAnalysis(StrandedFeatureSetI analyses, int strand, String prog, String db, String analysis_id, String type, String date, String version, Hashtable all_analyses) {
        FeatureSetI analysis;
        String analysis_type = this.getAnalysisType(prog, db);
        String analysis_name = !analysis_type.equals("no_type") ? analysis_type + (strand == 1 ? "-plus" : (strand == -1 ? "-minus" : "")) : "no_name" + (strand == 1 ? "-plus" : (strand == -1 ? "-minus" : ""));
        if (all_analyses == null) {
            all_analyses = new Hashtable();
        }
        if ((analysis = (FeatureSetI)all_analyses.get(analysis_name)) == null) {
            analysis = new FeatureSet();
            analysis.setId(analysis_id);
            analysis.setProgramName(prog);
            analysis.setDatabase(db);
            analysis.setFeatureType(analysis_type);
            if (!analysis_type.equals("no_type")) {
                analysis.setName(analysis_name);
            }
            analysis.setStrand(strand);
            if (type != null) {
                analysis.setTopLevelType(type);
            }
            if (date != null) {
                analysis.addProperty("date", date);
            }
            if (version != null) {
                analysis.addProperty("version", version);
            }
        }
        return analysis;
    }

    private FeatureSetI getResult(XMLElement result_element, String analysis_type, CurationSet curation) {
        FeatureSet result = new FeatureSet();
        result.setId(result_element.getID());
        result.setFeatureType(analysis_type);
        result.setName("");
        RangeI translate_start = null;
        Vector elements = result_element.getChildren();
        for (int i = 0; i < elements.size(); ++i) {
            SeqFeatureI span;
            XMLElement element = (XMLElement)elements.elementAt(i);
            if (element.getType().equals("score")) {
                this.setScore(element, result);
                continue;
            }
            if (element.getType().equals("name")) {
                if (element.getCharData() == null) {
                    System.out.println("Hey, " + result.getFeatureType() + " id " + result.getId() + " has empty name element");
                    continue;
                }
                result.setName(element.getCharData());
                continue;
            }
            if (element.getType().equals("type")) {
                result.setTopLevelType(element.getCharData());
                continue;
            }
            if (element.getType().equals("output")) {
                this.addOutput(result, element);
                continue;
            }
            if (element.getType().equals("seq_relationship")) {
                String rel_type = element.getAttribute("type");
                if (rel_type.equals("sbjct") || rel_type.equals("subject")) {
                    SequenceI seq = this.getSpanSequence(element, curation);
                    result.setHitSequence(seq);
                    if (seq.getName() == null || seq.getName().equals("")) {
                        try {
                            throw new Exception("Missing id for seq " + seq.getAccessionNo());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return null;
                        }
                    }
                    if (!result.getName().equals("")) continue;
                    result.setName(seq.getName());
                    continue;
                }
                this.setRange(element, result, curation.getRefSequence(), curation.getStart() - 1);
                continue;
            }
            if (element.getType().equals("result_set")) {
                span = this.getResult(element, analysis_type, curation);
                this.addToResult(result, span);
                continue;
            }
            if (element.getType().equals("result_span")) {
                span = this.getSpan(element, analysis_type, curation);
                if (span.getTopLevelType().equals("") || !span.getTopLevelType().equals("translate offset") && !span.getTopLevelType().equals("start codon")) {
                    this.addToResult(result, span);
                    continue;
                }
                translate_start = span;
                continue;
            }
            if (element.getCharData() == null || element.getCharData().equals("")) continue;
            System.out.println(result_element.getType() + ": Either intentionally ignoring or " + "inadvertently forgetting to parse " + element.getType() + (element.getCharData() == null ? "" : "=" + element.getCharData()));
        }
        if (translate_start != null) {
            result.sort(result.getStrand());
            result.setProteinCodingGene(true);
            if (!result.setTranslationStart(translate_start.getStart(), true)) {
                System.out.println("unable to set translation start of " + ((Object)result).toString());
            }
        }
        this.sniffOutInsertionSite(result);
        return result;
    }

    private void addToResult(FeatureSetI result, SeqFeatureI span) {
        if (span.getStrand() != result.getStrand() && result.getStrand() == 0) {
            result.setStrand(span.getStrand());
        }
        if (!result.hasFeatureType()) {
            result.setFeatureType(span.getTopLevelType());
        }
        if (span.getStrand() == result.getStrand()) {
            if (result.getName().equals("") || result.getName().equals("no_name")) {
                result.setName(span.getName());
            } else if (span.getName().equals("")) {
                span.setName((result.getName().equals("") ? result.getId() : result.getName()) + " span " + result.size());
            }
            if (result.getHitSequence() == null && span instanceof FeaturePairI) {
                result.setHitSequence(((FeaturePairI)span).getHitSequence());
            }
            result.addFeature(span);
        } else {
            System.out.println("Ignored result_span " + span.getName() + " of type " + span.getTopLevelType() + ": " + span.getStart() + "-" + span.getEnd() + " because span_strand " + span.getStrand() + " doesn't match result strand " + result.getStrand());
        }
    }

    private SeqFeatureI getSpan(XMLElement span_element, String analysis_type, CurationSet curation) {
        SeqFeature query = new SeqFeature();
        SeqFeature hit = new SeqFeature();
        SeqFeature span = null;
        query.setName("");
        hit.setName("");
        query.setFeatureType(analysis_type);
        hit.setFeatureType(analysis_type);
        query.setTopLevelType(analysis_type);
        hit.setTopLevelType(analysis_type);
        query.setId(span_element.getID());
        hit.setId(span_element.getID());
        String query_str = null;
        String sbjct_str = null;
        Vector elements = span_element.getChildren();
        for (int i = 0; i < elements.size(); ++i) {
            XMLElement element = (XMLElement)elements.elementAt(i);
            if (element.getType().equals("type")) {
                if (!element.getCharData().equals(analysis_type)) {
                    query.setTopLevelType(analysis_type);
                }
                if (element.getCharData().equals("start codon")) {
                    query.setTopLevelType("start codon");
                }
                hit.setTopLevelType(analysis_type);
                continue;
            }
            if (element.getType().equals("name")) {
                query.setName(element.getCharData());
                hit.setName(element.getCharData());
                continue;
            }
            if (element.getType().equals("score")) {
                this.setScore(element, query);
                this.setScore(element, hit);
                continue;
            }
            if (element.getType().equals("output")) {
                String type_tag = this.getTypeTag(element);
                if (type_tag.equals("cigar")) {
                    span = new FeaturePair(query, hit);
                    this.setTagValue(span, element, type_tag);
                    continue;
                }
                this.setTagValue(query, element, type_tag);
                continue;
            }
            if (element.getType().equals("seq_relationship")) {
                String rel_type = element.getAttribute("type");
                if (rel_type.equals("sbjct") || rel_type.equals("subject")) {
                    if (span == null) {
                        span = new FeaturePair(query, hit);
                    }
                    sbjct_str = this.setRange(element, hit, this.getSpanSequence(element, curation), 0);
                    hit.setName(hit.getRefSequence().getName());
                    query.addProperty("description", hit.getRefSequence().getDescription());
                    query.setName(hit.getName());
                    if (sbjct_str == null || sbjct_str.equals("")) continue;
                    hit.setExplicitAlignment(sbjct_str);
                    continue;
                }
                query_str = this.setRange(element, query, curation.getRefSequence(), curation.getStart() - 1);
                if (query_str == null || query_str.equals("")) continue;
                if (span == null) {
                    span = new FeaturePair(query, hit);
                }
                span.setExplicitAlignment(query_str);
                continue;
            }
            if (element.getCharData() == null || element.getCharData().equals("")) continue;
            System.out.println(span_element.getType() + ": Either intentionally ignoring or " + "inadvertently forgetting to parse span type " + element.getType() + (element.getCharData() == null ? "" : "=" + element.getCharData()));
        }
        if (span == null) {
            span = query;
        }
        return span;
    }

    private void getFocusSequence(CurationSet curation) throws ApolloAdapterException {
        Vector elements = this.game_element.getChildren();
        boolean found = false;
        for (int i = 0; i < elements.size(); ++i) {
            String focus;
            XMLElement seq_element = (XMLElement)elements.elementAt(i);
            if (!seq_element.getType().equals("seq") || (focus = seq_element.getAttribute("focus")) == null || !focus.equals("true")) continue;
            if (found) {
                System.err.println("Found duplicate focus sequence " + seq_element.getID());
            }
            GAMESequence seq = new GAMESequence(seq_element.getID(), Config.getController(), "");
            seq.setAccessionNo(seq_element.getID());
            seq.setResidueType("DNA");
            curation.addSequence(seq);
            curation.setName(seq.getName());
            this.setRegion(seq);
            found = true;
            this.parseSequence(seq, seq_element);
        }
    }

    private void getSequence(XMLElement seq_element, CurationSet curation) throws ApolloAdapterException {
        String focus = seq_element.getAttribute("focus");
        if (focus != null && focus.equals("true")) {
            return;
        }
        SequenceI seq = this.createSequence(seq_element.getID(), curation, false);
        this.parseSequence(seq, seq_element);
    }

    private void parseSequence(SequenceI seq, XMLElement seq_element) {
        String checksum;
        String lengthString = seq_element.getAttribute("length");
        int length = 0;
        if (lengthString != null) {
            length = Integer.parseInt(lengthString);
            seq.setLength(Integer.parseInt(lengthString));
        }
        if ((checksum = seq_element.getAttribute("md5checksum")) != null && !checksum.equals("")) {
            seq.setChecksum(checksum);
        }
        Vector seq_elements = seq_element.getChildren();
        for (int j = 0; j < seq_elements.size(); ++j) {
            XMLElement element = (XMLElement)seq_elements.elementAt(j);
            if (element.getType().equals("name")) {
                FastaHeader fasta = new FastaHeader(element.getCharData());
                seq.setName(fasta.getSeqId());
                continue;
            }
            if (element.getType().equals("description")) {
                GAMEAdapter.setSeqDescription(seq, element.getCharData(), seq_element.getID());
                continue;
            }
            if (element.getType().equals("dbxref")) {
                this.addSeqXref(element, seq);
                continue;
            }
            if (element.getType().equals("residues")) {
                seq.setResidues(element.getCharData());
                continue;
            }
            if (element.getType().equals("organism")) {
                seq.setOrganism(element.getCharData());
                continue;
            }
            if (element.getType().equals("potential_sequencing_error")) {
                this.addSequenceEdit(element, seq);
                continue;
            }
            System.out.println("Not dealing with seq element " + element.getType());
        }
    }

    private void addSeqXref(XMLElement dbxref_element, SequenceI seq) {
        Vector elements = dbxref_element.getChildren();
        String db = null;
        String acc = null;
        for (int i = 0; i < elements.size(); ++i) {
            XMLElement element = (XMLElement)elements.elementAt(i);
            if (element.getType().equals("xref_db")) {
                db = element.getCharData();
            }
            if (element.getType().equals("db_xref_id")) {
                acc = element.getCharData();
            }
            seq.addDbXref(db, acc);
        }
    }

    public static void setSeqDescription(SequenceI seq, String description, String seq_id) {
        int index;
        String current_desc;
        if (description != null && description.startsWith(seq_id)) {
            String string = description = seq_id.length() < description.length() ? description.substring(seq_id.length()) : "";
        }
        if ((current_desc = seq.getDescription()) != null) {
            description = current_desc + " " + description;
        }
        seq.setDescription(description);
        Date date = null;
        if (description != null && description.length() > 5 && (index = description.trim().lastIndexOf(32)) > 0) {
            String possibleDate = description.substring(index).trim();
            if (possibleDate.indexOf("]") > 0) {
                possibleDate = possibleDate.substring(possibleDate.indexOf("]") + 1);
            }
            if (possibleDate.indexOf("(") >= 0) {
                possibleDate = possibleDate.substring(possibleDate.indexOf("(") + 1);
            }
            if (possibleDate.indexOf(")") >= 0) {
                possibleDate = possibleDate.substring(0, possibleDate.indexOf(")"));
            }
            date = DateUtil.makeADate(possibleDate);
        }
        seq.setDate(date);
    }

    private void addSequenceEdit(XMLElement edit_element, SequenceI seq) {
        Vector elements = edit_element.getChildren();
        String edit_type = null;
        int position = 0;
        String base = null;
        for (int i = 0; i < elements.size(); ++i) {
            XMLElement element = (XMLElement)elements.elementAt(i);
            if (element.getType().equals("type")) {
                edit_type = element.getCharData();
            }
            if (element.getType().equals("position")) {
                position = Integer.parseInt(element.getCharData());
            }
            if (!element.getType().equals("base")) continue;
            base = element.getCharData();
        }
        if (edit_type != null && position > 0) {
            seq.addSequencingErrorPosition(edit_type, position, base);
        }
    }

    private void getGenomePosition(CurationSet curation) throws ApolloAdapterException {
        int curation_strand = 1;
        String seq_id = null;
        int start = 0;
        int end = 0;
        Vector elements = this.game_element.getChildren();
        for (int i = 0; i < elements.size(); ++i) {
            XMLElement map_element = (XMLElement)elements.elementAt(i);
            if (!map_element.getType().equals("map_position")) continue;
            if (map_element.getAttribute("type") != null) {
                curation.setFeatureType(map_element.getAttribute("type"));
            }
            if (map_element.getAttribute("seq") != null && !(seq_id = map_element.getAttribute("seq")).equals(curation.getName())) {
                System.out.println("getGenomePosition: map position is not for " + seq_id + ", but is for " + curation.getName() + "??");
            }
            Vector map_elements = map_element.getChildren();
            for (int j = 0; j < map_elements.size(); ++j) {
                XMLElement element = (XMLElement)map_elements.elementAt(j);
                if (element.getType().equals("arm")) {
                    String arm;
                    seq_id = arm = element.getCharData();
                    String chromosome = arm;
                    int dot_index = chromosome.indexOf(".");
                    if (dot_index != -1) {
                        chromosome = chromosome.substring(0, dot_index);
                    }
                    curation.setChromosome(chromosome);
                    continue;
                }
                if (element.getType().equals("chromosome")) {
                    curation.setChromosome(element.getCharData());
                    continue;
                }
                if (element.getType().equals("organism")) {
                    String organism = element.getCharData();
                    curation.setOrganism(organism);
                    if (!Config.hasStyleForSpecies(organism)) continue;
                    Config.setStyleForSpecies(organism);
                    this.setStyle(Config.getStyle());
                    continue;
                }
                if (!element.getType().equals("span")) continue;
                Vector map_pos_elements = element.getChildren();
                start = 0;
                end = 0;
                XMLElement map_pos_element = null;
                for (int k = 0; k < map_pos_elements.size(); ++k) {
                    map_pos_element = (XMLElement)map_pos_elements.elementAt(k);
                    if (map_pos_element.getType().equals("start")) {
                        start = Integer.parseInt(map_pos_element.getCharData());
                        continue;
                    }
                    if (!map_pos_element.getType().equals("end")) continue;
                    end = Integer.parseInt(map_pos_element.getCharData());
                }
                if (end == start) {
                    System.out.println("WARNING: top level end == start = " + end + ".  Using seq length  " + this.curated_seq.getLength() + " to set end position.");
                    end = start + this.curated_seq.getLength() + 1;
                    map_pos_element.setCharData(new Integer(end).toString());
                } else if (start > end) {
                    String message = "Problem in XML: map_position start is bigger than end.\nI don't yet know how to handle reversed regions--sorry.";
                    System.out.println(message);
                    throw new ApolloAdapterException(message);
                }
                this.setSpan(element, curation, 0);
            }
        }
        if (seq_id == null) {
            seq_id = this.curated_seq.getName();
        }
        if (start <= 0 || end <= 0) {
            start = 1;
            end = this.curated_seq.getLength();
            curation.setStrand(curation_strand);
            curation.setStart(start);
            curation.setEnd(end);
        }
        this.curated_seq.setName(seq_id);
    }

    private void setGeneInfo(XMLElement gene_element, AnnotatedFeatureI gene) {
        Vector gene_elements = gene_element.getChildren();
        for (int i = 0; i < gene_elements.size(); ++i) {
            XMLElement element = (XMLElement)gene_elements.elementAt(i);
            if (element.getType().equals("dbxref")) {
                this.setAnnotXref(element, gene);
                continue;
            }
            if (!element.getType().equals("name") || element.getCharData() == null || element.getCharData().equals("")) continue;
            gene.setName(element.getCharData());
        }
    }

    private void setAnnotXref(XMLElement element, AnnotatedFeatureI gene) {
        String db = "";
        String id = "";
        Vector xref_elements = element.getChildren();
        for (int j = 0; j < xref_elements.size(); ++j) {
            XMLElement xref_element = (XMLElement)xref_elements.elementAt(j);
            if (xref_element.getType().equals("xref_db")) {
                db = xref_element.getCharData();
            }
            if (!xref_element.getType().equals("db_xref_id")) continue;
            id = xref_element.getCharData();
        }
        if (!db.equals("") && !id.equals("")) {
            gene.addDbXref(new DbXref("id", id, db));
        }
    }

    private void setScore(XMLElement score_element, SeqFeatureI feat) {
        String scoreString = score_element.getCharData();
        double score = Double.valueOf(scoreString);
        feat.setScore(score);
    }

    private void addTranscriptSequence(CurationSet curation, Transcript transcript, XMLElement seq_element) {
        String checksum;
        String seq_id = seq_element.getID();
        SequenceI seq = this.createSequence(seq_id, curation, false);
        String res_type = seq_element.getAttribute("type");
        String lengthString = seq_element.getAttribute("length");
        int length = 0;
        if (lengthString != null) {
            length = Integer.parseInt(lengthString);
            seq.setLength(Integer.parseInt(lengthString));
        }
        if ((checksum = seq_element.getAttribute("md5checksum")) != null && !checksum.equals("")) {
            seq.setChecksum(checksum);
        }
        Vector elements = seq_element.getChildren();
        for (int i = 0; i < elements.size(); ++i) {
            XMLElement element = (XMLElement)elements.elementAt(i);
            if (element.getType().equals("name")) {
                FastaHeader fasta = new FastaHeader(element.getCharData());
                seq.setName(fasta.getSeqId());
                continue;
            }
            if (element.getType().equals("description")) {
                seq.setDescription(element.getCharData());
                continue;
            }
            if (element.getType().equals("dbxref")) {
                this.addSeqXref(element, (Sequence)seq);
                continue;
            }
            if (element.getType().equals("residues")) {
                seq.setResidues(element.getCharData());
                continue;
            }
            if (element.getType().equals("organism")) {
                seq.setOrganism(element.getCharData());
                continue;
            }
            System.out.println("Not dealing with seq element " + element.getType());
        }
        if (res_type != null && res_type.equalsIgnoreCase("AA")) {
            seq.setResidueType("AA");
            transcript.setPeptideSequence(seq);
            transcript.setPeptideValidity(!Config.getRefreshPeptides());
        } else {
            transcript.set_cDNASequence(seq);
        }
    }

    private SequenceI createSequence(String header, CurationSet curation, boolean alert) {
        FastaHeader fasta = new FastaHeader(header);
        String seq_id = fasta.getSeqId();
        SequenceI seq = curation.getSequence(seq_id);
        if (seq == null) {
            seq = fasta.generateSequence();
            curation.addSequence(seq);
        }
        return seq;
    }

    private boolean addOutput(SeqFeatureI sf, XMLElement output_element) {
        String type = this.getTypeTag(output_element);
        return this.setTagValue(sf, output_element, type);
    }

    private String getTypeTag(XMLElement output_element) {
        Vector elements = output_element.getChildren();
        String type = null;
        for (int i = 0; i < elements.size() && type == null; ++i) {
            XMLElement element = (XMLElement)elements.elementAt(i);
            if (!element.getType().equals("type")) continue;
            type = element.getCharData();
        }
        return type;
    }

    private String getTypeValue(XMLElement output_element) {
        Vector elements = output_element.getChildren();
        String value = null;
        for (int i = 0; i < elements.size() && value == null; ++i) {
            XMLElement element = (XMLElement)elements.elementAt(i);
            if (!element.getType().equals("value")) continue;
            value = element.getCharData();
        }
        return value;
    }

    private boolean setTagValue(SeqFeatureI sf, XMLElement output_element, String type) {
        boolean valid;
        block14: {
            String value = this.getTypeValue(output_element);
            valid = true;
            if (type != null && value != null) {
                try {
                    double score = Double.valueOf(value);
                    if (type.equals("total_score")) {
                        type = "score";
                    } else {
                        sf.addScore(type, score);
                    }
                }
                catch (Exception ex) {
                    if (type.equals("amino-acid")) {
                        sf.setName(value);
                    }
                    if (type.equals("non-canonical_splice_site") && sf instanceof Transcript) {
                        ((Transcript)sf).nonConsensusSplicingOkay(value.equals("approved"));
                    }
                    if (type.equals("cigar")) {
                        if (sf instanceof FeaturePairI) {
                            ((FeaturePairI)sf).setCigar(value);
                        } else {
                            valid = false;
                        }
                    }
                    if (type.equals("symbol")) {
                        String current_name = sf.getName();
                        if (current_name == null) {
                            sf.setName(value);
                        } else if (current_name.equals("") || current_name.equals("no_name")) {
                            sf.setName(value);
                        }
                    }
                    sf.addProperty(type, value);
                    if (!type.equals("problem") || !value.equals("true") || !(sf instanceof AnnotatedFeatureI)) break block14;
                    ((AnnotatedFeatureI)sf).setIsProblematic(true);
                }
            }
        }
        return valid;
    }

    private void sniffOutInsertionSite(FeatureSetI result) {
        String desc;
        int index;
        SeqFeatureI sf;
        SequenceI seq = result.getHitSequence();
        if (seq == null && result.size() > 0 && (sf = result.getFeatureAt(0)) instanceof FeaturePairI) {
            seq = ((FeaturePairI)sf).getHitSequence();
        }
        if (seq != null && seq.getDescription() != null && (index = (desc = seq.getDescription()).indexOf(sesame)) >= 0) {
            if ((index = (desc = desc.substring(index + sesame.length())).indexOf(" ")) > 0) {
                desc = desc.substring(0, index);
            }
            try {
                int site = Integer.parseInt(desc);
                if (site < result.length()) {
                    result.addProperty("insertion_site", desc);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void repairGreek(SeqFeatureI sf) {
        sf.setName(HTMLUtil.replaceSGMLWithGreekLetter(sf.getName()));
        AnnotatedFeature gene = (AnnotatedFeature)sf;
        Vector syns = gene.getSynonyms();
        for (int i = 0; i < syns.size(); ++i) {
            Synonym syn = (Synonym)syns.elementAt(i);
            String fixed = HTMLUtil.replaceSGMLWithGreekLetter(syn.getName());
            if (syn.getName().equals(fixed)) continue;
            gene.deleteSynonym(syn.getName());
            syn.setName(fixed);
            gene.addSynonym(syn);
        }
    }

    private void getTransactions(XMLElement transactionsElement, CurationSet curation) {
        TransactionXMLAdapter adap = new TransactionXMLAdapter();
        adap.getTransFromTopElement((Element)transactionsElement, curation);
    }

    private void debugPrint(String s) {
        if (Config.DEBUG) {
            System.out.println("DEBUG: " + s);
        }
    }
}

