/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.flygamexml;

import apollo.dataadapter.ApolloAdapterException;
import apollo.dataadapter.ApolloDataAdapterI;
import apollo.dataadapter.DataInput;
import apollo.dataadapter.DataInputType;
import apollo.dataadapter.FileTabPanel;
import apollo.dataadapter.GuiTabPanel;
import apollo.dataadapter.flygamexml.FlyGAMEAdapter;
import apollo.dataadapter.flygamexml.GAMEPanel;
import apollo.dataadapter.flygamexml.LocationGAMEPanel;
import apollo.gui.ProxyDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.bdgp.io.DataAdapter;
import org.bdgp.io.IOOperation;
import org.bdgp.swing.AbstractDataAdapterUI;

public class FlyGAMEAdapterGUI
extends AbstractDataAdapterUI {
    private static int tabbedIndex = 0;
    private IOOperation ioOperation;
    private FlyGAMEAdapter gameDriver;
    private JTabbedPane tabbedPane;
    private static final String indexPropString = "GAMETabIndex";
    private GuiTabPanel[] gamePanels;
    private int FileTabIndex = 0;
    private Color grayBackgroundColor = new Color(220, 220, 220);
    private JCheckBox saveAnnots = new JCheckBox("Save annotations");
    private JCheckBox saveResults = new JCheckBox("Save evidence (computational results)");

    public FlyGAMEAdapterGUI(IOOperation op) {
        this.ioOperation = op;
        this.setBackground(this.grayBackgroundColor);
        this.initPanels();
        this.buildGUI();
    }

    private void initPanels() {
        GAMEPanel gene = new GAMEPanel("Gene", "Gene name or synonym", DataInputType.GENE, "cact", this.grayBackgroundColor);
        GAMEPanel cyt = new GAMEPanel("Cytology", "Cytological location", DataInputType.CYTOLOGY, "34A", this.grayBackgroundColor);
        GAMEPanel scaf = new GAMEPanel("Scaffold", "Scaffold accession", DataInputType.SCAFFOLD, "AE003490", this.grayBackgroundColor);
        FileTabPanel file = new FileTabPanel((Component)((Object)this), this.grayBackgroundColor);
        LocationGAMEPanel loc = new LocationGAMEPanel(this.grayBackgroundColor);
        this.gamePanels = new GuiTabPanel[]{file, gene, cyt, scaf, loc};
    }

    public void setDataAdapter(DataAdapter driver) {
        super.setDataAdapter(driver);
        this.gameDriver = (FlyGAMEAdapter)driver;
    }

    public Object doOperation(Object values) throws ApolloAdapterException {
        if (this.getDataInput() == null || !this.getDataInput().hasInput()) {
            throw new ApolloAdapterException("null input");
        }
        this.gameDriver.setDataInput(this.getDataInput());
        if (this.ioOperation.equals((Object)ApolloDataAdapterI.OP_READ_DATA)) {
            this.gameDriver.setDatabase(this.getCurrentGamePanel().getDatabase());
            return this.gameDriver.getCurationSet();
        }
        if (this.ioOperation.equals((Object)ApolloDataAdapterI.OP_APPEND_DATA)) {
            this.gameDriver.setDatabase(this.getCurrentGamePanel().getDatabase());
            return this.gameDriver.addToCurationSet();
        }
        if (this.ioOperation.equals((Object)ApolloDataAdapterI.OP_WRITE_DATA)) {
            this.gameDriver.commitChanges(values, this.saveAnnots.isSelected(), this.saveResults.isSelected());
            return null;
        }
        return null;
    }

    private DataInput getDataInput() throws ApolloAdapterException {
        try {
            return this.getCurrentGamePanel().getDataInput();
        }
        catch (RuntimeException e) {
            throw new ApolloAdapterException(e.getMessage());
        }
    }

    private DataInputType getCurrentInputType() {
        return this.getCurrentGamePanel().getInputType();
    }

    private String getCurrentInput() {
        return this.getCurrentGamePanel().getCurrentInput();
    }

    public GuiTabPanel getCurrentGamePanel() {
        return this.gamePanels[this.tabbedPane.getSelectedIndex()];
    }

    private void addCheckboxes(FileTabPanel filepanel) {
        JPanel checkboxPanel = new JPanel();
        checkboxPanel.setLayout(new BorderLayout());
        checkboxPanel.add("North", this.saveAnnots);
        checkboxPanel.add("South", this.saveResults);
        filepanel.add("South", checkboxPanel);
        this.saveAnnots.setEnabled(true);
        this.saveAnnots.setSelected(true);
        this.saveResults.setEnabled(true);
        this.saveResults.setSelected(true);
    }

    public void setProperties(Properties in) {
        if (in == null) {
            return;
        }
        for (int i = 0; i < this.gamePanels.length; ++i) {
            this.gamePanels[i].retrieveHistoryFromProperties(in);
        }
        if (this.ioOperation.equals((Object)ApolloDataAdapterI.OP_WRITE_DATA)) {
            this.chooseTab("file");
            FileTabPanel filepanel = (FileTabPanel)this.gamePanels[this.FileTabIndex];
            this.addCheckboxes(filepanel);
        } else {
            String indexStr = in.getProperty(indexPropString);
            if (indexStr != null) {
                tabbedIndex = Integer.parseInt(indexStr);
                this.tabbedPane.setSelectedIndex(tabbedIndex);
            }
        }
    }

    public Properties getProperties() {
        this.getCurrentGamePanel().addSelectedToHistory();
        Properties out = new Properties();
        for (int i = 0; i < this.gamePanels.length; ++i) {
            this.gamePanels[i].putHistoryInProperties(out);
        }
        out.put(indexPropString, "" + tabbedIndex);
        return out;
    }

    private void buildGUI() {
        this.tabbedPane = new JTabbedPane();
        for (int i = 0; i < this.gamePanels.length; ++i) {
            this.gamePanels[i].insertIntoTabbedPane(this.tabbedPane, i);
        }
        this.tabbedPane.setSelectedIndex(tabbedIndex);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                tabbedIndex = FlyGAMEAdapterGUI.this.tabbedPane.getSelectedIndex();
            }
        });
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.add(this.tabbedPane);
        JButton proxyButton = new JButton("Proxy settings...");
        proxyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProxyDialog pd = new ProxyDialog(null);
                pd.setVisible(true);
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(Box.createHorizontalStrut(280));
        buttonPanel.add(Box.createHorizontalStrut(20));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(Box.createHorizontalStrut(150));
        buttonPanel.add(proxyButton);
        buttonPanel.add(Box.createHorizontalGlue());
        this.add(buttonPanel);
    }

    public void chooseTab(String which) {
        if (which.equalsIgnoreCase("file")) {
            tabbedIndex = this.FileTabIndex;
            for (int i = 0; i < this.gamePanels.length; ++i) {
                if (i == this.FileTabIndex) continue;
                this.tabbedPane.setEnabledAt(i, false);
            }
            this.tabbedPane.setSelectedIndex(this.FileTabIndex);
        }
    }
}

