/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj19;

import apollo.util.GuiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class DataSourceConfigurationPanel
extends JPanel {
    private JLabel hostLabel = new JLabel("Host");
    private JLabel portLabel = new JLabel("Port");
    private JLabel userLabel = new JLabel("User");
    private JLabel passwordLabel = new JLabel("Password");
    private JLabel ensemblDatabaseLabel = new JLabel("Ensembl Database Name");
    private JTextField jdbcDriverTextField = new JTextField(40);
    private JTextField hostTextField = new JTextField(40);
    private JTextField portTextField = new JTextField(6);
    private JTextField userTextField = new JTextField(40);
    private JPasswordField passwordTextField = new JPasswordField(40);
    private JTextField ensemblDriverTextField = new JTextField(40);
    private JComboBox ensemblDatabaseDropdown = new JComboBox();
    private JButton findButton = new JButton("Find...");
    private ActionListener hostListener;
    private ActionListener interactionListener;
    private ActionListener ensemblDBDropdownSelectionListener;
    private String prefix;
    private ActionListener externalDataChangeListener;

    public void detachEnsemblDatabaseDropdownListener() {
        this.getEnsemblDatabaseDropdown().removeActionListener(this.getEnsemblDBDropdownSelectionListener());
    }

    public void attachEnsemblDatabaseDropdownListener() {
        this.getEnsemblDatabaseDropdown().addActionListener(this.getEnsemblDBDropdownSelectionListener());
    }

    public void addExternalDataChangeListener(ActionListener listener) {
        this.externalDataChangeListener = listener;
    }

    public DataSourceConfigurationPanel() {
        this.prefix = "";
        this.buildGUI();
    }

    public DataSourceConfigurationPanel(String prefix) {
        this.prefix = prefix;
        this.buildGUI();
    }

    public String getPrefix() {
        return this.prefix;
    }

    private void buildGUI() {
        DataChangeListener dataChangeListener = new DataChangeListener();
        this.hostListener = new HostListener();
        int row = 0;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.hostLabel, GuiUtil.makeConstraintAt(0, row, 1));
        this.add((Component)this.hostTextField, GuiUtil.makeConstraintAt(1, row, 3));
        this.hostTextField.addKeyListener(dataChangeListener);
        this.add((Component)this.portLabel, GuiUtil.makeConstraintAt(0, ++row, 1));
        this.add((Component)this.portTextField, GuiUtil.makeConstraintAt(1, row, 3));
        this.portTextField.addKeyListener(dataChangeListener);
        this.add((Component)this.userLabel, GuiUtil.makeConstraintAt(0, ++row, 1));
        this.add((Component)this.userTextField, GuiUtil.makeConstraintAt(1, row, 3));
        this.userTextField.addKeyListener(dataChangeListener);
        this.add((Component)this.passwordLabel, GuiUtil.makeConstraintAt(0, ++row, 1));
        this.add((Component)this.passwordTextField, GuiUtil.makeConstraintAt(1, row, 3));
        this.passwordTextField.addKeyListener(dataChangeListener);
        this.add((Component)this.ensemblDatabaseLabel, GuiUtil.makeConstraintAt(0, ++row, 1));
        this.ensemblDBDropdownSelectionListener = new EnsemblDBSelectionListener();
        this.ensemblDatabaseDropdown.addActionListener(this.ensemblDBDropdownSelectionListener);
        Dimension hostTextFieldDimension = this.hostTextField.getPreferredSize();
        int newX = new Double(new Integer(hostTextFieldDimension.width).doubleValue() * 0.66).intValue();
        Dimension newDimension = new Dimension(newX, hostTextFieldDimension.height);
        this.ensemblDatabaseDropdown.setPreferredSize(newDimension);
        this.add((Component)this.ensemblDatabaseDropdown, GuiUtil.makeConstraintAt(1, row, 1));
        this.findButton.addActionListener(this.getHostListener());
        this.add((Component)this.findButton, GuiUtil.makeConstraintAt(2, row, 1));
    }

    public void setProperties(Properties properties) {
        this.setTextFieldFromProperty(this.getPrefix() + "jdbc_driver", properties, this.getJdbcDriverTextField());
        this.setTextFieldFromProperty(this.getPrefix() + "host", properties, this.getHostTextField());
        this.setTextFieldFromProperty(this.getPrefix() + "port", properties, this.getPortTextField());
        this.setTextFieldFromProperty(this.getPrefix() + "user", properties, this.getUserTextField());
        this.setTextFieldFromProperty(this.getPrefix() + "password", properties, this.getPasswordTextField());
        this.setTextFieldFromProperty(this.getPrefix() + "ensembl_driver", properties, this.getEnsemblDriverTextField());
        this.getEnsemblDatabaseDropdown().removeActionListener(this.getEnsemblDBDropdownSelectionListener());
        if (properties.getProperty(this.getPrefix() + "database") != null && properties.getProperty(this.getPrefix() + "database").trim().length() > 0) {
            this.getEnsemblDatabaseDropdown().setSelectedItem(properties.getProperty(this.getPrefix() + "database"));
        }
        this.getEnsemblDatabaseDropdown().addActionListener(this.getEnsemblDBDropdownSelectionListener());
    }

    private void setTextFieldFromProperty(String key, Properties properties, JTextField textField) {
        if (properties.getProperty(key) != null && properties.getProperty(key).trim().length() > 0) {
            textField.setText(properties.getProperty(key));
        }
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.put(this.getPrefix() + "jdbc_driver", this.getJdbcDriverTextField().getText());
        properties.put(this.getPrefix() + "host", this.getHostTextField().getText());
        properties.put(this.getPrefix() + "port", this.getPortTextField().getText());
        properties.put(this.getPrefix() + "user", this.getUserTextField().getText());
        properties.put(this.getPrefix() + "password", this.getPasswordTextField().getText());
        properties.put(this.getPrefix() + "ensembl_driver", this.getEnsemblDriverTextField().getText());
        if (this.getEnsemblDatabaseDropdown().getSelectedItem() != null) {
            properties.put(this.getPrefix() + "database", this.getEnsemblDatabaseDropdown().getSelectedItem());
        }
        properties.put(this.prefix + "connection_string", "jdbc:mysql://" + this.getHostTextField().getText() + ":" + this.getPortTextField().getText());
        return properties;
    }

    public static void main(String[] args) {
        JFrame myFrame = new JFrame();
        myFrame.setSize(200, 200);
        myFrame.getContentPane().add(new DataSourceConfigurationPanel());
        myFrame.pack();
        myFrame.show();
    }

    private List findDatabasesForMySQLHost() {
        String jdbcDriver = this.jdbcDriverTextField.getText();
        String host = this.hostTextField.getText();
        String port = this.portTextField.getText();
        String url = "jdbc:mysql://" + host + ":" + port + "/";
        String user = this.userTextField.getText();
        String password = this.passwordTextField.getText();
        ArrayList<String> returnList = new ArrayList<String>();
        if (jdbcDriver == null || jdbcDriver.trim().length() <= 0 || host == null || host.trim().length() <= 0 || port == null || port.trim().length() <= 0 || user == null || user.trim().length() <= 0) {
            return new ArrayList();
        }
        if (password == null) {
            password = "";
        }
        try {
            Class.forName(jdbcDriver).newInstance();
        }
        catch (IllegalAccessException exception) {
            JOptionPane.showMessageDialog(this, "Cannot access the driver class " + jdbcDriver + "\n" + exception.getMessage());
        }
        catch (InstantiationException exception) {
            JOptionPane.showMessageDialog(this, "Cannot create the driver class " + jdbcDriver + "\n" + exception.getMessage());
        }
        catch (ClassNotFoundException exception) {
            JOptionPane.showMessageDialog(this, "Cannot find the driver class " + jdbcDriver + "\n" + exception.getMessage());
        }
        try {
            Connection conn = DriverManager.getConnection(url, user, password);
            Statement statement = conn.createStatement();
            ResultSet databases = statement.executeQuery("show databases");
            while (databases.next()) {
                String databaseName = databases.getString(1);
                returnList.add(databaseName);
            }
        }
        catch (SQLException exception) {
            JOptionPane.showMessageDialog(this, "I cannot connect to the MySQL instance on the host to find the databases: \n" + host + ":" + port + " user: " + user + " - \n " + exception.getMessage());
        }
        return returnList;
    }

    private JTextField getJdbcDriverTextField() {
        return this.jdbcDriverTextField;
    }

    private JTextField getHostTextField() {
        return this.hostTextField;
    }

    private JTextField getPortTextField() {
        return this.portTextField;
    }

    private JTextField getUserTextField() {
        return this.userTextField;
    }

    private JPasswordField getPasswordTextField() {
        return this.passwordTextField;
    }

    private JTextField getEnsemblDriverTextField() {
        return this.ensemblDriverTextField;
    }

    public JComboBox getEnsemblDatabaseDropdown() {
        return this.ensemblDatabaseDropdown;
    }

    public String getSelectedEnsemblDatabase() {
        return (String)this.getEnsemblDatabaseDropdown().getSelectedItem();
    }

    public void setSelectedEnsemblDatabase(String database) {
        this.getEnsemblDatabaseDropdown().setSelectedItem(database);
    }

    public JButton getFindButton() {
        return this.findButton;
    }

    public ActionListener getHostListener() {
        return this.hostListener;
    }

    public void setInteractionListener(ActionListener listener) {
        this.interactionListener = listener;
    }

    public ActionListener getInteractionListener() {
        return this.interactionListener;
    }

    public ActionListener getEnsemblDBDropdownSelectionListener() {
        return this.ensemblDBDropdownSelectionListener;
    }

    public void setHostListener(ActionListener newValue) {
        this.hostListener = newValue;
    }

    private boolean databaseHasKeyAndVersion(String key, String name) {
        int keyIndex = -1;
        String numberSubstring = null;
        int endNumberIndex = -1;
        keyIndex = name.indexOf(key);
        if (keyIndex >= 0) {
            if (name.length() > keyIndex + key.length()) {
                int version;
                numberSubstring = name.substring(keyIndex + key.length() + 1);
                endNumberIndex = numberSubstring.indexOf("_");
                numberSubstring = numberSubstring.substring(0, endNumberIndex);
                try {
                    version = Integer.parseInt(numberSubstring);
                }
                catch (NumberFormatException exception) {
                    return true;
                }
                return version >= 9;
            }
            return true;
        }
        return false;
    }

    private ActionListener getExternalDataChangeListener() {
        return this.externalDataChangeListener;
    }

    public class EnsemblDBSelectionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            if (DataSourceConfigurationPanel.this.getInteractionListener() != null) {
                DataSourceConfigurationPanel.this.getInteractionListener().actionPerformed(new ActionEvent(DataSourceConfigurationPanel.this.getEnsemblDatabaseDropdown(), 0, (String)DataSourceConfigurationPanel.this.getEnsemblDatabaseDropdown().getSelectedItem()));
            }
            if (DataSourceConfigurationPanel.this.getExternalDataChangeListener() != null) {
                DataSourceConfigurationPanel.this.getExternalDataChangeListener().actionPerformed(new ActionEvent(this, this.hashCode(), "data changed"));
            }
        }
    }

    public class DataChangeListener
    extends KeyAdapter {
        public void keyTyped(KeyEvent event) {
            if (DataSourceConfigurationPanel.this.getEnsemblDatabaseDropdown().getModel().getSize() > 0) {
                DataSourceConfigurationPanel.this.detachEnsemblDatabaseDropdownListener();
                DataSourceConfigurationPanel.this.getEnsemblDatabaseDropdown().setModel(new DefaultComboBoxModel());
                DataSourceConfigurationPanel.this.attachEnsemblDatabaseDropdownListener();
            }
        }
    }

    public class HostListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            List databaseList = DataSourceConfigurationPanel.this.findDatabasesForMySQLHost();
            Vector<String> inputVector = new Vector<String>(databaseList);
            if (inputVector.size() > 0) {
                inputVector.add(0, "");
                DataSourceConfigurationPanel.this.getEnsemblDatabaseDropdown().removeActionListener(DataSourceConfigurationPanel.this.getEnsemblDBDropdownSelectionListener());
                DataSourceConfigurationPanel.this.getEnsemblDatabaseDropdown().setModel(new DefaultComboBoxModel(inputVector));
                DataSourceConfigurationPanel.this.ensemblDatabaseDropdown.setPopupVisible(true);
                DataSourceConfigurationPanel.this.getEnsemblDatabaseDropdown().addActionListener(DataSourceConfigurationPanel.this.getEnsemblDBDropdownSelectionListener());
            }
        }
    }
}

