/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj.view;

import apollo.dataadapter.ensj.model.LocationModel;
import apollo.dataadapter.ensj.model.Model;
import apollo.dataadapter.ensj.view.View;
import apollo.util.GuiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LocationPanel
extends JPanel {
    private View _view;
    private JLabel _stableIDLabel = new JLabel("Stable ID");
    private JLabel _coordSystemLabel = new JLabel("Coordinate System");
    private JLabel _seqRegionLabel = new JLabel("Seq Region Name");
    private JLabel _startLabel = new JLabel("Start - End");
    private JComboBox _stableIDDropdown = new JComboBox();
    private JComboBox _coordSystemDropdown = new JComboBox();
    private JComboBox _seqRegionDropdown = new JComboBox();
    private JTextField _startField = new JTextField(10);
    private JTextField _endField = new JTextField(10);
    private JLabel _historyLabel = new JLabel("History");
    private JComboBox _historyDropdown = new JComboBox();

    public LocationPanel(View view) {
        this._view = view;
        this.initialiseGUI();
    }

    private View getView() {
        return this._view;
    }

    public void initialiseGUI() {
        this.setLayout(new GridBagLayout());
        Dimension dropdownSize = new Dimension(200, 25);
        this.add((Component)this.getStableIDLabel(), GuiUtil.makeConstraintAt(0, 0, 10, true));
        this.getStableIDDropdown().setPreferredSize(dropdownSize);
        this.getStableIDDropdown().setMinimumSize(dropdownSize);
        this.getStableIDDropdown().setEditable(true);
        this.add((Component)this.getStableIDDropdown(), GuiUtil.makeConstraintAt(1, 0, 3, 10, true));
        this.getView().getAdapterGUI().addKeyRouter(this.getStableIDDropdown().getEditor().getEditorComponent(), "USE_STABLE_ID_LOCATION");
        this.getView().getAdapterGUI().addActionRouter(this.getStableIDDropdown(), "USE_STABLE_ID_LOCATION");
        this.add((Component)this.getCoordSystemLabel(), GuiUtil.makeConstraintAt(0, 1, 10, true));
        this.getCoordSystemDropdown().setPreferredSize(dropdownSize);
        this.add((Component)this.getCoordSystemDropdown(), GuiUtil.makeConstraintAt(1, 1, 3, 10, true));
        this.getView().getAdapterGUI().addActionRouter(this.getCoordSystemDropdown(), "USE_SEQ_REGION_LOCATION");
        this.getView().getAdapterGUI().addActionRouter(this.getCoordSystemDropdown(), "CLEAR_SEQ_REGIONS");
        this.getView().getAdapterGUI().addPopupRouter(this.getCoordSystemDropdown(), "FIND_COORD_SYSTEMS");
        this.add((Component)this.getSeqRegionLabel(), GuiUtil.makeConstraintAt(0, 2, 10, true));
        this.getSeqRegionDropdown().setPreferredSize(dropdownSize);
        this.getSeqRegionDropdown().setEditable(true);
        this.getView().getAdapterGUI().addActionRouter(this.getSeqRegionDropdown(), "SELECT_SEQ_REGION");
        this.add((Component)this.getSeqRegionDropdown(), GuiUtil.makeConstraintAt(1, 2, 3, 10, true));
        this.getView().getAdapterGUI().addPopupRouter(this.getSeqRegionDropdown(), "FIND_SEQ_REGIONS");
        this.getView().getAdapterGUI().addKeyRouter(this.getSeqRegionDropdown().getEditor().getEditorComponent(), "USE_SEQ_REGION_LOCATION");
        this.getView().getAdapterGUI().addActionRouter(this.getSeqRegionDropdown(), "USE_SEQ_REGION_LOCATION");
        this.add((Component)this.getStartLabel(), GuiUtil.makeConstraintAt(0, 3, 10, true));
        this.getStartField().setPreferredSize(dropdownSize);
        this.getStartField().setMinimumSize(dropdownSize);
        this.add((Component)this.getStartField(), GuiUtil.makeConstraintAt(1, 3, 10, false));
        this.add((Component)new JLabel("-"), GuiUtil.makeConstraintAt(2, 3, 10, true));
        this.getEndField().setPreferredSize(dropdownSize);
        this.getEndField().setMinimumSize(dropdownSize);
        this.add((Component)this.getEndField(), GuiUtil.makeConstraintAt(3, 3, 10, false));
        this.getView().getAdapterGUI().addKeyRouter(this.getStartField(), "USE_SEQ_REGION_LOCATION");
        this.getView().getAdapterGUI().addKeyRouter(this.getEndField(), "USE_SEQ_REGION_LOCATION");
        this.add((Component)this.getHistoryLabel(), GuiUtil.makeConstraintAt(0, 4, 10, true));
        this.getHistoryDropdown().setPreferredSize(dropdownSize);
        this.add((Component)this.getHistoryDropdown(), GuiUtil.makeConstraintAt(1, 4, 3, 10, true));
        this.getView().getAdapterGUI().addActionRouter(this.getHistoryDropdown(), "LOAD_SEQ_REGION_BY_HISTORY");
    }

    public void update(Model model) {
        LocationModel myModel = model.getLocationModel();
        myModel.setStableID((String)this.getStableIDDropdown().getSelectedItem());
        myModel.setSelectedCoordSystem((String)this.getCoordSystemDropdown().getSelectedItem());
        myModel.setSelectedSeqRegion((String)this.getSeqRegionDropdown().getSelectedItem());
        myModel.setStart(this.getStartField().getText());
        myModel.setEnd(this.getEndField().getText());
        myModel.setSelectedHistoryLocation((String)this.getHistoryDropdown().getSelectedItem());
    }

    public void read(Model model) {
        LocationModel myModel = model.getLocationModel();
        this.getStableIDDropdown().setModel(new DefaultComboBoxModel(new Vector(myModel.getStableIDHistory())));
        this.getStableIDDropdown().setSelectedItem(myModel.getStableID());
        this.getCoordSystemDropdown().setModel(new DefaultComboBoxModel(new Vector(myModel.getCoordSystems())));
        this.getCoordSystemDropdown().setSelectedItem(myModel.getSelectedCoordSystem());
        this.getSeqRegionDropdown().setModel(new DefaultComboBoxModel(new Vector(myModel.getSeqRegions())));
        this.getSeqRegionDropdown().setSelectedItem(myModel.getSelectedSeqRegion());
        this.getSeqRegionDropdown().setSelectedItem(myModel.getSelectedSeqRegion());
        this.getStartField().setText(myModel.getStart());
        this.getEndField().setText(myModel.getEnd());
        this.getHistoryDropdown().setModel(new DefaultComboBoxModel(new Vector(myModel.getLocationHistory())));
        this.getHistoryDropdown().setSelectedItem(myModel.getSelectedHistoryLocation());
    }

    private JLabel getStableIDLabel() {
        return this._stableIDLabel;
    }

    private JLabel getCoordSystemLabel() {
        return this._coordSystemLabel;
    }

    private JLabel getSeqRegionLabel() {
        return this._seqRegionLabel;
    }

    private JLabel getStartLabel() {
        return this._startLabel;
    }

    private JLabel getHistoryLabel() {
        return this._historyLabel;
    }

    private JComboBox getStableIDDropdown() {
        return this._stableIDDropdown;
    }

    private JComboBox getCoordSystemDropdown() {
        return this._coordSystemDropdown;
    }

    private JComboBox getSeqRegionDropdown() {
        return this._seqRegionDropdown;
    }

    private JComboBox getHistoryDropdown() {
        return this._historyDropdown;
    }

    private JTextField getStartField() {
        return this._startField;
    }

    private JTextField getEndField() {
        return this._endField;
    }
}

