/*
 * Decompiled with CFR 0.152.
 */
package apollo.dataadapter.ensj.view;

import apollo.dataadapter.ensj.model.DatabaseModel;
import apollo.dataadapter.ensj.model.Model;
import apollo.dataadapter.ensj.view.View;
import apollo.util.GuiUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class DatabasePanel
extends JPanel {
    private JLabel _hostLabel = new JLabel("Host");
    private JLabel _portLabel = new JLabel("Port");
    private JLabel _userLabel = new JLabel("User");
    private JLabel _passwordLabel = new JLabel("Password");
    private JLabel _ensemblDatabaseLabel = new JLabel("Ensembl Database Name");
    private JTextField _hostTextField = new JTextField(40);
    private JTextField _portTextField = new JTextField(6);
    private JTextField _userTextField = new JTextField(40);
    private JPasswordField _passwordTextField = new JPasswordField(40);
    private JComboBox _ensemblDatabaseDropdown = new JComboBox();
    private JLabel _sequenceHostLabel = new JLabel("Host");
    private JLabel _sequencePortLabel = new JLabel("Port");
    private JLabel _sequenceUserLabel = new JLabel("User");
    private JLabel _sequencePasswordLabel = new JLabel("Password");
    private JLabel _sequenceEnsemblDatabaseLabel = new JLabel("Ensembl Database Name");
    private JTextField _sequenceHostTextField = new JTextField(40);
    private JTextField _sequencePortTextField = new JTextField(6);
    private JTextField _sequenceUserTextField = new JTextField(40);
    private JPasswordField _sequencePasswordTextField = new JPasswordField(40);
    private JComboBox _sequenceEnsemblDatabaseDropdown = new JComboBox();
    private View _view;

    public DatabasePanel(View view) {
        this._view = view;
        this.initialiseGUI();
    }

    private void initialiseGUI() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.createCoreDatabasePanel(), GuiUtil.makeConstraintAt(0, 0, 1));
    }

    private JPanel createCoreDatabasePanel() {
        int row = 0;
        JPanel corePanel = new JPanel();
        Dimension fieldSize = new Dimension(400, 25);
        corePanel.setLayout(new GridBagLayout());
        corePanel.add((Component)this.getHostLabel(), GuiUtil.makeConstraintAt(0, row, 1));
        corePanel.add((Component)this.getHostTextField(), GuiUtil.makeConstraintAt(1, row, 3));
        this.getHostTextField().setPreferredSize(fieldSize);
        this.getHostTextField().setMinimumSize(fieldSize);
        this.getView().getAdapterGUI().addKeyRouter(this.getHostTextField(), "CHANGE_DATABASE");
        corePanel.add((Component)this.getPortLabel(), GuiUtil.makeConstraintAt(0, ++row, 1));
        corePanel.add((Component)this.getPortTextField(), GuiUtil.makeConstraintAt(1, row, 3));
        this.getPortTextField().setPreferredSize(fieldSize);
        this.getPortTextField().setMinimumSize(fieldSize);
        this.getView().getAdapterGUI().addKeyRouter(this.getPortTextField(), "CHANGE_DATABASE");
        corePanel.add((Component)this.getUserLabel(), GuiUtil.makeConstraintAt(0, ++row, 1));
        corePanel.add((Component)this.getUserTextField(), GuiUtil.makeConstraintAt(1, row, 3));
        this.getUserTextField().setPreferredSize(fieldSize);
        this.getUserTextField().setMinimumSize(fieldSize);
        this.getView().getAdapterGUI().addKeyRouter(this.getUserTextField(), "CHANGE_DATABASE");
        corePanel.add((Component)this.getPasswordLabel(), GuiUtil.makeConstraintAt(0, ++row, 1));
        corePanel.add((Component)this.getPasswordTextField(), GuiUtil.makeConstraintAt(1, row, 3));
        this.getPasswordTextField().setPreferredSize(fieldSize);
        this.getPasswordTextField().setMinimumSize(fieldSize);
        this.getView().getAdapterGUI().addKeyRouter(this.getPasswordTextField(), "CHANGE_DATABASE");
        corePanel.add((Component)this.getEnsemblDatabaseLabel(), GuiUtil.makeConstraintAt(0, ++row, 1));
        Dimension hostTextFieldDimension = this.getHostTextField().getPreferredSize();
        int newX = new Double(new Integer(hostTextFieldDimension.width).doubleValue() * 0.66).intValue();
        Dimension newDimension = new Dimension(newX, hostTextFieldDimension.height);
        this.getEnsemblDatabaseDropdown().setPreferredSize(fieldSize);
        this.getEnsemblDatabaseDropdown().setMinimumSize(fieldSize);
        this.getView().getAdapterGUI().addPopupRouter(this.getEnsemblDatabaseDropdown(), "FIND_ENSEMBL_DATABASE_NAMES");
        this.getView().getAdapterGUI().addActionRouter(this.getEnsemblDatabaseDropdown(), "SELECT_NEW_ENSEMBL_DATABASE");
        corePanel.add((Component)this.getEnsemblDatabaseDropdown(), GuiUtil.makeConstraintAt(1, row, 1));
        return corePanel;
    }

    private JPanel createSequenceDatabasePanel() {
        int row = 0;
        JPanel sequencePanel = new JPanel();
        sequencePanel.setLayout(new GridBagLayout());
        sequencePanel.add((Component)this.getSequenceHostLabel(), GuiUtil.makeConstraintAt(0, row, 1));
        sequencePanel.add((Component)this.getSequenceHostTextField(), GuiUtil.makeConstraintAt(1, row, 3));
        sequencePanel.add((Component)this.getSequencePortLabel(), GuiUtil.makeConstraintAt(0, ++row, 1));
        sequencePanel.add((Component)this.getSequencePortTextField(), GuiUtil.makeConstraintAt(1, row, 3));
        sequencePanel.add((Component)this.getSequenceUserLabel(), GuiUtil.makeConstraintAt(0, ++row, 1));
        sequencePanel.add((Component)this.getSequenceUserTextField(), GuiUtil.makeConstraintAt(1, row, 3));
        sequencePanel.add((Component)this.getSequencePasswordLabel(), GuiUtil.makeConstraintAt(0, ++row, 1));
        sequencePanel.add((Component)this.getSequencePasswordTextField(), GuiUtil.makeConstraintAt(1, row, 3));
        sequencePanel.add((Component)this.getSequenceEnsemblDatabaseLabel(), GuiUtil.makeConstraintAt(0, ++row, 1));
        Dimension hostTextFieldDimension = this.getSequenceHostTextField().getPreferredSize();
        int newX = new Double(new Integer(hostTextFieldDimension.width).doubleValue() * 0.66).intValue();
        Dimension newDimension = new Dimension(newX, hostTextFieldDimension.height);
        this.getSequenceEnsemblDatabaseDropdown().setPreferredSize(newDimension);
        sequencePanel.add((Component)this.getSequenceEnsemblDatabaseDropdown(), GuiUtil.makeConstraintAt(1, row, 1));
        return sequencePanel;
    }

    public void update(Model model) {
        DatabaseModel myModel = model.getDatabaseModel();
        myModel.setHost(this.getHostTextField().getText());
        myModel.setPort(this.getPortTextField().getText());
        myModel.setUser(this.getUserTextField().getText());
        myModel.setPassword(this.getPasswordTextField().getText());
        myModel.setSelectedEnsemblDatabase((String)this.getEnsemblDatabaseDropdown().getSelectedItem());
    }

    public void read(Model model) {
        DatabaseModel myModel = model.getDatabaseModel();
        this.getHostTextField().setText(myModel.getHost());
        this.getPortTextField().setText(myModel.getPort());
        this.getUserTextField().setText(myModel.getUser());
        this.getPasswordTextField().setText(myModel.getPassword());
        this.getEnsemblDatabaseDropdown().setModel(new DefaultComboBoxModel(new Vector(myModel.getEnsemblDatabases())));
        this.getEnsemblDatabaseDropdown().setSelectedItem(myModel.getSelectedEnsemblDatabase());
    }

    private JTextField getHostTextField() {
        return this._hostTextField;
    }

    private JTextField getPortTextField() {
        return this._portTextField;
    }

    private JTextField getUserTextField() {
        return this._userTextField;
    }

    private JPasswordField getPasswordTextField() {
        return this._passwordTextField;
    }

    public JComboBox getEnsemblDatabaseDropdown() {
        return this._ensemblDatabaseDropdown;
    }

    private JLabel getHostLabel() {
        return this._hostLabel;
    }

    private JLabel getPortLabel() {
        return this._portLabel;
    }

    private JLabel getUserLabel() {
        return this._userLabel;
    }

    private JLabel getPasswordLabel() {
        return this._passwordLabel;
    }

    public JLabel getEnsemblDatabaseLabel() {
        return this._ensemblDatabaseLabel;
    }

    private JTextField getSequenceHostTextField() {
        return this._sequenceHostTextField;
    }

    private JTextField getSequencePortTextField() {
        return this._sequencePortTextField;
    }

    private JTextField getSequenceUserTextField() {
        return this._sequenceUserTextField;
    }

    private JPasswordField getSequencePasswordTextField() {
        return this._sequencePasswordTextField;
    }

    public JComboBox getSequenceEnsemblDatabaseDropdown() {
        return this._sequenceEnsemblDatabaseDropdown;
    }

    private JLabel getSequenceHostLabel() {
        return this._sequenceHostLabel;
    }

    private JLabel getSequencePortLabel() {
        return this._sequencePortLabel;
    }

    private JLabel getSequenceUserLabel() {
        return this._sequenceUserLabel;
    }

    private JLabel getSequencePasswordLabel() {
        return this._sequencePasswordLabel;
    }

    public JLabel getSequenceEnsemblDatabaseLabel() {
        return this._sequenceEnsemblDatabaseLabel;
    }

    private View getView() {
        return this._view;
    }
}

